/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.AbstractSetTester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetAddAllTester<E>
extends AbstractSetTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD_ALL})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAll_supportedSomePresent() {
        SetAddAllTester.assertTrue("add(somePresent) should return true", this.getSet().addAll(MinimalCollection.of(this.samples.e3, this.samples.e0)));
        this.expectAdded(this.samples.e3);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD_ALL})
    public void testAddAll_withDuplicates() {
        MinimalCollection<Object> elementsToAdd = MinimalCollection.of(this.samples.e3, this.samples.e4, this.samples.e3, this.samples.e4);
        SetAddAllTester.assertTrue("add(hasDuplicates) should return true", this.getSet().addAll(elementsToAdd));
        this.expectAdded(this.samples.e3, this.samples.e4);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD_ALL})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAll_supportedAllPresent() {
        SetAddAllTester.assertFalse("add(allPresent) should return false", this.getSet().addAll(MinimalCollection.of(this.samples.e0)));
        this.expectUnchanged();
    }
}

