/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.AbstractQueueTester;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueRemoveTester<E>
extends AbstractQueueTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testRemove_empty() {
        try {
            this.getQueue().remove();
            QueueRemoveTester.fail("emptyQueue.remove() should throw");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testRemove_size1() {
        QueueRemoveTester.assertEquals("size1Queue.remove() should return first element", this.samples.e0, this.getQueue().remove());
        this.expectMissing(this.samples.e0);
    }

    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER, CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testRemove_sizeMany() {
        QueueRemoveTester.assertEquals("sizeManyQueue.remove() should return first element", this.samples.e0, this.getQueue().remove());
        this.expectMissing(this.samples.e0);
    }
}

