/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapRemoveTester<K, V>
extends AbstractMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemove_present() {
        int initialSize = this.getMap().size();
        MapRemoveTester.assertEquals("remove(present) should return the associated value", ((Map.Entry)this.samples.e0).getValue(), this.getMap().remove(((Map.Entry)this.samples.e0).getKey()));
        MapRemoveTester.assertEquals("remove(present) should decrease a map's size by one.", initialSize - 1, this.getMap().size());
        this.expectMissing((Map.Entry)this.samples.e0);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemove_notPresent() {
        MapRemoveTester.assertNull("remove(notPresent) should return null", this.getMap().remove(((Map.Entry)this.samples.e3).getKey()));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemove_nullPresent() {
        this.initMapWithNullKey();
        int initialSize = this.getMap().size();
        MapRemoveTester.assertEquals("remove(null) should return the associated value", this.getValueForNullKey(), this.getMap().remove(null));
        MapRemoveTester.assertEquals("remove(present) should decrease a map's size by one.", initialSize - 1, this.getMap().size());
        this.expectMissing(this.entry(null, this.getValueForNullKey()));
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemove_unsupported() {
        try {
            this.getMap().remove(((Map.Entry)this.samples.e0).getKey());
            MapRemoveTester.fail("remove(present) should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
        MapRemoveTester.assertEquals("remove(present) should not remove the element", ((Map.Entry)this.samples.e0).getValue(), this.get(((Map.Entry)this.samples.e0).getKey()));
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_REMOVE})
    public void testRemove_unsupportedNotPresent() {
        try {
            MapRemoveTester.assertNull("remove(notPresent) should return null or throw UnsupportedOperationException", this.getMap().remove(((Map.Entry)this.samples.e3).getKey()));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectMissing((Map.Entry)this.samples.e3);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE}, absent={MapFeature.ALLOWS_NULL_KEYS})
    public void testRemove_nullNotSupported() {
        try {
            MapRemoveTester.assertNull("remove(null) should return null or throw NullPointerException", this.getMap().remove(null));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_KEYS})
    public void testRemove_nullSupportedMissing() {
        MapRemoveTester.assertNull("remove(null) should return null", this.getMap().remove(null));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemove_wrongType() {
        try {
            MapRemoveTester.assertNull(this.getMap().remove((Object)WrongType.VALUE));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.expectUnchanged();
    }
}

