/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapGetTester<K, V>
extends AbstractMapTester<K, V> {
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testGet_yes() {
        MapGetTester.assertEquals("get(present) should return the associated value", ((Map.Entry)this.samples.e0).getValue(), this.get(((Map.Entry)this.samples.e0).getKey()));
    }

    public void testGet_no() {
        MapGetTester.assertNull("get(notPresent) should return null", this.get(((Map.Entry)this.samples.e3).getKey()));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    public void testGet_nullNotContainedButSupported() {
        MapGetTester.assertNull("get(null) should return null", this.get(null));
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_KEYS})
    public void testGet_nullNotContainedAndUnsupported() {
        try {
            MapGetTester.assertNull("get(null) should return null or throw", this.get(null));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testGet_nonNullWhenNullContained() {
        this.initMapWithNullKey();
        MapGetTester.assertNull("get(notPresent) should return null", this.get(((Map.Entry)this.samples.e3).getKey()));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testGet_nullContained() {
        this.initMapWithNullKey();
        MapGetTester.assertEquals("get(null) should return the associated value", this.getValueForNullKey(), this.get(null));
    }

    public void testGet_wrongType() {
        try {
            MapGetTester.assertNull("get(wrongType) should return null or throw", this.getMap().get((Object)WrongType.VALUE));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

