/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapContainsKeyTester<K, V>
extends AbstractMapTester<K, V> {
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContains_yes() {
        MapContainsKeyTester.assertTrue("containsKey(present) should return true", this.getMap().containsKey(((Map.Entry)this.samples.e0).getKey()));
    }

    public void testContains_no() {
        MapContainsKeyTester.assertFalse("containsKey(notPresent) should return false", this.getMap().containsKey(((Map.Entry)this.samples.e3).getKey()));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    public void testContains_nullNotContainedButSupported() {
        MapContainsKeyTester.assertFalse("containsKey(null) should return false", this.getMap().containsKey(null));
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_KEYS})
    public void testContains_nullNotContainedAndUnsupported() {
        this.expectNullKeyMissingWhenNullKeysUnsupported("containsKey(null) should return false or throw");
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContains_nonNullWhenNullContained() {
        this.initMapWithNullKey();
        MapContainsKeyTester.assertFalse("containsKey(notPresent) should return false", this.getMap().containsKey(((Map.Entry)this.samples.e3).getKey()));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContains_nullContained() {
        this.initMapWithNullKey();
        MapContainsKeyTester.assertTrue("containsKey(null) should return true", this.getMap().containsKey(null));
    }

    public void testContains_wrongType() {
        try {
            MapContainsKeyTester.assertFalse("containsKey(wrongType) should return false or throw", this.getMap().containsKey((Object)WrongType.VALUE));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

