/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionToStringTester<E>
extends AbstractCollectionTester<E> {
    public void testToString_minimal() {
        CollectionToStringTester.assertNotNull("toString() should not return null", this.collection.toString());
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    @CollectionFeature.Require(absent={CollectionFeature.NON_STANDARD_TOSTRING})
    public void testToString_size0() {
        CollectionToStringTester.assertEquals("emptyCollection.toString should return []", "[]", this.collection.toString());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(absent={CollectionFeature.NON_STANDARD_TOSTRING})
    public void testToString_size1() {
        CollectionToStringTester.assertEquals("size1Collection.toString should return [{element}]", "[" + this.samples.e0 + "]", this.collection.toString());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER}, absent={CollectionFeature.NON_STANDARD_TOSTRING})
    public void testToString_sizeSeveral() {
        String expected = Helpers.copyToList(this.getOrderedElements()).toString();
        CollectionToStringTester.assertEquals("collection.toString() incorrect", expected, this.collection.toString());
    }
}

