/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionRemoveTester<E>
extends AbstractCollectionTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemove_present() {
        int initialSize = this.collection.size();
        CollectionRemoveTester.assertTrue("remove(present) should return true", this.collection.remove(this.samples.e0));
        CollectionRemoveTester.assertEquals("remove(present) should decrease a collection's size by one.", initialSize - 1, this.collection.size());
        this.expectMissing(this.samples.e0);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_notPresent() {
        CollectionRemoveTester.assertFalse("remove(notPresent) should return false", this.collection.remove(this.samples.e3));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemove_nullPresent() {
        this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(this.createArrayWithNullElement());
        int initialSize = this.collection.size();
        CollectionRemoveTester.assertTrue("remove(null) should return true", this.collection.remove(null));
        CollectionRemoveTester.assertEquals("remove(present) should decrease a collection's size by one.", initialSize - 1, this.collection.size());
        this.expectMissing(new Object[]{null});
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemove_unsupported() {
        try {
            this.collection.remove(this.samples.e0);
            CollectionRemoveTester.fail("remove(present) should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
        CollectionRemoveTester.assertTrue("remove(present) should not remove the element", this.collection.contains(this.samples.e0));
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_unsupportedNotPresent() {
        try {
            CollectionRemoveTester.assertFalse("remove(notPresent) should return false or throw UnsupportedOperationException", this.collection.remove(this.samples.e3));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectMissing(this.samples.e3);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE}, absent={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testRemove_nullNotSupported() {
        try {
            CollectionRemoveTester.assertFalse("remove(null) should return false or throw NullPointerException", this.collection.remove(null));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_VALUES})
    public void testRemove_nullSupportedMissing() {
        CollectionRemoveTester.assertFalse("remove(null) should return false", this.collection.remove(null));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testIteratorRemove_unsupported() {
        Iterator iterator = this.collection.iterator();
        iterator.next();
        try {
            iterator.remove();
            CollectionRemoveTester.fail("iterator.remove() should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
        CollectionRemoveTester.assertTrue(this.collection.contains(this.samples.e0));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_wrongType() {
        try {
            CollectionRemoveTester.assertFalse(this.collection.remove((Object)WrongType.VALUE));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.expectUnchanged();
    }
}

