/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionClearTester<E>
extends AbstractCollectionTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_CLEAR})
    public void testClear() {
        this.collection.clear();
        CollectionClearTester.assertTrue("After clear(), a collection should be empty.", this.collection.isEmpty());
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_CLEAR})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testClear_unsupported() {
        try {
            this.collection.clear();
            CollectionClearTester.fail("clear() should throw UnsupportedOperation if a collection does not support it and is not empty.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_CLEAR})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testClear_unsupportedByEmptyCollection() {
        try {
            this.collection.clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }
}

