/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.Helpers;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractListTester<E>
extends AbstractCollectionTester<E> {
    protected final List<E> getList() {
        return (List)this.collection;
    }

    @Override
    protected void expectContents(Collection<E> expectedCollection) {
        List<E> expected = Helpers.copyToList(expectedCollection);
        String context = String.format("expected collection %s; actual collection %s: ", expected, this.collection);
        AbstractListTester.assertEquals("size mismatch: " + context, expected.size(), this.getList().size());
        for (int i = 0; i < expected.size(); ++i) {
            String indexContext = "mismatch at index " + i + ": " + context;
            AbstractListTester.assertEquals(indexContext, expected.get(i), this.getList().get(i));
        }
    }
}

