/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Helpers {
    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static <E> List<E> copyToList(Iterable<? extends E> elements) {
        ArrayList list = new ArrayList();
        Helpers.addAll(list, elements);
        return list;
    }

    public static <E> List<E> copyToList(E[] elements) {
        return Helpers.copyToList(Arrays.asList(elements));
    }

    public static <E> Set<E> copyToSet(Iterable<? extends E> elements) {
        LinkedHashSet set = new LinkedHashSet();
        Helpers.addAll(set, elements);
        return set;
    }

    public static <E> Set<E> copyToSet(E[] elements) {
        return Helpers.copyToSet(Arrays.asList(elements));
    }

    public static <K, V> Map.Entry<K, V> mapEntry(K key, V value) {
        return Collections.singletonMap(key, value).entrySet().iterator().next();
    }

    public static void assertEqualIgnoringOrder(Iterable<?> expected, Iterable<?> actual) {
        List<?> exp = Helpers.copyToList(expected);
        List<?> act = Helpers.copyToList(actual);
        String actString = act.toString();
        for (Object object : exp) {
            if (act.remove(object)) continue;
            Assert.fail("did not contain expected element " + object + ", " + "expected = " + exp + ", actual = " + actString);
        }
        Assert.assertTrue("unexpected elements: " + act, act.isEmpty());
    }

    public static void assertContentsAnyOrder(Iterable<?> actual, Object ... expected) {
        Helpers.assertEqualIgnoringOrder(Arrays.asList(expected), actual);
    }

    public static <E> boolean addAll(Collection<E> addTo, Iterable<? extends E> elementsToAdd) {
        boolean modified = false;
        for (E e : elementsToAdd) {
            modified |= addTo.add(e);
        }
        return modified;
    }

    static <T> Iterable<T> reverse(final List<T> list) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final ListIterator listIter = list.listIterator(list.size());
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return listIter.hasPrevious();
                    }

                    @Override
                    public T next() {
                        return listIter.previous();
                    }

                    @Override
                    public void remove() {
                        listIter.remove();
                    }
                };
            }
        };
    }

    static <T> Iterator<T> cycle(final Iterable<T> iterable) {
        return new Iterator<T>(){
            Iterator<T> iterator = Collections.emptySet().iterator();

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                if (!this.iterator.hasNext()) {
                    this.iterator = iterable.iterator();
                }
                return this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static <T> T get(Iterator<T> iterator, int position) {
        for (int i = 0; i < position; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    static void fail(Throwable cause, Object message) {
        AssertionFailedError assertionFailedError = new AssertionFailedError(String.valueOf(message));
        assertionFailedError.initCause(cause);
        throw assertionFailedError;
    }
}

