/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.collect.testing.MapInterfaceTest;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConcurrentMapInterfaceTest<K, V>
extends MapInterfaceTest<K, V> {
    protected ConcurrentMapInterfaceTest(boolean allowsNullKeys, boolean allowsNullValues, boolean supportsPut, boolean supportsRemove, boolean supportsClear) {
        super(allowsNullKeys, allowsNullValues, supportsPut, supportsRemove, supportsClear);
    }

    protected abstract V getSecondValueNotInPopulatedMap() throws UnsupportedOperationException;

    @Override
    protected abstract ConcurrentMap<K, V> makeEmptyMap() throws UnsupportedOperationException;

    @Override
    protected abstract ConcurrentMap<K, V> makePopulatedMap() throws UnsupportedOperationException;

    @Override
    protected ConcurrentMap<K, V> makeEitherMap() {
        try {
            return this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return this.makeEmptyMap();
        }
    }

    public void testPutIfAbsentNewKey() {
        Object valueToPut;
        Object keyToPut;
        Map map;
        try {
            map = this.makeEitherMap();
            keyToPut = this.getKeyNotInPopulatedMap();
            valueToPut = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        if (this.supportsPut) {
            int initialSize = map.size();
            Object oldValue = map.putIfAbsent(keyToPut, valueToPut);
            ConcurrentMapInterfaceTest.assertEquals(valueToPut, map.get(keyToPut));
            ConcurrentMapInterfaceTest.assertTrue(map.containsKey(keyToPut));
            ConcurrentMapInterfaceTest.assertTrue(map.containsValue(valueToPut));
            ConcurrentMapInterfaceTest.assertEquals(initialSize + 1, map.size());
            ConcurrentMapInterfaceTest.assertNull(oldValue);
        } else {
            try {
                map.putIfAbsent(keyToPut, valueToPut);
                ConcurrentMapInterfaceTest.fail("Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testPutIfAbsentExistingKey() {
        Object valueToPut;
        Map map;
        try {
            map = this.makePopulatedMap();
            valueToPut = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Object keyToPut = map.keySet().iterator().next();
        if (this.supportsPut) {
            Object oldValue = map.get(keyToPut);
            int initialSize = map.size();
            ConcurrentMapInterfaceTest.assertEquals(oldValue, map.putIfAbsent(keyToPut, valueToPut));
            ConcurrentMapInterfaceTest.assertEquals(oldValue, map.get(keyToPut));
            ConcurrentMapInterfaceTest.assertTrue(map.containsKey(keyToPut));
            ConcurrentMapInterfaceTest.assertTrue(map.containsValue(oldValue));
            ConcurrentMapInterfaceTest.assertFalse(map.containsValue(valueToPut));
            ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        } else {
            try {
                map.putIfAbsent(keyToPut, valueToPut);
                ConcurrentMapInterfaceTest.fail("Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testPutIfAbsentNullKey() {
        Object valueToPut;
        Map map;
        if (this.allowsNullKeys) {
            return;
        }
        try {
            map = this.makeEitherMap();
            valueToPut = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        int initialSize = map.size();
        if (this.supportsPut) {
            try {
                map.putIfAbsent(null, valueToPut);
                ConcurrentMapInterfaceTest.fail("Expected NullPointerException");
            }
            catch (NullPointerException e) {}
        } else {
            try {
                map.putIfAbsent(null, valueToPut);
                ConcurrentMapInterfaceTest.fail("Expected UnsupportedOperationException or NullPointerException");
            }
            catch (UnsupportedOperationException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        this.assertInvariants(map);
    }

    public void testPutIfAbsentNewKeyNullValue() {
        Object keyToPut;
        Map map;
        if (this.allowsNullValues) {
            return;
        }
        try {
            map = this.makeEitherMap();
            keyToPut = this.getKeyNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        int initialSize = map.size();
        if (this.supportsPut) {
            try {
                map.putIfAbsent(keyToPut, null);
                ConcurrentMapInterfaceTest.fail("Expected NullPointerException");
            }
            catch (NullPointerException e) {}
        } else {
            try {
                map.putIfAbsent(keyToPut, null);
                ConcurrentMapInterfaceTest.fail("Expected UnsupportedOperationException or NullPointerException");
            }
            catch (UnsupportedOperationException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        this.assertInvariants(map);
    }

    public void testPutIfAbsentExistingKeyNullValue() {
        Map map;
        if (this.allowsNullValues) {
            return;
        }
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Object keyToPut = map.keySet().iterator().next();
        int initialSize = map.size();
        if (this.supportsPut) {
            try {
                ConcurrentMapInterfaceTest.assertNull(map.putIfAbsent(keyToPut, null));
            }
            catch (NullPointerException e) {}
        } else {
            try {
                map.putIfAbsent(keyToPut, null);
                ConcurrentMapInterfaceTest.fail("Expected UnsupportedOperationException or NullPointerException");
            }
            catch (UnsupportedOperationException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        this.assertInvariants(map);
    }

    public void testRemoveKeyValueExisting() {
        Map map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Object keyToRemove = map.keySet().iterator().next();
        Object oldValue = map.get(keyToRemove);
        if (this.supportsRemove) {
            int initialSize = map.size();
            ConcurrentMapInterfaceTest.assertTrue(map.remove(keyToRemove, oldValue));
            ConcurrentMapInterfaceTest.assertFalse(map.containsKey(keyToRemove));
            ConcurrentMapInterfaceTest.assertEquals(initialSize - 1, map.size());
        } else {
            try {
                map.remove(keyToRemove, oldValue);
                ConcurrentMapInterfaceTest.fail("Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testRemoveKeyValueMissingKey() {
        Object valueToRemove;
        Object keyToRemove;
        Map map;
        try {
            map = this.makePopulatedMap();
            keyToRemove = this.getKeyNotInPopulatedMap();
            valueToRemove = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        if (this.supportsRemove) {
            int initialSize = map.size();
            ConcurrentMapInterfaceTest.assertFalse(map.remove(keyToRemove, valueToRemove));
            ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        } else {
            try {
                map.remove(keyToRemove, valueToRemove);
                ConcurrentMapInterfaceTest.fail("Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testRemoveKeyValueDifferentValue() {
        Object valueToRemove;
        Map map;
        try {
            map = this.makePopulatedMap();
            valueToRemove = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Object keyToRemove = map.keySet().iterator().next();
        if (this.supportsRemove) {
            int initialSize = map.size();
            Object oldValue = map.get(keyToRemove);
            ConcurrentMapInterfaceTest.assertFalse(map.remove(keyToRemove, valueToRemove));
            ConcurrentMapInterfaceTest.assertEquals(oldValue, map.get(keyToRemove));
            ConcurrentMapInterfaceTest.assertTrue(map.containsKey(keyToRemove));
            ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        } else {
            try {
                map.remove(keyToRemove, valueToRemove);
                ConcurrentMapInterfaceTest.fail("Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testRemoveKeyValueNullKey() {
        Object valueToRemove;
        Map map;
        if (this.allowsNullKeys) {
            return;
        }
        try {
            map = this.makeEitherMap();
            valueToRemove = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        int initialSize = map.size();
        if (this.supportsRemove) {
            try {
                ConcurrentMapInterfaceTest.assertFalse(map.remove(null, valueToRemove));
            }
            catch (NullPointerException e) {}
        } else {
            try {
                ConcurrentMapInterfaceTest.assertFalse(map.remove(null, valueToRemove));
            }
            catch (UnsupportedOperationException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        this.assertInvariants(map);
    }

    public void testRemoveKeyValueExistingKeyNullValue() {
        Map map;
        if (this.allowsNullValues) {
            return;
        }
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Object keyToRemove = map.keySet().iterator().next();
        int initialSize = map.size();
        if (this.supportsRemove) {
            try {
                ConcurrentMapInterfaceTest.assertFalse(map.remove(keyToRemove, null));
            }
            catch (NullPointerException e) {}
        } else {
            try {
                ConcurrentMapInterfaceTest.assertFalse(map.remove(keyToRemove, null));
            }
            catch (UnsupportedOperationException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        this.assertInvariants(map);
    }

    public void testRemoveKeyValueMissingKeyNullValue() {
        Object keyToRemove;
        Map map;
        if (this.allowsNullValues) {
            return;
        }
        try {
            map = this.makeEitherMap();
            keyToRemove = this.getKeyNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        int initialSize = map.size();
        if (this.supportsRemove) {
            try {
                ConcurrentMapInterfaceTest.assertFalse(map.remove(keyToRemove, null));
            }
            catch (NullPointerException e) {}
        } else {
            try {
                ConcurrentMapInterfaceTest.assertFalse(map.remove(keyToRemove, null));
            }
            catch (UnsupportedOperationException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        this.assertInvariants(map);
    }

    public void testReplace2ExistingKey() {
        Object newValue;
        Map map;
        try {
            map = this.makePopulatedMap();
            newValue = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Object keyToReplace = map.keySet().iterator().next();
        if (this.supportsPut) {
            Object oldValue = map.get(keyToReplace);
            int initialSize = map.size();
            ConcurrentMapInterfaceTest.assertEquals(oldValue, map.replace(keyToReplace, newValue));
            ConcurrentMapInterfaceTest.assertEquals(newValue, map.get(keyToReplace));
            ConcurrentMapInterfaceTest.assertTrue(map.containsKey(keyToReplace));
            ConcurrentMapInterfaceTest.assertTrue(map.containsValue(newValue));
            ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        } else {
            try {
                map.replace(keyToReplace, newValue);
                ConcurrentMapInterfaceTest.fail("Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testReplace2MissingKey() {
        Object newValue;
        Object keyToReplace;
        Map map;
        try {
            map = this.makeEitherMap();
            keyToReplace = this.getKeyNotInPopulatedMap();
            newValue = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        if (this.supportsPut) {
            int initialSize = map.size();
            ConcurrentMapInterfaceTest.assertNull(map.replace(keyToReplace, newValue));
            ConcurrentMapInterfaceTest.assertNull(map.get(keyToReplace));
            ConcurrentMapInterfaceTest.assertFalse(map.containsKey(keyToReplace));
            ConcurrentMapInterfaceTest.assertFalse(map.containsValue(newValue));
            ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        } else {
            try {
                map.replace(keyToReplace, newValue);
                ConcurrentMapInterfaceTest.fail("Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testReplace2NullKey() {
        Object valueToReplace;
        Map map;
        if (this.allowsNullKeys) {
            return;
        }
        try {
            map = this.makeEitherMap();
            valueToReplace = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        int initialSize = map.size();
        if (this.supportsPut) {
            try {
                ConcurrentMapInterfaceTest.assertNull(map.replace(null, valueToReplace));
            }
            catch (NullPointerException e) {}
        } else {
            try {
                ConcurrentMapInterfaceTest.assertNull(map.replace(null, valueToReplace));
            }
            catch (UnsupportedOperationException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        this.assertInvariants(map);
    }

    public void testReplace2ExistingKeyNullValue() {
        Map map;
        if (this.allowsNullValues) {
            return;
        }
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Object keyToReplace = map.keySet().iterator().next();
        int initialSize = map.size();
        if (this.supportsPut) {
            try {
                map.replace(keyToReplace, null);
                ConcurrentMapInterfaceTest.fail("Expected NullPointerException");
            }
            catch (NullPointerException e) {}
        } else {
            try {
                map.replace(keyToReplace, null);
                ConcurrentMapInterfaceTest.fail("Expected UnsupportedOperationException or NullPointerException");
            }
            catch (UnsupportedOperationException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        this.assertInvariants(map);
    }

    public void testReplace2MissingKeyNullValue() {
        Object keyToReplace;
        Map map;
        if (this.allowsNullValues) {
            return;
        }
        try {
            map = this.makeEitherMap();
            keyToReplace = this.getKeyNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        int initialSize = map.size();
        if (this.supportsPut) {
            try {
                ConcurrentMapInterfaceTest.assertNull(map.replace(keyToReplace, null));
            }
            catch (NullPointerException e) {}
        } else {
            try {
                ConcurrentMapInterfaceTest.assertNull(map.replace(keyToReplace, null));
            }
            catch (UnsupportedOperationException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        this.assertInvariants(map);
    }

    public void testReplace3ExistingKeyValue() {
        Object newValue;
        Map map;
        try {
            map = this.makePopulatedMap();
            newValue = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Object keyToReplace = map.keySet().iterator().next();
        Object oldValue = map.get(keyToReplace);
        if (this.supportsPut) {
            int initialSize = map.size();
            ConcurrentMapInterfaceTest.assertTrue(map.replace(keyToReplace, oldValue, newValue));
            ConcurrentMapInterfaceTest.assertEquals(newValue, map.get(keyToReplace));
            ConcurrentMapInterfaceTest.assertTrue(map.containsKey(keyToReplace));
            ConcurrentMapInterfaceTest.assertTrue(map.containsValue(newValue));
            ConcurrentMapInterfaceTest.assertFalse(map.containsValue(oldValue));
            ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        } else {
            try {
                map.replace(keyToReplace, oldValue, newValue);
                ConcurrentMapInterfaceTest.fail("Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testReplace3ExistingKeyDifferentValue() {
        V newValue;
        Object oldValue;
        Map map;
        try {
            map = this.makePopulatedMap();
            oldValue = this.getValueNotInPopulatedMap();
            newValue = this.getSecondValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Object keyToReplace = map.keySet().iterator().next();
        Object originalValue = map.get(keyToReplace);
        int initialSize = map.size();
        if (this.supportsPut) {
            ConcurrentMapInterfaceTest.assertFalse(map.replace(keyToReplace, oldValue, newValue));
        } else {
            try {
                map.replace(keyToReplace, oldValue, newValue);
                ConcurrentMapInterfaceTest.fail("Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        ConcurrentMapInterfaceTest.assertTrue(map.containsKey(keyToReplace));
        ConcurrentMapInterfaceTest.assertFalse(map.containsValue(newValue));
        ConcurrentMapInterfaceTest.assertFalse(map.containsValue(oldValue));
        ConcurrentMapInterfaceTest.assertEquals(originalValue, map.get(keyToReplace));
        ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        this.assertInvariants(map);
    }

    public void testReplace3MissingKey() {
        V newValue;
        Object oldValue;
        Object keyToReplace;
        Map map;
        try {
            map = this.makeEitherMap();
            keyToReplace = this.getKeyNotInPopulatedMap();
            oldValue = this.getValueNotInPopulatedMap();
            newValue = this.getSecondValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        int initialSize = map.size();
        if (this.supportsPut) {
            ConcurrentMapInterfaceTest.assertFalse(map.replace(keyToReplace, oldValue, newValue));
        } else {
            try {
                map.replace(keyToReplace, oldValue, newValue);
                ConcurrentMapInterfaceTest.fail("Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        ConcurrentMapInterfaceTest.assertFalse(map.containsKey(keyToReplace));
        ConcurrentMapInterfaceTest.assertFalse(map.containsValue(newValue));
        ConcurrentMapInterfaceTest.assertFalse(map.containsValue(oldValue));
        ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        this.assertInvariants(map);
    }

    public void testReplace3NullKey() {
        V newValue;
        Object oldValue;
        Map map;
        if (this.allowsNullKeys) {
            return;
        }
        try {
            map = this.makeEitherMap();
            oldValue = this.getValueNotInPopulatedMap();
            newValue = this.getSecondValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        int initialSize = map.size();
        if (this.supportsPut) {
            try {
                ConcurrentMapInterfaceTest.assertFalse(map.replace(null, oldValue, newValue));
            }
            catch (NullPointerException e) {}
        } else {
            try {
                ConcurrentMapInterfaceTest.assertFalse(map.replace(null, oldValue, newValue));
            }
            catch (UnsupportedOperationException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        this.assertInvariants(map);
    }

    public void testReplace3ExistingKeyNullOldValue() {
        Object newValue;
        Map map;
        if (this.allowsNullValues) {
            return;
        }
        try {
            map = this.makePopulatedMap();
            newValue = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Object keyToReplace = map.keySet().iterator().next();
        Object originalValue = map.get(keyToReplace);
        int initialSize = map.size();
        if (this.supportsPut) {
            try {
                ConcurrentMapInterfaceTest.assertFalse(map.replace(keyToReplace, null, newValue));
            }
            catch (NullPointerException e) {}
        } else {
            try {
                ConcurrentMapInterfaceTest.assertFalse(map.replace(keyToReplace, null, newValue));
            }
            catch (UnsupportedOperationException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        ConcurrentMapInterfaceTest.assertEquals(originalValue, map.get(keyToReplace));
        this.assertInvariants(map);
    }

    public void testReplace3MissingKeyNullOldValue() {
        Object newValue;
        Object keyToReplace;
        Map map;
        if (this.allowsNullValues) {
            return;
        }
        try {
            map = this.makeEitherMap();
            keyToReplace = this.getKeyNotInPopulatedMap();
            newValue = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        int initialSize = map.size();
        if (this.supportsPut) {
            try {
                ConcurrentMapInterfaceTest.assertFalse(map.replace(keyToReplace, null, newValue));
            }
            catch (NullPointerException e) {}
        } else {
            try {
                ConcurrentMapInterfaceTest.assertFalse(map.replace(keyToReplace, null, newValue));
            }
            catch (UnsupportedOperationException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        this.assertInvariants(map);
    }

    public void testReplace3MissingKeyNullNewValue() {
        Object oldValue;
        Object keyToReplace;
        Map map;
        if (this.allowsNullValues) {
            return;
        }
        try {
            map = this.makeEitherMap();
            keyToReplace = this.getKeyNotInPopulatedMap();
            oldValue = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        int initialSize = map.size();
        if (this.supportsPut) {
            try {
                map.replace(keyToReplace, oldValue, null);
            }
            catch (NullPointerException e) {}
        } else {
            try {
                map.replace(keyToReplace, oldValue, null);
            }
            catch (UnsupportedOperationException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        this.assertInvariants(map);
    }

    public void testReplace3ExistingKeyValueNullNewValue() {
        Map map;
        if (this.allowsNullValues) {
            return;
        }
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Object keyToReplace = map.keySet().iterator().next();
        Object oldValue = map.get(keyToReplace);
        int initialSize = map.size();
        if (this.supportsPut) {
            try {
                map.replace(keyToReplace, oldValue, null);
                ConcurrentMapInterfaceTest.fail("Expected NullPointerException");
            }
            catch (NullPointerException e) {}
        } else {
            try {
                map.replace(keyToReplace, oldValue, null);
                ConcurrentMapInterfaceTest.fail("Expected UnsupportedOperationException or NullPointerException");
            }
            catch (UnsupportedOperationException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        ConcurrentMapInterfaceTest.assertEquals(initialSize, map.size());
        ConcurrentMapInterfaceTest.assertEquals(oldValue, map.get(keyToReplace));
        this.assertInvariants(map);
    }
}

