/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.IteratorFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractIteratorTester<E, I extends Iterator<E>> {
    private boolean whenNextThrowsExceptionStopTestingCallsToRemove;
    private boolean whenAddThrowsExceptionStopTesting;
    private Stimulus<? super I>[] stimuli;
    private final Iterator<E> elementsToInsert;
    private final Set<IteratorFeature> features;
    private final List<E> expectedElements;
    private final int startIndex;
    private final KnownOrder knownOrder;
    private static final IteratorOperation REMOVE_METHOD = new IteratorOperation(){

        @Override
        public Object execute(Iterator<?> iterator) {
            iterator.remove();
            return null;
        }
    };
    private static final IteratorOperation NEXT_METHOD = new IteratorOperation(){

        @Override
        public Object execute(Iterator<?> iterator) {
            return iterator.next();
        }
    };
    private static final IteratorOperation PREVIOUS_METHOD = new IteratorOperation(){

        @Override
        public Object execute(Iterator<?> iterator) {
            return ((ListIterator)iterator).previous();
        }
    };
    Stimulus<Iterator<E>> hasNext = new Stimulus<Iterator<E>>("hasNext"){

        @Override
        boolean executeAndCompare(ListIterator<E> reference, Iterator<E> target) {
            Assert.assertEquals(reference.hasNext(), target.hasNext());
            return false;
        }
    };
    Stimulus<Iterator<E>> next = new Stimulus<Iterator<E>>("next"){

        @Override
        boolean executeAndCompare(ListIterator<E> reference, Iterator<E> target) {
            return AbstractIteratorTester.this.internalExecuteAndCompare(reference, target, NEXT_METHOD);
        }
    };
    Stimulus<Iterator<E>> remove = new Stimulus<Iterator<E>>("remove"){

        @Override
        boolean executeAndCompare(ListIterator<E> reference, Iterator<E> target) {
            return AbstractIteratorTester.this.internalExecuteAndCompare(reference, target, REMOVE_METHOD);
        }
    };
    Stimulus<ListIterator<E>> hasPrevious = new Stimulus<ListIterator<E>>("hasPrevious"){

        @Override
        boolean executeAndCompare(ListIterator<E> reference, ListIterator<E> target) {
            Assert.assertEquals(reference.hasPrevious(), target.hasPrevious());
            return false;
        }
    };
    Stimulus<ListIterator<E>> nextIndex = new Stimulus<ListIterator<E>>("nextIndex"){

        @Override
        boolean executeAndCompare(ListIterator<E> reference, ListIterator<E> target) {
            Assert.assertEquals(reference.nextIndex(), target.nextIndex());
            return false;
        }
    };
    Stimulus<ListIterator<E>> previousIndex = new Stimulus<ListIterator<E>>("previousIndex"){

        @Override
        boolean executeAndCompare(ListIterator<E> reference, ListIterator<E> target) {
            Assert.assertEquals(reference.previousIndex(), target.previousIndex());
            return false;
        }
    };
    Stimulus<ListIterator<E>> previous = new Stimulus<ListIterator<E>>("previous"){

        @Override
        boolean executeAndCompare(ListIterator<E> reference, ListIterator<E> target) {
            return AbstractIteratorTester.this.internalExecuteAndCompare(reference, target, PREVIOUS_METHOD);
        }
    };
    Stimulus<ListIterator<E>> add = new Stimulus<ListIterator<E>>("add"){

        @Override
        boolean executeAndCompare(ListIterator<E> reference, ListIterator<E> target) {
            return AbstractIteratorTester.this.internalExecuteAndCompare(reference, target, AbstractIteratorTester.this.newAddMethod());
        }
    };
    Stimulus<ListIterator<E>> set = new Stimulus<ListIterator<E>>("set"){

        @Override
        boolean executeAndCompare(ListIterator<E> reference, ListIterator<E> target) {
            return AbstractIteratorTester.this.internalExecuteAndCompare(reference, target, AbstractIteratorTester.this.newSetMethod());
        }
    };

    public void ignoreSunJavaBug6529795() {
        this.whenNextThrowsExceptionStopTestingCallsToRemove = true;
    }

    public void stopTestingWhenAddThrowsException() {
        this.whenAddThrowsExceptionStopTesting = true;
    }

    AbstractIteratorTester(int steps, Iterable<E> elementsToInsertIterable, Iterable<? extends IteratorFeature> features, Iterable<E> expectedElements, KnownOrder knownOrder, int startIndex) {
        this.stimuli = new Stimulus[steps];
        if (!elementsToInsertIterable.iterator().hasNext()) {
            throw new IllegalArgumentException();
        }
        this.elementsToInsert = Helpers.cycle(elementsToInsertIterable);
        this.features = Helpers.copyToSet(features);
        this.expectedElements = Helpers.copyToList(expectedElements);
        this.knownOrder = knownOrder;
        this.startIndex = startIndex;
    }

    protected abstract Iterable<? extends Stimulus<? super I>> getStimulusValues();

    protected abstract I newTargetIterator();

    protected void verify(List<E> elements) {
    }

    public final void test() throws Exception {
        try {
            this.recurse(0);
        }
        catch (Exception e) {
            throw new Exception(Arrays.toString(this.stimuli), e);
        }
    }

    private void recurse(int level) throws Exception {
        if (level == this.stimuli.length) {
            this.compareResultsForThisListOfStimuli();
        } else {
            for (Stimulus<I> stimulus : this.getStimulusValues()) {
                this.stimuli[level] = stimulus;
                this.recurse(level + 1);
            }
        }
    }

    private void compareResultsForThisListOfStimuli() {
        Stimulus<I> stimulus;
        MultiExceptionListIterator reference = new MultiExceptionListIterator(this.expectedElements);
        I target = this.newTargetIterator();
        boolean shouldStopTestingCallsToRemove = false;
        for (int i = 0; !(i >= this.stimuli.length || (stimulus = this.stimuli[i]).equals(this.remove) && shouldStopTestingCallsToRemove); ++i) {
            try {
                boolean threwException = stimulus.executeAndCompare(reference, target);
                if (threwException && stimulus.equals(this.next) && this.whenNextThrowsExceptionStopTestingCallsToRemove) {
                    shouldStopTestingCallsToRemove = true;
                }
                if (threwException && stimulus.equals(this.add) && this.whenAddThrowsExceptionStopTesting) break;
                List elements = reference.getElements();
                this.verify(elements);
                continue;
            }
            catch (AssertionFailedError cause) {
                Helpers.fail((Throwable)((Object)cause), "failed with stimuli " + AbstractIteratorTester.subListCopy(this.stimuli, i + 1));
            }
        }
    }

    private static List<Object> subListCopy(Object[] source, int size) {
        Object[] copy = new Object[size];
        System.arraycopy(source, 0, copy, 0, size);
        return Arrays.asList(copy);
    }

    private <T extends Iterator<E>> boolean internalExecuteAndCompare(T reference, T target, IteratorOperation method) throws AssertionFailedError {
        Object referenceReturnValue = null;
        PermittedMetaException referenceException = null;
        Object targetReturnValue = null;
        RuntimeException targetException = null;
        try {
            targetReturnValue = method.execute(target);
        }
        catch (RuntimeException e) {
            targetException = e;
        }
        try {
            if (method == NEXT_METHOD && targetException == null && this.knownOrder == KnownOrder.UNKNOWN_ORDER) {
                Object targetReturnValueFromNext = targetReturnValue;
                ((MultiExceptionListIterator)reference).promoteToNext(targetReturnValueFromNext);
            }
            referenceReturnValue = method.execute(reference);
        }
        catch (PermittedMetaException e) {
            referenceException = e;
        }
        catch (UnknownElementException e) {
            Helpers.fail(e, e.getMessage());
        }
        if (referenceException == null) {
            if (targetException != null) {
                Helpers.fail(targetException, "Target threw exception when reference did not");
            }
            Assert.assertEquals(referenceReturnValue, targetReturnValue);
            return false;
        }
        if (targetException == null) {
            Assert.fail("Target failed to throw " + referenceException);
        }
        referenceException.assertPermitted(targetException);
        return true;
    }

    private final IteratorOperation newAddMethod() {
        final E toInsert = this.elementsToInsert.next();
        return new IteratorOperation(){

            @Override
            public Object execute(Iterator<?> iterator) {
                ListIterator rawIterator = (ListIterator)iterator;
                rawIterator.add(toInsert);
                return null;
            }
        };
    }

    private final IteratorOperation newSetMethod() {
        final E toInsert = this.elementsToInsert.next();
        return new IteratorOperation(){

            @Override
            public Object execute(Iterator<?> iterator) {
                ListIterator li = (ListIterator)iterator;
                li.set(toInsert);
                return null;
            }
        };
    }

    List<Stimulus<Iterator<E>>> iteratorStimuli() {
        return Arrays.asList(this.hasNext, this.next, this.remove);
    }

    List<Stimulus<ListIterator<E>>> listIteratorStimuli() {
        return Arrays.asList(this.hasPrevious, this.nextIndex, this.previousIndex, this.previous, this.add, this.set);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class Stimulus<T extends Iterator<?>> {
        private final String toString;

        protected Stimulus(String toString) {
            this.toString = toString;
        }

        abstract boolean executeAndCompare(ListIterator<E> var1, T var2);

        public String toString() {
            return this.toString;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface IteratorOperation {
        public Object execute(Iterator<?> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KnownOrder {
        KNOWN_ORDER,
        UNKNOWN_ORDER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class MultiExceptionListIterator
    implements ListIterator<E> {
        final Stack<E> nextElements = new Stack();
        final Stack<E> previousElements = new Stack();
        Stack<E> stackWithLastReturnedElementAtTop = null;

        MultiExceptionListIterator(List<E> expectedElements) {
            Helpers.addAll(this.nextElements, Helpers.reverse(expectedElements));
            for (int i = 0; i < AbstractIteratorTester.this.startIndex; ++i) {
                this.previousElements.push(this.nextElements.pop());
            }
        }

        @Override
        public void add(E e) {
            if (!AbstractIteratorTester.this.features.contains((Object)IteratorFeature.SUPPORTS_ADD)) {
                throw new PermittedMetaException(UnsupportedOperationException.class);
            }
            this.previousElements.push(e);
            this.stackWithLastReturnedElementAtTop = null;
        }

        @Override
        public boolean hasNext() {
            return !this.nextElements.isEmpty();
        }

        @Override
        public boolean hasPrevious() {
            return !this.previousElements.isEmpty();
        }

        @Override
        public E next() {
            return this.transferElement(this.nextElements, this.previousElements);
        }

        @Override
        public int nextIndex() {
            return this.previousElements.size();
        }

        @Override
        public E previous() {
            return this.transferElement(this.previousElements, this.nextElements);
        }

        @Override
        public int previousIndex() {
            return this.nextIndex() - 1;
        }

        @Override
        public void remove() {
            this.throwIfInvalid(IteratorFeature.SUPPORTS_REMOVE);
            this.stackWithLastReturnedElementAtTop.pop();
            this.stackWithLastReturnedElementAtTop = null;
        }

        @Override
        public void set(E e) {
            this.throwIfInvalid(IteratorFeature.SUPPORTS_SET);
            this.stackWithLastReturnedElementAtTop.pop();
            this.stackWithLastReturnedElementAtTop.push(e);
        }

        void promoteToNext(E e) {
            if (!this.nextElements.remove(e)) {
                throw new UnknownElementException(this.nextElements, e);
            }
            this.nextElements.push(e);
        }

        private E transferElement(Stack<E> source, Stack<E> destination) {
            if (source.isEmpty()) {
                throw new PermittedMetaException(NoSuchElementException.class);
            }
            destination.push(source.pop());
            this.stackWithLastReturnedElementAtTop = destination;
            return destination.peek();
        }

        private void throwIfInvalid(IteratorFeature methodFeature) {
            HashSet<Class> exceptions = new HashSet<Class>();
            if (!AbstractIteratorTester.this.features.contains((Object)methodFeature)) {
                exceptions.add(UnsupportedOperationException.class);
            }
            if (this.stackWithLastReturnedElementAtTop == null) {
                exceptions.add(IllegalStateException.class);
            }
            if (!exceptions.isEmpty()) {
                throw new PermittedMetaException(exceptions);
            }
        }

        private List<E> getElements() {
            ArrayList elements = new ArrayList();
            Helpers.addAll(elements, this.previousElements);
            Helpers.addAll(elements, Helpers.reverse(this.nextElements));
            return elements;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnknownElementException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        private UnknownElementException(Collection<?> expected, Object actual) {
            super("Returned value '" + actual + "' not found. Remaining elements: " + expected);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PermittedMetaException
    extends RuntimeException {
        final Set<? extends Class<? extends RuntimeException>> exceptionClasses;
        private static final long serialVersionUID = 0L;

        PermittedMetaException(Set<? extends Class<? extends RuntimeException>> exceptionClasses) {
            super("one of " + exceptionClasses);
            this.exceptionClasses = exceptionClasses;
        }

        PermittedMetaException(Class<? extends RuntimeException> exceptionClass) {
            this(Collections.singleton(exceptionClass));
        }

        boolean isPermitted(RuntimeException exception) {
            for (Class<? extends RuntimeException> clazz : this.exceptionClasses) {
                if (!clazz.isInstance(exception)) continue;
                return true;
            }
            return false;
        }

        void assertPermitted(RuntimeException exception) {
            if (!this.isPermitted(exception)) {
                String message = "Exception " + exception.getClass() + " was thrown; expected " + this;
                Helpers.fail(exception, message);
            }
        }

        @Override
        public String toString() {
            return this.getMessage();
        }
    }
}

