/*
 * Decompiled with CFR 0.152.
 */
package JFlex.tests;

import JFlex.Options;
import JFlex.Skeleton;
import JFlex.anttask.JFlexTask;
import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;

public class AntTaskTests
extends TestCase {
    private JFlexTask task;

    public AntTaskTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Options.setDefaults();
        this.task = new JFlexTask();
    }

    public void testPackageAndClass() throws IOException {
        this.task.setFile(new File("src/JFlex/LexScan.flex"));
        this.task.findPackageAndClass();
        Assert.assertEquals(this.task.getPackage(), "JFlex");
        Assert.assertEquals(this.task.getClassName(), "LexScan");
    }

    public void testPackageAndClassDefaults() throws IOException {
        this.task.setFile(new File("examples/simple/simple.flex"));
        this.task.findPackageAndClass();
        Assert.assertEquals(this.task.getPackage(), null);
        Assert.assertEquals(this.task.getClassName(), "Yylex");
    }

    public void testDestdir() throws IOException {
        this.task.setFile(new File("src/JFlex/LexScan.flex"));
        File dir = new File("src");
        this.task.setDestdir(dir);
        this.task.findPackageAndClass();
        this.task.normalizeOutdir();
        Assert.assertEquals(Options.getDir(), new File(dir, "JFlex"));
    }

    public void testOutdir() throws IOException {
        this.task.setFile(new File("src/JFlex/LexScan.flex"));
        File dir = new File("src");
        this.task.setOutdir(dir);
        this.task.findPackageAndClass();
        this.task.normalizeOutdir();
        Assert.assertEquals(Options.getDir(), dir);
    }

    public void testDefaultDir() throws IOException {
        this.task.setFile(new File("src/JFlex/LexScan.flex"));
        this.task.findPackageAndClass();
        this.task.normalizeOutdir();
        Assert.assertEquals(Options.getDir(), new File("src/JFlex"));
    }

    public void testNomin() {
        Assert.assertTrue(!Options.no_minimize);
        this.task.setNomin(true);
        Assert.assertTrue(Options.no_minimize);
    }

    public void testSkipMinimization() {
        Assert.assertTrue(!Options.no_minimize);
        this.task.setSkipMinimization(true);
        Assert.assertTrue(Options.no_minimize);
    }

    public void testNobak() {
        Assert.assertTrue(!Options.no_backup);
        this.task.setNobak(true);
        Assert.assertTrue(Options.no_backup);
    }

    public void testCodeGen() {
        this.task.setSwitch(true);
        Assert.assertEquals(Options.gen_method, 2);
        this.task.setTable(true);
        Assert.assertEquals(Options.gen_method, 1);
        this.task.setPack(true);
        Assert.assertEquals(Options.gen_method, 0);
    }

    public void testSkel() {
        this.task.setVerbose(false);
        this.task.setSkeleton(new File("src/skeleton.nested"));
        Assert.assertTrue(Skeleton.line[3].indexOf("java.util.Stack") > 0);
    }

    public void testVerbose() {
        this.task.setVerbose(false);
        Assert.assertTrue(!Options.verbose);
        this.task.setVerbose(true);
        Assert.assertTrue(Options.verbose);
    }

    public void testTime() {
        Assert.assertTrue(!Options.time);
        this.task.setTimeStatistics(true);
        Assert.assertTrue(Options.time);
        this.task.setTime(false);
        Assert.assertTrue(!Options.time);
    }

    public void testDot() {
        Assert.assertTrue(!Options.dot);
        this.task.setDot(true);
        Assert.assertTrue(Options.dot);
        this.task.setGenerateDot(false);
        Assert.assertTrue(!Options.dot);
    }

    public void testDump() {
        Assert.assertTrue(!Options.dump);
        this.task.setDump(true);
        Assert.assertTrue(Options.dump);
    }

    public void testJlex() {
        Assert.assertTrue(!Options.jlex);
        this.task.setJLex(true);
        Assert.assertTrue(Options.jlex);
    }
}

