/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.structs.H5G_info_t;
import ncsa.hdf.hdf5lib.structs.H5L_info_t;
import ncsa.hdf.hdf5lib.structs.H5O_info_t;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.object.h5.H5CompoundDS;
import ncsa.hdf.object.h5.H5Datatype;
import ncsa.hdf.object.h5.H5Group;
import ncsa.hdf.object.h5.H5Link;
import ncsa.hdf.object.h5.H5ScalarDS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H5File
extends FileFormat {
    private static final long serialVersionUID = 6247335559471526045L;
    private static final Logger log = LoggerFactory.getLogger(H5File.class);
    private int flag;
    private int indexType = HDF5Constants.H5_INDEX_NAME;
    private int indexOrder = HDF5Constants.H5_ITER_INC;
    private DefaultMutableTreeNode rootNode = null;
    private static final int attrNameLen = 256;
    private int[] libver = new int[2];
    private boolean attrFlag = false;

    public H5File() {
        this("", 2);
    }

    public H5File(String string) {
        this(string, 4);
    }

    public H5File(String string, int n) {
        super(string);
        this.fid = -1;
        boolean bl = this.isReadOnly = n == 2;
        this.flag = n == 2 ? HDF5Constants.H5F_ACC_RDONLY : (n == 4 ? HDF5Constants.H5F_ACC_RDWR : (n == 8 ? HDF5Constants.H5F_ACC_CREAT : n));
    }

    public static final void copyAttributes(HObject hObject, HObject hObject2) {
        if (hObject != null && hObject2 != null) {
            int n = hObject.open();
            int n2 = hObject2.open();
            if (n >= 0 && n2 >= 0) {
                H5File.copyAttributes(n, n2);
            }
            if (n >= 0) {
                hObject.close(n);
            }
            if (n2 >= 0) {
                hObject2.close(n2);
            }
        }
    }

    public static final void copyAttributes(int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        String[] stringArray = new String[]{""};
        H5O_info_t h5O_info_t = null;
        try {
            h5O_info_t = H5.H5Oget_info(n);
        }
        catch (Exception exception) {
            h5O_info_t.num_attrs = -1L;
        }
        if (h5O_info_t.num_attrs < 0L) {
            return;
        }
        int n7 = 0;
        while ((long)n7 < h5O_info_t.num_attrs) {
            stringArray[0] = new String("");
            try {
                n3 = H5.H5Aopen_by_idx(n, ".", HDF5Constants.H5_INDEX_CRT_ORDER, HDF5Constants.H5_ITER_INC, n7, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
                H5.H5Aget_name(n3, 256L, stringArray);
                n5 = H5.H5Aget_type(n3);
                n6 = H5.H5Aget_space(n3);
                n4 = H5.H5Acreate(n2, stringArray[0], n5, n6, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
                H5.H5Acopy(n3, n4);
            }
            catch (Exception exception) {
                log.debug("Attribute[{}] failure: ", (Object)n7, (Object)exception);
            }
            try {
                H5.H5Sclose(n6);
            }
            catch (Exception exception) {
                log.debug("H5Sclose failure: ", (Throwable)exception);
            }
            try {
                H5.H5Tclose(n5);
            }
            catch (Exception exception) {
                log.debug("H5Tclose failure: ", (Throwable)exception);
            }
            try {
                H5.H5Aclose(n3);
            }
            catch (Exception exception) {
                log.debug("src H5Aclose failure: ", (Throwable)exception);
            }
            try {
                H5.H5Aclose(n4);
            }
            catch (Exception exception) {
                log.debug("dst H5Aclose failure: ", (Throwable)exception);
            }
            ++n7;
        }
    }

    public static final List<Attribute> getAttribute(int n) throws HDF5Exception {
        return H5File.getAttribute(n, HDF5Constants.H5_INDEX_NAME, HDF5Constants.H5_ITER_INC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<Attribute> getAttribute(int n, int n2, int n3) throws HDF5Exception {
        Vector<Attribute> vector = null;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        H5O_info_t h5O_info_t = null;
        log.trace("getAttribute: start");
        try {
            h5O_info_t = H5.H5Oget_info(n);
        }
        catch (Exception exception) {
            log.debug("H5Oget_info failure: ", (Throwable)exception);
        }
        if (h5O_info_t.num_attrs <= 0L) {
            vector = new Vector<Attribute>();
            return vector;
        }
        int n7 = (int)h5O_info_t.num_attrs;
        vector = new Vector(n7);
        log.trace("getAttribute: num_attrs={}", (Object)n7);
        for (int i = 0; i < n7; ++i) {
            long l = 1L;
            log.trace("getAttribute: attribute[{}]", (Object)i);
            try {
                n4 = H5.H5Aopen_by_idx(n, ".", n2, n3, i, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
                n5 = H5.H5Aget_space(n4);
                long[] lArray = null;
                int n8 = H5.H5Sget_simple_extent_ndims(n5);
                if (n8 > 0) {
                    lArray = new long[n8];
                    H5.H5Sget_simple_extent_dims(n5, lArray, null);
                    for (int j = 0; j < lArray.length; ++j) {
                        l *= lArray[j];
                    }
                }
                String[] stringArray = new String[]{""};
                H5.H5Aget_name(n4, 256L, stringArray);
                log.trace("getAttribute: attribute[{}] is {}", (Object)i, (Object)stringArray);
                int n9 = -1;
                try {
                    n9 = H5.H5Aget_type(n4);
                    n6 = H5.H5Tget_native_type(n9);
                    log.trace("getAttribute: attribute[{}] tid={} native tmptid={} from aid={}", new Object[]{i, n6, n9, n4});
                }
                finally {
                    try {
                        H5.H5Tclose(n9);
                    }
                    catch (Exception exception) {
                        log.debug("H5Tclose failure: ", (Throwable)exception);
                    }
                }
                H5Datatype h5Datatype = new H5Datatype(n6);
                Attribute attribute = new Attribute(stringArray[0], h5Datatype, lArray);
                vector.add(attribute);
                log.trace("getAttribute: attribute[{}] Datatype={}", (Object)i, (Object)((Datatype)h5Datatype).getDatatypeDescription());
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                int n10 = H5.H5Tget_class(n6);
                if (lArray == null) {
                    bl4 = true;
                }
                try {
                    bl = H5.H5Tis_variable_str(n6);
                }
                catch (Exception exception) {
                    log.debug("H5Tis_variable_str failure: ", (Throwable)exception);
                }
                bl2 = n10 == HDF5Constants.H5T_VLEN;
                bl3 = n10 == HDF5Constants.H5T_COMPOUND;
                log.trace("getAttribute: attribute[{}] has size={} isCompound={} isScalar={} is_variable_str={} isVLEN={}", new Object[]{i, l, bl3, bl4, bl, bl2});
                if (l <= 0L) continue;
                Object[] objectArray = null;
                if (bl2 || bl || bl3 || bl4 && n10 == HDF5Constants.H5T_ARRAY) {
                    String[] stringArray2 = new String[(int)l];
                    int n11 = 0;
                    while ((long)n11 < l) {
                        stringArray2[n11] = "";
                        ++n11;
                    }
                    try {
                        log.trace("getAttribute: attribute[{}] H5AreadVL", (Object)i);
                        H5.H5AreadVL(n4, n6, stringArray2);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    objectArray = stringArray2;
                } else {
                    objectArray = H5Datatype.allocateArray(n6, (int)l);
                    if (objectArray == null) continue;
                    if (n10 == HDF5Constants.H5T_ARRAY) {
                        int n12 = -1;
                        int n13 = -1;
                        try {
                            log.trace("getAttribute: attribute[{}] H5Aread ARRAY tid={}", (Object)i, (Object)n6);
                            H5.H5Aread(n4, n6, objectArray);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        finally {
                            try {
                                H5.H5Tclose(n12);
                            }
                            catch (Exception exception) {
                                log.debug("tid1 H5Tclose failure: ", (Throwable)exception);
                            }
                            try {
                                H5.H5Tclose(n13);
                            }
                            catch (Exception exception) {
                                log.debug("tid2 H5Tclose failure: ", (Throwable)exception);
                            }
                        }
                    } else {
                        log.trace("getAttribute: attribute[{}] H5Aread", (Object)i);
                        H5.H5Aread(n4, n6, objectArray);
                    }
                    if (n10 == HDF5Constants.H5T_STRING) {
                        log.trace("getAttribute: attribute[{}] byteToString", (Object)i);
                        objectArray = Dataset.byteToString((byte[])objectArray, H5.H5Tget_size(n6));
                    } else if (n10 == HDF5Constants.H5T_REFERENCE) {
                        log.trace("getAttribute: attribute[{}] byteToLong", (Object)i);
                        objectArray = HDFNativeData.byteToLong((byte[])objectArray);
                    }
                }
                attribute.setValue(objectArray);
                continue;
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("Attribute[{}] inspection failure: ", (Object)i, (Object)hDF5Exception);
                continue;
            }
            finally {
                try {
                    H5.H5Tclose(n6);
                }
                catch (Exception exception) {
                    log.debug("H5Tclose[{}] failure: ", (Object)i, (Object)exception);
                }
                try {
                    H5.H5Sclose(n5);
                }
                catch (Exception exception) {
                    log.debug("H5Sclose[{}] failure: ", (Object)i, (Object)exception);
                }
                try {
                    H5.H5Aclose(n4);
                }
                catch (Exception exception) {
                    log.debug("H5Aclose[{}] failure: ", (Object)i, (Object)exception);
                }
            }
        }
        log.trace("getAttribute: finish");
        return vector;
    }

    private static final void createImageAttributes(Dataset dataset, int n) throws Exception {
        String string = null;
        String string2 = null;
        if (n == 0) {
            string = "IMAGE_TRUECOLOR";
            string2 = "INTERLACE_PIXEL";
        } else if (n == 2) {
            string = "IMAGE_TRUECOLOR";
            string2 = "INTERLACE_PLANE";
        } else if (n == -1) {
            string = "IMAGE_INDEXED";
        } else {
            throw new HDF5Exception("The selectionFlag is invalid.");
        }
        String string3 = "CLASS";
        String[] stringArray = new String[]{"IMAGE"};
        H5Datatype h5Datatype = new H5Datatype(3, stringArray[0].length() + 1, -1, -1);
        Attribute attribute = new Attribute(string3, h5Datatype, null);
        attribute.setValue(stringArray);
        dataset.writeMetadata(attribute);
        string3 = "IMAGE_VERSION";
        String[] stringArray2 = new String[]{"1.2"};
        h5Datatype = new H5Datatype(3, stringArray2[0].length() + 1, -1, -1);
        attribute = new Attribute(string3, h5Datatype, null);
        attribute.setValue(stringArray2);
        dataset.writeMetadata(attribute);
        long[] lArray = new long[]{2L};
        string3 = "IMAGE_MINMAXRANGE";
        byte[] byArray = new byte[]{0, -1};
        h5Datatype = new H5Datatype(2, 1, -1, 0);
        attribute = new Attribute(string3, h5Datatype, lArray);
        attribute.setValue(byArray);
        dataset.writeMetadata(attribute);
        string3 = "IMAGE_SUBCLASS";
        String[] stringArray3 = new String[]{string};
        h5Datatype = new H5Datatype(3, stringArray3[0].length() + 1, -1, -1);
        attribute = new Attribute(string3, h5Datatype, null);
        attribute.setValue(stringArray3);
        dataset.writeMetadata(attribute);
        if (n == 0 || n == 2) {
            string3 = "INTERLACE_MODE";
            String[] stringArray4 = new String[]{string2};
            h5Datatype = new H5Datatype(3, stringArray4[0].length() + 1, -1, -1);
            attribute = new Attribute(string3, h5Datatype, null);
            attribute.setValue(stringArray4);
            dataset.writeMetadata(attribute);
        } else {
            string3 = "PALETTE";
            long[] lArray2 = new long[]{0L};
            h5Datatype = new H5Datatype(7, 1, -1, 0);
            attribute = new Attribute(string3, h5Datatype, null);
            attribute.setValue(lArray2);
            dataset.writeMetadata(attribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void updateReferenceDataset(H5File h5File, H5File h5File2) throws Exception {
        ScalarDS scalarDS;
        if (h5File == null || h5File2 == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)h5File.getRootNode();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)h5File2.getRootNode();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        Enumeration<TreeNode> enumeration2 = defaultMutableTreeNode2.breadthFirstEnumeration();
        int n = -1;
        int n2 = -1;
        Hashtable<String, long[]> hashtable = new Hashtable<String, long[]>();
        Vector<ScalarDS> vector = new Vector<ScalarDS>();
        while (enumeration2.hasMoreElements() && enumeration.hasMoreElements()) {
            HObject hObject = (HObject)((DefaultMutableTreeNode)enumeration.nextElement()).getUserObject();
            HObject hObject2 = (HObject)((DefaultMutableTreeNode)enumeration2.nextElement()).getUserObject();
            hashtable.put(String.valueOf(hObject.getOID()[0]), hObject2.getOID());
            n = -1;
            n2 = -1;
            if (!(hObject2 instanceof ScalarDS)) continue;
            scalarDS = (ScalarDS)hObject2;
            n = scalarDS.open();
            if (n >= 0) {
                try {
                    n2 = H5.H5Dget_type(n);
                    if (H5.H5Tequal(n2, HDF5Constants.H5T_STD_REF_OBJ)) {
                        vector.add(scalarDS);
                    }
                }
                catch (Exception exception) {
                    log.debug("ScalarDS reference  failure: ", (Throwable)exception);
                }
                finally {
                    try {
                        H5.H5Tclose(n2);
                    }
                    catch (Exception exception) {
                        log.debug("ScalarDS reference H5Tclose failure: ", (Throwable)exception);
                    }
                }
            }
            scalarDS.close(n);
        }
        scalarDS = null;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        int n6 = vector.size();
        for (int i = 0; i < n6; ++i) {
            log.trace("Update the references in the scalar datasets in the dest file");
            scalarDS = (H5ScalarDS)vector.get(i);
            byte[] byArray = null;
            long[] lArray = null;
            try {
                n = ((H5ScalarDS)scalarDS).open();
                if (n >= 0) {
                    n2 = H5.H5Dget_type(n);
                    n3 = H5.H5Dget_space(n);
                    n5 = H5.H5Sget_simple_extent_ndims(n3);
                    n4 = 1;
                    if (n5 > 0) {
                        long[] lArray2 = new long[n5];
                        H5.H5Sget_simple_extent_dims(n3, lArray2, null);
                        for (int j = 0; j < n5; ++j) {
                            n4 *= (int)lArray2[j];
                        }
                        lArray2 = null;
                    }
                    byArray = new byte[n4 * 8];
                    H5.H5Dread(n, n2, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, byArray);
                    lArray = HDFNativeData.byteToLong(byArray);
                    n4 = lArray.length;
                    for (int j = 0; j < n4; ++j) {
                        long[] lArray3 = (long[])hashtable.get(String.valueOf(lArray[j]));
                        if (lArray3 == null) continue;
                        lArray[j] = lArray3[0];
                    }
                    H5.H5Dwrite(n, n2, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, lArray);
                } else {
                    log.debug("dest file dataset failed to open");
                }
            }
            catch (Exception exception) {
                continue;
            }
            finally {
                try {
                    H5.H5Tclose(n2);
                }
                catch (Exception exception) {
                    log.debug("H5ScalarDS reference[{}] H5Tclose failure: ", (Object)i, (Object)exception);
                }
                try {
                    H5.H5Sclose(n3);
                }
                catch (Exception exception) {
                    log.debug("H5ScalarDS reference[{}] H5Sclose failure: ", (Object)i, (Object)exception);
                }
                try {
                    H5.H5Dclose(n);
                }
                catch (Exception exception) {
                    log.debug("H5ScalarDS reference[{}] H5Dclose failure: ", (Object)i, (Object)exception);
                }
            }
            lArray = null;
            byArray = null;
        }
    }

    @Override
    public String getLibversion() {
        int[] nArray = new int[3];
        String string = "HDF5 ";
        try {
            H5.H5get_libversion(nArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        string = string + nArray[0] + "." + nArray[1] + "." + nArray[2];
        log.debug("libversion is {}", (Object)string);
        return string;
    }

    @Override
    public boolean isThisType(FileFormat fileFormat) {
        return fileFormat instanceof H5File;
    }

    @Override
    public boolean isThisType(String string) {
        boolean bl = false;
        try {
            bl = H5.H5Fis_hdf5(string);
        }
        catch (HDF5Exception hDF5Exception) {
            bl = false;
        }
        return bl;
    }

    @Override
    public FileFormat createFile(String string, int n) throws Exception {
        File file;
        Boolean bl = true;
        if ((n & 0x14) == 20 && (file = new File(string)).exists()) {
            bl = false;
        }
        if (bl.booleanValue()) {
            int n2 = H5.H5Pcreate(HDF5Constants.H5P_FILE_ACCESS);
            if ((n & 0x28) != 40) {
                H5.H5Pset_libver_bounds(n2, HDF5Constants.H5F_LIBVER_LATEST, HDF5Constants.H5F_LIBVER_LATEST);
            }
            int n3 = H5.H5Fcreate(string, HDF5Constants.H5F_ACC_TRUNC, HDF5Constants.H5P_DEFAULT, n2);
            try {
                H5.H5Pclose(n2);
                H5.H5Fclose(n3);
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("H5 file, {} failure: ", (Object)string, (Object)hDF5Exception);
            }
        }
        return new H5File(string, 4);
    }

    @Override
    public FileFormat createInstance(String string, int n) throws Exception {
        return new H5File(string, n);
    }

    @Override
    public int open() throws Exception {
        return this.open(true);
    }

    @Override
    public int open(int ... nArray) throws Exception {
        this.setIndexType(nArray[0]);
        return this.open(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLibBounds(int n, int n2) throws Exception {
        int n3 = HDF5Constants.H5P_DEFAULT;
        if (this.fid < 0) {
            return;
        }
        n3 = H5.H5Fget_access_plist(this.fid);
        try {
            if (n < 0) {
                n = HDF5Constants.H5F_LIBVER_EARLIEST;
            }
            if (n2 < 0) {
                n2 = HDF5Constants.H5F_LIBVER_LATEST;
            }
            H5.H5Pset_libver_bounds(n3, n, n2);
            H5.H5Pget_libver_bounds(n3, this.libver);
        }
        finally {
            try {
                H5.H5Pclose(n3);
            }
            catch (Exception exception) {
                log.debug("libver bounds H5Pclose failure: ", (Throwable)exception);
            }
        }
    }

    @Override
    public int[] getLibBounds() throws Exception {
        return this.libver;
    }

    @Override
    public void close() throws HDF5Exception {
        Object object;
        if (this.fid < 0) {
            log.debug("file {} is not open", (Object)this.fullFileName);
            return;
        }
        String string = System.getProperty("hdfview.root");
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        H5.H5Dchdir_ext(string);
        if (this.rootNode != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            HObject hObject = null;
            object = this.rootNode.breadthFirstEnumeration();
            while (object.hasMoreElements()) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)object.nextElement();
                hObject = (HObject)defaultMutableTreeNode.getUserObject();
                if (hObject instanceof Dataset) {
                    ((Dataset)hObject).clear();
                    continue;
                }
                if (!(hObject instanceof Group)) continue;
                ((Group)hObject).clear();
            }
        }
        try {
            int n = 0;
            int n2 = -1;
            n = H5.H5Fget_obj_count(this.fid, HDF5Constants.H5F_OBJ_ALL);
            if (n > 0) {
                object = new int[n];
                H5.H5Fget_obj_ids(this.fid, HDF5Constants.H5F_OBJ_ALL, n, (int[])object);
                for (int i = 0; i < n; ++i) {
                    n2 = H5.H5Iget_type((int)object[i]);
                    if (HDF5Constants.H5I_DATASET == n2) {
                        try {
                            H5.H5Dclose((int)object[i]);
                        }
                        catch (Exception exception) {
                            log.debug("Object[{}] H5Dclose failure: ", (Object)i, (Object)exception);
                        }
                        continue;
                    }
                    if (HDF5Constants.H5I_GROUP == n2) {
                        try {
                            H5.H5Gclose((int)object[i]);
                        }
                        catch (Exception exception) {
                            log.debug("Object[{}] H5Gclose failure: ", (Object)i, (Object)exception);
                        }
                        continue;
                    }
                    if (HDF5Constants.H5I_DATATYPE == n2) {
                        try {
                            H5.H5Tclose((int)object[i]);
                        }
                        catch (Exception exception) {
                            log.debug("Object[{}] H5Tclose failure: ", (Object)i, (Object)exception);
                        }
                        continue;
                    }
                    if (HDF5Constants.H5I_ATTR != n2) continue;
                    try {
                        H5.H5Aclose((int)object[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        log.debug("Object[{}] H5Aclose failure: ", (Object)i, (Object)exception);
                    }
                }
            }
        }
        catch (Exception exception) {
            log.debug("close open objects failure: ", (Throwable)exception);
        }
        try {
            H5.H5Fflush(this.fid, HDF5Constants.H5F_SCOPE_GLOBAL);
        }
        catch (Exception exception) {
            log.debug("H5Fflush failure: ", (Throwable)exception);
        }
        try {
            H5.H5Fclose(this.fid);
        }
        catch (Exception exception) {
            log.debug("H5Fclose failure: ", (Throwable)exception);
        }
        this.fid = -1;
    }

    @Override
    public TreeNode getRootNode() {
        return this.rootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HObject get(String string) throws Exception {
        int n;
        HObject hObject = null;
        if (string == null || string.length() <= 0) {
            System.err.println("(path == null) || (path.length() <= 0)");
            return null;
        }
        string = string.replace('\\', '/');
        string = "/" + string;
        string = string.replaceAll("//", "/");
        if (this.rootNode != null) {
            hObject = H5File.findObject((FileFormat)this, string);
        }
        if (hObject != null) {
            return hObject;
        }
        String string2 = null;
        String string3 = null;
        if (string.equals("/")) {
            string2 = "/";
        } else {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            n = string.lastIndexOf(47);
            string2 = string.substring(n + 1);
            string3 = n == 0 ? "/" : string.substring(0, n);
        }
        n = this.fid;
        this.fid = this.open(false);
        if (this.fid < 0) {
            System.err.println("Could not open file handler");
            return null;
        }
        try {
            int n2 = H5.H5Oopen(this.fid, string, HDF5Constants.H5P_DEFAULT);
            if (n2 >= 0) {
                int n3;
                H5O_info_t h5O_info_t = H5.H5Oget_info(n2);
                int n4 = h5O_info_t.type;
                if (n4 == HDF5Constants.H5O_TYPE_DATASET) {
                    n3 = -1;
                    try {
                        n3 = H5.H5Dopen(this.fid, string, HDF5Constants.H5P_DEFAULT);
                        hObject = this.getDataset(n3, string2, string3);
                    }
                    finally {
                        try {
                            H5.H5Dclose(n3);
                        }
                        catch (Exception exception) {
                            log.debug("{} H5Dclose failure: ", (Object)string, (Object)exception);
                        }
                    }
                }
                if (n4 == HDF5Constants.H5O_TYPE_GROUP) {
                    n3 = -1;
                    try {
                        n3 = H5.H5Gopen(this.fid, string, HDF5Constants.H5P_DEFAULT);
                        H5Group h5Group = null;
                        if (string3 != null) {
                            h5Group = new H5Group((FileFormat)this, null, string3, null);
                            hObject = this.getGroup(n3, string2, h5Group);
                            h5Group.addToMemberList(hObject);
                        }
                        hObject = this.getGroup(n3, string2, h5Group);
                    }
                    finally {
                        try {
                            H5.H5Gclose(n3);
                        }
                        catch (Exception exception) {
                            log.debug("{} H5Gclose failure: ", (Object)string, (Object)exception);
                        }
                    }
                } else if (n4 == HDF5Constants.H5O_TYPE_NAMED_DATATYPE) {
                    hObject = new H5Datatype(this, string2, string3);
                }
            }
            try {
                H5.H5Oclose(n2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            log.debug("Exception finding obj {}", (Object)string);
            hObject = null;
        }
        finally {
            if (n <= 0 && hObject == null) {
                try {
                    H5.H5Fclose(this.fid);
                }
                catch (Exception exception) {
                    log.debug("[] H5Fclose failure: ", (Object)string, (Object)exception);
                }
                this.fid = n;
            }
        }
        return hObject;
    }

    @Override
    public Datatype createDatatype(int n, int n2, int n3, int n4, String string) throws Exception {
        return this.createDatatype(n, n2, n3, n4, null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datatype createDatatype(int n, int n2, int n3, int n4, Datatype datatype, String string) throws Exception {
        int n5 = -1;
        H5Datatype h5Datatype = null;
        log.trace("createDatatype with name={} start", (Object)string);
        try {
            H5Datatype h5Datatype2 = (H5Datatype)this.createDatatype(n, n2, n3, n4, datatype);
            n5 = h5Datatype2.toNative();
            if (n5 < 0) {
                throw new Exception("toNative failed");
            }
            H5.H5Tcommit(this.fid, string, n5, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
            byte[] byArray = H5.H5Rcreate(this.fid, string, HDF5Constants.H5R_OBJECT, -1);
            long l = HDFNativeData.byteToLong(byArray, 0);
            long[] lArray = new long[]{l};
            h5Datatype = new H5Datatype(this, null, string);
        }
        finally {
            H5.H5Tclose(n5);
        }
        log.trace("createDatatype with name={} finish", (Object)string);
        return h5Datatype;
    }

    @Override
    public Datatype createDatatype(int n, int n2, int n3, int n4) throws Exception {
        log.trace("createDatatype");
        return new H5Datatype(n, n2, n3, n4);
    }

    @Override
    public Datatype createDatatype(int n, int n2, int n3, int n4, Datatype datatype) throws Exception {
        log.trace("createDatatype with base");
        return new H5Datatype(n, n2, n3, n4, datatype);
    }

    @Override
    public Dataset createScalarDS(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, Object object, Object object2) throws Exception {
        if (group == null) {
            group = (Group)this.get("/");
        }
        log.trace("createScalarDS name={}", (Object)string);
        return H5ScalarDS.create(string, group, datatype, lArray, lArray2, lArray3, n, object, object2);
    }

    @Override
    public Dataset createCompoundDS(String string, Group group, long[] lArray, long[] lArray2, long[] lArray3, int n, String[] stringArray, Datatype[] datatypeArray, int[] nArray, Object object) throws Exception {
        int n2 = stringArray.length;
        int[] nArray2 = new int[n2];
        long[][] lArray4 = new long[n2][1];
        Dataset dataset = null;
        for (int i = 0; i < n2; ++i) {
            nArray2[i] = 1;
            lArray4[i][0] = nArray == null ? 1L : (long)nArray[i];
        }
        if (group == null) {
            group = (Group)this.get("/");
        }
        log.trace("createCompoundDS name={}", (Object)string);
        dataset = H5CompoundDS.create(string, group, lArray, lArray2, lArray3, n, stringArray, datatypeArray, nArray2, lArray4, object);
        return dataset;
    }

    @Override
    public Dataset createImage(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, int n2, int n3, Object object) throws Exception {
        if (group == null) {
            group = (Group)this.get("/");
        }
        H5ScalarDS h5ScalarDS = (H5ScalarDS)H5ScalarDS.create(string, group, datatype, lArray, lArray2, lArray3, n, object);
        try {
            H5File.createImageAttributes(h5ScalarDS, n3);
            h5ScalarDS.setIsImage(true);
        }
        catch (Exception exception) {
            log.debug("{} createImageAttributtes failure: ", (Object)string, (Object)exception);
        }
        return h5ScalarDS;
    }

    @Override
    public Group createGroup(String string, Group group) throws Exception {
        return this.createGroup(string, group, HDF5Constants.H5P_DEFAULT);
    }

    @Override
    public Group createGroup(String string, Group group, int ... nArray) throws Exception {
        if (group == null) {
            group = (Group)this.get("/");
        }
        return H5Group.create(string, group, nArray);
    }

    @Override
    public int createGcpl(int n, int n2, int n3) throws Exception {
        int n4 = -1;
        try {
            n4 = H5.H5Pcreate(HDF5Constants.H5P_GROUP_CREATE);
            if (n4 >= 0) {
                if (n == 1) {
                    H5.H5Pset_link_creation_order(n4, HDF5Constants.H5P_CRT_ORDER_TRACKED);
                } else if (n == 2) {
                    H5.H5Pset_link_creation_order(n4, HDF5Constants.H5P_CRT_ORDER_TRACKED + HDF5Constants.H5P_CRT_ORDER_INDEXED);
                }
                H5.H5Pset_link_phase_change(n4, n2, n3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n4;
    }

    @Override
    public HObject createLink(Group group, String string, Object object) throws Exception {
        if (object instanceof HObject) {
            return this.createLink(group, string, (HObject)object, 0);
        }
        if (object instanceof String) {
            return this.createLink(group, string, (String)object, 0);
        }
        return null;
    }

    @Override
    public HObject createLink(Group group, String string, HObject hObject, int n) throws Exception {
        HObject hObject2 = null;
        int n2 = 0;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (hObject == null) {
            throw new HDF5Exception("The object pointed by the link cannot be null.");
        }
        string4 = group == null || group.isRoot() ? "/" : group.getPath() + "/" + group.getName() + "/";
        string3 = string4 + string;
        if (n == 0) {
            n2 = HDF5Constants.H5L_TYPE_HARD;
        } else if (n == 1) {
            n2 = HDF5Constants.H5L_TYPE_SOFT;
        } else if (n == 64) {
            n2 = HDF5Constants.H5L_TYPE_EXTERNAL;
        }
        if (H5.H5Lexists(this.fid, string3, HDF5Constants.H5P_DEFAULT)) {
            H5.H5Ldelete(this.fid, string3, HDF5Constants.H5P_DEFAULT);
        }
        if (n2 == HDF5Constants.H5L_TYPE_HARD) {
            if (hObject instanceof Group && ((Group)hObject).isRoot()) {
                throw new HDF5Exception("Cannot make a link to the root group.");
            }
            string2 = hObject.getPath() + "/" + hObject.getName();
            H5.H5Lcreate_hard(this.fid, string2, this.fid, string3, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
        } else if (n2 == HDF5Constants.H5L_TYPE_SOFT) {
            H5.H5Lcreate_soft(hObject.getFullName(), this.fid, string3, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
        } else if (n2 == HDF5Constants.H5L_TYPE_EXTERNAL) {
            H5.H5Lcreate_external(hObject.getFile(), hObject.getFullName(), this.fid, string3, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
        }
        if (hObject instanceof Group) {
            hObject2 = new H5Group((FileFormat)this, string, string4, group);
        } else if (hObject instanceof H5Datatype) {
            hObject2 = new H5Datatype(this, string, string4);
        } else if (hObject instanceof H5CompoundDS) {
            hObject2 = new H5CompoundDS(this, string, string4);
        } else if (hObject instanceof H5ScalarDS) {
            hObject2 = new H5ScalarDS(this, string, string4);
        }
        return hObject2;
    }

    @Override
    public HObject createLink(Group group, String string, String string2, int n) throws Exception {
        H5Link h5Link = null;
        int n2 = 0;
        String string3 = null;
        String string4 = null;
        if (string2 == null) {
            throw new HDF5Exception("The object pointed by the link cannot be null.");
        }
        string4 = group == null || group.isRoot() ? "/" : group.getPath() + "/" + group.getName() + "/";
        string3 = string4 + string;
        if (n == 0) {
            n2 = HDF5Constants.H5L_TYPE_HARD;
        } else if (n == 1) {
            n2 = HDF5Constants.H5L_TYPE_SOFT;
        } else if (n == 64) {
            n2 = HDF5Constants.H5L_TYPE_EXTERNAL;
        }
        if (H5.H5Lexists(this.fid, string3, HDF5Constants.H5P_DEFAULT)) {
            H5.H5Ldelete(this.fid, string3, HDF5Constants.H5P_DEFAULT);
        }
        if (n2 == HDF5Constants.H5L_TYPE_SOFT) {
            H5.H5Lcreate_soft(string2, this.fid, string3, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
        } else if (n2 == HDF5Constants.H5L_TYPE_EXTERNAL) {
            String string5 = null;
            String string6 = null;
            string5 = string2.substring(0, string2.lastIndexOf("://"));
            string6 = string2.substring(string2.indexOf("://"));
            string6 = string6.substring(3);
            H5.H5Lcreate_external(string5, string6, this.fid, string3, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        h5Link = new H5Link(this, string, string4);
        return h5Link;
    }

    public void reloadTree(Group group) {
        if (this.fid < 0 || this.rootNode == null || group == null) {
            return;
        }
        HObject hObject = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (group.equals(this.rootNode.getUserObject())) {
            defaultMutableTreeNode = this.rootNode;
        } else {
            Enumeration<TreeNode> enumeration = this.rootNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements() && !group.equals(hObject = (HObject)(defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement()).getUserObject())) {
            }
        }
        defaultMutableTreeNode.removeAllChildren();
        this.depth_first(defaultMutableTreeNode, Integer.MIN_VALUE);
    }

    @Override
    public TreeNode copy(HObject hObject, Group group, String string) throws Exception {
        TreeNode treeNode = null;
        if (hObject == null || group == null) {
            return null;
        }
        if (string == null) {
            string = hObject.getName();
        }
        List<HObject> list = group.getMemberList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            HObject hObject2 = list.get(i);
            String string2 = hObject2.getName();
            while (string2.equals(string)) {
                string = string + "~copy";
            }
        }
        if (hObject instanceof Dataset) {
            treeNode = this.copyDataset((Dataset)hObject, (H5Group)group, string);
        } else if (hObject instanceof H5Group) {
            treeNode = this.copyGroup((H5Group)hObject, (H5Group)group, string);
        } else if (hObject instanceof H5Datatype) {
            treeNode = this.copyDatatype((H5Datatype)hObject, (H5Group)group, string);
        }
        return treeNode;
    }

    @Override
    public void delete(HObject hObject) throws Exception {
        if (hObject == null || this.fid < 0) {
            return;
        }
        String string = hObject.getPath() + hObject.getName();
        H5.H5Ldelete(this.fid, string, HDF5Constants.H5P_DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void writeAttribute(HObject var1_1, Attribute var2_2, boolean var3_3) throws HDF5Exception {
        var4_4 = var1_1.getFullName();
        var5_5 = var2_2.getName();
        var6_6 = -1;
        var7_7 = -1;
        var8_8 = -1;
        H5File.log.trace("{} writeAttribute start", (Object)var5_5);
        var9_9 = var1_1.open();
        if (var9_9 < 0) {
            return;
        }
        var6_6 = var2_2.getType().toNative();
        if (var6_6 >= 0) {
            H5File.log.trace("{} writeAttribute tid from native", (Object)var5_5);
            try {
                var7_7 = var2_2.isScalar() != false ? H5.H5Screate(HDF5Constants.H5S_SCALAR) : H5.H5Screate_simple(var2_2.getRank(), var2_2.getDataDims(), null);
                var8_8 = var3_3 != false ? H5.H5Aopen_by_name(var9_9, var4_4, var5_5, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT) : H5.H5Acreate(var9_9, var5_5, var6_6, var7_7, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
                H5File.log.trace("{} writeAttribute aid opened/created", (Object)var5_5);
                var10_10 = var2_2.getValue();
                H5File.log.trace("{} writeAttribute getvalue", (Object)var5_5);
                if (var10_10 == null) ** GOTO lbl91
                v0 = var11_14 = H5.H5Tget_class(var6_6) == HDF5Constants.H5T_VLEN || H5.H5Tis_variable_str(var6_6) != false;
                if (var11_14) {
                    H5File.log.trace("{} writeAttribute isvlen", (Object)var5_5);
                    try {
                        var12_15 = var6_6;
                        var6_6 = H5.H5Tget_native_type(var12_15);
                        try {
                            H5.H5Tclose(var12_15);
                        }
                        catch (Exception var13_19) {
                            H5File.log.debug("{} writeAttribute H5Tclose failure: ", (Object)var5_5, (Object)var13_19);
                        }
                        H5File.log.trace("{} writeAttribute H5.H5AwriteVL", (Object)var5_5);
                        if (var10_10 instanceof String || var2_2.getDataDims().length == 1) {
                            H5.H5AwriteVL(var8_8, var6_6, (String[])var10_10);
                        }
                        H5File.log.info("Datatype is not a string, unable to write {} data", (Object)var5_5);
                    }
                    catch (Exception var12_16) {
                        H5File.log.debug("{} writeAttribute native type failure: ", (Object)var5_5, (Object)var12_16);
                    }
                }
                if (var2_2.getType().getDatatypeClass() == 7 && var10_10 instanceof String) {
                    var10_10 = H5.H5Rcreate(this.getFID(), (String)var10_10, HDF5Constants.H5R_OBJECT, -1);
                    H5File.log.trace("{} writeAttribute CLASS_REFERENCE", (Object)var5_5);
                } else if (Array.get(var10_10, 0) instanceof String) {
                    var12_17 = H5.H5Tget_size(var6_6);
                    var13_20 = ((String[])var10_10).length;
                    var14_22 = Dataset.stringToByte((String[])var10_10, var12_17);
                    if (var14_22 != null && var14_22.length == var12_17 * var13_20) {
                        var14_22[var14_22.length - 1] = 0;
                        var10_10 = var14_22;
                    }
                    H5File.log.trace("{} writeAttribute Array", (Object)var5_5);
                }
                try {
                    var12_17 = var6_6;
                    var6_6 = H5.H5Tget_native_type(var12_17);
                    try {
                        H5.H5Tclose(var12_17);
                    }
                    catch (Exception var13_21) {
                        H5File.log.debug("{} writeAttribute H5Tclose failure: ", (Object)var5_5, (Object)var13_21);
                    }
                    H5File.log.trace("{} writeAttribute H5.H5Awrite", (Object)var5_5);
                    H5.H5Awrite(var8_8, var6_6, var10_10);
                }
                catch (Exception var12_18) {
                    H5File.log.debug("{} writeAttribute native type failure: ", (Object)var5_5, (Object)var12_18);
                }
            }
            finally {
                try {
                    H5.H5Tclose(var6_6);
                }
                catch (Exception var10_11) {
                    H5File.log.debug("{} writeAttribute H5Tclose failure: ", (Object)var5_5, (Object)var10_11);
                }
                try {
                    H5.H5Sclose(var7_7);
                }
                catch (Exception var10_12) {
                    H5File.log.debug("{} writeAttribute H5Sclose failure: ", (Object)var5_5, (Object)var10_12);
                }
                try {
                    H5.H5Aclose(var8_8);
                }
                catch (Exception var10_13) {
                    H5File.log.debug("{} writeAttribute H5Aclose failure: ", (Object)var5_5, (Object)var10_13);
                }
            }
        } else {
            H5File.log.debug("{} writeAttribute toNative failure: ", (Object)var5_5);
        }
lbl91:
        // 7 sources

        var1_1.close(var9_9);
        H5File.log.trace("{} writeAttribute finish", (Object)var5_5);
    }

    public int open(int n) throws Exception {
        return this.open(true, n);
    }

    private int open(boolean bl) throws Exception {
        int n = -1;
        int n2 = HDF5Constants.H5P_DEFAULT;
        n = this.open(bl, n2);
        return n;
    }

    private int open(boolean bl, int n) throws Exception {
        block14: {
            if (this.fid > 0) {
                return this.fid;
            }
            log.trace("open: loadFullHierarchy={} start", (Object)bl);
            String string = System.getProperty("hdfview.root");
            if (string == null) {
                string = System.getProperty("user.dir");
            }
            H5.H5Dchdir_ext(string);
            if (this.flag < 0) {
                throw new HDF5Exception("Invalid access identifer -- " + this.flag);
            }
            if (HDF5Constants.H5F_ACC_CREAT == this.flag) {
                log.trace("open: create file");
                this.fid = H5.H5Fcreate(this.fullFileName, HDF5Constants.H5F_ACC_TRUNC, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
                H5.H5Fflush(this.fid, HDF5Constants.H5F_SCOPE_LOCAL);
                H5.H5Fclose(this.fid);
                this.flag = HDF5Constants.H5F_ACC_RDWR;
            } else {
                if (!this.exists()) {
                    throw new HDF5Exception("File does not exist -- " + this.fullFileName);
                }
                if (!(this.flag != HDF5Constants.H5F_ACC_RDWR && this.flag != HDF5Constants.H5F_ACC_CREAT || this.canWrite())) {
                    throw new HDF5Exception("Cannot write file, try open as read-only -- " + this.fullFileName);
                }
                if (this.flag == HDF5Constants.H5F_ACC_RDONLY && !this.canRead()) {
                    throw new HDF5Exception("Cannot read file -- " + this.fullFileName);
                }
            }
            try {
                log.trace("open: open file");
                this.fid = H5.H5Fopen(this.fullFileName, this.flag, n);
            }
            catch (Exception exception) {
                try {
                    this.fid = H5.H5Fopen(this.fullFileName, HDF5Constants.H5F_ACC_RDONLY, HDF5Constants.H5P_DEFAULT);
                    this.isReadOnly = true;
                }
                catch (Exception exception2) {
                    int n2;
                    int n3;
                    File file = new File(this.fullFileName);
                    String string2 = file.getName();
                    for (n3 = string2.lastIndexOf("."); n3 > 0 && (n2 = string2.charAt(n3)) >= 48; --n3) {
                    }
                    if (n3 <= 0) break block14;
                    string2 = string2.substring(0, n3 - 1) + "%d" + string2.substring(string2.lastIndexOf("."));
                    n2 = H5.H5Pcreate(HDF5Constants.H5P_FILE_ACCESS);
                    H5.H5Pset_fapl_family(n2, 0L, HDF5Constants.H5P_DEFAULT);
                    this.fid = H5.H5Fopen(file.getParent() + File.separator + string2, this.flag, n2);
                    H5.H5Pclose(n2);
                }
            }
        }
        if (this.fid >= 0 && bl) {
            this.rootNode = this.loadTree();
        }
        log.trace("open: finish");
        return this.fid;
    }

    private DefaultMutableTreeNode loadTree() {
        if (this.fid < 0) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        long[] lArray = new long[]{0L};
        H5Group h5Group = new H5Group((FileFormat)this, "/", null, null);
        defaultMutableTreeNode = new DefaultMutableTreeNode(h5Group){
            private static final long serialVersionUID = 991382067363411723L;

            @Override
            public boolean isLeaf() {
                return false;
            }
        };
        this.depth_first(defaultMutableTreeNode, 0);
        return defaultMutableTreeNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int depth_first(MutableTreeNode mutableTreeNode, int n) {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        String string = null;
        String string2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)mutableTreeNode;
        int n2 = -1;
        log.trace("depth_first: start");
        H5Group h5Group = (H5Group)defaultMutableTreeNode2.getUserObject();
        string2 = h5Group.getPath();
        string = string2 == null ? "/" : string2 + h5Group.getName() + "/";
        int n3 = 0;
        try {
            n2 = h5Group.open();
            object = H5.H5Gget_info(n2);
            n3 = (int)((H5G_info_t)object).nlinks;
        }
        catch (HDF5Exception hDF5Exception) {
            n3 = -1;
        }
        if (n3 <= 0) {
            h5Group.close(n2);
            return n;
        }
        object = new int[n3];
        long[] lArray = new long[n3];
        long[] lArray2 = new long[n3];
        String[] stringArray = new String[n3];
        try {
            H5.H5Gget_obj_info_full(this.fid, string, stringArray, (int[])object, null, lArray, lArray2, this.indexType, this.indexOrder);
        }
        catch (HDF5Exception hDF5Exception) {
            hDF5Exception.printStackTrace();
            return n;
        }
        int n4 = this.getStartMembers();
        int n5 = this.getMaxMembers();
        for (int i = 0; i < n3; ++i) {
            HObject hObject;
            long[] lArray3;
            Object object2;
            String string3;
            block32: {
                int n6;
                Serializable serializable;
                block33: {
                    int n7;
                    int n8;
                    block31: {
                        string3 = stringArray[i];
                        object2 = object[i];
                        log.trace("depth_first: obj_name={}, obj_type={}", (Object)string3, (Object)((int)object2));
                        lArray3 = new long[]{lArray2[i], lArray[i]};
                        if (string3 == null) continue;
                        if (n5 > 0 && ++n - n4 >= n5) break;
                        boolean bl = false;
                        if (n > 0 && n < n4) {
                            bl = true;
                        }
                        if (object2 == HDF5Constants.H5O_TYPE_GROUP) {
                            hObject = new H5Group(this, string3, string, h5Group, lArray3);
                            defaultMutableTreeNode = new DefaultMutableTreeNode(hObject){
                                private static final long serialVersionUID = 5139629211215794015L;

                                @Override
                                public boolean isLeaf() {
                                    return false;
                                }
                            };
                            defaultMutableTreeNode2.add(defaultMutableTreeNode);
                            h5Group.addToMemberList(hObject);
                            n8 = 0;
                            HObject hObject2 = null;
                            for (serializable = defaultMutableTreeNode2; serializable != null; serializable = (DefaultMutableTreeNode)serializable.getParent()) {
                                hObject2 = (HObject)serializable.getUserObject();
                                if (!hObject2.equalsOID(lArray3)) continue;
                                n8 = 1;
                                break;
                            }
                            if (n8 != 0) continue;
                            n = this.depth_first(defaultMutableTreeNode, n);
                            continue;
                        }
                        if (bl) continue;
                        if (object2 != HDF5Constants.H5O_TYPE_DATASET) break block32;
                        n7 = -1;
                        n8 = -1;
                        n6 = -1;
                        n7 = H5.H5Dopen(this.fid, string + string3, HDF5Constants.H5P_DEFAULT);
                        if (n7 >= 0) {
                            n8 = H5.H5Dget_type(n7);
                            n6 = H5.H5Tget_class(n8);
                            if (n6 == HDF5Constants.H5T_ARRAY || n6 == HDF5Constants.H5T_VLEN) {
                                int n9 = H5.H5Tget_super(n8);
                                int n10 = H5.H5Tget_class(n9);
                                if (n10 != HDF5Constants.H5T_COMPOUND) {
                                    n6 = H5.H5Tget_class(n9);
                                }
                                try {
                                    H5.H5Tclose(n9);
                                }
                                catch (Exception exception) {
                                    log.debug("depth_first[{}] {} dataset access H5Tclose failure: ", new Object[]{i, string3, exception});
                                }
                            }
                            break block31;
                        }
                        log.debug("depth_first[{}] {} dataset open failure", (Object)i, (Object)string3);
                    }
                    try {
                        H5.H5Tclose(n8);
                    }
                    catch (Exception exception) {
                        log.debug("depth_first[{}] {} dataset access H5Tclose failure: ", new Object[]{i, string3, exception});
                    }
                    try {
                        H5.H5Dclose(n7);
                    }
                    catch (Exception exception) {
                        log.debug("depth_first[{}] {} dataset access H5Dclose failure: ", new Object[]{i, string3, exception});
                    }
                    break block33;
                    catch (Exception exception) {
                        try {
                            log.debug("depth_first[{}] {} dataset access failure: ", new Object[]{i, string3, exception});
                        }
                        catch (Throwable throwable) {
                            try {
                                H5.H5Tclose(n8);
                            }
                            catch (Exception exception2) {
                                log.debug("depth_first[{}] {} dataset access H5Tclose failure: ", new Object[]{i, string3, exception2});
                            }
                            try {
                                H5.H5Dclose(n7);
                            }
                            catch (Exception exception3) {
                                log.debug("depth_first[{}] {} dataset access H5Dclose failure: ", new Object[]{i, string3, exception3});
                            }
                            throw throwable;
                        }
                        try {
                            H5.H5Tclose(n8);
                        }
                        catch (Exception exception4) {
                            log.debug("depth_first[{}] {} dataset access H5Tclose failure: ", new Object[]{i, string3, exception4});
                        }
                        try {
                            H5.H5Dclose(n7);
                        }
                        catch (Exception exception5) {
                            log.debug("depth_first[{}] {} dataset access H5Dclose failure: ", new Object[]{i, string3, exception5});
                        }
                    }
                }
                serializable = null;
                serializable = n6 == HDF5Constants.H5T_COMPOUND ? new H5CompoundDS(this, string3, string, lArray3) : new H5ScalarDS(this, string3, string, lArray3);
                defaultMutableTreeNode = new DefaultMutableTreeNode(serializable);
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
                h5Group.addToMemberList((HObject)serializable);
                continue;
            }
            if (object2 == HDF5Constants.H5O_TYPE_NAMED_DATATYPE) {
                hObject = new H5Datatype(this, string3, string, lArray3);
                defaultMutableTreeNode = new DefaultMutableTreeNode(hObject);
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
                h5Group.addToMemberList(hObject);
                continue;
            }
            if (object2 != HDF5Constants.H5O_TYPE_UNKNOWN) continue;
            hObject = new H5Link(this, string3, string, lArray3);
            defaultMutableTreeNode = new DefaultMutableTreeNode(hObject);
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
            h5Group.addToMemberList(hObject);
        }
        h5Group.close(n2);
        log.trace("depth_first: finish");
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void depth_first_old(MutableTreeNode mutableTreeNode) {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        String string = null;
        String string2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)mutableTreeNode;
        int n = -1;
        log.trace("depth_first_old: start");
        H5Group h5Group = (H5Group)defaultMutableTreeNode2.getUserObject();
        string2 = h5Group.getPath();
        string = string2 == null ? "/" : string2 + h5Group.getName() + "/";
        int n2 = 0;
        try {
            n = h5Group.open();
            object = H5.H5Gget_info(n);
            n2 = (int)((H5G_info_t)object).nlinks;
        }
        catch (HDF5Exception hDF5Exception) {
            n2 = -1;
        }
        if (n2 <= 0) {
            h5Group.close(n);
            return;
        }
        object = new int[n2];
        long[] lArray = new long[n2];
        long[] lArray2 = new long[n2];
        String[] stringArray = new String[n2];
        try {
            H5.H5Gget_obj_info_full(this.fid, string, stringArray, (int[])object, null, lArray, lArray2, this.indexType, this.indexOrder);
        }
        catch (HDF5Exception hDF5Exception) {
            hDF5Exception.printStackTrace();
            return;
        }
        int n3 = Math.max(0, this.getStartMembers());
        int n4 = this.getMaxMembers();
        if (n4 >= n2) {
            n4 = n2;
            n3 = 0;
        }
        n4 += n3;
        n4 = Math.min(n4, n2);
        for (int i = n3; i < n4; ++i) {
            HObject hObject;
            long[] lArray3;
            Object object2;
            String string3;
            block32: {
                int n5;
                Serializable serializable;
                block33: {
                    int n6;
                    int n7;
                    block31: {
                        string3 = stringArray[i];
                        object2 = object[i];
                        log.trace("depth_first_old: obj_name={}, obj_type={}", (Object)string3, (Object)((int)object2));
                        lArray3 = new long[]{lArray2[i], lArray[i]};
                        if (string3 == null) continue;
                        if (object2 == HDF5Constants.H5O_TYPE_UNKNOWN) {
                            hObject = new H5Link(this, string3, string, lArray3);
                            defaultMutableTreeNode = new DefaultMutableTreeNode(hObject);
                            defaultMutableTreeNode2.add(defaultMutableTreeNode);
                            h5Group.addToMemberList(hObject);
                            continue;
                        }
                        if (object2 == HDF5Constants.H5O_TYPE_GROUP) {
                            hObject = new H5Group(this, string3, string, h5Group, lArray3);
                            defaultMutableTreeNode = new DefaultMutableTreeNode(hObject){
                                private static final long serialVersionUID = 5139629211215794015L;

                                @Override
                                public boolean isLeaf() {
                                    return false;
                                }
                            };
                            defaultMutableTreeNode2.add(defaultMutableTreeNode);
                            h5Group.addToMemberList(hObject);
                            n7 = 0;
                            HObject hObject2 = null;
                            for (serializable = defaultMutableTreeNode2; serializable != null; serializable = (DefaultMutableTreeNode)serializable.getParent()) {
                                hObject2 = (HObject)serializable.getUserObject();
                                if (!hObject2.equalsOID(lArray3)) continue;
                                n7 = 1;
                                break;
                            }
                            if (n7 != 0) continue;
                            this.depth_first_old(defaultMutableTreeNode);
                            continue;
                        }
                        if (object2 != HDF5Constants.H5O_TYPE_DATASET) break block32;
                        n6 = -1;
                        n7 = -1;
                        n5 = -1;
                        n6 = H5.H5Dopen(this.fid, string + string3, HDF5Constants.H5P_DEFAULT);
                        if (n6 >= 0) {
                            n7 = H5.H5Dget_type(n6);
                            n5 = H5.H5Tget_class(n7);
                            if (n5 == HDF5Constants.H5T_ARRAY || n5 == HDF5Constants.H5T_VLEN) {
                                int n8 = H5.H5Tget_super(n7);
                                int n9 = H5.H5Tget_class(n8);
                                if (n9 != HDF5Constants.H5T_COMPOUND) {
                                    n5 = H5.H5Tget_class(n8);
                                }
                                try {
                                    H5.H5Tclose(n8);
                                }
                                catch (Exception exception) {
                                    log.debug("depth_first_old[{}] {} dataset access H5Tclose failure: ", new Object[]{i, string3, exception});
                                }
                            }
                            break block31;
                        }
                        log.debug("depth_first_old[{}] {} dataset open failure", (Object)i, (Object)string3);
                    }
                    try {
                        H5.H5Tclose(n7);
                    }
                    catch (Exception exception) {
                        log.debug("depth_first_old[{}] {} dataset access H5Tclose failure: ", new Object[]{i, string3, exception});
                    }
                    try {
                        H5.H5Dclose(n6);
                    }
                    catch (Exception exception) {
                        log.debug("depth_first_old[{}] {} dataset access H5Tclose failure: ", new Object[]{i, string3, exception});
                    }
                    break block33;
                    catch (HDF5Exception hDF5Exception) {
                        try {
                            log.debug("depth_first_old[{}] {} dataset access failure: ", new Object[]{i, string3, hDF5Exception});
                        }
                        catch (Throwable throwable) {
                            try {
                                H5.H5Tclose(n7);
                            }
                            catch (Exception exception) {
                                log.debug("depth_first_old[{}] {} dataset access H5Tclose failure: ", new Object[]{i, string3, exception});
                            }
                            try {
                                H5.H5Dclose(n6);
                            }
                            catch (Exception exception) {
                                log.debug("depth_first_old[{}] {} dataset access H5Tclose failure: ", new Object[]{i, string3, exception});
                            }
                            throw throwable;
                        }
                        try {
                            H5.H5Tclose(n7);
                        }
                        catch (Exception exception) {
                            log.debug("depth_first_old[{}] {} dataset access H5Tclose failure: ", new Object[]{i, string3, exception});
                        }
                        try {
                            H5.H5Dclose(n6);
                        }
                        catch (Exception exception) {
                            log.debug("depth_first_old[{}] {} dataset access H5Tclose failure: ", new Object[]{i, string3, exception});
                        }
                    }
                }
                serializable = null;
                serializable = n5 == HDF5Constants.H5T_COMPOUND ? new H5CompoundDS(this, string3, string, lArray3) : new H5ScalarDS(this, string3, string, lArray3);
                defaultMutableTreeNode = new DefaultMutableTreeNode(serializable);
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
                h5Group.addToMemberList((HObject)serializable);
                continue;
            }
            if (object2 != HDF5Constants.H5O_TYPE_NAMED_DATATYPE) continue;
            hObject = new H5Datatype(this, string3, string, lArray3);
            defaultMutableTreeNode = new DefaultMutableTreeNode(hObject);
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
            h5Group.addToMemberList(hObject);
        }
        h5Group.close(n);
        log.trace("depth_first_old: finish");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeNode copyDataset(Dataset dataset, H5Group h5Group, String string) throws Exception {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Dataset dataset2 = null;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        String string2 = null;
        String string3 = null;
        string3 = h5Group.isRoot() ? "/" : h5Group.getPath() + h5Group.getName() + "/";
        if (string == null || string.equals("/") || string.length() < 1) {
            string = dataset.getName();
        }
        string2 = string3 + string;
        try {
            n = dataset.open();
            n2 = h5Group.open();
            try {
                n3 = H5.H5Pcreate(HDF5Constants.H5P_OBJECT_COPY);
                H5.H5Pset_copy_object(n3, HDF5Constants.H5O_COPY_EXPAND_REFERENCE_FLAG);
                H5.H5Ocopy(n, ".", n2, string, n3, HDF5Constants.H5P_DEFAULT);
            }
            catch (Exception exception) {
                log.debug("copyDataset {} failure: ", (Object)string2, (Object)exception);
            }
            finally {
                try {
                    H5.H5Pclose(n3);
                }
                catch (Exception exception) {
                    log.debug("copyDataset {} H5Pclose failure: ", (Object)string2, (Object)exception);
                }
            }
            dataset2 = dataset instanceof H5ScalarDS ? new H5ScalarDS(h5Group.getFileFormat(), string, string3) : new H5CompoundDS(h5Group.getFileFormat(), string, string3);
            h5Group.addToMemberList(dataset2);
            defaultMutableTreeNode = new DefaultMutableTreeNode(dataset2);
        }
        finally {
            try {
                dataset.close(n);
            }
            catch (Exception exception) {
                log.debug("copyDataset {} srcDataset.close failure: ", (Object)string2, (Object)exception);
            }
            try {
                h5Group.close(n2);
            }
            catch (Exception exception) {
                log.debug("copyDataset {} pgroup.close failure: ", (Object)string2, (Object)exception);
            }
        }
        return defaultMutableTreeNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dataset getDataset(int n, String string, String string2) throws HDF5Exception {
        Dataset dataset = null;
        if (n >= 0) {
            int n2 = -1;
            int n3 = -1;
            try {
                n2 = H5.H5Dget_type(n);
                n3 = H5.H5Tget_class(n2);
                if (n3 == HDF5Constants.H5T_ARRAY) {
                    int n4 = H5.H5Tget_super(n2);
                    n3 = H5.H5Tget_class(n4);
                    try {
                        H5.H5Tclose(n4);
                    }
                    catch (Exception exception) {
                        log.debug("getDataset {} H5Tclose failure: ", (Object)string, (Object)exception);
                    }
                }
            }
            finally {
                try {
                    H5.H5Tclose(n2);
                }
                catch (Exception exception) {
                    log.debug("getDataset {} H5Tclose failure: ", (Object)string, (Object)exception);
                }
            }
            dataset = n3 == HDF5Constants.H5T_COMPOUND ? new H5CompoundDS(this, string, string2) : new H5ScalarDS(this, string, string2);
        } else {
            log.debug("getDataset id failure");
        }
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeNode copyDatatype(Datatype datatype, H5Group h5Group, String string) throws Exception {
        H5Datatype h5Datatype = null;
        int n = -1;
        int n2 = -1;
        String string2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        string2 = h5Group.isRoot() ? "/" : h5Group.getPath() + h5Group.getName() + "/";
        if (string == null || string.equals("/") || string.length() < 1) {
            string = datatype.getName();
        }
        try {
            n = datatype.open();
            n2 = h5Group.open();
            try {
                H5.H5Ocopy(n, ".", n2, string, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
            }
            catch (Exception exception) {
                log.debug("copyDatatype {} H5Ocopy failure: ", (Object)string, (Object)exception);
            }
            h5Datatype = new H5Datatype(h5Group.getFileFormat(), string, string2);
            h5Group.addToMemberList(h5Datatype);
            defaultMutableTreeNode = new DefaultMutableTreeNode(h5Datatype);
        }
        finally {
            try {
                datatype.close(n);
            }
            catch (Exception exception) {
                log.debug("copyDatatype {} srcType.close failure: ", (Object)string, (Object)exception);
            }
            try {
                h5Group.close(n2);
            }
            catch (Exception exception) {
                log.debug("copyDatatype {} pgroup.close failure: ", (Object)string, (Object)exception);
            }
        }
        return defaultMutableTreeNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeNode copyGroup(H5Group h5Group, H5Group h5Group2, String string) throws Exception {
        H5Group h5Group3 = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        int n = -1;
        int n2 = -1;
        String string2 = null;
        String string3 = null;
        string3 = h5Group2.isRoot() ? "/" : h5Group2.getPath() + h5Group2.getName() + "/";
        if (string == null || string.equals("/") || string.length() < 1) {
            string = h5Group.getName();
        }
        string2 = string3 + string;
        try {
            n = h5Group.open();
            n2 = h5Group2.open();
            try {
                H5.H5Ocopy(n, ".", n2, string, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
            }
            catch (Exception exception) {
                log.debug("copyGroup {} H5Ocopy failure: ", (Object)string, (Object)exception);
            }
            h5Group3 = new H5Group(h5Group2.getFileFormat(), string, string3, h5Group2);
            defaultMutableTreeNode = new DefaultMutableTreeNode(h5Group3){
                private static final long serialVersionUID = -4981107816640372359L;

                @Override
                public boolean isLeaf() {
                    return false;
                }
            };
            this.depth_first(defaultMutableTreeNode, Integer.MIN_VALUE);
            h5Group2.addToMemberList(h5Group3);
        }
        finally {
            try {
                h5Group.close(n);
            }
            catch (Exception exception) {
                log.debug("copyGroup {} srcGroup.close failure: ", (Object)string, (Object)exception);
            }
            try {
                h5Group2.close(n2);
            }
            catch (Exception exception) {
                log.debug("copyGroup {} pgroup.close failure: ", (Object)string, (Object)exception);
            }
        }
        return defaultMutableTreeNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private H5Group getGroup(int n, String string, Group group) throws HDF5Exception {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (group == null) {
            string = "/";
            string3 = "/";
        } else {
            string2 = group.getFullName();
            string3 = string2 == null || string2.equals("/") ? "/" + string : string2 + "/" + string;
        }
        if (string2 != null) {
            string2 = string2.replaceAll("//", "/");
        }
        if (string3 != null) {
            string3 = string3.replaceAll("//", "/");
        }
        H5Group h5Group = new H5Group((FileFormat)this, string, string2, group);
        H5G_info_t h5G_info_t = null;
        H5O_info_t h5O_info_t = null;
        int n2 = -1;
        String string5 = null;
        try {
            h5G_info_t = H5.H5Gget_info(n);
        }
        catch (Exception exception) {
            log.debug("getGroup {} H5Gget_info failure: ", (Object)string, (Object)exception);
        }
        try {
            n2 = H5.H5Oopen(n, string3, HDF5Constants.H5P_DEFAULT);
        }
        catch (Exception exception) {
            log.debug("getGroup {} H5Oopen failure: ", (Object)string, (Object)exception);
        }
        int n3 = 0;
        while ((long)n3 < h5G_info_t.nlinks) {
            block21: {
                HObject hObject;
                block23: {
                    block22: {
                        try {
                            string5 = H5.H5Lget_name_by_idx(n, string3, this.indexType, this.indexOrder, n3, HDF5Constants.H5P_DEFAULT);
                            h5O_info_t = H5.H5Oget_info_by_idx(n2, string3, this.indexType, this.indexOrder, n3, HDF5Constants.H5P_DEFAULT);
                        }
                        catch (HDF5Exception hDF5Exception) {
                            log.debug("getGroup[{}] {} name,info failure: ", new Object[]{n3, string, hDF5Exception});
                            break block21;
                        }
                        if (h5O_info_t.type != HDF5Constants.H5O_TYPE_GROUP) break block22;
                        hObject = new H5Group((FileFormat)this, string5, string3, h5Group);
                        h5Group.addToMemberList(hObject);
                        break block21;
                    }
                    if (h5O_info_t.type != HDF5Constants.H5O_TYPE_DATASET) break block23;
                    int n4 = -1;
                    Dataset dataset = null;
                    string4 = string3 == null || string3.equals("/") ? "/" + string5 : string3 + "/" + string5;
                    try {
                        n4 = H5.H5Dopen(this.fid, string4, HDF5Constants.H5P_DEFAULT);
                        dataset = this.getDataset(n4, string5, string3);
                    }
                    catch (Throwable throwable) {
                        try {
                            H5.H5Dclose(n4);
                        }
                        catch (Exception exception) {
                            log.debug("getGroup[{}] {} H5Dclose failure: ", new Object[]{n3, string, exception});
                        }
                        throw throwable;
                    }
                    try {
                        H5.H5Dclose(n4);
                    }
                    catch (Exception exception) {
                        log.debug("getGroup[{}] {} H5Dclose failure: ", new Object[]{n3, string, exception});
                    }
                    h5Group.addToMemberList(dataset);
                    break block21;
                }
                if (h5O_info_t.type == HDF5Constants.H5O_TYPE_NAMED_DATATYPE) {
                    hObject = new H5Datatype(this, string5, string3);
                    h5Group.addToMemberList(hObject);
                }
            }
            ++n3;
        }
        try {
            if (n2 >= 0) {
                H5.H5Oclose(n2);
            }
        }
        catch (Exception exception) {
            log.debug("getGroup {} H5Oclose failure: ", (Object)string, (Object)exception);
        }
        return h5Group;
    }

    public static String getLinkTargetName(HObject hObject) throws Exception {
        String[] stringArray = new String[]{null, null};
        String string = null;
        if (hObject == null) {
            return null;
        }
        if (hObject.getFullName().equals("/")) {
            return null;
        }
        H5L_info_t h5L_info_t = null;
        try {
            h5L_info_t = H5.H5Lget_info(hObject.getFID(), hObject.getFullName(), HDF5Constants.H5P_DEFAULT);
        }
        catch (Throwable throwable) {
            log.debug("H5Lget_info {} failure: ", (Object)hObject.getFullName());
            log.trace("H5Lget_info {} failure: ", (Object)hObject.getFullName(), (Object)throwable);
        }
        if (h5L_info_t != null && (h5L_info_t.type == HDF5Constants.H5L_TYPE_SOFT || h5L_info_t.type == HDF5Constants.H5L_TYPE_EXTERNAL)) {
            try {
                H5.H5Lget_val(hObject.getFID(), hObject.getFullName(), stringArray, HDF5Constants.H5P_DEFAULT);
            }
            catch (Exception exception) {
                log.debug("H5Lget_val {} failure: ", (Object)hObject.getFullName(), (Object)exception);
            }
            if (h5L_info_t.type == HDF5Constants.H5L_TYPE_SOFT) {
                string = stringArray[0];
            } else if (h5L_info_t.type == HDF5Constants.H5L_TYPE_EXTERNAL) {
                string = stringArray[1] + "://" + stringArray[0];
            }
        }
        return string;
    }

    @Override
    public void exportDataset(String string, String string2, String string3, int n) throws Exception {
        H5.H5export_dataset(string, string2, string3, n);
    }

    @Override
    public void renameAttribute(HObject hObject, String string, String string2) throws Exception {
        log.trace("renameAttribute {} to {}", (Object)string, (Object)string2);
        if (!this.attrFlag) {
            this.attrFlag = true;
            H5.H5Arename_by_name(hObject.getFID(), hObject.getName(), string, string2, HDF5Constants.H5P_DEFAULT);
        }
    }

    public static void renameObject(HObject hObject, String string) throws Exception {
        String string2 = hObject.getPath() + hObject.getName();
        String string3 = hObject.getPath() + string;
        string2 = string2.replaceAll("//", "/");
        string3 = string3.replaceAll("//", "/");
        if (string2.equals("/")) {
            throw new HDF5Exception("Can't rename the root group.");
        }
        if (string2.equals(string3)) {
            throw new HDF5Exception("The new name is the same as the current name.");
        }
        H5.H5Lmove(hObject.getFID(), string2, hObject.getFID(), string3, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
    }

    public static int getIndexTypeValue(String string) {
        if (string.compareTo("H5_INDEX_NAME") == 0) {
            return HDF5Constants.H5_INDEX_NAME;
        }
        if (string.compareTo("H5_INDEX_CRT_ORDER") == 0) {
            return HDF5Constants.H5_INDEX_CRT_ORDER;
        }
        if (string.compareTo("H5_INDEX_N") == 0) {
            return HDF5Constants.H5_INDEX_N;
        }
        return HDF5Constants.H5_INDEX_UNKNOWN;
    }

    public static int getIndexOrderValue(String string) {
        if (string.compareTo("H5_ITER_INC") == 0) {
            return HDF5Constants.H5_ITER_INC;
        }
        if (string.compareTo("H5_ITER_DEC") == 0) {
            return HDF5Constants.H5_ITER_DEC;
        }
        if (string.compareTo("H5_ITER_NATIVE") == 0) {
            return HDF5Constants.H5_ITER_NATIVE;
        }
        if (string.compareTo("H5_ITER_N") == 0) {
            return HDF5Constants.H5_ITER_N;
        }
        return HDF5Constants.H5_ITER_UNKNOWN;
    }

    @Override
    public int getIndexType(String string) {
        if (string != null) {
            if (string.compareTo("H5_INDEX_NAME") == 0) {
                return HDF5Constants.H5_INDEX_NAME;
            }
            if (string.compareTo("H5_INDEX_CRT_ORDER") == 0) {
                return HDF5Constants.H5_INDEX_CRT_ORDER;
            }
            return HDF5Constants.H5_INDEX_UNKNOWN;
        }
        return this.getIndexType();
    }

    public int getIndexType() {
        return this.indexType;
    }

    @Override
    public void setIndexType(int n) {
        this.indexType = n;
    }

    @Override
    public int getIndexOrder(String string) {
        if (string != null) {
            if (string.compareTo("H5_ITER_INC") == 0) {
                return HDF5Constants.H5_ITER_INC;
            }
            if (string.compareTo("H5_ITER_DEC") == 0) {
                return HDF5Constants.H5_ITER_DEC;
            }
            if (string.compareTo("H5_ITER_NATIVE") == 0) {
                return HDF5Constants.H5_ITER_NATIVE;
            }
            if (string.compareTo("H5_ITER_N") == 0) {
                return HDF5Constants.H5_ITER_N;
            }
            return HDF5Constants.H5_ITER_UNKNOWN;
        }
        return this.getIndexOrder();
    }

    public int getIndexOrder() {
        return this.indexOrder;
    }

    @Override
    public void setIndexOrder(int n) {
        this.indexOrder = n;
    }
}

