/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object;

import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.HObject;

public abstract class Group
extends HObject {
    private static final long serialVersionUID = 3913174542591568052L;
    private List<HObject> memberList;
    protected Group parent;
    protected int nMembersInFile;
    public static final int LINK_TYPE_HARD = 0;
    public static final int LINK_TYPE_SOFT = 1;
    public static final int LINK_TYPE_EXTERNAL = 64;
    public static final int CRT_ORDER_TRACKED = 1;
    public static final int CRT_ORDER_INDEXED = 2;

    public Group(FileFormat fileFormat, String string, String string2, Group group) {
        this(fileFormat, string, string2, group, null);
    }

    @Deprecated
    public Group(FileFormat fileFormat, String string, String string2, Group group, long[] lArray) {
        super(fileFormat, string, string2, lArray);
        this.parent = group;
    }

    public void clear() {
        if (this.memberList != null) {
            ((Vector)this.memberList).setSize(0);
        }
    }

    public void addToMemberList(HObject hObject) {
        if (this.memberList == null) {
            int n = Math.min(this.getNumberOfMembersInFile(), this.getFileFormat().getMaxMembers());
            this.memberList = new Vector<HObject>(n + 5);
        }
        if (hObject != null && !this.memberList.contains(hObject)) {
            this.memberList.add(hObject);
        }
    }

    public void removeFromMemberList(HObject hObject) {
        if (this.memberList != null) {
            this.memberList.remove(hObject);
        }
    }

    public List<HObject> getMemberList() {
        FileFormat fileFormat = this.getFileFormat();
        String string = this.getPath();
        String string2 = this.getName();
        if (this.memberList == null && fileFormat != null) {
            int n = Math.min(this.getNumberOfMembersInFile(), this.getFileFormat().getMaxMembers());
            this.memberList = new Vector<HObject>(n + 5);
            try {
                fileFormat.open();
            }
            catch (Exception exception) {
                // empty catch block
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)fileFormat.getRootNode();
            if (defaultMutableTreeNode == null) {
                return this.memberList;
            }
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
            Group group = null;
            Object object = null;
            while (enumeration.hasMoreElements()) {
                object = ((DefaultMutableTreeNode)enumeration.nextElement()).getUserObject();
                if (!(object instanceof Group) || (group = (Group)object).getPath() == null || (!this.isRoot() || !group.isRoot()) && (!string.equals(group.getPath()) || !group.getName().endsWith(string2))) continue;
                this.memberList = group.getMemberList();
                break;
            }
        }
        return this.memberList;
    }

    @Override
    public void setName(String string) throws Exception {
        super.setName(string);
        if (this.memberList != null) {
            int n = this.memberList.size();
            HObject hObject = null;
            for (int i = 0; i < n; ++i) {
                hObject = this.memberList.get(i);
                hObject.setPath(this.getPath() + string + "/");
            }
        }
    }

    public final Group getParent() {
        return this.parent;
    }

    public final boolean isRoot() {
        return this.parent == null;
    }

    public int getNumberOfMembersInFile() {
        return this.nMembersInFile;
    }
}

