/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.hdf5;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.hdf5.HDF5DatasetExampleTable;
import com.rapidminer.hdf5.HDF5MetaDataProvider;
import com.rapidminer.hdf5.HDF5Reader;
import com.rapidminer.hdf5.HDF5WriteUtil;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.AbstractExampleSetWriter;
import com.rapidminer.operator.nio.file.FileObject;
import com.rapidminer.operator.nio.file.FileOutputPortHandler;
import com.rapidminer.operator.nio.file.SimpleFileObject;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeLong;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.LogService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.h5.H5File;

public class HDF5Writer
extends AbstractExampleSetWriter {
    public static final String PARAMETER_HDF5_GROUP = "hdf5_group";
    public static final String PARAMETER_TABLE_NAME = "table_name";
    public static final String PARAMETER_APPEND_TABLE = "append_to_table";
    public static final String PARAMETER_REPLACE_TABLE = "replace table";
    public static final String PARAMETER_ENUM_HANDLING = "enum_handling";
    public static final String[] ENUM_HANDLING_OPTIONS = new String[]{"dynamic", "only enum", "only string"};
    public static final String PARAMETER_CHUNK_SIZE = "chunk size";
    public static final String PARAMETER_GZIP = "gzip";
    protected OutputPort fileOutputPort = (OutputPort)this.getOutputPorts().createPort("file");
    protected FileOutputPortHandler filePortHandler = new FileOutputPortHandler((Operator)this, this.fileOutputPort, HDF5Writer.getFileParameterName());
    private Vector<String> groupNames = new Vector();

    public HDF5Writer(OperatorDescription description) {
        super(description);
        this.getTransformer().addGenerationRule(this.fileOutputPort, FileObject.class);
        this.getParameters().addObserverAsFirst((parameters, parameter) -> {
            if ("hdf5_file".equals(parameter)) {
                try {
                    this.updateGroupList();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, false);
    }

    private void updateGroupList() throws Exception {
        File f = this.getParameterAsFile("hdf5_file");
        this.groupNames.clear();
        if (f == null || !f.exists()) {
            HDF5Writer.refreshPropertyPanel();
            return;
        }
        String fileName = f.getAbsolutePath();
        H5File h5File = HDF5Writer.getHDFFile(fileName);
        Group g = (Group)h5File.get("/");
        if (g == null) {
            HDF5Writer.refreshPropertyPanel();
            return;
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        groups.add(g);
        while (!groups.isEmpty()) {
            g = (Group)groups.remove(0);
            this.groupNames.add(g.getFullName());
            for (HObject obj : g.getMemberList()) {
                if (!(obj instanceof Group)) continue;
                groups.add((Group)obj);
            }
        }
        Collections.sort(this.groupNames);
        HDF5Writer.refreshPropertyPanel();
    }

    private static void refreshPropertyPanel() {
        MainFrame mf = RapidMinerGUI.getMainFrame();
        if (mf != null) {
            mf.getPropertyPanel().invalidate();
        }
    }

    public ExampleSet write(ExampleSet exampleSet) throws OperatorException {
        int eH;
        String fileName = this.getParameterAsString("hdf5_file");
        String groupName = this.getParameterAsString(PARAMETER_HDF5_GROUP);
        String tableName = this.getParameterAsString(PARAMETER_TABLE_NAME);
        boolean replace = this.getParameterAsBoolean(PARAMETER_REPLACE_TABLE);
        String enumHandling = this.getParameterAsString(PARAMETER_ENUM_HANDLING);
        for (eH = 0; eH < ENUM_HANDLING_OPTIONS.length && !ENUM_HANDLING_OPTIONS[eH].equals(enumHandling); ++eH) {
        }
        Object chunks = new long[]{this.getParameterAsLong(PARAMETER_CHUNK_SIZE)};
        int gzip = this.getParameterAsInt(PARAMETER_GZIP);
        H5File h5File = HDF5Writer.getHDFFile(fileName);
        Group group = HDF5Writer.getGroup(h5File, groupName);
        ExampleTable et = exampleSet.getExampleTable();
        if (chunks[0] == 0L) {
            chunks = et instanceof HDF5DatasetExampleTable ? ((HDF5DatasetExampleTable)et).dataset.getChunkSize() : null;
        } else if (chunks[0] > (long)exampleSet.size()) {
            throw new OperatorException("Chunk size can not be bigger than example set size.");
        }
        if (chunks == null) {
            gzip = 0;
        }
        HObject old = null;
        try {
            old = h5File.get(group.getFullName() + "/" + tableName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Dataset target = HDF5Writer.getTargetDataset(exampleSet, eH, h5File, group, tableName, chunks, gzip, old);
        target.init();
        Exception writeEx = HDF5WriteUtil.writeToDataset(exampleSet, target);
        if (writeEx != null) {
            throw new OperatorException("Could not write example set to file.", (Throwable)writeEx);
        }
        if (replace && old != null) {
            boolean changed = true;
            try {
                h5File.delete(old);
            }
            catch (Exception e) {
                changed = false;
                LogService.getRoot().warning("Could not delete and thus replace old data set " + old.getName() + "\nNew data set is saved as " + target.getName() + "\n" + e.toString());
            }
            if (changed) {
                try {
                    H5File.renameObject(target, tableName);
                }
                catch (Exception e) {
                    changed = false;
                    LogService.getRoot().warning("Could not rename new data set to match specified name. It is now saved as " + target.getName() + "\n" + e.toString());
                }
            }
            if (changed) {
                e = new NullPointerException();
                try {
                    target = (Dataset)h5File.get(group.getName() + "/" + tableName);
                }
                catch (Exception ex) {
                    target = null;
                    e = ex;
                }
                if (target == null) {
                    throw new OperatorException("Could not load renamed data set " + tableName, (Throwable)e);
                }
            }
        }
        HDF5DatasetExampleTable h5Table = new HDF5DatasetExampleTable(target);
        HDF5Writer.renameAttributes(exampleSet, h5Table);
        this.fileOutputPort.deliver((IOObject)new SimpleFileObject((File)h5File));
        ExampleSet newSet = h5Table.createExampleSet();
        HDF5Writer.copyRoles(exampleSet, newSet);
        return newSet;
    }

    private static H5File getHDFFile(String fileName) throws OperatorException {
        H5File file;
        FileFormat format = FileFormat.getFileFormat("HDF5");
        if (format == null) {
            throw new OperatorException("HDF 5 file format was not found.");
        }
        File f = new File(fileName);
        f = f.getAbsoluteFile();
        HDF5Writer.createParentFolder(f);
        try {
            file = (H5File)format.createFile(fileName, 20);
        }
        catch (Exception e) {
            throw new OperatorException("File is not an HDF 5 file or could not be created.", (Throwable)e);
        }
        return file;
    }

    private static void createParentFolder(File f) throws OperatorException {
        if (f.exists()) {
            return;
        }
        if (!(f = f.getParentFile()).exists() && !f.mkdirs()) {
            throw new OperatorException("Could not create parent folder " + f);
        }
    }

    private static Group getGroup(H5File h5File, String groupName) throws OperatorException {
        HObject obj;
        if ((groupName = groupName.trim()).isEmpty()) {
            groupName = "/";
        }
        try {
            obj = h5File.get(groupName);
        }
        catch (Exception e) {
            throw new OperatorException("Could not retrieve group " + groupName, (Throwable)e);
        }
        if (obj != null) {
            return (Group)obj;
        }
        Group g = null;
        if (groupName.startsWith("/")) {
            groupName = groupName.substring(1);
        }
        String[] groupNames = groupName.split("/");
        StringBuilder groupNameBuilder = new StringBuilder();
        for (String gName : groupNames) {
            groupNameBuilder.append("/").append(gName);
            groupName = groupNameBuilder.toString();
            try {
                g = (Group)h5File.get(groupName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (g == null) {
                try {
                    g = h5File.createGroup(groupName, null);
                }
                catch (Exception e) {
                    throw new OperatorException("Could not create group " + groupName, (Throwable)e);
                }
            }
            if (g != null) continue;
            throw new OperatorException("Could not create group " + groupName, (Throwable)new NullPointerException());
        }
        return g;
    }

    private static Dataset getTargetDataset(ExampleSet exampleSet, int eH, H5File h5File, Group group, String tableName, long[] chunks, int gzip, HObject old) throws OperatorException {
        Dataset ds;
        int copy = 0;
        if (old != null) {
            tableName = tableName + "~copy";
            do {
                try {
                    old = h5File.get(group.getFullName() + "/" + tableName + (copy > 0 ? "" + copy : ""));
                }
                catch (Exception e) {
                    old = null;
                }
                ++copy;
            } while (old != null);
            --copy;
        }
        if ((ds = HDF5WriteUtil.createDataset(exampleSet, eH, group, tableName + (copy > 0 ? "" + copy : ""), chunks, gzip)) == null) {
            throw new OperatorException("Could not create data set " + tableName + " in group " + group);
        }
        return ds;
    }

    private static void renameAttributes(ExampleSet exampleSet, HDF5DatasetExampleTable h5Table) {
        String dsName = h5Table.dataset.getFullName().replaceAll("/", ".").substring(1);
        Attributes oldAtts = exampleSet.getAttributes();
        for (Attribute a : h5Table.getAttributes()) {
            String name = a.getName();
            if (oldAtts.get(name) != null || !name.startsWith(dsName) || oldAtts.get(name = name.substring(dsName.length() + 1)) == null) continue;
            a.setName(name);
        }
    }

    private static void copyRoles(ExampleSet exampleSet, ExampleSet newSet) {
        Iterator iter = exampleSet.getAttributes().allAttributeRoles();
        while (iter.hasNext()) {
            Attribute a;
            AttributeRole r = (AttributeRole)iter.next();
            if (!r.isSpecial() || (a = newSet.getAttributes().get(r.getAttribute().getName())) == null) continue;
            newSet.getAttributes().setSpecialAttribute(a, r.getSpecialName());
        }
    }

    protected static String getFileParameterName() {
        return "hdf5_file";
    }

    protected static String[] getFileExtensions() {
        return HDF5Reader.HDF5_EXTENSIONS;
    }

    protected ParameterType makeFileParameterType() {
        return FileOutputPortHandler.makeFileParameterType((ParameterHandler)this, (String)HDF5Writer.getFileParameterName(), () -> this.fileOutputPort, (String[])HDF5Writer.getFileExtensions());
    }

    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(this.makeFileParameterType());
        ParameterTypeAttribute type = new ParameterTypeAttribute(PARAMETER_HDF5_GROUP, "the group in which the example set should be stored, default (emtpy) is the root group of the file\t", new HDF5MetaDataProvider(null){

            @Override
            public MetaData getMetaData() {
                return new MetaData();
            }
        }, true, new int[0]){
            private static final long serialVersionUID = -4549001763658591124L;

            public Vector<String> getAttributeNames() {
                return HDF5Writer.this.groupNames;
            }
        };
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeString(PARAMETER_TABLE_NAME, "the name of the table ", false, false));
        type = new ParameterTypeBoolean(PARAMETER_REPLACE_TABLE, "wether or not to replace a table if the name already exists", false, false);
        types.add((ParameterType)type);
        type = new ParameterTypeCategory(PARAMETER_ENUM_HANDLING, "how to write nominal attributes", ENUM_HANDLING_OPTIONS, 0, true);
        types.add((ParameterType)type);
        type = new ParameterTypeLong(PARAMETER_CHUNK_SIZE, "the chunk size for the data set; 0 for no chunking/adopt from existing data set", 0L, Long.MAX_VALUE, 0L, true);
        types.add((ParameterType)type);
        type = new ParameterTypeInt(PARAMETER_GZIP, "the GZIP compression level", 0, 9, 6, true);
        types.add((ParameterType)type);
        types.addAll(super.getParameterTypes());
        return types;
    }
}

