/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.hdf5;

import com.rapidminer.example.Tools;
import com.rapidminer.example.table.AbstractSparseArrayDataRow;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DoubleSparseArrayDataRow;
import com.rapidminer.hdf5.HDF5DatasetExampleTable;
import java.lang.reflect.Field;

public class HDF5DatasetDataRow
extends DoubleSparseArrayDataRow {
    private static final long serialVersionUID = -6571726101375890267L;
    private int row;
    private HDF5DatasetExampleTable table;

    public HDF5DatasetDataRow(int[] indices, double[] data, int row, HDF5DatasetExampleTable table) {
        super(indices.length);
        this.row = row;
        this.table = table;
        try {
            Field counter = AbstractSparseArrayDataRow.class.getDeclaredField("counter");
            counter.setAccessible(true);
            counter.set((Object)this, indices.length);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create data row", e);
        }
        System.arraycopy(indices, 0, this.getNonDefaultIndices(), 0, indices.length);
        System.arraycopy(data, 0, this.getAllValues(), 0, data.length);
    }

    protected void set(int index, double value, double defaultValue) {
        if (Tools.isDefault((double)value, (double)this.get(index, defaultValue))) {
            return;
        }
        super.set(index, value, defaultValue);
        this.table.set(this.row, index, value);
    }

    public int getType() {
        return -1;
    }

    public DataRow toBasicDataRow() {
        int size = this.getNonDefaultIndices().length;
        DoubleSparseArrayDataRow dr = new DoubleSparseArrayDataRow(size);
        try {
            Field counter = AbstractSparseArrayDataRow.class.getDeclaredField("counter");
            counter.setAccessible(true);
            counter.set(dr, size);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create data row", e);
        }
        System.arraycopy(this.getNonDefaultIndices(), 0, dr.getNonDefaultIndices(), 0, size);
        System.arraycopy(this.getAllValues(), 0, dr.getNonDefaultValues(), 0, size);
        return dr;
    }
}

