/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.lang.reflect.Array;
import java.util.List;
import java.util.StringTokenizer;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.structs.H5O_info_t;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.h5.H5File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H5Datatype
extends Datatype {
    private static final long serialVersionUID = -750546422258749792L;
    private static final Logger log = LoggerFactory.getLogger(H5Datatype.class);
    private List<Attribute> attributeList;
    private boolean isNamed = false;
    private int nAttributes = -1;
    private H5O_info_t obj_info;
    private boolean isVLEN = false;
    private String description = null;

    public H5Datatype(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    @Deprecated
    public H5Datatype(FileFormat fileFormat, String string, String string2, long[] lArray) {
        super(fileFormat, string, string2, lArray);
        this.obj_info = new H5O_info_t(-1L, -1L, 0, 0, -1L, 0L, 0L, 0L, 0L, null, null, null);
        if (lArray == null && fileFormat != null) {
            try {
                byte[] byArray = H5.H5Rcreate(fileFormat.getFID(), this.getFullName(), HDF5Constants.H5R_OBJECT, -1);
                this.oid = new long[1];
                this.oid[0] = HDFNativeData.byteToLong(byArray, 0);
            }
            catch (Exception exception) {
                log.debug("constructor ID {} for {} failed H5Rcreate", (Object)fileFormat.getFID(), (Object)this.getFullName());
            }
        }
    }

    public H5Datatype(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public H5Datatype(int n, int n2, int n3, int n4, Datatype datatype) {
        super(n, n2, n3, n4, datatype);
    }

    public H5Datatype(int n) {
        super(n);
        this.description = H5Datatype.getDatatypeDescription(n);
        log.trace("H5Datatype(int nativeID) description={}", (Object)this.description);
        this.fromNative(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAttribute() {
        this.obj_info.num_attrs = this.nAttributes;
        if (this.obj_info.num_attrs < 0L) {
            int n = -1;
            try {
                n = H5.H5Topen(this.getFID(), this.getPath() + this.getName(), HDF5Constants.H5P_DEFAULT);
                this.fromNative(n);
                this.obj_info = H5.H5Oget_info(n);
                this.isNamed = true;
            }
            catch (Exception exception) {
                this.obj_info.num_attrs = 0L;
            }
            finally {
                try {
                    H5.H5Tclose(n);
                }
                catch (Exception exception) {
                    log.debug("hasAttribute() finally close:", (Throwable)exception);
                }
            }
        }
        return this.obj_info.num_attrs > 0L;
    }

    public static final String[] convertEnumValueToName(int n, Object object, String[] stringArray) throws HDF5Exception {
        int n2;
        int n3 = 0;
        log.trace("convertEnumValueToName start");
        if (object == null || (n3 = Array.getLength(object)) <= 0 || stringArray != null && n3 != Array.getLength(stringArray)) {
            return null;
        }
        int n4 = H5.H5Tget_nmembers(n);
        if (n4 <= 0) {
            return null;
        }
        log.trace("convertEnumValueToName inSize={} nMembers={}", (Object)n3, (Object)n4);
        if (stringArray == null) {
            stringArray = new String[n3];
        } else {
            for (int i = 0; i < n3; ++i) {
                stringArray[i] = null;
            }
        }
        String[] stringArray2 = new String[n4];
        int[] nArray = new int[n4];
        int[] nArray2 = new int[]{0};
        for (n2 = 0; n2 < n4; ++n2) {
            stringArray2[n2] = H5.H5Tget_member_name(n, n2);
            H5.H5Tget_member_value(n, n2, nArray2);
            nArray[n2] = nArray2[0];
            log.trace("convertEnumValueToName: extract member[{}] names[i]={} values[i]={}", new Object[]{n2, stringArray2[n2], nArray[n2]});
        }
        n2 = -1;
        block2: for (int i = 0; i < n3; ++i) {
            n2 = Array.getInt(object, i);
            for (int j = 0; j < n4; ++j) {
                if (n2 != nArray[j]) continue;
                stringArray[i] = stringArray2[j];
                continue block2;
            }
        }
        log.trace("convertEnumValueToName finish");
        return stringArray;
    }

    public static final int[] convertEnumNameToValue(int n, String[] stringArray, int[] nArray) throws HDF5Exception {
        int n2;
        int n3 = 0;
        log.trace("convertEnumNameToValue start");
        if (stringArray == null || (n3 = Array.getLength(stringArray)) <= 0 || nArray != null && n3 != Array.getLength(nArray)) {
            return null;
        }
        int n4 = H5.H5Tget_nmembers(n);
        if (n4 <= 0) {
            return null;
        }
        if (nArray == null) {
            nArray = new int[n3];
        } else {
            for (int i = 0; i < n3; ++i) {
                nArray[i] = -1;
            }
        }
        String[] stringArray2 = new String[n4];
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[]{0};
        for (n2 = 0; n2 < n4; ++n2) {
            stringArray2[n2] = H5.H5Tget_member_name(n, n2);
            H5.H5Tget_member_value(n, n2, nArray3);
            nArray2[n2] = nArray3[0];
        }
        block2: for (n2 = 0; n2 < n3; ++n2) {
            if (stringArray[n2] == null || stringArray[n2].length() <= 0) continue;
            for (int i = 0; i < n4; ++i) {
                if (!stringArray[n2].equalsIgnoreCase(stringArray2[i])) continue;
                nArray[n2] = nArray2[i];
                continue block2;
            }
        }
        log.trace("convertEnumNameToValue finish");
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fromNative(int n) {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        boolean bl = false;
        boolean bl2 = false;
        log.trace("fromNative start");
        if (n < 0) {
            this.datatypeClass = -1;
        } else {
            block62: {
                try {
                    n2 = H5.H5Tget_class(n);
                    n3 = H5.H5Tget_size(n);
                    n4 = H5.H5Tget_order(n);
                    this.isVLEN = n2 == HDF5Constants.H5T_VLEN;
                }
                catch (Exception exception) {
                    this.datatypeClass = -1;
                }
                this.datatypeOrder = n4 == HDF5Constants.H5T_ORDER_BE ? 1 : 0;
                try {
                    bl2 = H5.H5Tequal(n, HDF5Constants.H5T_NATIVE_UCHAR);
                    bl = H5.H5Tequal(n, HDF5Constants.H5T_NATIVE_CHAR) || bl2;
                }
                catch (Exception exception) {
                    log.debug("native char type:", (Throwable)exception);
                }
                if (n2 == HDF5Constants.H5T_ARRAY) {
                    int n5 = -1;
                    this.datatypeClass = 10;
                    try {
                        int n6 = H5.H5Tget_array_ndims(n);
                        this.dims = new long[n6];
                        H5.H5Tget_array_dims(n, this.dims);
                        n5 = H5.H5Tget_super(n);
                        this.baseType = new H5Datatype(n5);
                    }
                    catch (Exception exception) {
                        log.debug("array type:", (Throwable)exception);
                    }
                    finally {
                        try {
                            H5.H5Tclose(n5);
                        }
                        catch (Exception exception) {
                            log.debug("finally close:", (Throwable)exception);
                        }
                    }
                } else if (bl) {
                    this.datatypeClass = 2;
                    this.datatypeSign = bl2 ? 0 : 1;
                } else if (n2 == HDF5Constants.H5T_INTEGER) {
                    this.datatypeClass = 0;
                    try {
                        int n7 = H5.H5Tget_sign(n);
                        if (n7 == HDF5Constants.H5T_SGN_NONE) {
                            this.datatypeSign = 0;
                            break block62;
                        }
                        this.datatypeSign = 1;
                    }
                    catch (Exception exception) {
                        log.debug("int type:", (Throwable)exception);
                    }
                } else if (n2 == HDF5Constants.H5T_FLOAT) {
                    this.datatypeClass = 1;
                } else if (n2 == HDF5Constants.H5T_STRING) {
                    try {
                        this.isVLEN = H5.H5Tis_variable_str(n);
                    }
                    catch (Exception exception) {
                        log.debug("var str type:", (Throwable)exception);
                    }
                    this.datatypeClass = 3;
                } else if (n2 == HDF5Constants.H5T_REFERENCE) {
                    this.datatypeClass = 7;
                } else if (n2 == HDF5Constants.H5T_ENUM) {
                    this.datatypeClass = 8;
                    try {
                        int n8 = H5.H5Tget_nmembers(n);
                        String string = null;
                        byte[] byArray = new byte[n3];
                        String string2 = "";
                        for (int i = 0; i < n8; ++i) {
                            string = H5.H5Tget_member_name(n, i);
                            H5.H5Tget_member_value(n, i, byArray);
                            string2 = string2 + string + "=";
                            switch (H5.H5Tget_size(n)) {
                                case 1: {
                                    string2 = string2 + HDFNativeData.byteToByte(byArray[0])[0];
                                    break;
                                }
                                case 2: {
                                    string2 = string2 + HDFNativeData.byteToShort(byArray)[0];
                                    break;
                                }
                                case 4: {
                                    string2 = string2 + HDFNativeData.byteToInt(byArray)[0];
                                    break;
                                }
                                case 8: {
                                    string2 = string2 + HDFNativeData.byteToLong(byArray)[0];
                                    break;
                                }
                                default: {
                                    string2 = string2 + "?";
                                }
                            }
                            if (i >= n8 - 1) continue;
                            string2 = string2 + ",";
                        }
                        this.enumMembers = string2;
                    }
                    catch (Exception exception) {
                        log.debug("enum type:", (Throwable)exception);
                    }
                } else if (n2 == HDF5Constants.H5T_VLEN) {
                    int n9 = -1;
                    this.datatypeClass = 9;
                    try {
                        n9 = H5.H5Tget_super(n);
                        this.baseType = new H5Datatype(n9);
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        try {
                            H5.H5Tclose(n9);
                        }
                        catch (Exception exception) {
                            log.debug("vlen finally close:", (Throwable)exception);
                        }
                    }
                } else if (n2 == HDF5Constants.H5T_BITFIELD) {
                    this.datatypeClass = 4;
                } else if (n2 == HDF5Constants.H5T_OPAQUE) {
                    this.datatypeClass = 5;
                } else {
                    log.debug("fromNative datatypeClass is unknown");
                }
            }
            this.datatypeSize = this.isVLEN ? -1 : n3;
        }
        log.trace("fromNative datatypeClass={} baseType={} datatypeSize={}", new Object[]{this.datatypeClass, this.baseType, this.datatypeSize});
        log.trace("fromNative start");
    }

    @Deprecated
    public static int toNative(int n) {
        int n2 = -1;
        try {
            n2 = H5.H5Tget_native_type(n);
        }
        catch (Exception exception) {
            log.debug("toNative type:", (Throwable)exception);
        }
        try {
            if (H5.H5Tis_variable_str(n)) {
                H5.H5Tset_size(n2, HDF5Constants.H5T_VARIABLE);
            }
        }
        catch (Exception exception) {
            log.debug("var str type size:", (Throwable)exception);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int toNative() {
        int n = -1;
        int n2 = -1;
        if (this.isNamed) {
            try {
                n = H5.H5Topen(this.getFID(), this.getPath() + this.getName(), HDF5Constants.H5P_DEFAULT);
            }
            catch (Exception exception) {
                log.debug("toNative name {} open failure:", (Object)(this.getPath() + this.getName()), (Object)exception);
            }
        }
        if (n >= 0) {
            return n;
        }
        try {
            log.trace("toNative datatypeClass={} baseType={} datatypeSize={}", new Object[]{this.datatypeClass, this.baseType, this.datatypeSize});
            switch (this.datatypeClass) {
                case 10: {
                    if (this.baseType != null) {
                        n2 = this.baseType.toNative();
                        if (n2 < 0) break;
                        try {
                            n = H5.H5Tarray_create(n2, this.dims.length, this.dims);
                            break;
                        }
                        finally {
                            this.close(n2);
                        }
                    }
                    log.debug("CLASS_ARRAY base type is NULL");
                    break;
                }
                case 0: 
                case 8: {
                    if (this.datatypeSize == 1) {
                        log.trace("toNative CLASS_INT-ENUM is H5T_NATIVE_INT8");
                        n = H5.H5Tcopy(HDF5Constants.H5T_NATIVE_INT8);
                    } else if (this.datatypeSize == 2) {
                        log.trace("toNative CLASS_INT-ENUM is H5T_NATIVE_INT16");
                        n = H5.H5Tcopy(HDF5Constants.H5T_NATIVE_INT16);
                    } else if (this.datatypeSize == 4) {
                        log.trace("toNative CLASS_INT-ENUM is H5T_NATIVE_INT32");
                        n = H5.H5Tcopy(HDF5Constants.H5T_NATIVE_INT32);
                    } else if (this.datatypeSize == 8) {
                        log.trace("toNative CLASS_INT-ENUM is H5T_NATIVE_INT64");
                        n = H5.H5Tcopy(HDF5Constants.H5T_NATIVE_INT64);
                    } else {
                        log.trace("toNative CLASS_INT-ENUM is H5T_NATIVE_INT");
                        n = H5.H5Tcopy(HDF5Constants.H5T_NATIVE_INT);
                    }
                    if (this.datatypeOrder == 1) {
                        log.trace("toNative CLASS_INT-ENUM is H5T_ORDER_BE");
                        H5.H5Tset_order(n, HDF5Constants.H5T_ORDER_BE);
                    } else if (this.datatypeOrder == 0) {
                        log.trace("toNative CLASS_INT-ENUM is H5T_ORDER_LE");
                        H5.H5Tset_order(n, HDF5Constants.H5T_ORDER_LE);
                    }
                    if (this.datatypeSign == 0) {
                        log.trace("toNative CLASS_INT-ENUM is H5T_SGN_NONE");
                        H5.H5Tset_sign(n, HDF5Constants.H5T_SGN_NONE);
                    }
                    break;
                }
                case 1: {
                    n = this.datatypeSize == 8 ? H5.H5Tcopy(HDF5Constants.H5T_NATIVE_DOUBLE) : H5.H5Tcopy(HDF5Constants.H5T_NATIVE_FLOAT);
                    if (this.datatypeOrder == 1) {
                        H5.H5Tset_order(n, HDF5Constants.H5T_ORDER_BE);
                        break;
                    }
                    if (this.datatypeOrder == 0) {
                        H5.H5Tset_order(n, HDF5Constants.H5T_ORDER_LE);
                    }
                    break;
                }
                case 2: {
                    if (this.datatypeSign == 0) {
                        n = H5.H5Tcopy(HDF5Constants.H5T_NATIVE_UCHAR);
                        break;
                    }
                    n = H5.H5Tcopy(HDF5Constants.H5T_NATIVE_CHAR);
                    break;
                }
                case 3: {
                    n = H5.H5Tcopy(HDF5Constants.H5T_C_S1);
                    if (this.isVLEN || this.datatypeSize < 0) {
                        H5.H5Tset_size(n, HDF5Constants.H5T_VARIABLE);
                        break;
                    }
                    H5.H5Tset_size(n, this.datatypeSize);
                    break;
                }
                case 7: {
                    if (this.datatypeSize > H5.H5Tget_size(HDF5Constants.H5T_STD_REF_OBJ)) {
                        n = H5.H5Tcopy(HDF5Constants.H5T_STD_REF_DSETREG);
                        break;
                    }
                    n = H5.H5Tcopy(HDF5Constants.H5T_STD_REF_OBJ);
                    break;
                }
                case 9: {
                    if (this.baseType != null) {
                        n2 = this.baseType.toNative();
                        if (n2 < 0) break;
                        try {
                            n = H5.H5Tvlen_create(n2);
                            break;
                        }
                        finally {
                            this.close(n2);
                        }
                    }
                    log.debug("CLASS_VLEN base type is NULL");
                    break;
                }
                case 4: 
                case 5: {
                    if (this.datatypeSize == 1) {
                        log.trace("toNative CLASS_BITFIELD-OPAQUE is H5T_NATIVE_INT8");
                        n = H5.H5Tcopy(HDF5Constants.H5T_NATIVE_INT8);
                    } else if (this.datatypeSize == 2) {
                        log.trace("toNative CLASS_BITFIELD-OPAQUE is H5T_NATIVE_INT16");
                        n = H5.H5Tcopy(HDF5Constants.H5T_NATIVE_INT16);
                    } else if (this.datatypeSize == 4) {
                        log.trace("toNative CLASS_BITFIELD-OPAQUE is H5T_NATIVE_INT32");
                        n = H5.H5Tcopy(HDF5Constants.H5T_NATIVE_INT32);
                    } else if (this.datatypeSize == 8) {
                        log.trace("toNative CLASS_BITFIELD-OPAQUE is H5T_NATIVE_INT64");
                        n = H5.H5Tcopy(HDF5Constants.H5T_NATIVE_INT64);
                    } else {
                        log.trace("toNative CLASS_BITFIELD-OPAQUE is H5T_NATIVE_INT");
                        n = H5.H5Tcopy(HDF5Constants.H5T_NATIVE_INT);
                    }
                    if (this.datatypeOrder == 1) {
                        log.trace("toNative CLASS_BITFIELD-OPAQUE is H5T_ORDER_BE");
                        H5.H5Tset_order(n, HDF5Constants.H5T_ORDER_BE);
                        break;
                    }
                    if (this.datatypeOrder == 0) {
                        log.trace("toNative CLASS_BITFIELD-OPAQUE is H5T_ORDER_LE");
                        H5.H5Tset_order(n, HDF5Constants.H5T_ORDER_LE);
                    }
                    break;
                }
                default: {
                    log.debug("toNative Unknown class");
                }
            }
        }
        catch (Exception exception) {
            log.debug("toNative figure the datatype", (Throwable)exception);
            n = -1;
        }
        if (this.datatypeClass == 8) {
            int n3 = n;
            try {
                n = H5.H5Tenum_create(n3);
                this.datatypeSize = H5.H5Tget_size(n);
            }
            catch (Exception exception) {
                log.debug("toNative create members", (Throwable)exception);
                n = -1;
            }
            try {
                StringTokenizer stringTokenizer;
                byte[] byArray = null;
                if (this.datatypeSize == 1) {
                    byArray = HDFNativeData.byteToByte(new Byte(0));
                } else if (this.datatypeSize == 2) {
                    byArray = HDFNativeData.shortToByte(new Short(0));
                } else if (this.datatypeSize == 4) {
                    byArray = HDFNativeData.intToByte(new Integer(0));
                } else if (this.datatypeSize == 8) {
                    byArray = HDFNativeData.longToByte(new Long(0L));
                }
                if (this.enumMembers == null) {
                    stringTokenizer = new StringTokenizer("0,1", ",");
                    log.trace("toNative default string");
                } else {
                    stringTokenizer = new StringTokenizer(this.enumMembers, ",");
                    log.trace("toNative string {}", (Object)this.enumMembers);
                }
                while (stringTokenizer.hasMoreTokens()) {
                    Number number;
                    String string;
                    String string2 = stringTokenizer.nextToken();
                    if (string2 != null) {
                        string2 = string2.trim();
                    }
                    if (string2 == null || string2.length() < 1) continue;
                    int n4 = string2.indexOf(61);
                    if (n4 > 0) {
                        string = string2.substring(0, n4);
                        if (this.datatypeSize == 1) {
                            log.trace("toNative ENUM is H5T_NATIVE_INT8");
                            number = Byte.parseByte(string2.substring(n4 + 1));
                            byArray = HDFNativeData.byteToByte((Byte)number);
                        } else if (this.datatypeSize == 2) {
                            log.trace("toNative CLASS_INT-ENUM is H5T_NATIVE_INT16");
                            number = Short.parseShort(string2.substring(n4 + 1));
                            byArray = HDFNativeData.shortToByte((Short)number);
                        } else if (this.datatypeSize == 4) {
                            log.trace("toNative CLASS_INT-ENUM is H5T_NATIVE_INT32");
                            number = Integer.parseInt(string2.substring(n4 + 1));
                            byArray = HDFNativeData.intToByte((Integer)number);
                        } else if (this.datatypeSize == 8) {
                            log.trace("toNative CLASS_INT-ENUM is H5T_NATIVE_INT64");
                            number = Long.parseLong(string2.substring(n4 + 1));
                            byArray = HDFNativeData.longToByte((Long)number);
                        } else {
                            log.debug("toNative enum datatypeSize incorrect");
                        }
                    } else {
                        Number number2;
                        Number number3;
                        string = string2;
                        if (this.datatypeSize == 1) {
                            log.trace("toNative ENUM is H5T_NATIVE_INT8");
                            number = new Byte(byArray[0]);
                            number3 = number;
                            number = (byte)((Byte)number + 1);
                            number2 = number;
                            byArray = HDFNativeData.byteToByte((Byte)number);
                        } else if (this.datatypeSize == 2) {
                            log.trace("toNative CLASS_INT-ENUM is H5T_NATIVE_INT16");
                            number = HDFNativeData.byteToShort(byArray)[0];
                            number3 = number;
                            number = (short)((Short)number + 1);
                            number2 = number;
                            byArray = HDFNativeData.shortToByte((Short)number);
                        } else if (this.datatypeSize == 4) {
                            log.trace("toNative CLASS_INT-ENUM is H5T_NATIVE_INT32");
                            number = HDFNativeData.byteToInt(byArray)[0];
                            number3 = number;
                            number = (Integer)number + 1;
                            number2 = number;
                            byArray = HDFNativeData.intToByte((Integer)number);
                        } else if (this.datatypeSize == 8) {
                            log.trace("toNative CLASS_INT-ENUM is H5T_NATIVE_INT64");
                            number = HDFNativeData.byteToLong(byArray)[0];
                            number3 = number;
                            number = (Long)number + 1L;
                            number2 = number;
                            byArray = HDFNativeData.longToByte((Long)number);
                        } else {
                            log.debug("toNative enum datatypeSize incorrect");
                        }
                    }
                    log.trace("toNative H5Tenum_insert {} {}", (Object)string, (Object)byArray);
                    H5.H5Tenum_insert(n, string, byArray);
                }
            }
            catch (Exception exception) {
                log.debug("toNative set up enum members", (Throwable)exception);
            }
            try {
                H5.H5Tclose(n3);
            }
            catch (Exception exception) {
                log.debug("toNative enum class:", (Throwable)exception);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object allocateArray(int n, int n2) throws OutOfMemoryError {
        Object object = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        log.trace("allocateArray: size={}", (Object)n2);
        if (n2 < 0) {
            return null;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        int n3 = -1;
        int n4 = -1;
        try {
            n3 = H5.H5Tget_class(n);
            n4 = H5.H5Tget_size(n);
            log.trace("allocateArray tclass={} : tsize={}", (Object)n3, (Object)n4);
        }
        catch (Exception exception) {
            log.debug("H5Tget_xxxx data type information:", (Throwable)exception);
        }
        try {
            bl2 = H5.H5Tis_variable_str(n);
        }
        catch (Exception exception) {
            log.debug("H5Tis_variable_str data type information:", (Throwable)exception);
        }
        bl = n3 == HDF5Constants.H5T_VLEN;
        try {
            bl3 = H5.H5Tequal(n, HDF5Constants.H5T_STD_REF_DSETREG);
        }
        catch (Exception exception) {
            log.debug("H5Tequal data type information:", (Throwable)exception);
        }
        if (bl2 || bl || bl3) {
            log.trace("allocateArray is_variable_str={} || isVL={} || is_reg_ref={}", new Object[]{bl2, bl, bl3});
            object = new String[n2];
            for (int i = 0; i < n2; ++i) {
                ((String[])object)[i] = "";
            }
        } else if (n3 == HDF5Constants.H5T_INTEGER) {
            log.trace("allocateArray class.H5T_INTEGER={}", (Object)n3);
            if (n4 == 1) {
                object = new byte[n2];
            } else if (n4 == 2) {
                object = new short[n2];
            } else if (n4 == 4) {
                object = new int[n2];
            } else if (n4 == 8) {
                object = new long[n2];
            }
        } else if (n3 == HDF5Constants.H5T_ENUM) {
            log.trace("allocateArray class.H5T_ENUM={}", (Object)n3);
            int n5 = -1;
            try {
                n5 = H5.H5Tget_super(n);
                object = H5Datatype.allocateArray(n5, n2);
            }
            catch (Exception exception) {
                log.debug("H5T_ENUM class enum data type information:", (Throwable)exception);
            }
            finally {
                try {
                    H5.H5Tclose(n5);
                }
                catch (Exception exception) {
                    log.debug("H5T_ENUM class finally close:", (Throwable)exception);
                }
            }
        } else if (n3 == HDF5Constants.H5T_FLOAT) {
            log.trace("allocateArray class.H5T_FLOAT={}", (Object)n3);
            if (n4 == 4) {
                object = new float[n2];
            } else if (n4 == 8) {
                object = new double[n2];
            }
        } else if (n3 == HDF5Constants.H5T_STRING || n3 == HDF5Constants.H5T_REFERENCE) {
            log.trace("allocateArray class.H5T_STRING || H5T_REFERENCE={}", (Object)n3);
            object = new byte[n2 * n4];
        } else if (n3 == HDF5Constants.H5T_ARRAY) {
            int n6 = -1;
            try {
                int n7 = H5.H5Tget_array_ndims(n);
                long[] lArray = new long[n7];
                H5.H5Tget_array_dims(n, lArray);
                int n8 = 1;
                for (int i = 0; i < n7; ++i) {
                    n8 = (int)((long)n8 * lArray[i]);
                }
                log.trace("allocateArray class.H5T_ARRAY={} : members={} : asize={}", new Object[]{n3, n7, n8});
                n6 = H5.H5Tget_super(n);
                object = H5Datatype.allocateArray(n6, n2 * n8);
            }
            catch (Exception exception) {
                log.debug("H5T_ARRAY class: ", (Throwable)exception);
            }
            finally {
                try {
                    H5.H5Tclose(n6);
                }
                catch (Exception exception) {
                    log.debug("H5T_ARRAY class finally close:", (Throwable)exception);
                }
            }
        } else if (n3 == HDF5Constants.H5T_OPAQUE || n3 == HDF5Constants.H5T_BITFIELD) {
            log.trace("allocateArray class.H5T_OPAQUE || H5T_BITFIELD={}", (Object)n3);
            object = new byte[n2 * n4];
        } else {
            log.debug("allocateArray class.????={}", (Object)n3);
            object = null;
        }
        return object;
    }

    public static final int getDatatypeSize(int n) {
        int n2 = -1;
        try {
            n2 = H5.H5Tget_size(n);
        }
        catch (Exception exception) {
            n2 = -1;
        }
        return n2;
    }

    @Override
    public String getDatatypeDescription() {
        if (this.description == null) {
            int n = this.toNative();
            if (n >= 0) {
                this.description = H5Datatype.getDatatypeDescription(n);
                this.close(n);
            } else {
                this.description = "Unknown";
            }
        }
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getDatatypeDescription(int n) {
        String string;
        block80: {
            string = "Unknown";
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            try {
                n2 = H5.H5Tget_class(n);
                n3 = H5.H5Tget_size(n);
            }
            catch (Exception exception) {
                log.debug("getDatatypeDescription Unknown:", (Throwable)exception);
            }
            if (n2 == HDF5Constants.H5T_INTEGER) {
                try {
                    n4 = H5.H5Tget_sign(n);
                }
                catch (Exception exception) {
                    log.debug("getDatatypeDescription H5Tget_sign failure:", (Throwable)exception);
                }
                if (n3 == 1) {
                    try {
                        if (n4 == HDF5Constants.H5T_SGN_NONE) {
                            string = "8-bit unsigned integer";
                            break block80;
                        }
                        string = "8-bit integer";
                    }
                    catch (Exception exception) {
                        string = "Unknown";
                    }
                } else if (n3 == 2) {
                    string = n4 == HDF5Constants.H5T_SGN_NONE ? "16-bit unsigned integer" : "16-bit integer";
                } else if (n3 == 4) {
                    string = n4 == HDF5Constants.H5T_SGN_NONE ? "32-bit unsigned integer" : "32-bit integer";
                } else if (n3 == 8) {
                    string = n4 == HDF5Constants.H5T_SGN_NONE ? "64-bit unsigned integer" : "64-bit integer";
                }
            } else if (n2 == HDF5Constants.H5T_FLOAT) {
                if (n3 == 4) {
                    string = "32-bit floating-point";
                } else if (n3 == 8) {
                    string = "64-bit floating-point";
                }
            } else if (n2 == HDF5Constants.H5T_STRING) {
                try {
                    if (H5.H5Tis_variable_str(n)) {
                        string = "String, length = variable";
                        break block80;
                    }
                    string = "String, length = " + H5.H5Tget_size(n);
                }
                catch (Exception exception) {
                    string = "String";
                }
            } else if (n2 == HDF5Constants.H5T_REFERENCE) {
                boolean bl = false;
                try {
                    bl = H5.H5Tequal(n, HDF5Constants.H5T_STD_REF_DSETREG);
                }
                catch (Exception exception) {
                    log.debug("H5T_STD_REF_DSETREG:", (Throwable)exception);
                }
                string = bl ? "Dataset region reference" : "Object reference";
            } else if (n2 == HDF5Constants.H5T_BITFIELD) {
                string = "Bitfield";
            } else if (n2 == HDF5Constants.H5T_ENUM) {
                byte[] byArray = new byte[n3];
                String string2 = " ( ";
                try {
                    int n5 = H5.H5Tget_nmembers(n);
                    for (int i = 0; i < n5; ++i) {
                        H5.H5Tget_member_value(n, i, byArray);
                        string2 = string2 + H5.H5Tget_member_name(n, i);
                        string2 = string2 + "=";
                        if (n3 == 1) {
                            string = "8-bit enum";
                            string2 = string2 + HDFNativeData.byteToByte(byArray[0])[0];
                        } else if (n3 == 2) {
                            string = "16-bit enum";
                            string2 = string2 + HDFNativeData.byteToShort(byArray)[0];
                        } else if (n3 == 4) {
                            string = "32-bit enum";
                            string2 = string2 + HDFNativeData.byteToInt(byArray)[0];
                        } else if (n3 == 8) {
                            string = "64-bit enum";
                            string2 = string2 + HDFNativeData.byteToLong(byArray)[0];
                        }
                        if (i >= n5 - 1) continue;
                        string2 = string2 + " ";
                    }
                    string2 = string2 + ")";
                    string = string + string2;
                }
                catch (Exception exception) {
                    log.debug("H5T_ENUM:", (Throwable)exception);
                }
            } else if (n2 == HDF5Constants.H5T_ARRAY) {
                string = "Array of ";
                int n6 = -1;
                try {
                    n6 = H5.H5Tget_super(n);
                    string = string + H5Datatype.getDatatypeDescription(n6);
                    int n7 = H5.H5Tget_array_ndims(n);
                    long[] lArray = new long[n7];
                    try {
                        H5.H5Tget_array_dims(n, lArray);
                    }
                    catch (Exception exception) {
                        log.debug("H5T_ARRAY dims:", (Throwable)exception);
                    }
                    string = string + " (" + lArray[0];
                    for (int i = 1; i < n7; ++i) {
                        string = string + "x" + lArray[i];
                    }
                    string = string + ")";
                }
                catch (Exception exception) {
                    log.debug("H5T_ARRAY:", (Throwable)exception);
                }
                finally {
                    try {
                        H5.H5Tclose(n6);
                    }
                    catch (Exception exception) {
                        log.debug("finally close:", (Throwable)exception);
                    }
                }
            } else if (n2 == HDF5Constants.H5T_COMPOUND) {
                string = "Compound ";
                try {
                    string = string + "{";
                    int n8 = H5.H5Tget_nmembers(n);
                    int n9 = -1;
                    for (int i = 0; i < n8; ++i) {
                        n9 = H5.H5Tget_member_type(n, i);
                        string = string + H5Datatype.getDatatypeDescription(n9) + ", ";
                        try {
                            H5.H5Tclose(n9);
                        }
                        catch (Exception exception) {
                            log.debug("H5T_COMPOUND member close:", (Throwable)exception);
                        }
                        n9 = -1;
                    }
                    string = string + "}";
                }
                catch (Exception exception) {
                    log.debug("H5T_COMPOUND:", (Throwable)exception);
                }
            } else if (n2 == HDF5Constants.H5T_VLEN) {
                int n10 = -1;
                try {
                    n10 = H5.H5Tget_super(n);
                    string = "Variable-length of " + H5Datatype.getDatatypeDescription(n10);
                }
                catch (Exception exception) {
                    string = "Variable-length";
                }
                finally {
                    try {
                        H5.H5Tclose(n10);
                    }
                    catch (Exception exception) {
                        log.debug("finally close:", (Throwable)exception);
                    }
                }
            } else {
                string = n2 == HDF5Constants.H5T_OPAQUE ? "Opaque" : "Unknown";
            }
        }
        return string;
    }

    @Override
    public boolean isUnsigned() {
        boolean bl = false;
        int n = this.toNative();
        bl = H5Datatype.isUnsigned(n);
        try {
            H5.H5Tclose(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static final boolean isUnsigned(int n) {
        boolean bl;
        block7: {
            bl = false;
            if (n >= 0) {
                try {
                    int n2 = H5.H5Tget_class(n);
                    if (n2 != HDF5Constants.H5T_FLOAT && n2 != HDF5Constants.H5T_STRING && n2 != HDF5Constants.H5T_REFERENCE && n2 != HDF5Constants.H5T_BITFIELD && n2 != HDF5Constants.H5T_OPAQUE) {
                        int n3 = H5.H5Tget_sign(n);
                        if (n3 == HDF5Constants.H5T_SGN_NONE) {
                            bl = true;
                        } else {
                            log.trace("isUnsigned() not unsigned");
                        }
                        break block7;
                    }
                    log.trace("float isUnsigned() not unsigned");
                }
                catch (Exception exception) {
                    log.debug("{} Datatype {} failure", new Object[]{H5Datatype.getDatatypeDescription(n), n, exception});
                    bl = false;
                }
            } else {
                log.trace("isUnsigned() not a valid datatype");
            }
        }
        return bl;
    }

    @Override
    public int open() {
        int n = -1;
        try {
            n = H5.H5Topen(this.getFID(), this.getPath() + this.getName(), HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5Exception hDF5Exception) {
            n = -1;
        }
        return n;
    }

    @Override
    public void close(int n) {
        try {
            H5.H5Tclose(n);
        }
        catch (HDF5Exception hDF5Exception) {
            log.debug("close H5Datatype:", (Throwable)hDF5Exception);
        }
    }

    @Override
    public List<Attribute> getMetadata() throws HDF5Exception {
        return this.getMetadata(this.fileFormat.getIndexType(null), this.fileFormat.getIndexOrder(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Attribute> getMetadata(int ... nArray) throws HDF5Exception {
        if (this.attributeList == null) {
            int n = this.open();
            int n2 = this.fileFormat.getIndexType(null);
            int n3 = this.fileFormat.getIndexOrder(null);
            if (nArray.length > 0) {
                n2 = nArray[0];
                if (nArray.length > 1) {
                    n3 = nArray[1];
                }
            }
            try {
                this.attributeList = H5File.getAttribute(n, n2, n3);
            }
            catch (Exception exception) {
                log.debug("attributeList:", (Throwable)exception);
            }
            finally {
                this.close(n);
            }
        }
        try {
            this.linkTargetObjName = H5File.getLinkTargetName(this);
        }
        catch (Exception exception) {
            log.debug("linkTargetObjName:", (Throwable)exception);
        }
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        log.trace("writeMetadata start");
        boolean bl = false;
        Attribute attribute = (Attribute)object;
        String string = attribute.getName();
        if (this.attributeList == null) {
            this.getMetadata();
        }
        if (this.attributeList != null) {
            bl = this.attributeList.contains(attribute);
        }
        this.getFileFormat().writeAttribute(this, attribute, bl);
        if (!bl) {
            this.attributeList.add(attribute);
            this.nAttributes = this.attributeList.size();
        }
        log.trace("writeMetadata finish");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetadata(Object object) throws HDF5Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        Attribute attribute = (Attribute)object;
        int n = this.open();
        try {
            H5.H5Adelete(n, attribute.getName());
            List<Attribute> list = this.getMetadata();
            list.remove(attribute);
            this.nAttributes = this.attributeList.size();
        }
        finally {
            this.close(n);
        }
    }

    @Override
    public void setName(String string) throws Exception {
        H5File.renameObject(this, string);
        super.setName(string);
    }
}

