/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5DataFiltersException;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.structs.H5O_info_t;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.h5.H5Datatype;
import ncsa.hdf.object.h5.H5File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H5CompoundDS
extends CompoundDS {
    private static final long serialVersionUID = -5968625125574032736L;
    private static final Logger log = LoggerFactory.getLogger(H5CompoundDS.class);
    private List<Attribute> attributeList;
    private int nAttributes = -1;
    private H5O_info_t obj_info = new H5O_info_t(-1L, -1L, 0, 0, -1L, 0L, 0L, 0L, 0L, null, null, null);
    private List<String> flatNameList;
    private List<Integer> flatTypeList;
    private boolean isExternal = false;

    public H5CompoundDS(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    @Deprecated
    public H5CompoundDS(FileFormat fileFormat, String string, String string2, long[] lArray) {
        super(fileFormat, string, string2, lArray);
        if (lArray == null && fileFormat != null) {
            try {
                byte[] byArray = H5.H5Rcreate(fileFormat.getFID(), this.getFullName(), HDF5Constants.H5R_OBJECT, -1);
                this.oid = new long[1];
                this.oid[0] = HDFNativeData.byteToLong(byArray, 0);
            }
            catch (Exception exception) {
                log.debug("constructor ID {} for {} failed H5Rcreate", (Object)fileFormat.getFID(), (Object)this.getFullName());
            }
        }
    }

    @Override
    public int open() {
        int n = -1;
        try {
            n = H5.H5Dopen(this.getFID(), this.getPath() + this.getName(), HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5Exception hDF5Exception) {
            log.debug("Failed to open dataset {}", (Object)(this.getPath() + this.getName()));
            n = -1;
        }
        return n;
    }

    @Override
    public void close(int n) {
        if (n >= 0) {
            try {
                H5.H5Fflush(n, HDF5Constants.H5F_SCOPE_LOCAL);
            }
            catch (Exception exception) {
                log.debug("close.H5Fflush:", (Throwable)exception);
            }
            try {
                H5.H5Dclose(n);
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("close.H5Dclose:", (Throwable)hDF5Exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.rank > 0) {
            this.resetSelection();
            return;
        }
        log.trace("init() start");
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        this.flatNameList = new Vector<String>();
        this.flatTypeList = new Vector<Integer>();
        int[] nArray = null;
        n = this.open();
        if (n >= 0) {
            block50: {
                int n5 = -1;
                try {
                    n5 = H5.H5Dget_create_plist(n);
                    int n6 = H5.H5Pget_external_count(n5);
                    this.isExternal = n6 > 0;
                }
                catch (Exception exception) {
                    log.debug("check if it is an external dataset:", (Throwable)exception);
                }
                finally {
                    try {
                        H5.H5Pclose(n5);
                    }
                    catch (Exception exception) {
                        log.debug("finally close:", (Throwable)exception);
                    }
                }
                try {
                    n2 = H5.H5Dget_space(n);
                    this.rank = H5.H5Sget_simple_extent_ndims(n2);
                    n3 = H5.H5Dget_type(n);
                    n4 = H5.H5Tget_class(n3);
                    int n7 = 0;
                    if (n4 == HDF5Constants.H5T_ARRAY) {
                        n7 = n3;
                        n3 = H5.H5Tget_super(n7);
                        try {
                            H5.H5Tclose(n7);
                        }
                        catch (HDF5Exception hDF5Exception) {
                            // empty catch block
                        }
                    }
                    if (this.rank == 0) {
                        this.rank = 1;
                        this.dims = new long[1];
                        this.dims[0] = 1L;
                    } else {
                        this.dims = new long[this.rank];
                        this.maxDims = new long[this.rank];
                        H5.H5Sget_simple_extent_dims(n2, this.dims, this.maxDims);
                    }
                    this.startDims = new long[this.rank];
                    this.selectedDims = new long[this.rank];
                    this.extractCompoundInfo(n3, "", this.flatNameList, this.flatTypeList);
                    this.numberOfMembers = this.flatNameList.size();
                    this.memberNames = new String[this.numberOfMembers];
                    nArray = new int[this.numberOfMembers];
                    this.memberTypes = new Datatype[this.numberOfMembers];
                    this.memberOrders = new int[this.numberOfMembers];
                    this.isMemberSelected = new boolean[this.numberOfMembers];
                    this.memberDims = new Object[this.numberOfMembers];
                    for (int i = 0; i < this.numberOfMembers; ++i) {
                        this.isMemberSelected[i] = true;
                        nArray[i] = this.flatTypeList.get(i);
                        this.memberTypes[i] = new H5Datatype(nArray[i]);
                        this.memberNames[i] = this.flatNameList.get(i);
                        this.memberOrders[i] = 1;
                        this.memberDims[i] = null;
                        try {
                            n4 = H5.H5Tget_class(nArray[i]);
                        }
                        catch (HDF5Exception hDF5Exception) {
                            log.debug("memberTIDs[{}]:", (Object)i, (Object)hDF5Exception);
                        }
                        if (n4 != HDF5Constants.H5T_ARRAY) continue;
                        int n8 = H5.H5Tget_array_ndims(nArray[i]);
                        long[] lArray = new long[n8];
                        H5.H5Tget_array_dims(nArray[i], lArray);
                        int[] nArray2 = new int[n8];
                        for (int j = 0; j < n8; ++j) {
                            nArray2[j] = (int)lArray[j];
                        }
                        this.memberDims[i] = nArray2;
                        n7 = H5.H5Tget_super(nArray[i]);
                        this.memberOrders[i] = H5.H5Tget_size(nArray[i]) / H5.H5Tget_size(n7);
                        try {
                            H5.H5Tclose(n7);
                            continue;
                        }
                        catch (HDF5Exception hDF5Exception) {
                            log.debug("close temp of memberTIDs[{}]:", (Object)i, (Object)hDF5Exception);
                        }
                    }
                }
                catch (HDF5Exception hDF5Exception) {
                    this.numberOfMembers = 0;
                    this.memberNames = null;
                    this.memberTypes = null;
                    this.memberOrders = null;
                    log.debug("init():", (Throwable)hDF5Exception);
                }
                finally {
                    try {
                        H5.H5Tclose(n3);
                    }
                    catch (HDF5Exception hDF5Exception) {
                        log.debug("finally close:", (Throwable)hDF5Exception);
                    }
                    try {
                        H5.H5Sclose(n2);
                    }
                    catch (HDF5Exception hDF5Exception) {
                        log.debug("finally close:", (Throwable)hDF5Exception);
                    }
                    if (nArray == null) break block50;
                    for (int i = 0; i < nArray.length; ++i) {
                        try {
                            H5.H5Tclose((int)nArray[i]);
                            continue;
                        }
                        catch (Exception exception) {
                            log.debug("finally close:", (Throwable)exception);
                        }
                    }
                }
            }
            this.close(n);
        } else {
            log.debug("init() failed to open dataset");
        }
        this.resetSelection();
    }

    @Override
    public boolean hasAttribute() {
        this.obj_info.num_attrs = this.nAttributes;
        if (this.obj_info.num_attrs < 0L) {
            int n = this.open();
            if (n >= 0) {
                try {
                    this.obj_info = H5.H5Oget_info(n);
                    this.nAttributes = (int)this.obj_info.num_attrs;
                }
                catch (Exception exception) {
                    this.obj_info.num_attrs = 0L;
                    log.debug("hasAttribute: get object info:", (Throwable)exception);
                }
                this.close(n);
            } else {
                log.debug("could not open dataset");
            }
        }
        return this.obj_info.num_attrs > 0L;
    }

    @Override
    public Datatype getDatatype() {
        if (this.datatype == null) {
            log.trace("H5CompoundDS getDatatype: datatype == null");
            this.datatype = new H5Datatype(6, -1, -1, -1);
        }
        return this.datatype;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.attributeList != null) {
            ((Vector)this.attributeList).setSize(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readBytes() throws HDF5Exception {
        int n;
        byte[] byArray = null;
        log.trace("H5CompoundDS readBytes: start");
        if (this.rank <= 0) {
            this.init();
        }
        if ((n = this.open()) >= 0) {
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            try {
                int n5;
                long[] lArray = new long[]{1L};
                for (n5 = 0; n5 < this.selectedDims.length; ++n5) {
                    lArray[0] = lArray[0] * this.selectedDims[n5];
                }
                n2 = H5.H5Dget_space(n);
                n3 = H5.H5Screate_simple(this.rank, this.selectedDims, null);
                if ((long)this.rank * this.dims[0] > 1L) {
                    H5.H5Sselect_hyperslab(n2, HDF5Constants.H5S_SELECT_SET, this.startDims, this.selectedStride, this.selectedDims, null);
                }
                n4 = H5.H5Dget_type(n);
                n5 = H5.H5Tget_size(n4) * (int)lArray[0];
                log.trace("H5CompoundDS readBytes: size = {}", (Object)n5);
                byArray = new byte[n5];
                H5.H5Dread(n, n4, n3, n2, HDF5Constants.H5P_DEFAULT, byArray);
            }
            finally {
                try {
                    H5.H5Sclose(n2);
                }
                catch (Exception exception) {
                    log.debug("finally close:", (Throwable)exception);
                }
                try {
                    H5.H5Sclose(n3);
                }
                catch (Exception exception) {
                    log.debug("finally close:", (Throwable)exception);
                }
                try {
                    H5.H5Tclose(n4);
                }
                catch (HDF5Exception hDF5Exception) {
                    log.debug("finally close:", (Throwable)hDF5Exception);
                }
                this.close(n);
            }
        }
        log.trace("H5CompoundDS readBytes: finish");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object read() throws Exception {
        Object object;
        Vector<Object> vector = null;
        String[] stringArray = null;
        String string = null;
        int n = -1;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int[] nArray = new int[]{-1, -1};
        log.trace("H5CompoundDS read: start");
        if (this.rank <= 0) {
            this.init();
        }
        if (this.numberOfMembers <= 0) {
            return null;
        }
        if (this.isExternal) {
            object = this.getFileFormat().getAbsoluteFile().getParent();
            if (object == null) {
                object = ".";
            }
            H5.H5Dchdir_ext((String)object);
        }
        object = new long[]{1L};
        log.trace("H5CompoundDS read: open dataset");
        n4 = this.open();
        if (n4 >= 0) {
            int n8;
            vector = new Vector<Object>(this.flatNameList.size());
            Vector<Integer> vector2 = new Vector<Integer>();
            try {
                int n6;
                object[0] = this.selectHyperslab(n4, nArray);
                log.trace("H5CompoundDS read: opened dataset size {} for {}", (Object)((long)object[0]), (Object)this.nPoints);
                if (object[0] == 0L) {
                    throw new HDF5Exception("No data to read.\nEither the dataset or the selected subset is empty.");
                }
                if (log.isDebugEnabled()) {
                    try {
                        long l = H5.H5Dget_storage_size(n4);
                        log.trace("Storage space allocated = {}.", (Object)l);
                    }
                    catch (Exception exception) {
                        log.debug("check if storage space is allocated:", (Throwable)exception);
                    }
                }
                int n7 = this.flatNameList.size();
                n5 = H5.H5Dget_type(n4);
                log.trace("H5CompoundDS read: H5Tget_super");
                n8 = H5.H5Tget_class(n5);
                if (n8 == HDF5Constants.H5T_ARRAY) {
                    n6 = -1;
                    try {
                        n6 = n5;
                        n5 = H5.H5Tget_super(n6);
                    }
                    finally {
                        try {
                            H5.H5Tclose(n6);
                        }
                        catch (Exception exception) {
                            log.debug("finally close:", (Throwable)exception);
                        }
                    }
                }
                this.extractCompoundInfo(n5, null, null, vector2);
                log.trace("H5CompoundrDS read: foreach nMembers={}", (Object)n7);
                for (n6 = 0; n6 < n7; ++n6) {
                    int n9;
                    String[] stringArray2;
                    Object object2;
                    boolean bl = false;
                    if (!this.isMemberSelected[n6]) {
                        log.debug("H5CompoundDS read: Member[{}] is not selected", (Object)n6);
                        continue;
                    }
                    string = new String(this.memberNames[n6]);
                    n3 = vector2.get(n6);
                    try {
                        n = H5.H5Tget_class(n3);
                        n2 = H5.H5Tget_size(n3);
                        stringArray = H5Datatype.allocateArray(n3, (int)object[0]);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        stringArray = null;
                        throw new HDF5Exception("Out Of Memory.");
                    }
                    catch (Exception exception) {
                        stringArray = null;
                    }
                    log.trace("H5CompoundDS read: {} Member[{}] is class {} of size={}", new Object[]{string, n6, n, n2});
                    if (stringArray == null || H5.H5Tequal(n3, HDF5Constants.H5T_STD_REF_DSETREG)) {
                        String[] stringArray3 = new String[(int)object[0]];
                        object2 = "*unsupported*";
                        int n10 = 0;
                        while ((long)n10 < object[0]) {
                            stringArray3[n10] = object2;
                            ++n10;
                        }
                        vector.add(stringArray3);
                        continue;
                    }
                    if (stringArray == null) continue;
                    int n11 = -1;
                    object2 = new int[]{n, n2, 0};
                    try {
                        n11 = this.createCompoundFieldType(n3, string, (int[])object2);
                    }
                    catch (HDF5Exception hDF5Exception) {
                        stringArray2 = new String[(int)object[0]];
                        n9 = 0;
                        while ((long)n9 < object[0]) {
                            stringArray2[n9] = "";
                            ++n9;
                        }
                        vector.add(stringArray2);
                        log.debug("H5CompoundDS read: {} Member[{}] createCompoundFieldTypefailure:", new Object[]{string, n6, hDF5Exception});
                        continue;
                    }
                    try {
                        bl = bl || H5.H5Tis_variable_str(n3);
                        bl = bl || H5.H5Tdetect_class(n3, HDF5Constants.H5T_VLEN);
                    }
                    catch (Exception exception) {
                        log.debug("H5CompoundDS read: detection of varstr:", (Throwable)exception);
                        bl = false;
                    }
                    try {
                        log.trace("H5CompoundDS read: H5Dread did={} spaceIDs[0]={} spaceIDs[1]={}", new Object[]{n4, nArray[0], nArray[1]});
                        if (bl) {
                            H5.H5DreadVL(n4, n11, nArray[0], nArray[1], HDF5Constants.H5P_DEFAULT, stringArray);
                        } else {
                            H5.H5Dread(n4, n11, nArray[0], nArray[1], HDF5Constants.H5P_DEFAULT, stringArray);
                        }
                    }
                    catch (HDF5DataFiltersException hDF5DataFiltersException) {
                        log.debug("H5CompoundDS read: {} Member[{}] read failure:", new Object[]{string, n6, hDF5DataFiltersException});
                        throw new Exception("Filter not available exception: " + hDF5DataFiltersException.getMessage(), hDF5DataFiltersException);
                    }
                    catch (HDF5Exception hDF5Exception) {
                        stringArray2 = new String[(int)object[0]];
                        n9 = 0;
                        while ((long)n9 < object[0]) {
                            stringArray2[n9] = "";
                            ++n9;
                        }
                        vector.add(stringArray2);
                        log.debug("H5CompoundDS read: {} Member[{}] read failure:", new Object[]{string, n6, hDF5Exception});
                        continue;
                    }
                    finally {
                        try {
                            H5.H5Tclose(n11);
                        }
                        catch (Exception exception) {
                            log.debug("H5CompoundDS read: finally close:", (Throwable)exception);
                        }
                    }
                    if (!bl) {
                        String string2 = stringArray.getClass().getName();
                        char c = string2.charAt(string2.lastIndexOf("[") + 1);
                        if (n == HDF5Constants.H5T_STRING && this.convertByteToString) {
                            if (c == 'B') {
                                stringArray = H5CompoundDS.byteToString((byte[])stringArray, n2 / this.memberOrders[n6]);
                            }
                        } else if (n == HDF5Constants.H5T_REFERENCE) {
                            if (c == 'B') {
                                stringArray = (String[])HDFNativeData.byteToLong((byte[])stringArray);
                            }
                        } else if (object2[2] != false) {
                            stringArray = Dataset.convertFromUnsignedC(stringArray, null);
                        } else if (n == HDF5Constants.H5T_ENUM && this.enumConverted) {
                            try {
                                String[] stringArray4 = H5Datatype.convertEnumValueToName(n3, stringArray, null);
                                if (stringArray4 != null) {
                                    stringArray = stringArray4;
                                }
                            }
                            catch (Exception exception) {
                                log.debug("read: H5Datatype.convertEnumValueToName:", (Throwable)exception);
                            }
                        }
                    }
                    vector.add(stringArray);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (HDF5Constants.H5S_ALL != nArray[0]) {
                        H5.H5Sclose(nArray[0]);
                    }
                }
                catch (Exception exception) {
                    log.debug("read: finally close:", (Throwable)exception);
                }
                try {
                    if (HDF5Constants.H5S_ALL != nArray[1]) {
                        H5.H5Sclose(nArray[1]);
                    }
                }
                catch (Exception exception) {
                    log.debug("read: finally close:", (Throwable)exception);
                }
                int n13 = vector2.size();
                for (int i = 0; i < n13; ++i) {
                    n3 = (Integer)vector2.get(i);
                    try {
                        H5.H5Tclose(n3);
                        continue;
                    }
                    catch (Exception exception) {
                        log.debug("finally close:", (Throwable)exception);
                    }
                }
                try {
                    H5.H5Tclose(n5);
                }
                catch (Exception exception) {
                    log.debug("finally close:", (Throwable)exception);
                }
                this.close(n4);
                throw throwable;
            }
            try {
                if (HDF5Constants.H5S_ALL != nArray[0]) {
                    H5.H5Sclose(nArray[0]);
                }
            }
            catch (Exception exception) {
                log.debug("read: finally close:", (Throwable)exception);
            }
            try {
                if (HDF5Constants.H5S_ALL != nArray[1]) {
                    H5.H5Sclose(nArray[1]);
                }
            }
            catch (Exception exception) {
                log.debug("read: finally close:", (Throwable)exception);
            }
            int n12 = vector2.size();
            for (n8 = 0; n8 < n12; ++n8) {
                n3 = vector2.get(n8);
                try {
                    H5.H5Tclose(n3);
                    continue;
                }
                catch (Exception exception) {
                    log.debug("finally close:", (Throwable)exception);
                }
            }
            try {
                H5.H5Tclose(n5);
            }
            catch (Exception exception) {
                log.debug("finally close:", (Throwable)exception);
            }
            this.close(n4);
        }
        log.trace("H5CompoundDS read: finish");
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Object object) throws HDF5Exception {
        log.trace("H5CompoundDS write: start");
        int n = -1;
        int n2 = -1;
        int[] nArray = new int[]{-1, -1};
        Object object2 = null;
        String string = null;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        List list = (List)object;
        if (object == null || this.numberOfMembers <= 0 || !(object instanceof List)) {
            return;
        }
        long[] lArray = new long[]{1L};
        n = this.open();
        log.trace("H5CompoundDS write: dataset opened");
        if (n >= 0) {
            int n6;
            Vector<Integer> vector = new Vector<Integer>();
            try {
                lArray[0] = this.selectHyperslab(n, nArray);
                int n7 = H5.H5Dget_type(n);
                n6 = 0;
                int n8 = this.flatNameList.size();
                boolean bl = false;
                try {
                    this.extractCompoundInfo(n7, null, null, vector);
                }
                finally {
                    try {
                        H5.H5Tclose(n7);
                    }
                    catch (Exception exception) {
                        log.debug("finally close:", (Throwable)exception);
                    }
                }
                for (int i = 0; i < n8; ++i) {
                    log.trace("H5CompoundDS write: Member[{}] of {}", (Object)i, (Object)n8);
                    if (!this.isMemberSelected[i]) {
                        log.debug("H5CompoundDS write: Member[{}] is not selected", (Object)i);
                        continue;
                    }
                    string = new String(this.memberNames[i]);
                    n3 = vector.get(i);
                    if ((object2 = (Object)list.get(n6++)) == null) {
                        log.debug("H5CompoundDS write: Member[{}] data is null", (Object)i);
                        continue;
                    }
                    boolean bl2 = false;
                    try {
                        bl2 = H5.H5Tget_class(n3) == HDF5Constants.H5T_VLEN || H5.H5Tis_variable_str(n3);
                        log.debug("H5CompoundDS write: Member[{}] is VL", (Object)i);
                    }
                    catch (Exception exception) {
                        log.debug("isVL:", (Throwable)exception);
                    }
                    try {
                        n4 = H5.H5Tget_class(n3);
                        n5 = H5.H5Tget_size(n3);
                        bl = n4 == HDF5Constants.H5T_ENUM;
                    }
                    catch (Exception exception) {
                        log.debug("H5CompoundDS write: member class - size:", (Throwable)exception);
                    }
                    log.trace("H5CompoundDS write: {} Member[{}] is class {} of size={}", new Object[]{string, i, n4, n5});
                    Object object3 = object2;
                    int[] nArray2 = new int[]{n4, n5, 0};
                    try {
                        n2 = this.createCompoundFieldType(n3, string, nArray2);
                        log.debug("H5CompoundDS write: {} Member[{}] compInfo[class]={} compInfo[size]={} compInfo[unsigned]={}", new Object[]{string, i, nArray2[0], nArray2[1], nArray2[2]});
                        if (bl2) {
                            H5.H5DwriteString(n, n2, nArray[0], nArray[1], HDF5Constants.H5P_DEFAULT, (String[])object3);
                            continue;
                        }
                        if (nArray2[2] != 0) {
                            int n9 = H5.H5Tget_size(n2);
                            String string2 = object2.getClass().getName();
                            char c = string2.charAt(string2.lastIndexOf("[") + 1);
                            boolean bl3 = n9 == 1 && c == 'S' || n9 == 2 && c == 'I' || n9 == 4 && c == 'J';
                            object3 = object2;
                            if (bl3) {
                                object3 = H5CompoundDS.convertToUnsignedC(object2, null);
                            }
                            log.trace("H5CompoundDS write: {} Member[{}] convertToUnsignedC", (Object)string, (Object)i);
                        } else if (n4 == HDF5Constants.H5T_STRING && Array.get(object2, 0) instanceof String) {
                            object3 = H5CompoundDS.stringToByte((String[])object2, n5);
                            log.trace("H5CompoundDS write: {} Member[{}] stringToByte", (Object)string, (Object)i);
                        } else if (bl && Array.get(object2, 0) instanceof String) {
                            object3 = H5Datatype.convertEnumNameToValue(n3, (String[])object2, null);
                            log.trace("H5CompoundDS write: {} Member[{}] convertEnumNameToValue", (Object)string, (Object)i);
                        }
                        if (object3 == null) continue;
                        log.debug("H5CompoundDS write: H5Dwrite warning - does not write nested compound data");
                        H5.H5Dwrite(n, n2, nArray[0], nArray[1], HDF5Constants.H5P_DEFAULT, object3);
                        continue;
                    }
                    catch (Exception exception) {
                        log.debug("write: H5Dwrite process failure:", (Throwable)exception);
                        continue;
                    }
                    finally {
                        try {
                            H5.H5Tclose(n2);
                        }
                        catch (Exception exception) {
                            log.debug("write: finally close:", (Throwable)exception);
                        }
                    }
                }
            }
            finally {
                try {
                    if (HDF5Constants.H5S_ALL != nArray[0]) {
                        H5.H5Sclose(nArray[0]);
                    }
                }
                catch (Exception exception) {
                    log.debug("write: finally close:", (Throwable)exception);
                }
                try {
                    if (HDF5Constants.H5S_ALL != nArray[1]) {
                        H5.H5Sclose(nArray[1]);
                    }
                }
                catch (Exception exception) {
                    log.debug("write: finally close:", (Throwable)exception);
                }
                int n10 = vector.size();
                for (n6 = 0; n6 < n10; ++n6) {
                    n3 = vector.get(n6);
                    try {
                        H5.H5Tclose(n3);
                        continue;
                    }
                    catch (Exception exception) {
                        log.debug("write: finally close:", (Throwable)exception);
                    }
                }
            }
            this.close(n);
        }
        log.trace("H5CompoundDS write: finish");
    }

    private long selectHyperslab(int n, int[] nArray) throws HDF5Exception {
        long l = 1L;
        boolean bl = true;
        for (int i = 0; i < this.rank; ++i) {
            l *= this.selectedDims[i];
            if (this.selectedDims[i] >= this.dims[i]) continue;
            bl = false;
        }
        if (bl) {
            nArray[0] = HDF5Constants.H5S_ALL;
            nArray[1] = HDF5Constants.H5S_ALL;
        } else {
            nArray[1] = H5.H5Dget_space(n);
            nArray[0] = H5.H5Screate_simple(this.rank, this.selectedDims, null);
            H5.H5Sselect_hyperslab(nArray[1], HDF5Constants.H5S_SELECT_SET, this.startDims, this.selectedStride, this.selectedDims, null);
        }
        return l;
    }

    @Override
    public List<Attribute> getMetadata() throws HDF5Exception {
        return this.getMetadata(this.fileFormat.getIndexType(null), this.fileFormat.getIndexOrder(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Attribute> getMetadata(int ... nArray) throws HDF5Exception {
        if (this.rank <= 0) {
            this.init();
        }
        log.trace("getMetadata: inited");
        try {
            this.linkTargetObjName = H5File.getLinkTargetName(this);
        }
        catch (Exception exception) {
            log.debug("getLinkTargetName failed: ", (Throwable)exception);
        }
        if (this.attributeList != null) {
            return this.attributeList;
        }
        int n = -1;
        int n2 = -1;
        int n3 = this.fileFormat.getIndexType(null);
        int n4 = this.fileFormat.getIndexOrder(null);
        if (nArray.length > 0) {
            n3 = nArray[0];
            if (nArray.length > 1) {
                n4 = nArray[1];
            }
        }
        log.trace("getMetadata: open dataset");
        n = this.open();
        if (n >= 0) {
            log.trace("getMetadata: dataset opened");
            try {
                this.compression = "";
                this.attributeList = H5File.getAttribute(n, n3, n4);
                log.trace("getMetadata: attributeList loaded");
                n2 = H5.H5Dget_create_plist(n);
                long l = H5.H5Dget_storage_size(n);
                int n5 = H5.H5Pget_nfilters(n2);
                if (H5.H5Pget_layout(n2) == HDF5Constants.H5D_CHUNKED) {
                    this.chunkSize = new long[this.rank];
                    H5.H5Pget_chunk(n2, this.rank, this.chunkSize);
                    if (n5 > 0) {
                        int n6;
                        long l2 = 1L;
                        long l3 = this.getDatatype().getDatatypeSize();
                        if (l3 < 0L) {
                            n6 = -1;
                            try {
                                n6 = H5.H5Dget_type(n);
                                l3 = H5.H5Tget_size(n6);
                            }
                            finally {
                                try {
                                    H5.H5Tclose(n6);
                                }
                                catch (Exception exception) {
                                    log.debug("finally close:", (Throwable)exception);
                                }
                            }
                        }
                        for (n6 = 0; n6 < this.rank; ++n6) {
                            l2 *= this.dims[n6];
                        }
                        long l4 = l2 * l3;
                        if (l != 0L) {
                            double d = (double)l4 / (double)l;
                            DecimalFormat decimalFormat = new DecimalFormat();
                            decimalFormat.setMinimumFractionDigits(3);
                            decimalFormat.setMaximumFractionDigits(3);
                            this.compression = this.compression + decimalFormat.format(d) + ":1";
                        }
                    }
                } else {
                    this.chunkSize = null;
                }
                int[] nArray2 = new int[]{0, 0};
                long[] lArray = new long[]{20L};
                int[] nArray3 = new int[(int)lArray[0]];
                String[] stringArray = new String[]{"", ""};
                log.trace("getMetadata: {} filters in pipeline", (Object)n5);
                int n7 = -1;
                int[] nArray4 = new int[]{1};
                this.filters = "";
                int n8 = 0;
                for (int i = 0; i < n5; ++i) {
                    int n9;
                    log.trace("getMetadata: filter[{}]", (Object)i);
                    if (i > 0) {
                        this.filters = this.filters + ", ";
                    }
                    if (n8 > 0) {
                        this.compression = this.compression + ", ";
                    }
                    try {
                        lArray[0] = 20L;
                        nArray3 = new int[(int)lArray[0]];
                        nArray3 = new int[(int)lArray[0]];
                        n7 = H5.H5Pget_filter(n2, i, nArray2, lArray, nArray3, 120L, stringArray, nArray4);
                        log.trace("getMetadata: filter[{}] is {} has {} elements ", new Object[]{i, stringArray[0], lArray[0]});
                        n9 = 0;
                        while ((long)n9 < lArray[0]) {
                            log.trace("getMetadata: filter[{}] element {} = {}", new Object[]{i, n9, nArray3[n9]});
                            ++n9;
                        }
                    }
                    catch (Throwable throwable) {
                        this.filters = this.filters + "ERROR";
                        continue;
                    }
                    if (n7 == HDF5Constants.H5Z_FILTER_NONE) {
                        this.filters = this.filters + "NONE";
                        continue;
                    }
                    if (n7 == HDF5Constants.H5Z_FILTER_DEFLATE) {
                        this.filters = this.filters + "GZIP";
                        this.compression = this.compression + "GZIP: level = " + nArray3[0];
                        ++n8;
                        continue;
                    }
                    if (n7 == HDF5Constants.H5Z_FILTER_FLETCHER32) {
                        this.filters = this.filters + "Error detection filter";
                        continue;
                    }
                    if (n7 == HDF5Constants.H5Z_FILTER_SHUFFLE) {
                        this.filters = this.filters + "SHUFFLE: Nbytes = " + nArray3[0];
                        continue;
                    }
                    if (n7 == HDF5Constants.H5Z_FILTER_NBIT) {
                        this.filters = this.filters + "NBIT";
                        continue;
                    }
                    if (n7 == HDF5Constants.H5Z_FILTER_SCALEOFFSET) {
                        this.filters = this.filters + "SCALEOFFSET: MIN BITS = " + nArray3[0];
                        continue;
                    }
                    if (n7 == HDF5Constants.H5Z_FILTER_SZIP) {
                        this.filters = this.filters + "SZIP";
                        this.compression = this.compression + "SZIP: Pixels per block = " + nArray3[1];
                        ++n8;
                        n9 = -1;
                        try {
                            n9 = H5.H5Zget_filter_info(n7);
                        }
                        catch (Exception exception) {
                            n9 = -1;
                        }
                        if (n9 == HDF5Constants.H5Z_FILTER_CONFIG_DECODE_ENABLED) {
                            this.compression = this.compression + ": H5Z_FILTER_CONFIG_DECODE_ENABLED";
                            continue;
                        }
                        if (n9 != HDF5Constants.H5Z_FILTER_CONFIG_ENCODE_ENABLED && n9 < HDF5Constants.H5Z_FILTER_CONFIG_ENCODE_ENABLED + HDF5Constants.H5Z_FILTER_CONFIG_DECODE_ENABLED) continue;
                        this.compression = this.compression + ": H5Z_FILTER_CONFIG_ENCODE_ENABLED";
                        continue;
                    }
                    this.filters = this.filters + "USERDEFINED " + stringArray[0] + "(" + n7 + "): ";
                    n9 = 0;
                    while ((long)n9 < lArray[0]) {
                        if (n9 > 0) {
                            this.filters = this.filters + ", ";
                        }
                        this.filters = this.filters + nArray3[n9];
                        ++n9;
                    }
                    log.debug("getMetadata: filter[{}] is user defined compression", (Object)i);
                }
                if (this.compression.length() == 0) {
                    this.compression = "NONE";
                }
                log.trace("getMetadata: filter compression={}", (Object)this.compression);
                if (this.filters.length() == 0) {
                    this.filters = "NONE";
                }
                log.trace("getMetadata: filter information={}", (Object)this.filters);
                this.storage = "" + l;
                try {
                    int[] nArray5 = new int[]{0};
                    H5.H5Pget_alloc_time(n2, nArray5);
                    this.storage = this.storage + ", allocation time: ";
                    if (nArray5[0] == HDF5Constants.H5D_ALLOC_TIME_EARLY) {
                        this.storage = this.storage + "Early";
                    } else if (nArray5[0] == HDF5Constants.H5D_ALLOC_TIME_INCR) {
                        this.storage = this.storage + "Incremental";
                    } else if (nArray5[0] == HDF5Constants.H5D_ALLOC_TIME_LATE) {
                        this.storage = this.storage + "Late";
                    }
                }
                catch (Exception exception) {
                    log.debug("Storage allocation time:", (Throwable)exception);
                }
                if (this.storage.length() == 0) {
                    this.storage = "NONE";
                }
                log.trace("getMetadata: storage={}", (Object)this.storage);
            }
            finally {
                try {
                    H5.H5Pclose(n2);
                }
                catch (Exception exception) {
                    log.debug("finally close:", (Throwable)exception);
                }
                this.close(n);
            }
        }
        log.trace("getMetadata: finish");
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        boolean bl = false;
        Attribute attribute = (Attribute)object;
        log.trace("writeMetadata: {}", (Object)attribute.getName());
        if (this.attributeList == null) {
            this.getMetadata();
        }
        if (this.attributeList != null) {
            bl = this.attributeList.contains(attribute);
        }
        this.getFileFormat().writeAttribute(this, attribute, bl);
        if (!bl) {
            this.attributeList.add(attribute);
            this.nAttributes = this.attributeList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetadata(Object object) throws HDF5Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        Attribute attribute = (Attribute)object;
        log.trace("removeMetadata: {}", (Object)attribute.getName());
        int n = this.open();
        if (n >= 0) {
            try {
                H5.H5Adelete(n, attribute.getName());
                List<Attribute> list = this.getMetadata();
                list.remove(attribute);
                this.nAttributes = list.size();
            }
            finally {
                this.close(n);
            }
        }
    }

    @Override
    public void updateMetadata(Object object) throws HDF5Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        log.trace("updateMetadata");
        this.nAttributes = -1;
    }

    @Override
    public void setName(String string) throws Exception {
        H5File.renameObject(this, string);
        super.setName(string);
    }

    private void resetSelection() {
        log.trace("resetSelection: start");
        for (int i = 0; i < this.rank; ++i) {
            this.startDims[i] = 0L;
            this.selectedDims[i] = 1L;
            if (this.selectedStride == null) continue;
            this.selectedStride[i] = 1L;
        }
        if (this.rank == 1) {
            this.selectedIndex[0] = 0;
            this.selectedDims[0] = this.dims[0];
        } else if (this.rank == 2) {
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
        } else if (this.rank > 2) {
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedIndex[2] = 2;
            this.selectedDims[this.selectedIndex[0]] = this.dims[this.selectedIndex[0]];
            this.selectedDims[this.selectedIndex[1]] = this.dims[this.selectedIndex[1]];
        }
        this.isDataLoaded = false;
        this.setMemberSelection(true);
        log.trace("resetSelection: finish");
    }

    @Deprecated
    public static Dataset create(String string, Group group, long[] lArray, String[] stringArray, Datatype[] datatypeArray, int[] nArray, Object object) throws Exception {
        if (group == null || string == null || lArray == null || stringArray == null || datatypeArray == null || nArray == null) {
            return null;
        }
        int n = stringArray.length;
        int[] nArray2 = new int[n];
        long[][] lArray2 = new long[n][1];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = 1;
            lArray2[i][0] = nArray[i];
        }
        return H5CompoundDS.create(string, group, lArray, stringArray, datatypeArray, nArray2, lArray2, object);
    }

    @Deprecated
    public static Dataset create(String string, Group group, long[] lArray, String[] stringArray, Datatype[] datatypeArray, int[] nArray, long[][] lArray2, Object object) throws Exception {
        return H5CompoundDS.create(string, group, lArray, null, null, -1, stringArray, datatypeArray, nArray, lArray2, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dataset create(String string, Group group, long[] lArray, long[] lArray2, long[] lArray3, int n, String[] stringArray, Datatype[] datatypeArray, int[] nArray, long[][] lArray4, Object object) throws Exception {
        int n2;
        int n3;
        int n4;
        H5CompoundDS h5CompoundDS = null;
        String string2 = null;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        log.trace("H5CompoundDS create start");
        if (group == null || string == null || lArray == null || n > 0 && lArray3 == null || stringArray == null || datatypeArray == null || nArray == null || lArray4 == null) {
            return null;
        }
        H5File h5File = (H5File)group.getFileFormat();
        if (h5File == null) {
            return null;
        }
        String string3 = "/";
        if (!group.isRoot()) {
            string3 = group.getPath() + group.getName() + "/";
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            if ((n4 = string.lastIndexOf("/")) >= 0) {
                string = string.substring(n4 + 1);
            }
        }
        string2 = string3 + string;
        n4 = 0;
        int n9 = stringArray.length;
        int[] nArray2 = new int[n9];
        int n10 = 1;
        for (n3 = 0; n3 < n9; ++n3) {
            n10 = 1;
            for (n2 = 0; n2 < nArray[n3]; ++n2) {
                n10 = (int)((long)n10 * lArray4[n3][n2]);
            }
            nArray2[n3] = -1;
            if (n10 > 1 && datatypeArray[n3].getDatatypeClass() != 3) {
                n2 = -1;
                n2 = datatypeArray[n3].toNative();
                if (n2 >= 0) {
                    try {
                        nArray2[n3] = H5.H5Tarray_create(n2, nArray[n3], lArray4[n3]);
                    }
                    finally {
                        try {
                            H5.H5Tclose(n2);
                        }
                        catch (Exception exception) {
                            log.debug("compound array create finally close:", (Throwable)exception);
                        }
                    }
                }
            } else {
                nArray2[n3] = datatypeArray[n3].toNative();
            }
            try {
                n4 += H5.H5Tget_size(nArray2[n3]);
                continue;
            }
            catch (Exception exception) {
                log.debug("array create H5Tget_size:", (Throwable)exception);
                while (n3 > 0) {
                    try {
                        H5.H5Tclose(nArray2[n3]);
                    }
                    catch (HDF5Exception hDF5Exception) {
                        log.debug("compound create finally close:", (Throwable)hDF5Exception);
                    }
                    --n3;
                }
                throw exception;
            }
        }
        n3 = 0;
        if (lArray2 != null) {
            for (n2 = 0; n2 < lArray2.length; ++n2) {
                if (lArray2[n2] == 0L) {
                    lArray2[n2] = lArray[n2];
                } else if (lArray2[n2] < 0L) {
                    lArray2[n2] = HDF5Constants.H5S_UNLIMITED;
                }
                if (lArray2[n2] == lArray[n2]) continue;
                n3 = 1;
            }
        }
        if (lArray3 == null && n3 != 0) {
            lArray3 = new long[lArray.length];
            for (n2 = 0; n2 < lArray.length; ++n2) {
                lArray3[n2] = Math.min(lArray[n2], 64L);
            }
        }
        n2 = lArray.length;
        try {
            int n11;
            n6 = H5.H5Screate_simple(n2, lArray, lArray2);
            n8 = HDF5Constants.H5P_DEFAULT;
            n7 = H5.H5Tcreate(HDF5Constants.H5T_COMPOUND, n4);
            int n12 = 0;
            for (n11 = 0; n11 < n9; ++n11) {
                H5.H5Tinsert(n7, stringArray[n11], n12, nArray2[n11]);
                n12 += H5.H5Tget_size(nArray2[n11]);
            }
            if (lArray3 != null) {
                n8 = H5.H5Pcreate(HDF5Constants.H5P_DATASET_CREATE);
                H5.H5Pset_layout(n8, HDF5Constants.H5D_CHUNKED);
                H5.H5Pset_chunk(n8, n2, lArray3);
                if (n > 0) {
                    H5.H5Pset_deflate(n8, n);
                }
            }
            n11 = h5File.getFID();
            log.trace("H5CompoundDS create dataset");
            n5 = H5.H5Dcreate(n11, string2, n7, n6, HDF5Constants.H5P_DEFAULT, n8, HDF5Constants.H5P_DEFAULT);
            log.trace("H5CompoundDS create H5CompoundDS");
            h5CompoundDS = new H5CompoundDS(h5File, string, string3);
        }
        finally {
            try {
                H5.H5Pclose(n8);
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("create finally close:", (Throwable)hDF5Exception);
            }
            try {
                H5.H5Sclose(n6);
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("create finally close:", (Throwable)hDF5Exception);
            }
            try {
                H5.H5Tclose(n7);
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("create finally close:", (Throwable)hDF5Exception);
            }
            try {
                H5.H5Dclose(n5);
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("create finally close:", (Throwable)hDF5Exception);
            }
            for (int i = 0; i < n9; ++i) {
                try {
                    H5.H5Tclose(nArray2[i]);
                    continue;
                }
                catch (HDF5Exception hDF5Exception) {
                    log.debug("compound create finally close:", (Throwable)hDF5Exception);
                }
            }
        }
        if (h5CompoundDS != null) {
            group.addToMemberList(h5CompoundDS);
            if (object != null) {
                h5CompoundDS.init();
                long[] lArray5 = h5CompoundDS.getSelectedDims();
                for (int i = 0; i < n2; ++i) {
                    lArray5[i] = lArray[i];
                }
                h5CompoundDS.write(object);
            }
        }
        log.trace("H5CompoundDS create finish");
        return h5CompoundDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractCompoundInfo(int n, String string, List<String> list, List<Integer> list2) {
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        String string2 = null;
        try {
            n2 = H5.H5Tget_nmembers(n);
        }
        catch (Exception exception) {
            n2 = 0;
        }
        if (n2 <= 0) {
            return;
        }
        int n5 = -1;
        for (int i = 0; i < n2; ++i) {
            try {
                n4 = H5.H5Tget_member_type(n, i);
            }
            catch (Exception exception) {
                log.debug("continue H5Tget_member_type[{}]:", (Object)i, (Object)exception);
                continue;
            }
            try {
                n5 = n4;
                n4 = H5.H5Tget_native_type(n5);
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("continue H5Tget_native_type[{}]:", (Object)i, (Object)hDF5Exception);
                continue;
            }
            finally {
                try {
                    H5.H5Tclose(n5);
                }
                catch (HDF5Exception hDF5Exception) {
                    log.debug("finally close:", (Throwable)hDF5Exception);
                }
            }
            try {
                n3 = H5.H5Tget_class(n4);
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("continue H5Tget_class[{}]:", (Object)i, (Object)hDF5Exception);
                continue;
            }
            if (list != null) {
                string2 = string + H5.H5Tget_member_name(n, i);
            }
            if (n3 == HDF5Constants.H5T_COMPOUND) {
                log.debug("continue after recursive H5T_COMPOUND[{}]:", (Object)i);
                this.extractCompoundInfo(n4, string2 + "\u0095", list, list2);
                continue;
            }
            if (n3 == HDF5Constants.H5T_ARRAY) {
                try {
                    n5 = H5.H5Tget_super(n4);
                    int n6 = H5.H5Tget_class(n5);
                    if (n6 == HDF5Constants.H5T_COMPOUND || n6 == HDF5Constants.H5T_ARRAY) {
                        log.debug("continue unsupported ARRAY of COMPOUND or ARRAY of ARRAY[{}]:", (Object)i);
                        continue;
                    }
                }
                catch (Exception exception) {
                    log.debug("continue H5T_ARRAY id or class failure[{}]:", (Object)i, (Object)exception);
                    continue;
                }
                finally {
                    try {
                        H5.H5Tclose(n5);
                    }
                    catch (Exception exception) {
                        log.debug("finally close[{}]:", (Object)i, (Object)exception);
                    }
                }
            }
            if (list != null) {
                list.add(string2);
            }
            list2.add(new Integer(n4));
        }
    }

    @Override
    public boolean isString(int n) {
        boolean bl = false;
        try {
            bl = HDF5Constants.H5T_STRING == H5.H5Tget_class(n);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    @Override
    public int getSize(int n) {
        int n2 = -1;
        try {
            n2 = H5.H5Tget_size(n);
        }
        catch (Exception exception) {
            n2 = -1;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int createCompoundFieldType(int n, String string, int[] nArray) throws HDF5Exception {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        try {
            int n7 = nArray[0];
            int n8 = nArray[1];
            log.trace("{} Member is class {} of size={} with baseType={}", new Object[]{string, n7, n8, n4});
            if (n7 == HDF5Constants.H5T_ARRAY) {
                int n9 = H5.H5Tget_array_ndims(n);
                long[] lArray = new long[n9];
                H5.H5Tget_array_dims(n, lArray);
                n4 = H5.H5Tget_super(n);
                n6 = H5.H5Tget_native_type(n4);
                n3 = H5.H5Tarray_create(n6, n9, lArray);
                log.trace("H5T_ARRAY {} Member is class {} of size={} with baseType={}", new Object[]{string, n7, n8, n4});
            }
            try {
                if (n4 < 0) {
                    if (H5Datatype.isUnsigned(n)) {
                        nArray[2] = 1;
                    }
                } else if (H5Datatype.isUnsigned(n4)) {
                    nArray[2] = 1;
                }
            }
            catch (Exception exception) {
                log.debug("baseType isUnsigned:", (Throwable)exception);
            }
            try {
                H5.H5Tclose(n4);
                n4 = -1;
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("finally close:", (Throwable)hDF5Exception);
            }
            n8 = H5.H5Tget_size(n);
            String string2 = string;
            n5 = n3 < 0 ? H5.H5Tcopy(n) : H5.H5Tcopy(n3);
            try {
                H5.H5Tclose(n3);
                n3 = -1;
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("finally close:", (Throwable)hDF5Exception);
            }
            int n10 = string.lastIndexOf("\u0095");
            while (n10 > 0) {
                string2 = string.substring(n10 + 1);
                n2 = H5.H5Tcreate(HDF5Constants.H5T_COMPOUND, n8);
                H5.H5Tinsert(n2, string2, 0L, n5);
                try {
                    H5.H5Tclose(n5);
                }
                catch (Exception exception) {
                    log.debug("close nested temp {}:", (Object)n10, (Object)exception);
                }
                n5 = n2;
                string = string.substring(0, n10);
                n10 = string.lastIndexOf("\u0095");
            }
            n2 = H5.H5Tcreate(HDF5Constants.H5T_COMPOUND, n8);
            H5.H5Tinsert(n2, string, 0L, n5);
        }
        finally {
            try {
                H5.H5Tclose(n5);
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("finally close:", (Throwable)hDF5Exception);
            }
            try {
                H5.H5Tclose(n6);
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("finally close:", (Throwable)hDF5Exception);
            }
            try {
                H5.H5Tclose(n4);
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("finally close:", (Throwable)hDF5Exception);
            }
            try {
                H5.H5Tclose(n3);
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("finally close:", (Throwable)hDF5Exception);
            }
        }
        return n2;
    }
}

