/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h4;

import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdflib.HDFChunkInfo;
import ncsa.hdf.hdflib.HDFCompInfo;
import ncsa.hdf.hdflib.HDFDeflateCompInfo;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFJPEGCompInfo;
import ncsa.hdf.hdflib.HDFLibrary;
import ncsa.hdf.hdflib.HDFNBITCompInfo;
import ncsa.hdf.hdflib.HDFSKPHUFFCompInfo;
import ncsa.hdf.hdflib.HDFSZIPCompInfo;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.object.h4.H4Datatype;
import ncsa.hdf.object.h4.H4File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H4SDS
extends ScalarDS {
    private static final long serialVersionUID = 2557157923292438696L;
    private static final Logger log = LoggerFactory.getLogger(H4SDS.class);
    public static final int DFTAG_NDG_NETCDF = 67687001;
    private List attributeList;
    private int sdid;
    private int datatypeID = -1;
    private int nAttributes = -1;

    public H4SDS(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    public H4SDS(FileFormat fileFormat, String string, String string2, long[] lArray) {
        super(fileFormat, string, string2, lArray);
        this.unsignedConverted = false;
        this.sdid = ((H4File)this.getFileFormat()).getSDAccessID();
    }

    @Override
    public boolean hasAttribute() {
        if (this.nAttributes < 0) {
            this.sdid = ((H4File)this.getFileFormat()).getSDAccessID();
            int n = this.open();
            try {
                String[] stringArray = new String[]{""};
                int[] nArray = new int[]{0, 0, 0};
                int[] nArray2 = new int[32];
                HDFLibrary.SDgetinfo(n, stringArray, nArray2, nArray);
                this.nAttributes = nArray[2];
            }
            catch (Exception exception) {
                this.nAttributes = 0;
            }
            this.close(n);
        }
        return this.nAttributes > 0;
    }

    @Override
    public byte[][] readPalette(int n) {
        return null;
    }

    @Override
    public byte[] getPaletteRefs() {
        return null;
    }

    @Override
    public Datatype getDatatype() {
        if (this.datatype == null) {
            this.datatype = new H4Datatype(this.datatypeID);
        }
        return this.datatype;
    }

    @Override
    public Dataset copy(Group group, String string, long[] lArray, Object object) throws Exception {
        int n;
        H4SDS h4SDS = null;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = 1;
        int n6 = 2;
        String string2 = null;
        int[] nArray = null;
        int[] nArray2 = null;
        if (group == null) {
            return null;
        }
        if (string == null) {
            string = this.getName();
        }
        string2 = group.isRoot() ? "/" : group.getPath() + group.getName() + "/";
        log.trace("copy(): start with path={}", (Object)string2);
        n2 = this.open();
        if (n2 < 0) {
            return null;
        }
        if (lArray == null) {
            n6 = this.getRank();
            if (n6 <= 0) {
                this.init();
            }
            n6 = this.getRank();
            lArray = this.getDims();
        } else {
            n6 = lArray.length;
        }
        nArray2 = new int[n6];
        nArray = new int[n6];
        for (n = 0; n < n6; ++n) {
            nArray2[n] = 0;
            nArray[n] = (int)lArray[n];
            n5 *= nArray[n];
        }
        log.trace("copy(): theRank={} with size={}", (Object)n6, (Object)n5);
        n4 = this.datatypeID;
        n3 = HDFLibrary.SDcreate(((H4File)group.getFileFormat()).getSDAccessID(), string, n4, n6, nArray);
        if (n3 < 0) {
            return null;
        }
        n = HDFLibrary.SDidtoref(n3);
        if (!group.isRoot()) {
            int n7 = group.open();
            HDFLibrary.Vaddtagref(n7, 720, n);
            group.close(n7);
        }
        this.copyAttribute(n2, n3);
        log.trace("copy(): read data from the source dataset");
        if (object == null) {
            object = new byte[n5 * HDFLibrary.DFKNTsize(n4)];
            HDFLibrary.SDreaddata(n2, nArray2, null, nArray, object);
        }
        log.trace("copy(): write the data into the destination dataset");
        HDFLibrary.SDwritedata(n3, nArray2, null, nArray, object);
        long[] lArray2 = new long[]{720L, n};
        h4SDS = new H4SDS(group.getFileFormat(), string, string2, lArray2);
        group.addToMemberList(h4SDS);
        this.close(n2);
        try {
            HDFLibrary.SDendaccess(n3);
        }
        catch (HDFException hDFException) {
            log.debug("copy.SDendaccess:", (Throwable)hDFException);
        }
        log.trace("copy(): finish");
        return h4SDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readBytes() throws HDFException {
        int n;
        int n2;
        byte[] byArray = null;
        log.trace("readBytes(): start");
        if (this.rank <= 0) {
            this.init();
        }
        if ((n2 = this.open()) < 0) {
            return null;
        }
        int n3 = 1;
        int[] nArray = new int[this.rank];
        int[] nArray2 = new int[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            n3 *= (int)this.selectedDims[i];
            nArray[i] = (int)this.selectedDims[i];
            nArray2[i] = (int)this.startDims[i];
        }
        int[] nArray3 = null;
        if (this.selectedStride != null) {
            nArray3 = new int[this.rank];
            for (n = 0; n < this.rank; ++n) {
                nArray3[n] = (int)this.selectedStride[n];
            }
        }
        try {
            n = HDFLibrary.DFKNTsize(this.datatypeID) * n3;
            byArray = new byte[n];
            HDFLibrary.SDreaddata(n2, nArray2, nArray3, nArray, byArray);
        }
        finally {
            this.close(n2);
        }
        log.trace("readBytes(): finish");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read() throws HDFException {
        int n;
        int n2;
        String[] stringArray = null;
        log.trace("read(): start");
        if (this.rank <= 0) {
            this.init();
        }
        if ((n2 = this.open()) < 0) {
            return null;
        }
        int n3 = 1;
        int[] nArray = new int[this.rank];
        int[] nArray2 = new int[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            n3 *= (int)this.selectedDims[i];
            nArray[i] = (int)this.selectedDims[i];
            nArray2[i] = (int)this.startDims[i];
        }
        int[] nArray3 = null;
        if (this.selectedStride != null) {
            nArray3 = new int[this.rank];
            for (n = 0; n < this.rank; ++n) {
                nArray3[n] = (int)this.selectedStride[n];
            }
        }
        try {
            stringArray = H4Datatype.allocateArray(this.datatypeID, n3);
            if (stringArray != null) {
                HDFLibrary.HXsetdir(this.getFileFormat().getParent());
                n = HDFLibrary.SDreaddata(n2, nArray2, nArray3, nArray, stringArray) ? 1 : 0;
                if (this.isText) {
                    stringArray = H4SDS.byteToString((byte[])stringArray, nArray[0]);
                }
            }
        }
        finally {
            this.close(n2);
        }
        if (this.fillValue == null && this.isImageDisplay) {
            try {
                this.getMetadata();
            }
            catch (Exception exception) {
                log.debug("read.getMetadata():", (Throwable)exception);
            }
        }
        this.isDefaultImageOrder = this.rank <= 1 || this.selectedIndex[0] <= this.selectedIndex[1];
        log.trace("read(): finish");
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Object object) throws HDFException {
        if (object == null) {
            return;
        }
        log.trace("write(): start");
        int n = this.open();
        if (n < 0) {
            return;
        }
        int[] nArray = new int[this.rank];
        int[] nArray2 = new int[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            nArray[i] = (int)this.selectedDims[i];
            nArray2[i] = (int)this.startDims[i];
        }
        int[] nArray3 = null;
        if (this.selectedStride != null) {
            nArray3 = new int[this.rank];
            for (int i = 0; i < this.rank; ++i) {
                nArray3[i] = (int)this.selectedStride[i];
            }
        }
        Object object2 = object;
        try {
            if (this.isUnsigned && this.unsignedConverted) {
                object2 = H4SDS.convertToUnsignedC(object);
            }
            HDFLibrary.HXsetdir(this.getFileFormat().getParent());
            HDFLibrary.SDwritedata(n, nArray2, nArray3, nArray, object2);
        }
        finally {
            object2 = null;
            this.close(n);
        }
        log.trace("write(): finish");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getMetadata() throws HDFException {
        if (this.attributeList != null) {
            return this.attributeList;
        }
        int n = this.open();
        String[] stringArray = new String[]{""};
        int[] nArray = new int[]{0, 0, 0};
        try {
            int[] nArray2 = new int[32];
            HDFLibrary.SDgetinfo(n, stringArray, nArray2, nArray);
            int n2 = nArray[2];
            if (this.attributeList == null && n2 > 0) {
                this.attributeList = new Vector(n2, 5);
            }
            boolean bl = false;
            String[] stringArray2 = new String[1];
            int[] nArray3 = new int[]{0, 0};
            for (int i = 0; i < n2; ++i) {
                stringArray2[0] = "";
                try {
                    bl = HDFLibrary.SDattrinfo(n, i, stringArray2, nArray3);
                    nArray3[0] = nArray3[0] & 0xFFFFBFFF;
                }
                catch (HDFException hDFException) {
                    bl = false;
                }
                if (!bl) continue;
                long[] lArray = new long[]{nArray3[1]};
                Attribute attribute = new Attribute(stringArray2[0], new H4Datatype(nArray3[0]), lArray);
                this.attributeList.add(attribute);
                String[] stringArray3 = H4Datatype.allocateArray(nArray3[0], nArray3[1]);
                try {
                    HDFLibrary.SDreadattr(n, i, stringArray3);
                }
                catch (HDFException hDFException) {
                    stringArray3 = null;
                }
                if (stringArray3 == null) continue;
                if (nArray3[0] == 4 || nArray3[0] == 3) {
                    stringArray3 = Dataset.byteToString((byte[])stringArray3, nArray3[1]);
                } else if (stringArray2[0].equalsIgnoreCase("fillValue") || stringArray2[0].equalsIgnoreCase("_fillValue")) {
                    this.fillValue = stringArray3;
                }
                attribute.setValue(stringArray3);
            }
        }
        finally {
            this.close(n);
        }
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        this.getFileFormat().writeAttribute(this, (Attribute)object, true);
        if (this.attributeList == null) {
            this.attributeList = new Vector();
        }
        this.attributeList.add(object);
        this.nAttributes = this.attributeList.size();
    }

    @Override
    public void removeMetadata(Object object) throws HDFException {
    }

    @Override
    public void updateMetadata(Object object) throws Exception {
        log.trace("updateMetadata(): disabled");
    }

    @Override
    public int open() {
        int n = -1;
        try {
            int n2 = 0;
            int n3 = (int)this.oid[0];
            n2 = n3 == 67687001 ? (int)this.oid[1] : HDFLibrary.SDreftoindex(this.sdid, (int)this.oid[1]);
            n = HDFLibrary.SDselect(this.sdid, n2);
        }
        catch (HDFException hDFException) {
            n = -1;
        }
        return n;
    }

    @Override
    public void close(int n) {
        try {
            HDFLibrary.SDendaccess(n);
        }
        catch (HDFException hDFException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.rank > 0) {
            return;
        }
        log.trace("init(): start");
        int n = this.open();
        String[] stringArray = new String[]{""};
        String[] stringArray2 = new String[]{""};
        int[] nArray = new int[]{0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0};
        boolean bl = false;
        int[] nArray3 = new int[32];
        try {
            Object object;
            int n2;
            HDFLibrary.SDgetinfo(n, stringArray, nArray3, nArray2);
            nArray2[1] = nArray2[1] & 0xFFFFBFFF;
            this.nAttributes = nArray2[2];
            this.rank = nArray2[0];
            if (this.rank <= 0) {
                this.rank = 1;
                nArray3[0] = 1;
            }
            bl = HDFLibrary.SDisrecord(n);
            this.datatypeID = nArray2[1];
            this.isText = this.datatypeID == 4 || this.datatypeID == 3;
            try {
                this.dimNames = new String[this.rank];
                for (int i = 0; i < this.rank; ++i) {
                    n2 = HDFLibrary.SDgetdimid(n, i);
                    HDFLibrary.SDdiminfo(n2, stringArray2, nArray);
                    this.dimNames[i] = stringArray2[0];
                }
            }
            catch (Exception exception) {
                log.debug("get the dimension names:", (Throwable)exception);
            }
            try {
                HDFCompInfo hDFCompInfo;
                object = new HDFCompInfo();
                n2 = HDFLibrary.SDgetcompress(n, (HDFCompInfo)object) ? 1 : 0;
                if (((HDFCompInfo)object).ctype == 4) {
                    hDFCompInfo = new HDFDeflateCompInfo();
                    HDFLibrary.SDgetcompress(n, hDFCompInfo);
                    this.compression = "GZIP(level=" + hDFCompInfo.level + ")";
                } else if (((HDFCompInfo)object).ctype == 5) {
                    hDFCompInfo = new HDFSZIPCompInfo();
                    HDFLibrary.SDgetcompress(n, hDFCompInfo);
                    this.compression = "SZIP(bits_per_pixel=" + ((HDFSZIPCompInfo)hDFCompInfo).bits_per_pixel + ",options_mask=" + ((HDFSZIPCompInfo)hDFCompInfo).options_mask + ",pixels=" + ((HDFSZIPCompInfo)hDFCompInfo).pixels + ",pixels_per_block=" + ((HDFSZIPCompInfo)hDFCompInfo).pixels_per_block + ",pixels_per_scanline=" + ((HDFSZIPCompInfo)hDFCompInfo).pixels_per_scanline + ")";
                } else if (((HDFCompInfo)object).ctype == 7) {
                    hDFCompInfo = new HDFJPEGCompInfo();
                    HDFLibrary.SDgetcompress(n, hDFCompInfo);
                    this.compression = "JPEG(quality=" + ((HDFJPEGCompInfo)hDFCompInfo).quality + ",options_mask=" + ",force_baseline=" + ((HDFJPEGCompInfo)hDFCompInfo).force_baseline + ")";
                } else if (((HDFCompInfo)object).ctype == 3) {
                    hDFCompInfo = new HDFSKPHUFFCompInfo();
                    HDFLibrary.SDgetcompress(n, hDFCompInfo);
                    this.compression = "SKPHUFF(skp_size=" + ((HDFSKPHUFFCompInfo)hDFCompInfo).skp_size + ")";
                } else if (((HDFCompInfo)object).ctype == 1) {
                    this.compression = "RLE";
                } else if (((HDFCompInfo)object).ctype == 2) {
                    hDFCompInfo = new HDFNBITCompInfo();
                    HDFLibrary.SDgetcompress(n, hDFCompInfo);
                    this.compression = "NBIT(nt=" + ((HDFNBITCompInfo)hDFCompInfo).nt + ",bit_len=" + ((HDFNBITCompInfo)hDFCompInfo).bit_len + ",ctype=" + ((HDFNBITCompInfo)hDFCompInfo).ctype + ",fill_one=" + ((HDFNBITCompInfo)hDFCompInfo).fill_one + ",sign_ext=" + ((HDFNBITCompInfo)hDFCompInfo).sign_ext + ",start_bit=" + ((HDFNBITCompInfo)hDFCompInfo).start_bit + ")";
                }
            }
            catch (Exception exception) {
                log.debug("get compression information:", (Throwable)exception);
            }
            try {
                object = new HDFChunkInfo();
                int[] nArray4 = new int[]{0};
                try {
                    boolean bl2 = HDFLibrary.SDgetchunkinfo(n, (HDFChunkInfo)object, nArray4);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                if (nArray4[0] == 0) {
                    this.chunkSize = null;
                } else {
                    this.chunkSize = new long[this.rank];
                    for (int i = 0; i < this.rank; ++i) {
                        this.chunkSize[i] = ((HDFChunkInfo)object).chunk_lengths[i];
                    }
                }
            }
            catch (Exception exception) {
                log.debug("get chunk information:", (Throwable)exception);
            }
        }
        catch (HDFException hDFException) {
            log.debug("init():", (Throwable)hDFException);
        }
        finally {
            this.close(n);
        }
        this.isUnsigned = H4Datatype.isUnsigned(this.datatypeID);
        if (nArray3 == null) {
            return;
        }
        this.dims = new long[this.rank];
        this.maxDims = new long[this.rank];
        this.startDims = new long[this.rank];
        this.selectedDims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.startDims[i] = 0L;
            this.selectedDims[i] = 1L;
            this.dims[i] = this.maxDims[i] = (long)nArray3[i];
        }
        if (bl) {
            this.maxDims[0] = -1L;
        }
        this.selectedIndex[0] = 0;
        this.selectedIndex[1] = 1;
        this.selectedIndex[2] = 2;
        if (this.rank == 1) {
            this.selectedDims[0] = this.dims[0];
        }
        if (this.rank > 1) {
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.isText ? 1L : this.dims[1];
        }
        log.trace("init(): finish");
    }

    @Override
    public byte[][] getPalette() {
        return this.palette;
    }

    public static H4SDS create(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, Object object, Object object2) throws Exception {
        int n2;
        Object object3;
        int n3;
        H4SDS h4SDS = null;
        if (group == null || string == null || lArray == null) {
            return null;
        }
        log.trace("create(): start");
        H4File h4File = (H4File)group.getFileFormat();
        if (h4File == null) {
            return null;
        }
        String string2 = "/";
        if (!group.isRoot()) {
            string2 = group.getPath() + group.getName() + "/";
        }
        int n4 = 1;
        int n5 = lArray.length;
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        for (int i = 0; i < n5; ++i) {
            nArray[i] = (int)lArray[i];
            nArray2[i] = 0;
            n4 *= nArray[i];
        }
        if (lArray2 != null && lArray2[0] <= 0L) {
            nArray[0] = 0;
        }
        int[] nArray3 = null;
        if (lArray3 != null) {
            nArray3 = new int[n5];
            for (n3 = 0; n3 < n5; ++n3) {
                nArray3[n3] = (int)lArray3[n3];
            }
        }
        if (nArray[0] == 0 && (nArray3 != null || n > 0)) {
            throw new HDFException("Unlimted cannot be used with chunking or compression");
        }
        n3 = h4File.getSDAccessID();
        int n6 = -1;
        int n7 = -1;
        int n8 = datatype.toNative();
        if (n8 >= 0) {
            n6 = HDFLibrary.SDcreate(n3, string, n8, n5, nArray);
            int n9 = HDFLibrary.DFKNTsize(n8);
            object3 = new byte[n9];
            for (n2 = 0; n2 < n9; ++n2) {
                object3[n2] = false;
            }
            HDFLibrary.SDsetfillvalue(n6, (byte[])object3);
        }
        if (n6 < 0) {
            throw new HDFException("Unable to create the new dataset.");
        }
        HDFDeflateCompInfo hDFDeflateCompInfo = null;
        if (n > 0) {
            hDFDeflateCompInfo = new HDFDeflateCompInfo();
            hDFDeflateCompInfo.level = n;
            if (lArray3 == null) {
                HDFLibrary.SDsetcompress(n6, 4, hDFDeflateCompInfo);
            }
        }
        if (lArray3 != null) {
            object3 = new HDFChunkInfo(nArray3);
            n2 = 1;
            if (n > 0) {
                n2 = 3;
                object3 = new HDFChunkInfo(nArray3, 4, hDFDeflateCompInfo);
            }
            try {
                HDFLibrary.SDsetchunk(n6, (HDFChunkInfo)object3, n2);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new HDFException("SDsetchunk failed.");
            }
        }
        if (n6 > 0 && object2 != null) {
            HDFLibrary.SDwritedata(n6, nArray2, null, nArray, object2);
        }
        int n10 = HDFLibrary.SDidtoref(n6);
        if (!group.isRoot()) {
            n7 = group.open();
            if (n7 < 0) {
                if (n6 > 0) {
                    HDFLibrary.SDendaccess(n6);
                }
                throw new HDFException("Unable to open the parent group.");
            }
            HDFLibrary.Vaddtagref(n7, 720, n10);
            group.close(n7);
        }
        try {
            if (n6 > 0) {
                HDFLibrary.SDendaccess(n6);
            }
        }
        catch (Exception exception) {
            log.debug("create.SDendaccess:", (Throwable)exception);
        }
        long[] lArray4 = new long[]{720L, n10};
        h4SDS = new H4SDS(h4File, string, string2, lArray4);
        if (h4SDS != null) {
            group.addToMemberList(h4SDS);
        }
        log.trace("create(): finish");
        return h4SDS;
    }

    public static H4SDS create(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, Object object) throws Exception {
        return H4SDS.create(string, group, datatype, lArray, lArray2, lArray3, n, null, object);
    }

    private void copyAttribute(int n, int n2) {
        try {
            String[] stringArray = new String[]{""};
            int[] nArray = new int[]{0, 0, 0};
            int[] nArray2 = new int[32];
            HDFLibrary.SDgetinfo(n, stringArray, nArray2, nArray);
            int n3 = nArray[2];
            log.trace("copyAttribute(): numberOfAttributes={}", (Object)n3);
            boolean bl = false;
            String[] stringArray2 = new String[1];
            int[] nArray3 = new int[]{0, 0};
            for (int i = 0; i < n3; ++i) {
                stringArray2[0] = "";
                try {
                    bl = HDFLibrary.SDattrinfo(n, i, stringArray2, nArray3);
                }
                catch (HDFException hDFException) {
                    bl = false;
                }
                if (!bl) continue;
                byte[] byArray = new byte[nArray3[1] * HDFLibrary.DFKNTsize(nArray3[0])];
                try {
                    HDFLibrary.SDreadattr(n, i, byArray);
                }
                catch (HDFException hDFException) {
                    byArray = null;
                }
                if (byArray == null) continue;
                HDFLibrary.SDsetattr(n2, stringArray2[0], nArray3[0], nArray3[1], byArray);
            }
        }
        catch (Exception exception) {
            log.debug("copyAttribute:", (Throwable)exception);
        }
        log.trace("copyAttribute(): finish");
    }

    public List getMetadata(int ... nArray) throws Exception {
        throw new UnsupportedOperationException("getMetadata(int... attrPropList) is not supported");
    }
}

