/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object;

import java.lang.reflect.Array;
import java.util.Vector;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Dataset
extends HObject {
    private static final long serialVersionUID = -3360885430038261178L;
    private static final Logger log = LoggerFactory.getLogger(Dataset.class);
    protected Object data = null;
    protected int rank = 0;
    protected long[] dims = null;
    protected long[] maxDims = null;
    protected long[] selectedDims = null;
    protected long[] startDims = null;
    protected final int[] selectedIndex = new int[3];
    protected long[] selectedStride = null;
    protected long[] chunkSize = null;
    protected String compression = "NONE";
    public static final String compression_gzip_txt = "GZIP: level = ";
    protected String filters = "NONE";
    protected String storage = "NONE";
    protected Datatype datatype;
    protected String[] dimNames = null;
    protected boolean convertByteToString = true;
    protected boolean isDataLoaded = false;
    protected long nPoints = 1L;
    protected Object originalBuf = null;
    protected Object convertedBuf = null;
    protected boolean enumConverted = false;

    public Dataset(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    @Deprecated
    public Dataset(FileFormat fileFormat, String string, String string2, long[] lArray) {
        super(fileFormat, string, string2, lArray);
        this.selectedIndex[0] = 0;
        this.selectedIndex[1] = 1;
        this.selectedIndex[2] = 2;
    }

    public void clear() {
        if (this.data != null) {
            if (this.data instanceof Vector) {
                ((Vector)this.data).setSize(0);
            }
            this.data = null;
            this.originalBuf = null;
            this.convertedBuf = null;
        }
        this.isDataLoaded = false;
    }

    public abstract void init();

    public final int getRank() {
        if (this.rank < 0) {
            this.init();
        }
        return this.rank;
    }

    public final long[] getDims() {
        if (this.rank < 0) {
            this.init();
        }
        return this.dims;
    }

    public final long[] getMaxDims() {
        if (this.rank < 0) {
            this.init();
        }
        if (this.maxDims == null) {
            return this.dims;
        }
        return this.maxDims;
    }

    public final long[] getSelectedDims() {
        if (this.rank < 0) {
            this.init();
        }
        return this.selectedDims;
    }

    public final long[] getStartDims() {
        if (this.rank < 0) {
            this.init();
        }
        return this.startDims;
    }

    public final long[] getStride() {
        if (this.rank < 0) {
            this.init();
        }
        if (this.rank <= 0) {
            return null;
        }
        if (this.selectedStride == null) {
            this.selectedStride = new long[this.rank];
            for (int i = 0; i < this.rank; ++i) {
                this.selectedStride[i] = 1L;
            }
        }
        return this.selectedStride;
    }

    public final void setConvertByteToString(boolean bl) {
        this.convertByteToString = bl;
    }

    public final boolean getConvertByteToString() {
        return this.convertByteToString;
    }

    public abstract Object read() throws Exception, OutOfMemoryError;

    public abstract byte[] readBytes() throws Exception;

    public abstract void write(Object var1) throws Exception;

    public final void write() throws Exception {
        if (this.data != null) {
            this.write(this.data);
        }
    }

    public abstract Dataset copy(Group var1, String var2, long[] var3, Object var4) throws Exception;

    public abstract Datatype getDatatype();

    public final Object getData() throws Exception, OutOfMemoryError {
        if (!this.isDataLoaded) {
            log.trace("getData: read");
            this.originalBuf = this.data = this.read();
            this.isDataLoaded = true;
            this.nPoints = 1L;
            for (int i = 0; i < this.selectedDims.length; ++i) {
                this.nPoints *= this.selectedDims[i];
            }
            log.trace("getData: read {}", (Object)this.nPoints);
        }
        return this.data;
    }

    @Deprecated
    public final void setData(Object object) {
        this.data = object;
    }

    public void clearData() {
        this.isDataLoaded = false;
    }

    public final int getHeight() {
        if (this.rank < 0) {
            this.init();
        }
        if (this.selectedDims == null || this.selectedIndex == null) {
            return 0;
        }
        return (int)this.selectedDims[this.selectedIndex[0]];
    }

    public final int getWidth() {
        if (this.rank < 0) {
            this.init();
        }
        if (this.selectedDims == null || this.selectedIndex == null) {
            return 0;
        }
        if (this.selectedDims.length < 2 || this.selectedIndex.length < 2) {
            return 1;
        }
        return (int)this.selectedDims[this.selectedIndex[1]];
    }

    public final int[] getSelectedIndex() {
        if (this.rank < 0) {
            this.init();
        }
        return this.selectedIndex;
    }

    public final String getCompression() {
        if (this.rank < 0) {
            this.init();
        }
        return this.compression;
    }

    public final String getFilters() {
        if (this.rank < 0) {
            this.init();
        }
        return this.filters;
    }

    public final String getStorage() {
        if (this.rank < 0) {
            this.init();
        }
        return this.storage;
    }

    public final long[] getChunkSize() {
        if (this.rank < 0) {
            this.init();
        }
        return this.chunkSize;
    }

    @Deprecated
    public static Object convertFromUnsignedC(Object object) {
        return Dataset.convertFromUnsignedC(object, null);
    }

    public static Object convertFromUnsignedC(Object object, Object object2) {
        Object object3;
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            return null;
        }
        if (!(object2 == null || ((Class)(object3 = object2.getClass())).isArray() && Array.getLength(object) == Array.getLength(object2))) {
            object2 = null;
        }
        object3 = clazz.getName();
        char c = ((String)object3).charAt(((String)object3).lastIndexOf("[") + 1);
        int n = Array.getLength(object);
        log.trace("convertFromUnsignedC: cname={} dname={} size={}", new Object[]{object3, Character.valueOf(c), n});
        if (c == 'B') {
            short[] sArray = null;
            sArray = object2 == null ? new short[n] : (short[])object2;
            byte[] byArray = (byte[])object;
            for (int i = 0; i < n; ++i) {
                sArray[i] = (short)(byArray[i] + 256 & 0xFF);
            }
            object2 = sArray;
        } else if (c == 'S') {
            int[] nArray = null;
            nArray = object2 == null ? new int[n] : (int[])object2;
            short[] sArray = (short[])object;
            for (int i = 0; i < n; ++i) {
                nArray[i] = sArray[i] + 65536 & 0xFFFF;
            }
            object2 = nArray;
        } else if (c == 'I') {
            long[] lArray = null;
            lArray = object2 == null ? new long[n] : (long[])object2;
            int[] nArray = (int[])object;
            for (int i = 0; i < n; ++i) {
                lArray[i] = (long)nArray[i] + 0x100000000L & 0xFFFFFFFFL;
            }
            object2 = lArray;
        } else {
            object2 = object;
            log.debug("convertFromUnsignedC: Java does not support unsigned long");
        }
        return object2;
    }

    @Deprecated
    public static Object convertToUnsignedC(Object object) {
        return Dataset.convertToUnsignedC(object, null);
    }

    public static Object convertToUnsignedC(Object object, Object object2) {
        Object object3;
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            return null;
        }
        if (!(object2 == null || ((Class)(object3 = object2.getClass())).isArray() && Array.getLength(object) == Array.getLength(object2))) {
            object2 = null;
        }
        object3 = clazz.getName();
        char c = ((String)object3).charAt(((String)object3).lastIndexOf("[") + 1);
        int n = Array.getLength(object);
        log.trace("convertToUnsignedC: cname={} dname={} size={}", new Object[]{object3, Character.valueOf(c), n});
        if (c == 'S') {
            byte[] byArray = null;
            byArray = object2 == null ? new byte[n] : (byte[])object2;
            short[] sArray = (short[])object;
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)sArray[i];
            }
            object2 = byArray;
        } else if (c == 'I') {
            short[] sArray = null;
            sArray = object2 == null ? new short[n] : (short[])object2;
            int[] nArray = (int[])object;
            for (int i = 0; i < n; ++i) {
                sArray[i] = (short)nArray[i];
            }
            object2 = sArray;
        } else if (c == 'J') {
            int[] nArray = null;
            nArray = object2 == null ? new int[n] : (int[])object2;
            long[] lArray = (long[])object;
            for (int i = 0; i < n; ++i) {
                nArray[i] = (int)lArray[i];
            }
            object2 = nArray;
        } else {
            object2 = object;
            log.debug("convertToUnsignedC: Java does not support unsigned long");
        }
        return object2;
    }

    public static final String[] byteToString(byte[] byArray, int n) {
        if (byArray == null) {
            return null;
        }
        int n2 = byArray.length / n;
        log.trace("byteToString: n={} from length of {}", (Object)n2, (Object)n);
        String[] stringArray = new String[n2];
        String string = null;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4;
            string = new String(byArray, i * n, n);
            n3 = string.indexOf(0);
            if (n3 > 0) {
                string = string.substring(0, n3);
            }
            for (n4 = string.length(); n4 > 0 && string.charAt(n4 - 1) <= ' '; --n4) {
            }
            stringArray[i] = n4 <= 0 ? "" : string.substring(0, n4);
        }
        return stringArray;
    }

    public static final byte[] stringToByte(String[] stringArray, int n) {
        if (stringArray == null) {
            return null;
        }
        int n2 = stringArray.length;
        byte[] byArray = new byte[n2 * n];
        log.trace("stringToByte: size={} length={}", (Object)n2, (Object)n);
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n2; ++i) {
            stringBuffer.replace(0, n, " ");
            if (stringArray[i] != null) {
                if (stringArray[i].length() > n) {
                    stringArray[i] = stringArray[i].substring(0, n);
                }
                stringBuffer.replace(0, n, stringArray[i]);
            }
            stringBuffer.setLength(n);
            System.arraycopy(stringBuffer.toString().getBytes(), 0, byArray, n * i, n);
        }
        return byArray;
    }

    public final String[] getDimNames() {
        if (this.rank < 0) {
            this.init();
        }
        return this.dimNames;
    }

    public boolean isString(int n) {
        return false;
    }

    public int getSize(int n) {
        return -1;
    }

    public boolean isEnumConverted() {
        return this.enumConverted;
    }

    public void setEnumConverted(boolean bl) {
        if (this.enumConverted != bl) {
            this.convertedBuf = null;
            this.originalBuf = null;
            this.clearData();
        }
        this.enumConverted = bl;
    }

    public final Class getOriginalClass() {
        return this.originalBuf.getClass();
    }
}

