/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object;

import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Attribute
implements Metadata {
    private static final long serialVersionUID = 2072473407027648309L;
    private static final Logger log = LoggerFactory.getLogger(Attribute.class);
    private final String name;
    private final Datatype type;
    private int rank;
    private long[] dims;
    private Object value;
    private Map<String, Object> properties;
    private boolean isUnsigned;
    protected boolean isScalar = false;

    public Attribute(String string, Datatype datatype, long[] lArray) {
        this(string, datatype, lArray, null);
    }

    public Attribute(String string, Datatype datatype, long[] lArray, Object object) {
        this.name = string;
        this.type = datatype;
        this.dims = lArray;
        this.value = null;
        this.properties = new HashMap<String, Object>();
        this.rank = 0;
        log.trace("Attribute: {}, attrValue={}", (Object)string, object);
        if (this.dims != null) {
            this.rank = this.dims.length;
        } else {
            this.isScalar = true;
            this.rank = 1;
            this.dims = new long[]{1L};
        }
        if (object != null) {
            this.value = object;
        }
        this.isUnsigned = this.type.getDatatypeSign() == 0;
        log.trace("Attribute: finish");
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public Collection<String> getPropertyKeys() {
        return this.properties.keySet();
    }

    @Override
    public void setValue(Object object) {
        this.value = object;
    }

    public String getName() {
        return this.name;
    }

    public int getRank() {
        return this.rank;
    }

    public long[] getDataDims() {
        return this.dims;
    }

    public Datatype getType() {
        return this.type;
    }

    public boolean isScalar() {
        return this.isScalar;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public String toString() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public String toString(String string) {
        StringBuffer stringBuffer;
        block48: {
            int n;
            block49: {
                String[] stringArray;
                boolean bl;
                Class<?> clazz;
                block47: {
                    if (this.value == null) {
                        return null;
                    }
                    log.trace("toString: start");
                    clazz = this.value.getClass();
                    if (!clazz.isArray()) {
                        return this.value.toString();
                    }
                    stringBuffer = new StringBuffer();
                    n = Array.getLength(this.value);
                    boolean bl2 = this.getType().getDatatypeSign() == 0;
                    bl = this.getType().getDatatypeClass() == 8;
                    log.trace("toString: is_enum={} is_unsigned={} Array.getLength={}", new Object[]{bl, bl2, n});
                    if (!bl2) break block47;
                    String string2 = clazz.getName();
                    char c = string2.charAt(string2.lastIndexOf("[") + 1);
                    log.trace("toString: is_unsigned with cname={} dname={}", (Object)string2, (Object)Character.valueOf(c));
                    switch (c) {
                        case 'B': {
                            byte[] byArray = (byte[])this.value;
                            short s = byArray[0];
                            if (s < 0) {
                                s = (short)(s + 256);
                            }
                            stringBuffer.append(s);
                            for (int i = 1; i < n; ++i) {
                                stringBuffer.append(string);
                                s = byArray[i];
                                if (s < 0) {
                                    s = (short)(s + 256);
                                }
                                stringBuffer.append(s);
                            }
                            break block48;
                        }
                        case 'S': {
                            int object;
                            short[] sArray = (short[])this.value;
                            short n2 = sArray[0];
                            if (n2 < 0) {
                                object = n2 + 65536;
                            }
                            stringBuffer.append(object);
                            for (int i = 1; i < n; ++i) {
                                stringBuffer.append(string);
                                int n3 = sArray[i];
                                if (n3 < 0) {
                                    n3 += 65536;
                                }
                                stringBuffer.append(n3);
                            }
                            break block48;
                        }
                        case 'I': {
                            int[] nArray = (int[])this.value;
                            long l = nArray[0];
                            if (l < 0L) {
                                l += 0x100000000L;
                            }
                            stringBuffer.append(l);
                            for (int i = 1; i < n; ++i) {
                                stringBuffer.append(string);
                                l = nArray[i];
                                if (l < 0L) {
                                    l += 0x100000000L;
                                }
                                stringBuffer.append(l);
                            }
                            break block48;
                        }
                        case 'J': {
                            BigInteger bigInteger;
                            BigInteger bigInteger2;
                            long[] lArray = (long[])this.value;
                            Long l = lArray[0];
                            String string3 = Long.toString(l);
                            if (l < 0L) {
                                l = l << 1 >>> 1;
                                BigInteger bigInteger3 = new BigInteger("9223372036854775808");
                                bigInteger2 = new BigInteger(l.toString());
                                bigInteger = bigInteger3.add(bigInteger2);
                                string3 = bigInteger.toString();
                            }
                            stringBuffer.append(string3);
                            for (int i = 1; i < n; ++i) {
                                stringBuffer.append(string);
                                l = lArray[i];
                                string3 = Long.toString(l);
                                if (l < 0L) {
                                    l = l << 1 >>> 1;
                                    bigInteger2 = new BigInteger("9223372036854775808");
                                    bigInteger = new BigInteger(l.toString());
                                    BigInteger bigInteger4 = bigInteger2.add(bigInteger);
                                    string3 = bigInteger4.toString();
                                }
                                stringBuffer.append(string3);
                            }
                            break block48;
                        }
                        default: {
                            stringBuffer.append(Array.get(this.value, 0));
                            for (int i = 1; i < n; ++i) {
                                stringBuffer.append(string);
                                stringBuffer.append(Array.get(this.value, i));
                            }
                            break block48;
                        }
                    }
                }
                if (!bl) break block49;
                String string4 = clazz.getName();
                char c = string4.charAt(string4.lastIndexOf("[") + 1);
                log.trace("toString: is_enum with cname={} dname={}", (Object)string4, (Object)Character.valueOf(c));
                String string5 = this.getType().getEnumMembers();
                log.trace("toString: is_enum enum_members={}", (Object)string5);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (String string6 : stringArray = string5.split(",")) {
                    String[] stringArray2 = string6.split("=");
                    hashMap.put(stringArray2[1], stringArray2[0]);
                    log.trace("toString: is_enum value={} name={}", (Object)stringArray2[1], (Object)stringArray2[0]);
                }
                Object var12_23 = null;
                switch (c) {
                    case 'B': {
                        void var15_64;
                        byte[] byArray = (byte[])this.value;
                        int n4 = byArray[0];
                        String string7 = String.valueOf(n4);
                        if (hashMap.containsKey(string7)) {
                            stringBuffer.append((String)hashMap.get(string7));
                        } else {
                            stringBuffer.append(n4);
                        }
                        boolean bl2 = true;
                        while (var15_64 < n) {
                            stringBuffer.append(string);
                            n4 = byArray[var15_64];
                            String string8 = String.valueOf(n4);
                            if (hashMap.containsKey(string8)) {
                                stringBuffer.append((String)hashMap.get(string8));
                            } else {
                                stringBuffer.append(n4);
                            }
                            ++var15_64;
                        }
                        break block48;
                    }
                    case 'S': {
                        short[] sArray = (short[])this.value;
                        short s = sArray[0];
                        String string9 = String.valueOf(s);
                        if (hashMap.containsKey(string9)) {
                            stringBuffer.append((String)hashMap.get(string9));
                        } else {
                            stringBuffer.append(s);
                        }
                        for (int i = 1; i < n; ++i) {
                            stringBuffer.append(string);
                            s = sArray[i];
                            String string10 = String.valueOf(s);
                            if (hashMap.containsKey(string10)) {
                                stringBuffer.append((String)hashMap.get(string10));
                                continue;
                            }
                            stringBuffer.append(s);
                        }
                        break block48;
                    }
                    case 'I': {
                        int[] nArray = (int[])this.value;
                        long l = nArray[0];
                        String string11 = String.valueOf(l);
                        if (hashMap.containsKey(string11)) {
                            stringBuffer.append((String)hashMap.get(string11));
                        } else {
                            stringBuffer.append(l);
                        }
                        for (int i = 1; i < n; ++i) {
                            stringBuffer.append(string);
                            l = nArray[i];
                            String string12 = String.valueOf(l);
                            if (hashMap.containsKey(string12)) {
                                stringBuffer.append((String)hashMap.get(string12));
                                continue;
                            }
                            stringBuffer.append(l);
                        }
                        break block48;
                    }
                    case 'J': {
                        long[] lArray = (long[])this.value;
                        Long l = lArray[0];
                        String string13 = Long.toString(l);
                        if (hashMap.containsKey(string13)) {
                            stringBuffer.append((String)hashMap.get(string13));
                        } else {
                            stringBuffer.append(string13);
                        }
                        for (int i = 1; i < n; ++i) {
                            stringBuffer.append(string);
                            l = lArray[i];
                            String string14 = Long.toString(l);
                            if (hashMap.containsKey(string14)) {
                                stringBuffer.append((String)hashMap.get(string14));
                                continue;
                            }
                            stringBuffer.append(string14);
                        }
                        break block48;
                    }
                    default: {
                        stringBuffer.append(Array.get(this.value, 0));
                        for (int i = 1; i < n; ++i) {
                            stringBuffer.append(string);
                            stringBuffer.append(Array.get(this.value, i));
                        }
                        break block48;
                    }
                }
            }
            stringBuffer.append(Array.get(this.value, 0));
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(string);
                stringBuffer.append(Array.get(this.value, i));
            }
        }
        log.trace("toString: finish");
        return stringBuffer.toString();
    }
}

