/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdflib;

import java.io.File;
import java.io.Serializable;
import ncsa.hdf.hdflib.HDFArray;
import ncsa.hdf.hdflib.HDFChunkInfo;
import ncsa.hdf.hdflib.HDFCompInfo;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFJavaException;
import ncsa.hdf.hdflib.HDFNativeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFLibrary
implements Serializable {
    private static final long serialVersionUID = -1695429510319126910L;
    public static final String HDFPATH_PROPERTY_KEY = "ncsa.hdf.hdflib.HDFLibrary.hdflib";
    private static final Logger log = LoggerFactory.getLogger(HDFLibrary.class);
    private static final String JHI_VERSION = "2.10";
    private static boolean isLibraryLoaded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadH4Lib() {
        Object object;
        block12: {
            String string;
            block14: {
                if (isLibraryLoaded) {
                    return;
                }
                string = System.getProperty(HDFPATH_PROPERTY_KEY, null);
                if (string == null || string.length() <= 0) break block12;
                object = new File(string);
                if (!((File)object).exists() || !((File)object).canRead() || !((File)object).isFile()) break block14;
                try {
                    System.load(string);
                    isLibraryLoaded = true;
                }
                catch (Throwable throwable) {
                    try {
                        isLibraryLoaded = false;
                    }
                    catch (Throwable throwable2) {
                        log.info("HDF4 library: ");
                        log.debug(string);
                        log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded.");
                        throw throwable2;
                    }
                    log.info("HDF4 library: ");
                    log.debug(string);
                    log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded.");
                    break block12;
                }
                log.info("HDF4 library: ");
                log.debug(string);
                log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded.");
                break block12;
            }
            isLibraryLoaded = false;
            throw new UnsatisfiedLinkError("Invalid HDF4 library, " + string);
        }
        if (!isLibraryLoaded) {
            object = null;
            String string = "jhdf";
            try {
                object = System.mapLibraryName(string);
                System.loadLibrary("jhdf");
                isLibraryLoaded = true;
            }
            catch (Throwable throwable) {
                try {
                    isLibraryLoaded = false;
                }
                catch (Throwable throwable3) {
                    log.info("HDF4 library: " + string);
                    log.debug(" resolved to: " + (String)object + "; ");
                    log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded from java.library.path");
                    throw throwable3;
                }
                log.info("HDF4 library: " + string);
                log.debug(" resolved to: " + (String)object + "; ");
                log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded from java.library.path");
            }
            log.info("HDF4 library: " + string);
            log.debug(" resolved to: " + (String)object + "; ");
            log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded from java.library.path");
        }
        try {
            HDFLibrary.HDdont_atexit();
        }
        catch (HDFException hDFException) {
            System.exit(1);
        }
    }

    @Deprecated
    public static final String getJHIVersion() {
        return JHI_VERSION;
    }

    public static int Hopen(String string) throws HDFException {
        return HDFLibrary.Hopen(string, 1);
    }

    public static native int Hopen(String var0, int var1) throws HDFException;

    public static native boolean Hclose(int var0) throws HDFException;

    public static native int HDdont_atexit() throws HDFException;

    public static native boolean Hishdf(String var0) throws HDFException;

    public static native int Hnumber(int var0) throws HDFException;

    public static native int DFKNTsize(int var0) throws HDFException;

    public static native String HDgetNTdesc(int var0) throws HDFException;

    public static native boolean Hcache(int var0, int var1) throws HDFException;

    public static native boolean Hgetfileversion(int var0, int[] var1, String[] var2) throws HDFException;

    public static native boolean Hgetlibversion(int[] var0, String[] var1) throws HDFException;

    public static native boolean Hsetaccesstype(int var0, int var1) throws HDFException;

    public static native boolean Hsync(int var0) throws HDFException;

    public static native int ANstart(int var0) throws HDFException;

    public static native boolean ANend(int var0) throws HDFException;

    public static native boolean ANendaccess(int var0) throws HDFException;

    public static native boolean ANfileinfo(int var0, int[] var1) throws HDFException;

    public static native int ANselect(int var0, int var1, int var2) throws HDFException;

    public static native int ANnumann(int var0, int var1, short var2, short var3) throws HDFException;

    public static native short ANatype2tag(int var0) throws HDFException;

    public static native int ANtag2atype(short var0) throws HDFException;

    public static native int ANannlist(int var0, int var1, int var2, int var3, int[] var4) throws HDFException;

    public static native int ANannlen(int var0) throws HDFException;

    public static native boolean ANreadann(int var0, String[] var1, int var2) throws HDFException;

    public static native int ANcreate(int var0, short var1, short var2, int var3) throws HDFException;

    public static native int ANcreatef(int var0, int var1) throws HDFException;

    public static native int ANget_tagref(int var0, int var1, int var2, short[] var3) throws HDFException;

    public static native boolean ANid2tagref(int var0, short[] var1) throws HDFException;

    public static native int ANtagref2id(int var0, short var1, short var2) throws HDFException;

    public static native boolean ANwriteann(int var0, String var1, int var2) throws HDFException;

    public static native boolean DFPaddpal(String var0, byte[] var1) throws HDFException;

    public static native boolean DFPgetpal(String var0, byte[] var1) throws HDFException;

    public static native short DFPlastref() throws HDFException;

    public static native int DFPnpals(String var0) throws HDFException;

    public static native boolean DFPputpal(String var0, byte[] var1, int var2, String var3) throws HDFException;

    public static boolean DFPputpal(String string, byte[] byArray, boolean bl, String string2) throws HDFException {
        if (bl) {
            return HDFLibrary.DFPputpal(string, byArray, 1, string2);
        }
        return HDFLibrary.DFPputpal(string, byArray, 0, string2);
    }

    public static native boolean DFPreadref(String var0, short var1) throws HDFException;

    public static native short DFPrestart() throws HDFException;

    public static native boolean DFPwriteref(String var0, short var1) throws HDFException;

    public static native int GRstart(int var0) throws HDFException;

    public static native boolean GRend(int var0) throws HDFException;

    public static native boolean GRfileinfo(int var0, int[] var1) throws HDFException;

    public static native boolean GRgetchunkinfo(int var0, HDFChunkInfo var1, int[] var2) throws HDFException;

    public static native int GRselect(int var0, int var1) throws HDFException;

    public static native int GRnametoindex(int var0, String var1) throws HDFException;

    public static native boolean GRgetiminfo(int var0, String[] var1, int[] var2, int[] var3) throws HDFException;

    public static native boolean GRreadimage(int var0, int[] var1, int[] var2, int[] var3, byte[] var4) throws HDFException;

    public static boolean GRreadimage(int n, int[] nArray, int[] nArray2, int[] nArray3, Object object) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.emptyBytes();
        boolean bl = HDFLibrary.GRreadimage(n, nArray, nArray2, nArray3, byArray);
        object = hDFArray.arrayify(byArray);
        return bl;
    }

    public static native boolean GRendaccess(int var0) throws HDFException;

    public static native short GRidtoref(int var0) throws HDFException;

    public static native int GRreftoindex(int var0, short var1) throws HDFException;

    public static native boolean GRreqlutil(int var0, int var1) throws HDFException;

    public static native boolean GRreqimageil(int var0, int var1) throws HDFException;

    public static native int GRgetlutid(int var0, int var1) throws HDFException;

    public static native int GRgetnluts(int var0) throws HDFException;

    public static native boolean GRgetlutinfo(int var0, int[] var1) throws HDFException;

    public static native boolean GRreadlut(int var0, byte[] var1) throws HDFException;

    public static boolean GRreadlut(int n, Object object) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.emptyBytes();
        boolean bl = HDFLibrary.GRreadlut(n, byArray);
        object = hDFArray.arrayify(byArray);
        return bl;
    }

    public static native boolean GRattrinfo(int var0, int var1, String[] var2, int[] var3) throws HDFException;

    public static native boolean GRgetattr(int var0, int var1, byte[] var2) throws HDFException;

    public static boolean GRgetattr(int n, int n2, Object object) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.emptyBytes();
        boolean bl = HDFLibrary.GRgetattr(n, n2, byArray);
        object = hDFArray.arrayify(byArray);
        return bl;
    }

    public static native int GRfindattr(int var0, String var1) throws HDFException;

    public static native int GRcreate(int var0, String var1, int var2, int var3, int var4, int[] var5) throws HDFException;

    public static native short GRluttoref(int var0) throws HDFException;

    public static native boolean GRsetattr(int var0, String var1, int var2, int var3, String var4) throws HDFException;

    public static native boolean GRsetattr(int var0, String var1, int var2, int var3, byte[] var4) throws HDFException;

    public static boolean GRsetattr(int n, String string, int n2, int n3, Object object) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        return HDFLibrary.GRsetattr(n, string, n2, n3, byArray);
    }

    public static native boolean GRsetchunk(int var0, HDFChunkInfo var1, int var2) throws HDFException;

    public static native int GRsetchunkcache(int var0, int var1, int var2) throws HDFException;

    public static native boolean GRsetcompress(int var0, int var1, HDFCompInfo var2) throws HDFException;

    public static native boolean GRgetcompress(int var0, HDFCompInfo var1) throws HDFException;

    public static native boolean GRsetexternalfile(int var0, String var1, int var2) throws HDFException;

    public static native boolean GRwriteimage(int var0, int[] var1, int[] var2, int[] var3, byte[] var4) throws HDFException;

    public static boolean GRwriteimage(int n, int[] nArray, int[] nArray2, int[] nArray3, Object object) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        return HDFLibrary.GRwriteimage(n, nArray, nArray2, nArray3, byArray);
    }

    public static native boolean GRwritelut(int var0, int var1, int var2, int var3, int var4, byte[] var5) throws HDFException;

    public static boolean GRwritelut(int n, int n2, int n3, int n4, int n5, Object object) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        return HDFLibrary.GRwritelut(n, n2, n3, n4, n5, byArray);
    }

    public static native boolean GRreadchunk(int var0, int[] var1, byte[] var2) throws HDFException;

    public static boolean GRreadchunk(int n, int[] nArray, Object object) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.emptyBytes();
        boolean bl = HDFLibrary.GRreadchunk(n, nArray, byArray);
        object = hDFArray.arrayify(byArray);
        return bl;
    }

    public static native boolean HDFclose(int var0) throws HDFException;

    public static native int HDFopen(String var0, int var1, short var2) throws HDFException;

    public static native short HEvalue(int var0) throws HDFException;

    public static native String HEstring(int var0) throws HDFException;

    public static native boolean HXsetcreatedir(String var0) throws HDFException;

    public static native boolean HXsetdir(String var0) throws HDFException;

    public static native int SDstart(String var0, int var1) throws HDFException;

    public static native boolean SDend(int var0) throws HDFException;

    public static native boolean SDfileinfo(int var0, int[] var1) throws HDFException;

    public static native int SDselect(int var0, int var1) throws HDFException;

    public static native int SDnametoindex(int var0, String var1) throws HDFException;

    public static native boolean SDgetinfo(int var0, String[] var1, int[] var2, int[] var3) throws HDFException;

    public static native boolean SDcheckempty(int var0, int[] var1) throws HDFException;

    public static native boolean SDreaddata(int var0, int[] var1, int[] var2, int[] var3, byte[] var4) throws HDFException;

    public static boolean SDreaddata(int n, int[] nArray, int[] nArray2, int[] nArray3, Object object) throws HDFException {
        boolean bl = false;
        boolean bl2 = false;
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new HDFJavaException("SDreaddata: data is not an array");
        }
        String string = clazz.getName();
        bl2 = string.lastIndexOf(91) == string.indexOf(91);
        char c = string.charAt(string.lastIndexOf("[") + 1);
        if (bl2 && c == 'B') {
            bl = HDFLibrary.SDreaddata(n, nArray, nArray2, nArray3, (byte[])object);
        } else if (bl2 && c == 'S') {
            bl = HDFLibrary.SDreaddata_short(n, nArray, nArray2, nArray3, (short[])object);
        } else if (bl2 && c == 'I') {
            bl = HDFLibrary.SDreaddata_int(n, nArray, nArray2, nArray3, (int[])object);
        } else if (bl2 && c == 'J') {
            bl = HDFLibrary.SDreaddata_long(n, nArray, nArray2, nArray3, (long[])object);
        } else if (bl2 && c == 'F') {
            bl = HDFLibrary.SDreaddata_float(n, nArray, nArray2, nArray3, (float[])object);
        } else if (bl2 && c == 'D') {
            bl = HDFLibrary.SDreaddata_double(n, nArray, nArray2, nArray3, (double[])object);
        } else {
            HDFArray hDFArray = new HDFArray(object);
            byte[] byArray = hDFArray.emptyBytes();
            bl = HDFLibrary.SDreaddata(n, nArray, nArray2, nArray3, byArray);
            object = hDFArray.arrayify(byArray);
        }
        return bl;
    }

    public static native boolean SDendaccess(int var0) throws HDFException;

    public static native int SDgetdimid(int var0, int var1) throws HDFException;

    public static native boolean SDdiminfo(int var0, String[] var1, int[] var2) throws HDFException;

    public static native int SDidtoref(int var0) throws HDFException;

    public static native int SDreftoindex(int var0, int var1) throws HDFException;

    public static native boolean SDattrinfo(int var0, int var1, String[] var2, int[] var3) throws HDFException;

    public static native boolean SDreadattr(int var0, int var1, byte[] var2) throws HDFException;

    public static boolean SDreadattr(int n, int n2, Object object) throws HDFException {
        boolean bl;
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        if (string.equals("java.lang.String")) {
            byte[] byArray = ((String)object).getBytes();
            bl = HDFLibrary.SDreadattr(n, n2, byArray);
            object = new String(byArray);
        } else {
            HDFArray hDFArray = new HDFArray(object);
            byte[] byArray = hDFArray.emptyBytes();
            bl = HDFLibrary.SDreadattr(n, n2, byArray);
            object = hDFArray.arrayify(byArray);
        }
        return bl;
    }

    public static native int SDfindattr(int var0, String var1) throws HDFException;

    public static native boolean SDiscoordvar(int var0) throws HDFException;

    public static native boolean SDgetcal(int var0, double[] var1, int[] var2) throws HDFException;

    public static native boolean SDgetdatastrs(int var0, String[] var1, int var2) throws HDFException;

    public static native boolean SDgetdimstrs(int var0, String[] var1, int var2) throws HDFException;

    public static native boolean SDgetdimscale(int var0, byte[] var1) throws HDFException;

    public static boolean SDgetdimscale(int n, Object object) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.emptyBytes();
        boolean bl = HDFLibrary.SDgetdimscale(n, byArray);
        object = hDFArray.arrayify(byArray);
        return bl;
    }

    public static native boolean SDgetfillvalue(int var0, byte[] var1) throws HDFException;

    public static boolean SDgetfillvalue(int n, Object[] objectArray) throws HDFException {
        int[] nArray = new int[3];
        String string = new String(" ");
        String[] stringArray = new String[]{string};
        int[] nArray2 = new int[16];
        HDFLibrary.SDgetinfo(n, stringArray, nArray2, nArray);
        string = stringArray[0];
        byte[] byArray = new byte[8];
        boolean bl = HDFLibrary.SDgetfillvalue(n, byArray);
        if (!bl) {
            return bl;
        }
        int n2 = nArray[1];
        if ((n2 & 0x4000) != 0) {
            n2 -= 16384;
        }
        if (n2 == 20 || n2 == 4 || n2 == 4) {
            objectArray[0] = new Byte(byArray[0]);
        } else if (n2 == 21 || n2 == 3 || n2 == 3) {
            Byte by = new Byte(byArray[0]);
            objectArray[0] = by.shortValue() < 0 ? new Short((short)(by.intValue() + 256)) : new Short(by.shortValue());
        } else if (n2 == 22 || n2 == 42) {
            short[] sArray = HDFNativeData.byteToShort(0, 1, byArray);
            objectArray[0] = new Short(sArray[0]);
        } else if (n2 == 23 || n2 == 43) {
            short[] sArray = HDFNativeData.byteToShort(0, 1, byArray);
            Short s = new Short(sArray[0]);
            objectArray[0] = s.intValue() < 0 ? new Integer(s.intValue() + 65536) : new Integer(s.intValue());
        } else if (n2 == 24) {
            int[] nArray3 = HDFNativeData.byteToInt(0, 1, byArray);
            objectArray[0] = new Integer(nArray3[0]);
        } else if (n2 == 25) {
            int[] nArray4 = HDFNativeData.byteToInt(0, 1, byArray);
            Integer n3 = new Integer(nArray4[0]);
            objectArray[0] = n3.floatValue() < 0.0f ? new Float((float)((double)n3.floatValue() + 4.294967296E9)) : new Float(n3.floatValue());
        } else if (n2 == 5) {
            float[] fArray = HDFNativeData.byteToFloat(0, 1, byArray);
            objectArray[0] = new Float(fArray[0]);
        } else if (n2 == 6) {
            double[] dArray = HDFNativeData.byteToDouble(0, 1, byArray);
            objectArray[0] = new Double(dArray[0]);
        } else {
            System.out.println("Error: SDgetfillvalue not converting, type " + n2);
        }
        return bl;
    }

    public static native boolean SDgetrange(int var0, byte[] var1, byte[] var2) throws HDFException;

    public static boolean SDgetrange(int n, double[] dArray) throws HDFException {
        int[] nArray = new int[3];
        String string = new String(" ");
        String[] stringArray = new String[]{string};
        int[] nArray2 = new int[16];
        HDFLibrary.SDgetinfo(n, stringArray, nArray2, nArray);
        string = stringArray[0];
        byte[] byArray = new byte[8];
        byte[] byArray2 = new byte[8];
        boolean bl = HDFLibrary.SDgetrange(n, byArray, byArray2);
        if (!bl) {
            return bl;
        }
        int n2 = nArray[1];
        if ((n2 & 0x4000) != 0) {
            n2 -= 16384;
        }
        if (n2 == 20 || n2 == 4 || n2 == 4) {
            Byte by = new Byte(byArray[0]);
            dArray[0] = by.doubleValue();
            by = new Byte(byArray2[0]);
            dArray[1] = by.doubleValue();
        } else if (n2 == 21 || n2 == 3 || n2 == 3) {
            Byte by = new Byte(byArray[0]);
            Short s = by.shortValue() < 0 ? new Short((short)(by.intValue() + 256)) : new Short(by.shortValue());
            dArray[0] = s.doubleValue();
            by = new Byte(byArray2[0]);
            s = new Short(by.shortValue());
            dArray[1] = s.doubleValue();
        } else if (n2 == 22 || n2 == 42) {
            short[] sArray = HDFNativeData.byteToShort(0, 1, byArray);
            short[] sArray2 = HDFNativeData.byteToShort(0, 1, byArray2);
            Short s = new Short(sArray[0]);
            dArray[0] = s.doubleValue();
            s = new Short(sArray2[0]);
            dArray[1] = s.doubleValue();
        } else if (n2 == 23 || n2 == 23) {
            short[] sArray = HDFNativeData.byteToShort(0, 1, byArray);
            Short s = new Short(sArray[0]);
            Integer n3 = s.intValue() < 0 ? new Integer(s.intValue() + 65536) : new Integer(s.intValue());
            dArray[0] = n3.doubleValue();
            sArray = HDFNativeData.byteToShort(0, 1, byArray2);
            s = new Short(sArray[0]);
            n3 = s.intValue() < 0 ? new Integer(s.intValue() + 65536) : new Integer(s.intValue());
            dArray[1] = n3.doubleValue();
        } else if (n2 == 24) {
            int[] nArray3 = HDFNativeData.byteToInt(0, 1, byArray);
            int[] nArray4 = HDFNativeData.byteToInt(0, 1, byArray2);
            Integer n4 = new Integer(nArray3[0]);
            dArray[0] = n4.doubleValue();
            n4 = new Integer(nArray4[0]);
            dArray[1] = n4.doubleValue();
        } else if (n2 == 25) {
            int[] nArray5 = HDFNativeData.byteToInt(0, 1, byArray);
            Integer n5 = new Integer(nArray5[0]);
            Float f = n5.floatValue() < 0.0f ? new Float((float)((double)n5.floatValue() + 4.294967296E9)) : new Float(n5.floatValue());
            dArray[0] = f.doubleValue();
            nArray5 = HDFNativeData.byteToInt(0, 1, byArray);
            n5 = new Integer(nArray5[0]);
            f = n5.floatValue() < 0.0f ? new Float((float)((double)n5.floatValue() + 4.294967296E9)) : new Float(n5.floatValue());
            dArray[1] = f.doubleValue();
        } else if (n2 == 5) {
            float[] fArray = HDFNativeData.byteToFloat(0, 1, byArray);
            float[] fArray2 = HDFNativeData.byteToFloat(0, 1, byArray2);
            Float f = new Float(fArray[0]);
            dArray[0] = f.doubleValue();
            f = new Float(fArray2[0]);
            dArray[1] = f.doubleValue();
        } else if (n2 == 6) {
            double[] dArray2 = HDFNativeData.byteToDouble(0, 1, byArray);
            double[] dArray3 = HDFNativeData.byteToDouble(0, 1, byArray2);
            Double d = new Double(dArray2[0]);
            dArray[0] = d;
            d = new Double(dArray3[0]);
            dArray[1] = d;
        } else {
            System.out.println("Error: SDgetrange not converting, type " + n2);
        }
        return bl;
    }

    public static native int SDcreate(int var0, String var1, int var2, int var3, int[] var4) throws HDFException;

    public static native boolean SDisrecord(int var0) throws HDFException;

    public static native boolean SDsetattr(int var0, String var1, int var2, int var3, byte[] var4) throws HDFException;

    public static boolean SDsetattr(int n, String string, int n2, int n3, Object object) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        return HDFLibrary.SDsetattr(n, string, n2, n3, byArray);
    }

    public static native boolean SDsetcal(int var0, double var1, double var3, double var5, double var7, int var9) throws HDFException;

    public static native boolean SDsetdatastrs(int var0, String var1, String var2, String var3, String var4) throws HDFException;

    public static native boolean SDsetdimname(int var0, String var1) throws HDFException;

    public static native boolean SDsetdimscale(int var0, int var1, int var2, byte[] var3) throws HDFException;

    public static boolean SDsetdimscale(int n, int n2, int n3, Object object) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        return HDFLibrary.SDsetdimscale(n, n2, n3, byArray);
    }

    public static native boolean SDsetdimstrs(int var0, String var1, String var2, String var3) throws HDFException;

    public static native boolean SDsetexternalfile(int var0, String var1, int var2) throws HDFException;

    public static native boolean SDsetfillvalue(int var0, byte[] var1) throws HDFException;

    public static boolean SDsetfillvalue(int n, Object object) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        return HDFLibrary.SDsetfillvalue(n, byArray);
    }

    public static native boolean SDsetrange(int var0, byte[] var1, byte[] var2) throws HDFException;

    public static boolean SDsetrange(int n, Object object, Object object2) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        HDFArray hDFArray2 = new HDFArray(object2);
        byte[] byArray2 = hDFArray2.byteify();
        return HDFLibrary.SDgetrange(n, byArray, byArray2);
    }

    public static native boolean SDwritedata(int var0, int[] var1, int[] var2, int[] var3, byte[] var4) throws HDFException;

    public static boolean SDwritedata(int n, int[] nArray, int[] nArray2, int[] nArray3, Object object) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        return HDFLibrary.SDwritedata(n, nArray, nArray2, nArray3, byArray);
    }

    public static native boolean SDsetnbitdataset(int var0, int var1, int var2, int var3, int var4) throws HDFException;

    public static native boolean SDsetcompress(int var0, int var1, HDFCompInfo var2) throws HDFException;

    @Deprecated
    public static native boolean SDgetcompress(int var0, HDFCompInfo var1) throws HDFException;

    public static native boolean SDgetcompinfo(int var0, HDFCompInfo var1) throws HDFException;

    public static native boolean SDsetaccesstype(int var0, int var1) throws HDFException;

    public static native boolean SDsetblocksize(int var0, int var1) throws HDFException;

    public static boolean SDsetfillmode(int n, boolean bl) throws HDFException {
        int n2 = bl ? 0 : 256;
        return HDFLibrary.SDsetfillmode(n, n2);
    }

    public static native boolean SDsetfillmode(int var0, int var1) throws HDFException;

    public static native boolean SDsetdimval_comp(int var0, int var1) throws HDFException;

    public static native boolean SDisdimval_bwcomp(int var0) throws HDFException;

    public static native boolean SDsetchunk(int var0, HDFChunkInfo var1, int var2) throws HDFException;

    public static native boolean SDgetchunkinfo(int var0, HDFChunkInfo var1, int[] var2) throws HDFException;

    public static native boolean SDreadchunk(int var0, int[] var1, byte[] var2) throws HDFException;

    public static boolean SDreadchunk(int n, int[] nArray, Object object) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.emptyBytes();
        boolean bl = HDFLibrary.SDreadchunk(n, nArray, byArray);
        object = hDFArray.arrayify(byArray);
        return bl;
    }

    public static native int SDsetchunkcache(int var0, int var1, int var2) throws HDFException;

    public static native boolean SDwritechunk(int var0, int[] var1, byte[] var2) throws HDFException;

    public static boolean SDwritechunk(int n, int[] nArray, Object object) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        return HDFLibrary.SDwritechunk(n, nArray, byArray);
    }

    public static native int VFfieldesize(int var0, int var1) throws HDFException;

    public static native int VFfieldisize(int var0, int var1) throws HDFException;

    public static native String VFfieldname(int var0, int var1) throws HDFException;

    public static native int VFfieldorder(int var0, int var1) throws HDFException;

    public static native int VFfieldtype(int var0, int var1) throws HDFException;

    public static native int VFnfields(int var0) throws HDFException;

    public static native int VHmakegroup(int var0, int[] var1, int[] var2, int var3, String var4, String var5) throws HDFException;

    public static native int VHstoredata(int var0, String var1, byte[] var2, int var3, int var4, String var5, String var6) throws HDFException;

    public static int VHstoredata(int n, String string, Object object, int n2, int n3, String string2, String string3) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        return HDFLibrary.VHstoredata(n, string, byArray, n2, n3, string2, string3);
    }

    public static native int VHstoredatam(int var0, String var1, byte[] var2, int var3, int var4, String var5, String var6, int var7) throws HDFException;

    public static int VHstoredatam(int n, String string, Object object, int n2, int n3, String string2, String string3, int n4) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        return HDFLibrary.VHstoredatam(n, string, byArray, n2, n3, string2, string3, n4);
    }

    public static native int VQueryref(int var0) throws HDFException;

    public static native int VQuerytag(int var0) throws HDFException;

    public static native boolean VSQuerycount(int var0, int[] var1) throws HDFException;

    public static native boolean VSQueryfields(int var0, String[] var1) throws HDFException;

    public static native boolean VSQueryinterlace(int var0, int[] var1) throws HDFException;

    public static native boolean VSQueryname(int var0, String[] var1) throws HDFException;

    public static native int VSQueryref(int var0) throws HDFException;

    public static native int VSQuerytag(int var0) throws HDFException;

    public static native boolean VSQueryvsize(int var0, int[] var1) throws HDFException;

    public static native int VSattach(int var0, int var1, String var2) throws HDFException;

    public static native void VSdetach(int var0) throws HDFException;

    public static native int VSgetid(int var0, int var1) throws HDFException;

    public static native void VSgetclass(int var0, String[] var1) throws HDFException;

    public static native void VSgetname(int var0, String[] var1) throws HDFException;

    public static native int VSelts(int var0) throws HDFException;

    public static native boolean VSfdefine(int var0, String var1, int var2, int var3) throws HDFException;

    public static native boolean VSfexist(int var0, String var1) throws HDFException;

    public static native int VSfind(int var0, String var1) throws HDFException;

    public static native int VSsetblocksize(int var0, int var1) throws HDFException;

    public static native int VSsetnumblocks(int var0, int var1) throws HDFException;

    public static native int VSgetfields(int var0, String[] var1) throws HDFException;

    public static native int VSgetinterlace(int var0) throws HDFException;

    public static native boolean VSinquire(int var0, int[] var1, String[] var2) throws HDFException;

    public static native boolean VSinquire(int var0, int[] var1) throws HDFException;

    public static native int VSlone(int var0, int[] var1, int var2) throws HDFException;

    public static native int VSread(int var0, byte[] var1, int var2, int var3) throws HDFException;

    public static int VSread(int n, Object object, int n2, int n3) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.emptyBytes();
        int n4 = HDFLibrary.VSread(n, byArray, n2, n3);
        object = hDFArray.arrayify(byArray);
        return n4;
    }

    public static native int VSseek(int var0, int var1) throws HDFException;

    public static native boolean VSsetfields(int var0, String var1) throws HDFException;

    public static native boolean VSsetinterlace(int var0, int var1) throws HDFException;

    public static native int VSsizeof(int var0, String var1) throws HDFException;

    public static native boolean VSappendable(int var0, int var1) throws HDFException;

    public static native int VSfindclass(int var0, String var1) throws HDFException;

    public static native int VSgetversion(int var0) throws HDFException;

    public static native void VSsetclass(int var0, String var1) throws HDFException;

    public static native boolean VSsetexternalfile(int var0, String var1, int var2) throws HDFException;

    public static native void VSsetname(int var0, String var1) throws HDFException;

    public static native int VSwrite(int var0, byte[] var1, int var2, int var3) throws HDFException;

    public static int VSwrite(int n, Object object, int n2, int n3) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        return HDFLibrary.VSwrite(n, byArray, n2, n3);
    }

    public static native boolean Vstart(int var0) throws HDFException;

    public static native int Vattach(int var0, int var1, String var2) throws HDFException;

    public static native void Vdetach(int var0) throws HDFException;

    public static native void Vend(int var0) throws HDFException;

    public static native int Vgetid(int var0, int var1) throws HDFException;

    public static native void Vgetclass(int var0, String[] var1) throws HDFException;

    public static native void Vgetname(int var0, String[] var1) throws HDFException;

    public static native boolean Visvg(int var0, int var1) throws HDFException;

    public static native boolean Visvs(int var0, int var1) throws HDFException;

    public static native int Vgettagrefs(int var0, int[] var1, int[] var2, int var3) throws HDFException;

    public static native boolean Vgettagref(int var0, int var1, int[] var2) throws HDFException;

    public static native int Vntagrefs(int var0) throws HDFException;

    public static native boolean Vinqtagref(int var0, int var1, int var2) throws HDFException;

    public static native int Vlone(int var0, int[] var1, int var2) throws HDFException;

    public static native int Vaddtagref(int var0, int var1, int var2) throws HDFException;

    public static native int Vdeletetagref(int var0, int var1, int var2) throws HDFException;

    public static native int Vfind(int var0, String var1) throws HDFException;

    public static native int Vfindclass(int var0, String var1) throws HDFException;

    public static native int Vflocate(int var0, String var1) throws HDFException;

    public static native int Vgetnext(int var0, int var1) throws HDFException;

    public static native boolean Vinquire(int var0, int[] var1, String[] var2) throws HDFException;

    public static native int Vinsert(int var0, int var1) throws HDFException;

    public static native int Vnrefs(int var0, int var1) throws HDFException;

    public static native boolean Vsetclass(int var0, String var1) throws HDFException;

    public static native boolean Vsetname(int var0, String var1) throws HDFException;

    public static boolean Vattrinfo(int n, int n2, String[] stringArray, int[] nArray) throws HDFException {
        int[] nArray2 = new int[5];
        boolean bl = HDFLibrary._Vattrinfo(n, n2, stringArray, nArray2);
        int n3 = Math.min(nArray.length, 5);
        for (int i = 0; i < n3; ++i) {
            nArray[i] = nArray2[i];
        }
        return bl;
    }

    private static native boolean _Vattrinfo(int var0, int var1, String[] var2, int[] var3) throws HDFException;

    public static native int Vfindattr(int var0, String var1) throws HDFException;

    public static native boolean Vgetattr(int var0, int var1, byte[] var2) throws HDFException;

    public static boolean Vgetattr(int n, int n2, Object object) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.emptyBytes();
        boolean bl = HDFLibrary.Vgetattr(n, n2, byArray);
        object = hDFArray.arrayify(byArray);
        return bl;
    }

    public static native int Vgetversion(int var0) throws HDFException;

    public static native int Vnattrs(int var0) throws HDFException;

    public static native boolean Vsetattr(int var0, String var1, int var2, int var3, String var4) throws HDFException;

    public static native boolean Vsetattr(int var0, String var1, int var2, int var3, byte[] var4) throws HDFException;

    public static boolean Vsetattr(int n, String string, int n2, int n3, Object object) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        return HDFLibrary.Vsetattr(n, string, n2, n3, byArray);
    }

    public static native boolean VSattrinfo(int var0, int var1, int var2, String[] var3, int[] var4) throws HDFException;

    public static native int VSfindex(int var0, String var1, int[] var2) throws HDFException;

    public static native int VSfindattr(int var0, int var1, String var2) throws HDFException;

    public static native int VSfnattrs(int var0, int var1) throws HDFException;

    public static native boolean VSgetattr(int var0, int var1, int var2, byte[] var3) throws HDFException;

    public static boolean VSgetattr(int n, int n2, int n3, Object object) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.emptyBytes();
        boolean bl = HDFLibrary.VSgetattr(n, n2, n3, byArray);
        object = hDFArray.arrayify(byArray);
        return bl;
    }

    public static native boolean VSisattr(int var0) throws HDFException;

    public static native int VSnattrs(int var0) throws HDFException;

    public static native boolean VSsetattr(int var0, int var1, String var2, int var3, int var4, String var5) throws HDFException;

    public static native boolean VSsetattr(int var0, int var1, String var2, int var3, int var4, byte[] var5) throws HDFException;

    public static boolean VSsetattr(int n, int n2, String string, int n3, int n4, Object object) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        return HDFLibrary.VSsetattr(n, n2, string, n3, n4, byArray);
    }

    public static native boolean DF24getdims(String var0, int[] var1) throws HDFException;

    public static native boolean DF24reqil(int var0) throws HDFException;

    public static native boolean DF24getimage(String var0, byte[] var1, int var2, int var3) throws HDFException;

    public static boolean DF24getimage(String string, Object object, int n, int n2) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.emptyBytes();
        boolean bl = HDFLibrary.DF24getimage(string, byArray, n, n2);
        object = hDFArray.arrayify(byArray);
        return bl;
    }

    public static native short DF24lastref() throws HDFException;

    public static native boolean DF24restart() throws HDFException;

    public static native boolean DF24readref(String var0, int var1) throws HDFException;

    public static native int DF24nimages(String var0) throws HDFException;

    public static native boolean DF24addimage(String var0, byte[] var1, int var2, int var3) throws HDFException;

    public static boolean DF24addimage(String string, Object object, int n, int n2) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        return HDFLibrary.DF24addimage(string, byArray, n, n2);
    }

    public static native boolean DF24putimage(String var0, byte[] var1, int var2, int var3) throws HDFException;

    public static boolean DF24putimage(String string, Object object, int n, int n2) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        return HDFLibrary.DF24putimage(string, byArray, n, n2);
    }

    public static native boolean DF24setcompress(int var0, HDFCompInfo var1) throws HDFException;

    public static native boolean DF24setdims(int var0, int var1) throws HDFException;

    public static native boolean DF24setil(int var0) throws HDFException;

    public static native boolean DFR8getdims(String var0, int[] var1, boolean[] var2) throws HDFException;

    public static native boolean DFR8getimage(String var0, byte[] var1, int var2, int var3, byte[] var4) throws HDFException;

    public static boolean DFR8getimage(String string, Object object, int n, int n2, byte[] byArray) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray2 = hDFArray.emptyBytes();
        boolean bl = HDFLibrary.DFR8getimage(string, byArray2, n, n2, byArray);
        object = hDFArray.arrayify(byArray2);
        return bl;
    }

    public static native short DFR8lastref() throws HDFException;

    public static native boolean DFR8restart() throws HDFException;

    public static native boolean DFR8readref(String var0, int var1) throws HDFException;

    public static native int DFR8nimages(String var0) throws HDFException;

    public static native boolean DFR8addimage(String var0, byte[] var1, int var2, int var3, short var4) throws HDFException;

    public static boolean DFR8addimage(String string, Object object, int n, int n2, short s) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        return HDFLibrary.DFR8addimage(string, byArray, n, n2, s);
    }

    public static native boolean DFR8putimage(String var0, byte[] var1, int var2, int var3, short var4) throws HDFException;

    public static boolean DFR8putimage(String string, Object object, int n, int n2, short s) throws HDFException {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        return HDFLibrary.DFR8putimage(string, byArray, n, n2, s);
    }

    public static native boolean DFR8setcompress(int var0, HDFCompInfo var1) throws HDFException;

    public static native boolean DFR8getpalref(short[] var0) throws HDFException;

    public static native boolean DFR8setpalette(byte[] var0) throws HDFException;

    public static native boolean DFR8writeref(String var0, short var1) throws HDFException;

    public static native boolean SDreaddata_short(int var0, int[] var1, int[] var2, int[] var3, short[] var4) throws HDFException;

    public static native boolean SDreaddata_int(int var0, int[] var1, int[] var2, int[] var3, int[] var4) throws HDFException;

    public static native boolean SDreaddata_long(int var0, int[] var1, int[] var2, int[] var3, long[] var4) throws HDFException;

    public static native boolean SDreaddata_float(int var0, int[] var1, int[] var2, int[] var3, float[] var4) throws HDFException;

    public static native boolean SDreaddata_double(int var0, int[] var1, int[] var2, int[] var3, double[] var4) throws HDFException;

    public static native int HCget_config_info(int var0) throws HDFException;

    static {
        HDFLibrary.loadH4Lib();
    }
}

