/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.hdf5.util.Compatiblity;
import com.rapidminer.repository.Repository;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.repository.resource.ResourceRepository;
import com.rapidminer.tools.FileSystemService;
import com.rapidminer.tools.GroupTree;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.plugin.Plugin;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PluginInitHDF5 {
    private static final String HDF_LIB_DIR = "hdflib";
    private static final String JHDF_VERSION = "2.11.0";
    private static final String[] OS_NAMES = new String[]{"lin", "win32", "win64", "mac", "sol"};
    public static final String HDF_KEY = "rmx_hdf5";
    private static boolean removeLibPath;
    private static ResourceRepository rep;
    private static File libDir;

    public static void initPlugin() {
        Plugin hdf5 = Plugin.getPluginByExtensionId((String)HDF_KEY);
        if (hdf5 == null) {
            throw new RuntimeException("HDF plugin not found.");
        }
        libDir = PluginInitHDF5.createLibDir();
        if (libDir == null) {
            throw new RuntimeException("Creating hdflib directory failed");
        }
        try {
            PluginInitHDF5.copyLibFiles(hdf5, libDir);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Copying hdf lib files failed");
        }
        try {
            removeLibPath = PluginInitHDF5.addLibraryPath(libDir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Adding hdf lib path failed");
        }
    }

    private static File createLibDir() {
        File parentDir = PluginInitHDF5.getParentDir();
        File libDir = new File(parentDir, HDF_LIB_DIR + File.separator + JHDF_VERSION);
        File parent = libDir.getParentFile();
        if (parent.exists()) {
            for (File child : parent.listFiles()) {
                if (child.isDirectory() || child.delete()) continue;
                child.deleteOnExit();
            }
            try {
                PluginInitHDF5.removeLibraryPath(HDF_LIB_DIR);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!libDir.exists() ? !libDir.mkdirs() : !libDir.isDirectory()) {
            return null;
        }
        return libDir;
    }

    private static File getParentDir() {
        File dir = null;
        try {
            dir = Compatiblity.getDefault().getLibDirParent();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dir != null && dir.exists()) {
            return dir;
        }
        String locationProperty = ParameterService.getParameterValue((String)"com.rapidanalytics.plugindir");
        if (locationProperty != null && !locationProperty.isEmpty() && (dir = new File(locationProperty)).exists()) {
            return dir;
        }
        dir = FileSystemService.getUserRapidMinerDir();
        if (dir != null && dir.exists()) {
            return dir;
        }
        dir = new File(System.getProperty("java.io.tmpdir"));
        if (dir.exists()) {
            return dir;
        }
        throw new RuntimeException("Could not find parent directory for hdf libraries");
    }

    private static void copyLibFiles(Plugin hdf5, File libDir) throws Exception {
        JarFile file = hdf5.getArchive();
        String libFolder = PluginInitHDF5.getLibFolder(file);
        if (libFolder == null) {
            throw new Exception("Native library files for this OS could not be found in jar file.");
        }
        Enumeration<JarEntry> entries = file.entries();
        while (entries.hasMoreElements()) {
            String name;
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !(name = entry.getName()).startsWith(libFolder)) continue;
            name = name.substring(libFolder.length() + 1);
            File target = new File(libDir, name);
            PluginInitHDF5.copyLibFile(file.getInputStream(entry), target);
        }
    }

    private static String getLibFolder(JarFile file) {
        String libFolder = HDF_LIB_DIR;
        boolean any = false;
        for (String os : OS_NAMES) {
            if (file.getEntry(libFolder + "/" + os) != null) {
                any = true;
            }
            if (any) break;
        }
        if (!any) {
            return libFolder;
        }
        libFolder = libFolder + "/";
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            os = "win";
        } else if (os.contains("mac")) {
            os = "mac";
        } else if (os.contains("nux") || os.contains("nix") || os.contains("aix")) {
            os = "lin";
        } else if (os.contains("sunos") || os.contains("solaris")) {
            os = "sol";
        } else {
            return null;
        }
        if (os.equals("win")) {
            String bitNess = System.getProperty("sun.arch.data.model", "32");
            if (bitNess.equals("unknown")) {
                bitNess = "32";
            }
            os = os + bitNess;
        }
        return libFolder + os;
    }

    private static void copyLibFile(InputStream inputStream, File target) throws Exception {
        int length;
        if (!target.createNewFile()) {
            return;
        }
        FileOutputStream fos = new FileOutputStream(target);
        byte[] data = new byte[1024];
        while ((length = inputStream.read(data)) != -1) {
            fos.write(data, 0, length);
        }
        inputStream.close();
        fos.close();
    }

    private static boolean addLibraryPath(String pathToAdd) throws Exception {
        String[] paths;
        Field usrPathsField = ClassLoader.class.getDeclaredField("usr_paths");
        usrPathsField.setAccessible(true);
        for (String path : paths = (String[])usrPathsField.get(null)) {
            if (!path.equals(pathToAdd)) continue;
            return false;
        }
        String[] newPaths = new String[paths.length + 1];
        System.arraycopy(paths, 0, newPaths, 1, paths.length);
        newPaths[0] = pathToAdd;
        usrPathsField.set(null, newPaths);
        return true;
    }

    public static void initGui(MainFrame mainframe) {
        GroupTree daf = OperatorService.getGroups().getSubGroup("data_access");
        if (daf == null) {
            return;
        }
        if ((daf = daf.getSubGroup("files")) == null) {
            return;
        }
        String readIcon = daf.getSubGroup("read").getIconName();
        String writeIcon = daf.getSubGroup("write").getIconName();
        OperatorService.getOperatorDescription((String)"hdf5:read_hdf5").setIconName(readIcon);
        OperatorService.getOperatorDescription((String)"hdf5:write_hdf5").setIconName(writeIcon);
    }

    public static void initFinalChecks() {
        rep = new ResourceRepository("HDF5 Examples", "hdf5rep");
        RepositoryManager.getInstance(null).addRepository((Repository)rep);
    }

    public static void initPluginManager() {
    }

    public static void tearDownGUI(MainFrame mainFrame) {
    }

    public static void tearDown() {
        if (rep != null) {
            RepositoryManager.getInstance(null).removeRepository((Repository)rep);
        }
        if (removeLibPath) {
            try {
                PluginInitHDF5.removeLibraryPath(libDir.getAbsolutePath());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Field libs = ClassLoader.class.getDeclaredField("nativeLibraries");
                libs.setAccessible(true);
                libs.set(PluginInitHDF5.class.getClassLoader(), new Vector());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void removeLibraryPath(String pathToRemove) throws Exception {
        Field usrPathsField = ClassLoader.class.getDeclaredField("usr_paths");
        usrPathsField.setAccessible(true);
        String[] paths = (String[])usrPathsField.get(null);
        int i = 0;
        for (String path : paths) {
            if (path.equals(pathToRemove)) break;
            ++i;
        }
        if (i == paths.length) {
            return;
        }
        String[] newPaths = new String[paths.length - 1];
        if (i > 0) {
            System.arraycopy(paths, 0, newPaths, 0, i);
        }
        if (i < newPaths.length) {
            System.arraycopy(paths, i + 1, newPaths, i, newPaths.length - i);
        }
        usrPathsField.set(null, newPaths);
    }
}

