/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.FileFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScalarDS
extends Dataset {
    private static final long serialVersionUID = 8925371455928203981L;
    private static final Logger log = LoggerFactory.getLogger(ScalarDS.class);
    public static final int INTERLACE_PIXEL = 0;
    public static final int INTERLACE_LINE = 1;
    public static final int INTERLACE_PLANE = 2;
    protected int interlace = -1;
    protected double[] imageDataRange;
    protected byte[][] palette = null;
    protected boolean isImage = false;
    protected boolean isTrueColor = false;
    protected boolean isText = false;
    protected boolean isUnsigned = false;
    protected boolean unsignedConverted;
    protected Object fillValue = null;
    private List<Number> filteredImageValues;
    protected boolean isImageDisplay;
    protected boolean isDefaultImageOrder;
    public boolean isFillValueConverted;

    public ScalarDS(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    @Deprecated
    public ScalarDS(FileFormat fileFormat, String string, String string2, long[] lArray) {
        super(fileFormat, string, string2, lArray);
        this.datatype = null;
        this.imageDataRange = null;
        this.isImageDisplay = false;
        this.isDefaultImageOrder = true;
        this.isFillValueConverted = false;
        this.filteredImageValues = new Vector<Number>();
    }

    @Override
    public void clearData() {
        super.clearData();
        this.unsignedConverted = false;
    }

    public Object convertFromUnsignedC() {
        log.trace("convertFromUnsignedC: start");
        if (this.data != null && this.isUnsigned && !this.unsignedConverted) {
            log.trace("convertFromUnsignedC: convert");
            this.originalBuf = this.data;
            this.data = this.convertedBuf = ScalarDS.convertFromUnsignedC(this.originalBuf, this.convertedBuf);
            this.unsignedConverted = true;
            if (this.fillValue != null && !this.isFillValueConverted) {
                this.fillValue = ScalarDS.convertFromUnsignedC(this.fillValue, null);
                this.isFillValueConverted = true;
            }
        }
        log.trace("convertFromUnsignedC: finish");
        return this.data;
    }

    public Object convertToUnsignedC() {
        if (this.data != null && this.isUnsigned) {
            this.convertedBuf = this.data;
            this.data = this.originalBuf = ScalarDS.convertToUnsignedC(this.convertedBuf, this.originalBuf);
        }
        return this.data;
    }

    public abstract byte[][] getPalette();

    public final void setPalette(byte[][] byArray) {
        this.palette = byArray;
    }

    public abstract byte[][] readPalette(int var1);

    public String getPaletteName(int n) {
        String string = "Default ";
        if (n != 0) {
            string = "Default " + n;
        }
        return string;
    }

    public abstract byte[] getPaletteRefs();

    public final boolean isImage() {
        return this.isImage;
    }

    public final boolean isImageDisplay() {
        return this.isImageDisplay;
    }

    public final boolean isDefaultImageOrder() {
        return this.isDefaultImageOrder;
    }

    public final void setIsImageDisplay(boolean bl) {
        this.isImageDisplay = bl;
        if (this.isImageDisplay) {
            this.enumConverted = false;
        }
    }

    public final void setIsImage(boolean bl) {
        this.isImage = bl;
        if (this.isImage) {
            this.enumConverted = false;
        }
    }

    public final void setImageDataRange(double d, double d2) {
        if (d2 <= d) {
            return;
        }
        if (this.imageDataRange == null) {
            this.imageDataRange = new double[2];
        }
        this.imageDataRange[0] = d;
        this.imageDataRange[1] = d2;
    }

    public void addFilteredImageValue(Number number) {
        Iterator<Number> iterator = this.filteredImageValues.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().toString().equals(number.toString())) continue;
            return;
        }
        this.filteredImageValues.add(number);
    }

    public List<Number> getFilteredImageValues() {
        return this.filteredImageValues;
    }

    public final boolean isTrueColor() {
        return this.isTrueColor;
    }

    public final boolean isText() {
        return this.isText;
    }

    public final int getInterlace() {
        return this.interlace;
    }

    public final boolean isUnsigned() {
        return this.isUnsigned;
    }

    public double[] getImageDataRange() {
        return this.imageDataRange;
    }

    public final Object getFillValue() {
        return this.fillValue;
    }
}

