/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object;

import java.io.Serializable;
import ncsa.hdf.object.DataFormat;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;

public abstract class HObject
implements Serializable,
DataFormat {
    private static final long serialVersionUID = -1723666708199882519L;
    public static final String separator = "/";
    private String filename;
    protected final FileFormat fileFormat;
    private String name;
    private String path;
    private String fullName;
    protected long[] oid;
    protected String linkTargetObjName;

    public HObject() {
        this(null, null, null, null);
    }

    public HObject(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    @Deprecated
    public HObject(FileFormat fileFormat, String string, String string2, long[] lArray) {
        this.fileFormat = fileFormat;
        this.oid = lArray;
        this.filename = this.fileFormat != null ? this.fileFormat.getFilePath() : null;
        if (string == null && string2 != null) {
            if (string2.equals(separator)) {
                string = separator;
                string2 = null;
            } else {
                if (!string2.startsWith(separator)) {
                    string2 = separator + string2;
                }
                if (string2.endsWith(separator)) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                string = string2.substring(string2.lastIndexOf(separator) + 1);
                string2 = string2.substring(0, string2.lastIndexOf(separator));
            }
        } else if (string != null && string2 == null && string.indexOf(separator) >= 0) {
            if (string.equals(separator)) {
                string = separator;
                string2 = null;
            } else {
                int n;
                if (!string.startsWith(separator)) {
                    string = separator + string;
                }
                int n2 = string.length();
                if (string.endsWith(separator)) {
                    string = string.substring(0, n2 - 1);
                }
                if ((n = string.lastIndexOf(separator)) < 0) {
                    string2 = separator;
                } else {
                    string2 = string.substring(0, n);
                    string = string.substring(n + 1);
                }
            }
        }
        if (string2 != null && !(string2 = string2.replaceAll("//", separator)).endsWith(separator)) {
            string2 = string2 + separator;
        }
        this.name = string;
        this.path = string2;
        this.fullName = string2 != null ? string2 + string : (string == null ? separator : (string.startsWith(separator) ? string : separator + string));
    }

    protected final void debug(Object object) {
        System.out.println("*** " + this.getClass().getName() + ": " + object);
    }

    @Override
    public final String getFile() {
        return this.filename;
    }

    public final String getName() {
        return this.name;
    }

    public final String getLinkTargetObjName() {
        return this.linkTargetObjName;
    }

    public final void setLinkTargetObjName(String string) {
        this.linkTargetObjName = string;
    }

    public final String getFullName() {
        return this.fullName;
    }

    public final String getPath() {
        return this.path;
    }

    public void setName(String string) throws Exception {
        if (string != null) {
            if (string.equals(separator)) {
                throw new IllegalArgumentException("The new name cannot be the root");
            }
            if (string.startsWith(separator)) {
                string = string.substring(1);
            }
            if (string.endsWith(separator)) {
                string = string.substring(0, string.length() - 2);
            }
            if (string.contains(separator)) {
                throw new IllegalArgumentException("The new name contains the separator character: /");
            }
        }
        this.name = string;
    }

    public void setPath(String string) throws Exception {
        if (string == null) {
            string = separator;
        }
        this.path = string;
    }

    public abstract int open();

    public abstract void close(int var1);

    public final int getFID() {
        if (this.fileFormat != null) {
            return this.fileFormat.getFID();
        }
        return -1;
    }

    public final boolean equalsOID(long[] lArray) {
        if (lArray == null || this.oid == null) {
            return false;
        }
        int n = lArray.length;
        int n2 = this.oid.length;
        if (n == 0 || n2 == 0) {
            return false;
        }
        int n3 = Math.min(n, n2);
        boolean bl = lArray[0] == this.oid[0];
        for (int i = 1; bl && i < n3; ++i) {
            bl = lArray[i] == this.oid[i];
        }
        return bl;
    }

    public final FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public final long[] getOID() {
        if (this.oid == null) {
            return null;
        }
        return (long[])this.oid.clone();
    }

    public String toString() {
        if (this instanceof Group && ((Group)this).isRoot() && this.getFileFormat() != null) {
            return this.getFileFormat().getName();
        }
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }
}

