/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.hdf5;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SimpleExampleSet;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.hdf5.HDF5DatasetExampleTable;
import com.rapidminer.hdf5.HDF5MetaDataProvider;
import com.rapidminer.hdf5.util.Compatiblity;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.AbstractReader;
import com.rapidminer.operator.nio.model.AbstractDataResultSetReader;
import com.rapidminer.operator.nio.model.DataResultSetFactory;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.CollectionMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.MetaDataProvider;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeAttributes;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.h5.H5File;

public class HDF5Reader
extends AbstractDataResultSetReader {
    public static final String PARAMETER_HDF_FILE = "hdf5_file";
    public static final String[] HDF5_EXTENSIONS = new String[]{"hdf5", "hd5", "h5"};
    public static final String PARAMETER_FILTER_TYPE = "table_filter_type";
    public static final String[] CONDITION_NAMES = new String[]{"single", "subset", "all"};
    public static final String PARAMETER_TABLES_SELECTION = "tables";
    public static final String PARAMETER_TABLE_SELECTION = "table";
    public static final String PARAMETER_INVERT_SELECTION = "invert";
    public static final String PARAMETER_JOIN_ATTRIBUTES = "join_attributes";
    public static final String PARAMETER_MEMORY = "in_memory";
    private Vector<String> tableNames;
    private Vector<String> joinAtts;
    private File currentFile;
    private Group currentRoot;
    private H5File currentHDF5File;
    private List<String> tablesSelected;
    private List<String> joinSelected;
    MetaDataProvider mdProvider = new HDF5MetaDataProvider(this);
    private boolean cacheable = false;

    public HDF5Reader(OperatorDescription description) {
        super(description);
        this.getFileInputPort().addObserver((Observer)new Observer<Port>(){
            private boolean isConnected;
            {
                this.isConnected = HDF5Reader.this.getFileInputPort().isConnected();
            }

            public void update(Observable<Port> observable, Port port) {
                boolean connectionChanged;
                boolean bl = connectionChanged = this.isConnected != port.isConnected();
                if (!connectionChanged) {
                    return;
                }
                this.isConnected = !this.isConnected;
                InputPort fip = (InputPort)port;
                if (this.isConnected) {
                    OutputPort fop = fip.getSource();
                    IOObject obj = fop.getAnyDataOrNull();
                    if (obj != null) {
                        fip.receive(obj);
                        HDF5Reader.this.processFileChange();
                    } else {
                        MetaData md = null;
                        try {
                            md = Compatiblity.getDefault().getMetaData((Port)fop, MetaData.class);
                            fip.receiveMD(md);
                            HDF5Reader.this.processFileChange();
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    fip.receive(null);
                    HDF5Reader.this.processFileChange();
                }
            }
        }, false);
        this.getFileInputPort().registerMetaDataChangeListener(newMetadata -> this.processFileChange());
        this.getParameters().addObserverAsFirst((parameters, param) -> {
            if (param == null) {
                return;
            }
            switch (param) {
                case "hdf5_file": {
                    this.processFileChange();
                    return;
                }
                case "join_attributes": {
                    this.createJoinList();
                    return;
                }
                case "table_filter_type": 
                case "table": 
                case "tables": 
                case "invert": {
                    try {
                        this.createTableList();
                    }
                    catch (UndefinedParameterError undefinedParameterError) {
                        // empty catch block
                    }
                    return;
                }
            }
        }, false);
    }

    private void processFileChange() {
        File newFile;
        if (this.isFileSpecified()) {
            try {
                newFile = this.getSelectedFile();
            }
            catch (Exception e) {
                newFile = null;
            }
        } else {
            newFile = null;
        }
        if (newFile == null || !newFile.exists() || newFile.isDirectory()) {
            if (this.currentFile != null) {
                try {
                    this.currentHDF5File.close();
                }
                catch (HDF5Exception e) {
                    // empty catch block
                }
                this.cacheable = false;
            }
            this.currentFile = null;
            this.currentHDF5File = null;
            this.currentRoot = null;
            this.createParameterLists();
            try {
                this.createTableList();
            }
            catch (UndefinedParameterError e) {
                // empty catch block
            }
            System.gc();
            return;
        }
        if (newFile.equals(this.currentFile)) {
            return;
        }
        this.currentFile = newFile;
        this.currentHDF5File = HDF5Reader.getHDF5File(this.currentFile);
        if (this.currentHDF5File == null) {
            this.currentRoot = null;
            this.createParameterLists();
            try {
                this.createTableList();
            }
            catch (UndefinedParameterError e) {
                // empty catch block
            }
            this.cacheable = false;
            System.gc();
            return;
        }
        try {
            this.currentHDF5File.open();
        }
        catch (Exception e) {
            // empty catch block
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.currentHDF5File.getRootNode();
        this.currentRoot = (Group)root.getUserObject();
        this.createParameterLists();
        try {
            this.createTableList();
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        this.cacheable = false;
        System.gc();
    }

    private static H5File getHDF5File(File f) {
        H5File h5File;
        FileFormat format = FileFormat.getFileFormat("HDF5");
        if (format == null) {
            return null;
        }
        try {
            h5File = (H5File)format.createFile(f.getAbsolutePath(), 20);
        }
        catch (Exception e) {
            return null;
        }
        try {
            h5File.open();
            h5File.close();
        }
        catch (Exception e) {
            return null;
        }
        return h5File;
    }

    private void createParameterLists() {
        this.tableNames.clear();
        this.joinAtts.clear();
        if (this.currentHDF5File == null) {
            return;
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        groups.add(this.currentRoot);
        while (!groups.isEmpty()) {
            Group group = (Group)groups.remove(0);
            List<HObject> members = group.getMemberList();
            for (HObject obj : members) {
                if (obj instanceof Group) {
                    groups.add((Group)obj);
                    continue;
                }
                if (!(obj instanceof Dataset)) continue;
                this.tableNames.add(obj.getFullName());
                ((Dataset)obj).init();
                if (!(obj instanceof CompoundDS)) continue;
                List<String> attributes = Arrays.asList(((CompoundDS)obj).getMemberNames());
                if (this.joinAtts.isEmpty()) {
                    this.joinAtts.addAll(attributes);
                    continue;
                }
                this.joinAtts.retainAll(attributes);
            }
        }
        MainFrame mf = RapidMinerGUI.getMainFrame();
        if (mf != null) {
            mf.getPropertyPanel().invalidate();
        }
    }

    private void createTableList() throws UndefinedParameterError {
        this.tablesSelected = new ArrayList<String>();
        this.cacheable = false;
        ArrayList<String> subset = new ArrayList<String>();
        int filterType = this.getParameterAsInt(PARAMETER_FILTER_TYPE);
        boolean invert = false;
        boolean all = false;
        switch (filterType) {
            case 0: {
                this.tablesSelected.add(this.getParameter(PARAMETER_TABLE_SELECTION));
                return;
            }
            case 1: {
                invert = this.getParameterAsBoolean(PARAMETER_INVERT_SELECTION);
                subset.addAll(Arrays.asList(this.getParameterAsString(PARAMETER_TABLES_SELECTION).split("\\|")));
                subset.remove("");
                break;
            }
            case 2: {
                all = true;
            }
        }
        if (this.currentRoot == null || this.tableNames == null || this.tableNames.isEmpty()) {
            if (!all && !invert) {
                this.tablesSelected.addAll(subset);
            }
            return;
        }
        if (all || invert) {
            this.tablesSelected.addAll(this.tableNames);
        }
        if (invert) {
            this.tablesSelected.removeAll(subset);
        } else {
            this.tablesSelected.addAll(subset);
        }
    }

    private void createJoinList() {
        String joins;
        try {
            joins = this.getParameterAsString(PARAMETER_JOIN_ATTRIBUTES);
        }
        catch (UndefinedParameterError e) {
            this.joinSelected = null;
            return;
        }
        this.joinSelected = new ArrayList<String>(Arrays.asList(joins.split("\\|")));
        this.joinSelected.remove("");
    }

    protected boolean isMetaDataCacheable() {
        return this.cacheable;
    }

    public MetaData getGeneratedMetaData() throws OperatorException {
        ExampleSetMetaData md = new ExampleSetMetaData();
        int filterType = this.getParameterAsInt(PARAMETER_FILTER_TYPE);
        if (this.tablesSelected != null && !this.tablesSelected.isEmpty() && this.currentHDF5File != null) {
            Dataset ds = null;
            String tableName = this.tablesSelected.get(0);
            try {
                ds = (Dataset)this.currentHDF5File.get(tableName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ds != null) {
                SimpleExampleSet es = new SimpleExampleSet((ExampleTable)new HDF5DatasetExampleTable(ds, this.joinSelected != null ? this.joinSelected : new ArrayList<String>()));
                if (this.currentFile != null) {
                    es.getAnnotations().setAnnotation("Source", tableName);
                    es.getAnnotations().setAnnotation("Filename", this.currentFile.getAbsolutePath());
                }
                md = new ExampleSetMetaData((ExampleSet)es, true);
            }
        }
        if (filterType > 0 && (this.tablesSelected == null || this.tablesSelected.size() != 1)) {
            md = new CollectionMetaData((MetaData)md);
            if (this.currentFile != null) {
                md.getAnnotations().setAnnotation("Filename", this.currentFile.getAbsolutePath());
            }
        }
        this.cacheable = true;
        return md;
    }

    public void doWork() throws OperatorException {
        IOObject result;
        if (this.checkProperties() > 0) {
            throw new OperatorException("Not all mandatory parameters are set.");
        }
        this.processFileChange();
        if (this.currentHDF5File == null) {
            throw new OperatorException("Could not read file " + this.currentFile.getName() + " as HDF5.");
        }
        if (this.tablesSelected == null || this.tablesSelected.isEmpty()) {
            throw new OperatorException("No tables were selected to read!");
        }
        if (this.joinSelected == null) {
            this.createJoinList();
        }
        boolean inMem = this.getParameterAsBoolean(PARAMETER_MEMORY);
        ArrayList<ExampleSet> exampleSets = new ArrayList<ExampleSet>();
        for (String tableName : this.tablesSelected) {
            Dataset dataSet;
            try {
                dataSet = (Dataset)this.currentHDF5File.get(tableName);
                if (dataSet == null) {
                    throw new NullPointerException("Data set must not be null");
                }
            }
            catch (Exception e) {
                throw new OperatorException("Dataset " + tableName + " does not exist or could not be read from file " + this.currentFile.getAbsolutePath(), (Throwable)e);
            }
            ExampleSet exampleSet = new HDF5DatasetExampleTable(dataSet, this.joinSelected).createInMemory(inMem).createExampleSet();
            exampleSets.add(exampleSet);
        }
        if (exampleSets.size() == 1) {
            result = (IOObject)exampleSets.get(0);
        } else {
            Collections.sort(exampleSets, (o1, o2) -> -o1.size() * o1.getAttributes().allSize() + o2.size() * o2.getAttributes().allSize());
            result = new IOObjectCollection(exampleSets);
            result.getAnnotations().setAnnotation("Source", this.currentFile.getAbsolutePath());
        }
        OutputPort output = (OutputPort)this.getOutputPorts().getPortByName("output");
        output.deliver(result);
    }

    protected DataResultSetFactory getDataResultSetFactory() throws OperatorException {
        return null;
    }

    protected NumberFormat getNumberFormat() throws OperatorException {
        return null;
    }

    protected String getFileParameterName() {
        return PARAMETER_HDF_FILE;
    }

    protected String getFileExtension() {
        return HDF5_EXTENSIONS[0];
    }

    protected String[] getFileExtensions() {
        return HDF5_EXTENSIONS;
    }

    public List<ParameterType> getParameterTypes() {
        if (this.tableNames == null) {
            this.tableNames = new Vector();
        }
        if (this.joinAtts == null) {
            this.joinAtts = new Vector();
        }
        if (this.mdProvider == null) {
            this.mdProvider = new HDF5MetaDataProvider(this);
        }
        ArrayList<ParameterType> types = new ArrayList<ParameterType>();
        types.add(this.makeFileParameterType());
        types.add((ParameterType)new ParameterTypeCategory(PARAMETER_FILTER_TYPE, "The condition specifies which tables are selected or affected by this operator.", CONDITION_NAMES, 0, false));
        Object type = new ParameterTypeAttribute(PARAMETER_TABLE_SELECTION, "The table that should be read", this.mdProvider, true, new int[0]){
            private static final long serialVersionUID = -550879138088370843L;

            public Vector<String> getAttributeNames() {
                return HDF5Reader.this.tableNames;
            }
        };
        type.setExpert(false);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_FILTER_TYPE, CONDITION_NAMES, true, new int[]{0}));
        types.add((ParameterType)type);
        type = new ParameterTypeAttributes(PARAMETER_TABLES_SELECTION, "The list of tables that should be read", null, true){
            private static final long serialVersionUID = 6960672500033948907L;

            public Vector<String> getAttributeNames() {
                return HDF5Reader.this.tableNames;
            }
        };
        type.setExpert(false);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_FILTER_TYPE, CONDITION_NAMES, false, new int[]{1}));
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean(PARAMETER_INVERT_SELECTION, "Select if all the tables except the selected should be read.", false, false);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_FILTER_TYPE, CONDITION_NAMES, false, new int[]{1}));
        types.add((ParameterType)type);
        type = new ParameterTypeAttributes(PARAMETER_JOIN_ATTRIBUTES, "Select which attributes should not be renamed to make a join possible.", null, true){
            private static final long serialVersionUID = 3699392159011210844L;

            public Vector<String> getAttributeNames() {
                return HDF5Reader.this.joinAtts;
            }
        };
        type.setExpert(false);
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_MEMORY, "Select if the selected table(s) should be completely loaded to memory. This will detach the table(s) from the hdf file.", false));
        return types;
    }

    protected void finalize() throws Throwable {
        if (this.currentHDF5File != null) {
            this.currentHDF5File.close();
        }
        super.finalize();
    }

    static {
        for (String extension : HDF5_EXTENSIONS) {
            HDF5Reader.registerReaderDescription((AbstractReader.ReaderDescription)new AbstractReader.ReaderDescription(extension, HDF5Reader.class, PARAMETER_HDF_FILE));
        }
    }
}

