/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.hdf5;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class HDF5Attribute
implements Serializable {
    private static final long serialVersionUID = -3003938095081897862L;
    private int[] index;
    private int order;
    private List<Integer> RM2HDF;

    public HDF5Attribute(int[] index, int order, List<Integer> RM2HDF) {
        this.index = index;
        this.order = order;
        this.RM2HDF = RM2HDF;
    }

    public HDF5Attribute(int[] index, List<Integer> RM2HDF) {
        this(index, 0, RM2HDF);
    }

    public HDF5Attribute(int[] index, int order) {
        this(index, order, null);
    }

    public HDF5Attribute(int[] index) {
        this(index, 0);
    }

    public boolean isArray() {
        return this.index.length > 1;
    }

    public boolean isPolynominal() {
        return this.RM2HDF != null;
    }

    public int getIndex() {
        return this.index[0];
    }

    public int[] getSubindices(int row) {
        if (!this.isArray()) {
            return new int[1];
        }
        int[] subIndices = Arrays.copyOfRange(this.index, 1, this.index.length);
        subIndices[0] = subIndices[0] + row * this.order;
        return subIndices;
    }

    protected void setIndex(int[] index) {
        this.index = index;
    }

    public int map2RM(int index) {
        if (this.RM2HDF != null) {
            return this.RM2HDF.indexOf(index);
        }
        return index;
    }

    public int map2HDF(int index) {
        if (this.RM2HDF != null) {
            return this.RM2HDF.get(index);
        }
        return index;
    }
}

