/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5DataFiltersException;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import ncsa.hdf.hdf5lib.structs.H5O_info_t;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.object.h5.H5Datatype;
import ncsa.hdf.object.h5.H5File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H5ScalarDS
extends ScalarDS {
    private static final long serialVersionUID = 2887517608230611642L;
    private static final Logger log = LoggerFactory.getLogger(H5ScalarDS.class);
    private List<Attribute> attributeList;
    private int nAttributes = -1;
    private H5O_info_t obj_info;
    private byte[] paletteRefs;
    private boolean isVLEN = false;
    private boolean isEnum = false;
    private boolean isExternal = false;
    private boolean isArrayOfCompound = false;
    private boolean isArrayOfVLEN = false;
    private boolean isNativeDatatype = false;
    private boolean isRegRef = false;

    public H5ScalarDS(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    @Deprecated
    public H5ScalarDS(FileFormat fileFormat, String string, String string2, long[] lArray) {
        super(fileFormat, string, string2, lArray);
        this.unsignedConverted = false;
        this.paletteRefs = null;
        this.obj_info = new H5O_info_t(-1L, -1L, 0, 0, -1L, 0L, 0L, 0L, 0L, null, null, null);
        if (lArray == null && fileFormat != null) {
            try {
                byte[] byArray = H5.H5Rcreate(fileFormat.getFID(), this.getFullName(), HDF5Constants.H5R_OBJECT, -1);
                this.oid = new long[1];
                this.oid[0] = HDFNativeData.byteToLong(byArray, 0);
            }
            catch (Exception exception) {
                log.debug("constructor ID {} for {} failed H5Rcreate", (Object)fileFormat.getFID(), (Object)this.getFullName());
            }
        }
    }

    @Override
    public int open() {
        int n = -1;
        try {
            n = H5.H5Dopen(this.getFID(), this.getPath() + this.getName(), HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5Exception hDF5Exception) {
            log.debug("Failed to open dataset {}", (Object)(this.getPath() + this.getName()));
            n = -1;
        }
        return n;
    }

    @Override
    public void close(int n) {
        if (n >= 0) {
            try {
                H5.H5Fflush(n, HDF5Constants.H5F_SCOPE_LOCAL);
            }
            catch (Exception exception) {
                log.debug("close.H5Fflush:", (Throwable)exception);
            }
            try {
                H5.H5Dclose(n);
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("close.H5Dclose:", (Throwable)hDF5Exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.rank > 0) {
            this.resetSelection();
            return;
        }
        log.trace("init() start");
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        n = this.open();
        if (n >= 0) {
            int n5 = -1;
            try {
                n5 = H5.H5Dget_create_plist(n);
                int n6 = H5.H5Pget_external_count(n5);
                this.isExternal = n6 > 0;
            }
            catch (Exception exception) {
                log.debug("check if it is an external dataset:", (Throwable)exception);
            }
            finally {
                try {
                    H5.H5Pclose(n5);
                }
                catch (Exception exception) {
                    log.debug("finally close:", (Throwable)exception);
                }
            }
            this.paletteRefs = this.getPaletteRefs(n);
            try {
                block60: {
                    int n7;
                    n2 = H5.H5Dget_space(n);
                    this.rank = H5.H5Sget_simple_extent_ndims(n2);
                    n3 = H5.H5Dget_type(n);
                    n4 = H5.H5Tget_class(n3);
                    int n8 = 0;
                    if (n4 == HDF5Constants.H5T_ARRAY) {
                        int n9 = H5.H5Tget_super(n3);
                        n7 = H5.H5Tget_class(n9);
                        this.isArrayOfCompound = n7 == HDF5Constants.H5T_COMPOUND;
                        this.isArrayOfVLEN = n7 == HDF5Constants.H5T_VLEN;
                    }
                    this.isText = n4 == HDF5Constants.H5T_STRING;
                    this.isVLEN = n4 == HDF5Constants.H5T_VLEN || H5.H5Tis_variable_str(n3);
                    this.isEnum = n4 == HDF5Constants.H5T_ENUM;
                    this.isUnsigned = H5Datatype.isUnsigned(n3);
                    this.isRegRef = H5.H5Tequal(n3, HDF5Constants.H5T_STD_REF_DSETREG);
                    log.debug("init() tid={} is tclass={} has isText={} : isVLEN={} : isEnum={} : isUnsigned={} : isRegRef={}", new Object[]{n3, n4, this.isText, this.isVLEN, this.isEnum, this.isUnsigned, this.isRegRef});
                    try {
                        n8 = H5.H5Tget_native_type(n3);
                        this.isNativeDatatype = H5.H5Tequal(n3, n8);
                        log.trace("init() isNativeDatatype={}", (Object)this.isNativeDatatype);
                        n5 = H5.H5Dget_create_plist(n);
                        int[] nArray = new int[]{0};
                        if (H5.H5Pfill_value_defined(n5, nArray) < 0 || nArray[0] != HDF5Constants.H5D_FILL_VALUE_USER_DEFINED) break block60;
                        this.fillValue = H5Datatype.allocateArray(n8, 1);
                        log.trace("init() fillValue={}", this.fillValue);
                        try {
                            H5.H5Pget_fill_value(n5, n8, this.fillValue);
                            log.trace("init() H5Pget_fill_value={}", this.fillValue);
                            if (this.fillValue != null) {
                                if (this.isFillValueConverted) {
                                    this.fillValue = ScalarDS.convertToUnsignedC(this.fillValue, null);
                                }
                                n7 = Array.getLength(this.fillValue);
                                for (int i = 0; i < n7; ++i) {
                                    this.addFilteredImageValue((Number)Array.get(this.fillValue, i));
                                }
                            }
                        }
                        catch (Exception exception) {
                            log.debug("fill value was defined :", (Throwable)exception);
                            this.fillValue = null;
                        }
                    }
                    catch (HDF5Exception hDF5Exception) {
                        log.debug("check if datatype in file is native datatype :", (Throwable)hDF5Exception);
                    }
                    finally {
                        try {
                            H5.H5Tclose(n8);
                        }
                        catch (HDF5Exception hDF5Exception) {
                            log.debug("finally close:", (Throwable)hDF5Exception);
                        }
                        try {
                            H5.H5Pclose(n5);
                        }
                        catch (Exception exception) {
                            log.debug("finally close:", (Throwable)exception);
                        }
                    }
                }
                if (this.rank == 0) {
                    this.rank = 1;
                    this.dims = new long[1];
                    this.dims[0] = 1L;
                } else {
                    this.dims = new long[this.rank];
                    this.maxDims = new long[this.rank];
                    H5.H5Sget_simple_extent_dims(n2, this.dims, this.maxDims);
                }
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("init():", (Throwable)hDF5Exception);
            }
            finally {
                try {
                    H5.H5Tclose(n3);
                }
                catch (HDF5Exception hDF5Exception) {
                    log.debug("finally close:", (Throwable)hDF5Exception);
                }
                try {
                    H5.H5Sclose(n2);
                }
                catch (HDF5Exception hDF5Exception) {
                    log.debug("finally close:", (Throwable)hDF5Exception);
                }
            }
            if (this.rank >= 3 && this.isImage) {
                this.interlace = -1;
                this.isTrueColor = this.isStringAttributeOf(n, "IMAGE_SUBCLASS", "IMAGE_TRUECOLOR");
                if (this.isTrueColor) {
                    this.interlace = 0;
                    if (this.isStringAttributeOf(n, "INTERLACE_MODE", "INTERLACE_PLANE")) {
                        this.interlace = 2;
                    }
                }
            }
            this.close(n);
        } else {
            log.debug("init() failed to open dataset");
        }
        this.startDims = new long[this.rank];
        this.selectedDims = new long[this.rank];
        log.trace("init() finish");
        this.resetSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAttribute() {
        this.obj_info.num_attrs = this.nAttributes;
        log.trace("hasAttribute start: nAttributes = {}", (Object)this.nAttributes);
        if (this.obj_info.num_attrs < 0L) {
            int n = this.open();
            if (n >= 0) {
                int n2 = -1;
                this.obj_info.num_attrs = 0L;
                try {
                    this.obj_info = H5.H5Oget_info(n);
                    this.nAttributes = (int)this.obj_info.num_attrs;
                    n2 = H5.H5Dget_type(n);
                    int n3 = H5.H5Tget_class(n2);
                    this.isText = n3 == HDF5Constants.H5T_STRING;
                    this.isVLEN = n3 == HDF5Constants.H5T_VLEN || H5.H5Tis_variable_str(n2);
                    this.isEnum = n3 == HDF5Constants.H5T_ENUM;
                    log.trace("hasAttribute: obj_info.num_attrs={} with tclass type: isText={},isVLEN={},isEnum={}", new Object[]{this.nAttributes, this.isText, this.isVLEN, this.isEnum});
                }
                catch (Exception exception) {
                    this.obj_info.num_attrs = 0L;
                    log.debug("hasAttribute: get object info:", (Throwable)exception);
                }
                finally {
                    try {
                        H5.H5Tclose(n2);
                    }
                    catch (HDF5Exception hDF5Exception) {}
                }
                Object object = this.getAttrValue(n, "CLASS");
                if (object != null) {
                    try {
                        this.isImageDisplay = this.isImage = "IMAGE".equalsIgnoreCase(new String((byte[])object).trim());
                        log.trace("hasAttribute: isImageDisplay dataset: {} with value = {}", (Object)this.isImageDisplay, object);
                    }
                    catch (Throwable throwable) {
                        log.debug("check image:", throwable);
                    }
                }
                if ((object = this.getAttrValue(n, "IMAGE_MINMAXRANGE")) != null) {
                    double d = 0.0;
                    double d2 = 0.0;
                    try {
                        d = Double.valueOf(Array.get(object, 0).toString());
                        d2 = Double.valueOf(Array.get(object, 1).toString());
                    }
                    catch (Exception exception) {
                        d2 = 0.0;
                        d = 0.0;
                    }
                    if (d2 > d) {
                        this.imageDataRange = new double[2];
                        this.imageDataRange[0] = d;
                        this.imageDataRange[1] = d2;
                    }
                }
                try {
                    this.checkCFconvention(n);
                }
                catch (Exception exception) {
                    log.debug("checkCFconvention({}):", (Object)n, (Object)exception);
                }
                this.close(n);
            } else {
                log.debug("could not open dataset");
            }
        }
        log.trace("hasAttribute exit");
        return this.obj_info.num_attrs > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datatype getDatatype() {
        if (this.datatype == null) {
            log.trace("H5ScalarDS getDatatype: datatype == null");
            int n = -1;
            int n2 = -1;
            n = this.open();
            if (n >= 0) {
                try {
                    n2 = H5.H5Dget_type(n);
                    log.trace("H5ScalarDS getDatatype: isNativeDatatype", (Object)this.isNativeDatatype);
                    if (!this.isNativeDatatype) {
                        int n3 = -1;
                        try {
                            n3 = n2;
                            n2 = H5.H5Tget_native_type(n3);
                        }
                        finally {
                            try {
                                H5.H5Tclose(n3);
                            }
                            catch (Exception exception) {
                                log.debug("finally close:", (Throwable)exception);
                            }
                        }
                    }
                    this.datatype = new H5Datatype(n2);
                }
                catch (Exception exception) {
                    log.debug("new H5Datatype:", (Throwable)exception);
                }
                finally {
                    try {
                        H5.H5Tclose(n2);
                    }
                    catch (HDF5Exception hDF5Exception) {
                        log.debug("finally close:", (Throwable)hDF5Exception);
                    }
                    try {
                        H5.H5Dclose(n);
                    }
                    catch (HDF5Exception hDF5Exception) {
                        log.debug("finally close:", (Throwable)hDF5Exception);
                    }
                }
            }
        }
        return this.datatype;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.attributeList != null) {
            ((Vector)this.attributeList).setSize(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readBytes() throws HDF5Exception {
        int n;
        byte[] byArray = null;
        log.trace("H5ScalarDS readBytes: start");
        if (this.rank <= 0) {
            this.init();
        }
        if ((n = this.open()) >= 0) {
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            try {
                int n5;
                long[] lArray = new long[]{1L};
                for (n5 = 0; n5 < this.selectedDims.length; ++n5) {
                    lArray[0] = lArray[0] * this.selectedDims[n5];
                }
                n2 = H5.H5Dget_space(n);
                n3 = H5.H5Screate_simple(this.rank, this.selectedDims, null);
                if ((long)this.rank * this.dims[0] > 1L) {
                    H5.H5Sselect_hyperslab(n2, HDF5Constants.H5S_SELECT_SET, this.startDims, this.selectedStride, this.selectedDims, null);
                }
                n4 = H5.H5Dget_type(n);
                n5 = H5.H5Tget_size(n4) * (int)lArray[0];
                log.trace("H5ScalarDS readBytes: size = {}", (Object)n5);
                byArray = new byte[n5];
                H5.H5Dread(n, n4, n3, n2, HDF5Constants.H5P_DEFAULT, byArray);
            }
            finally {
                try {
                    H5.H5Sclose(n2);
                }
                catch (Exception exception) {
                    log.debug("finally close:", (Throwable)exception);
                }
                try {
                    H5.H5Sclose(n3);
                }
                catch (Exception exception) {
                    log.debug("finally close:", (Throwable)exception);
                }
                try {
                    H5.H5Tclose(n4);
                }
                catch (HDF5Exception hDF5Exception) {
                    log.debug("finally close:", (Throwable)hDF5Exception);
                }
                this.close(n);
            }
        }
        log.trace("H5ScalarDS readBytes: finish");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read() throws Exception {
        Object object = null;
        int n = -1;
        int n2 = -1;
        int[] nArray = new int[]{-1, -1};
        log.trace("H5ScalarDS read: start");
        if (this.rank <= 0) {
            this.init();
        }
        if (this.isArrayOfCompound) {
            throw new HDF5Exception("Cannot show data with datatype of ARRAY of COMPOUND.");
        }
        if (this.isArrayOfVLEN) {
            throw new HDF5Exception("Cannot show data with datatype of ARRAY of VL.");
        }
        if (this.isExternal) {
            String string = this.getFileFormat().getAbsoluteFile().getParent();
            if (string == null) {
                string = ".";
            }
            H5.H5Dchdir_ext(string);
        }
        boolean bl = false;
        long[] lArray = new long[]{1L};
        log.trace("H5ScalarDS read: open dataset");
        n = this.open();
        if (n >= 0) {
            try {
                lArray[0] = this.selectHyperslab(n, nArray);
                log.trace("H5ScalarDS read: opened dataset size {} for {}", (Object)lArray[0], (Object)this.nPoints);
                if (lArray[0] == 0L) {
                    throw new HDF5Exception("No data to read.\nEither the dataset or the selected subset is empty.");
                }
                if (log.isDebugEnabled()) {
                    try {
                        long l = H5.H5Dget_storage_size(n);
                        log.trace("Storage space allocated = {}.", (Object)l);
                    }
                    catch (Exception exception) {
                        log.debug("check if storage space is allocated:", (Throwable)exception);
                    }
                }
                n2 = H5.H5Dget_type(n);
                log.trace("H5ScalarDS read: H5Tget_native_type:");
                log.trace("H5ScalarDS read: isNativeDatatype={}", (Object)this.isNativeDatatype);
                if (!this.isNativeDatatype) {
                    int n3 = -1;
                    try {
                        n3 = n2;
                        n2 = H5.H5Tget_native_type(n3);
                    }
                    finally {
                        try {
                            H5.H5Tclose(n3);
                        }
                        catch (Exception exception) {
                            log.debug("finally close:", (Throwable)exception);
                        }
                    }
                }
                bl = H5.H5Tequal(n2, HDF5Constants.H5T_STD_REF_OBJ);
                log.trace("H5ScalarDS read: originalBuf={} isText={} isREF={} lsize[0]={} nPoints={}", new Object[]{this.originalBuf, this.isText, bl, lArray[0], this.nPoints});
                if (this.originalBuf == null || this.isEnum || this.isText || bl || this.originalBuf != null && lArray[0] != this.nPoints) {
                    try {
                        object = H5Datatype.allocateArray(n2, (int)lArray[0]);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new HDF5Exception("Out Of Memory.");
                    }
                } else {
                    object = this.originalBuf;
                }
                if (object != null) {
                    if (this.isVLEN) {
                        log.trace("H5ScalarDS read: H5DreadVL");
                        H5.H5DreadVL(n, n2, nArray[0], nArray[1], HDF5Constants.H5P_DEFAULT, object);
                    } else {
                        log.trace("H5ScalarDS read: H5Dread did={} spaceIDs[0]={} spaceIDs[1]={}", new Object[]{n, nArray[0], nArray[1]});
                        H5.H5Dread(n, n2, nArray[0], nArray[1], HDF5Constants.H5P_DEFAULT, object);
                    }
                }
            }
            catch (HDF5DataFiltersException hDF5DataFiltersException) {
                log.debug("H5ScalarDS read: read failure:", (Throwable)hDF5DataFiltersException);
                throw new Exception("Filter not available exception: " + hDF5DataFiltersException.getMessage(), hDF5DataFiltersException);
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("H5ScalarDS read: read failure", (Throwable)hDF5Exception);
                throw new HDF5Exception(hDF5Exception.toString());
            }
            finally {
                try {
                    if (HDF5Constants.H5S_ALL != nArray[0]) {
                        H5.H5Sclose(nArray[0]);
                    }
                }
                catch (Exception exception) {
                    log.debug("read: finally close:", (Throwable)exception);
                }
                try {
                    if (HDF5Constants.H5S_ALL != nArray[1]) {
                        H5.H5Sclose(nArray[1]);
                    }
                }
                catch (Exception exception) {
                    log.debug("read: finally close:", (Throwable)exception);
                }
                try {
                    if (this.isText && this.convertByteToString) {
                        log.trace("H5ScalarDS read: H5Dread convertByteToString");
                        object = H5ScalarDS.byteToString((byte[])object, H5.H5Tget_size(n2));
                    } else if (bl) {
                        log.trace("H5ScalarDS read: H5Dread isREF");
                        object = HDFNativeData.byteToLong((byte[])object);
                    } else if (this.isEnum && this.isEnumConverted()) {
                        log.trace("H5ScalarDS read: H5Dread isEnum theData={}", object);
                        object = H5Datatype.convertEnumValueToName(n2, object, null);
                    }
                }
                catch (Exception exception) {
                    log.debug("H5ScalarDS read: convert data:", (Throwable)exception);
                }
                try {
                    H5.H5Tclose(n2);
                }
                catch (Exception exception) {
                    log.debug("finally close:", (Throwable)exception);
                }
                this.close(n);
            }
        }
        log.trace("H5ScalarDS read: finish");
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Object object) throws HDF5Exception {
        log.trace("H5ScalarDS write: start");
        int n = -1;
        int n2 = -1;
        int[] nArray = new int[]{-1, -1};
        Object object2 = null;
        if (object == null) {
            return;
        }
        if (this.isVLEN && !this.isText) {
            log.trace("H5ScalarDS write: VL data={}", object);
            throw new HDF5Exception("Writing non-string variable-length data is not supported");
        }
        if (this.isRegRef) {
            throw new HDF5Exception("Writing region references data is not supported");
        }
        long[] lArray = new long[]{1L};
        n = this.open();
        log.trace("H5ScalarDS write: dataset opened");
        if (n >= 0) {
            try {
                int n3;
                lArray[0] = this.selectHyperslab(n, nArray);
                n2 = H5.H5Dget_type(n);
                log.trace("H5ScalarDS write: isNativeDatatype={}", (Object)this.isNativeDatatype);
                if (!this.isNativeDatatype) {
                    n3 = -1;
                    try {
                        n3 = n2;
                        n2 = H5.H5Tget_native_type(n3);
                    }
                    finally {
                        try {
                            H5.H5Tclose(n3);
                        }
                        catch (Exception exception) {
                            log.debug("finally close:", (Throwable)exception);
                        }
                    }
                }
                this.isText = H5.H5Tget_class(n2) == HDF5Constants.H5T_STRING;
                n3 = H5.H5Tget_size(n2);
                String string = object.getClass().getName();
                char c = string.charAt(string.lastIndexOf("[") + 1);
                boolean bl = n3 == 1 && c == 'S' || n3 == 2 && c == 'I' || n3 == 4 && c == 'J' || this.isUnsigned && this.unsignedConverted;
                log.trace("H5ScalarDS write: tsize={} cname={} dname={} doConversion={}", new Object[]{n3, string, Character.valueOf(c), bl});
                object2 = object;
                if (bl) {
                    object2 = H5ScalarDS.convertToUnsignedC(object, null);
                } else if (this.isText && this.convertByteToString && !H5.H5Tis_variable_str(n2)) {
                    object2 = H5ScalarDS.stringToByte((String[])object, H5.H5Tget_size(n2));
                } else if (this.isEnum && Array.get(object, 0) instanceof String) {
                    object2 = H5Datatype.convertEnumNameToValue(n2, (String[])object, null);
                }
                H5.H5Dwrite(n, n2, nArray[0], nArray[1], HDF5Constants.H5P_DEFAULT, object2);
            }
            finally {
                object2 = null;
                try {
                    if (HDF5Constants.H5S_ALL != nArray[0]) {
                        H5.H5Sclose(nArray[0]);
                    }
                }
                catch (Exception exception) {
                    log.debug("write: finally close:", (Throwable)exception);
                }
                try {
                    if (HDF5Constants.H5S_ALL != nArray[1]) {
                        H5.H5Sclose(nArray[1]);
                    }
                }
                catch (Exception exception) {
                    log.debug("write: finally close:", (Throwable)exception);
                }
                try {
                    H5.H5Tclose(n2);
                }
                catch (Exception exception) {
                    log.debug("write: finally close:", (Throwable)exception);
                }
            }
            this.close(n);
        }
        log.trace("H5ScalarDS write: finish");
    }

    private long selectHyperslab(int n, int[] nArray) throws HDF5Exception {
        long l = 1L;
        boolean bl = true;
        for (int i = 0; i < this.rank; ++i) {
            l *= this.selectedDims[i];
            if (this.selectedDims[i] >= this.dims[i]) continue;
            bl = false;
        }
        if (bl) {
            nArray[0] = HDF5Constants.H5S_ALL;
            nArray[1] = HDF5Constants.H5S_ALL;
        } else {
            nArray[1] = H5.H5Dget_space(n);
            nArray[0] = H5.H5Screate_simple(this.rank, this.selectedDims, null);
            H5.H5Sselect_hyperslab(nArray[1], HDF5Constants.H5S_SELECT_SET, this.startDims, this.selectedStride, this.selectedDims, null);
        }
        this.isDefaultImageOrder = this.rank <= 1 || this.selectedIndex[0] <= this.selectedIndex[1];
        return l;
    }

    @Override
    public List<Attribute> getMetadata() throws HDF5Exception {
        return this.getMetadata(this.fileFormat.getIndexType(null), this.fileFormat.getIndexOrder(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Attribute> getMetadata(int ... nArray) throws HDF5Exception {
        if (this.rank <= 0) {
            this.init();
        }
        log.trace("getMetadata: inited");
        try {
            this.linkTargetObjName = H5File.getLinkTargetName(this);
        }
        catch (Exception exception) {
            log.debug("getLinkTargetName failed: ", (Throwable)exception);
        }
        if (this.attributeList != null) {
            log.trace("getMetadata: attributeList != null");
            return this.attributeList;
        }
        int n = -1;
        int n2 = -1;
        int n3 = this.fileFormat.getIndexType(null);
        int n4 = this.fileFormat.getIndexOrder(null);
        if (nArray.length > 0) {
            n3 = nArray[0];
            if (nArray.length > 1) {
                n4 = nArray[1];
            }
        }
        log.trace("getMetadata: open dataset");
        n = this.open();
        if (n >= 0) {
            log.trace("getMetadata: dataset opened");
            try {
                this.compression = "";
                this.attributeList = H5File.getAttribute(n, n3, n4);
                log.trace("getMetadata: attributeList loaded");
                n2 = H5.H5Dget_create_plist(n);
                long l = H5.H5Dget_storage_size(n);
                int n5 = H5.H5Pget_nfilters(n2);
                if (H5.H5Pget_layout(n2) == HDF5Constants.H5D_CHUNKED) {
                    this.chunkSize = new long[this.rank];
                    H5.H5Pget_chunk(n2, this.rank, this.chunkSize);
                    if (n5 > 0) {
                        int n6;
                        long l2 = 1L;
                        long l3 = this.getDatatype().getDatatypeSize();
                        if (l3 < 0L) {
                            n6 = -1;
                            try {
                                n6 = H5.H5Dget_type(n);
                                l3 = H5.H5Tget_size(n6);
                            }
                            finally {
                                try {
                                    H5.H5Tclose(n6);
                                }
                                catch (Exception exception) {
                                    log.debug("finally close:", (Throwable)exception);
                                }
                            }
                        }
                        for (n6 = 0; n6 < this.rank; ++n6) {
                            l2 *= this.dims[n6];
                        }
                        long l4 = l2 * l3;
                        if (l != 0L) {
                            double d = (double)l4 / (double)l;
                            DecimalFormat decimalFormat = new DecimalFormat();
                            decimalFormat.setMinimumFractionDigits(3);
                            decimalFormat.setMaximumFractionDigits(3);
                            this.compression = this.compression + decimalFormat.format(d) + ":1";
                        }
                    }
                } else {
                    this.chunkSize = null;
                }
                int[] nArray2 = new int[]{0, 0};
                long[] lArray = new long[]{20L};
                int[] nArray3 = new int[(int)lArray[0]];
                String[] stringArray = new String[]{"", ""};
                log.trace("getMetadata: {} filters in pipeline", (Object)n5);
                int n7 = -1;
                int[] nArray4 = new int[]{1};
                this.filters = "";
                int n8 = 0;
                for (int i = 0; i < n5; ++i) {
                    int n9;
                    log.trace("getMetadata: filter[{}]", (Object)i);
                    if (i > 0) {
                        this.filters = this.filters + ", ";
                    }
                    if (n8 > 0) {
                        this.compression = this.compression + ", ";
                    }
                    try {
                        lArray[0] = 20L;
                        nArray3 = new int[(int)lArray[0]];
                        nArray3 = new int[(int)lArray[0]];
                        n7 = H5.H5Pget_filter(n2, i, nArray2, lArray, nArray3, 120L, stringArray, nArray4);
                        log.trace("getMetadata: filter[{}] is {} has {} elements ", new Object[]{i, stringArray[0], lArray[0]});
                        n9 = 0;
                        while ((long)n9 < lArray[0]) {
                            log.trace("getMetadata: filter[{}] element {} = {}", new Object[]{i, n9, nArray3[n9]});
                            ++n9;
                        }
                    }
                    catch (Throwable throwable) {
                        this.filters = this.filters + "ERROR";
                        continue;
                    }
                    if (n7 == HDF5Constants.H5Z_FILTER_NONE) {
                        this.filters = this.filters + "NONE";
                        continue;
                    }
                    if (n7 == HDF5Constants.H5Z_FILTER_DEFLATE) {
                        this.filters = this.filters + "GZIP";
                        this.compression = this.compression + "GZIP: level = " + nArray3[0];
                        ++n8;
                        continue;
                    }
                    if (n7 == HDF5Constants.H5Z_FILTER_FLETCHER32) {
                        this.filters = this.filters + "Error detection filter";
                        continue;
                    }
                    if (n7 == HDF5Constants.H5Z_FILTER_SHUFFLE) {
                        this.filters = this.filters + "SHUFFLE: Nbytes = " + nArray3[0];
                        continue;
                    }
                    if (n7 == HDF5Constants.H5Z_FILTER_NBIT) {
                        this.filters = this.filters + "NBIT";
                        continue;
                    }
                    if (n7 == HDF5Constants.H5Z_FILTER_SCALEOFFSET) {
                        this.filters = this.filters + "SCALEOFFSET: MIN BITS = " + nArray3[0];
                        continue;
                    }
                    if (n7 == HDF5Constants.H5Z_FILTER_SZIP) {
                        this.filters = this.filters + "SZIP";
                        this.compression = this.compression + "SZIP: Pixels per block = " + nArray3[1];
                        ++n8;
                        n9 = -1;
                        try {
                            n9 = H5.H5Zget_filter_info(n7);
                        }
                        catch (Exception exception) {
                            n9 = -1;
                        }
                        if (n9 == HDF5Constants.H5Z_FILTER_CONFIG_DECODE_ENABLED) {
                            this.compression = this.compression + ": H5Z_FILTER_CONFIG_DECODE_ENABLED";
                            continue;
                        }
                        if (n9 != HDF5Constants.H5Z_FILTER_CONFIG_ENCODE_ENABLED && n9 < HDF5Constants.H5Z_FILTER_CONFIG_ENCODE_ENABLED + HDF5Constants.H5Z_FILTER_CONFIG_DECODE_ENABLED) continue;
                        this.compression = this.compression + ": H5Z_FILTER_CONFIG_ENCODE_ENABLED";
                        continue;
                    }
                    this.filters = this.filters + "USERDEFINED " + stringArray[0] + "(" + n7 + "): ";
                    n9 = 0;
                    while ((long)n9 < lArray[0]) {
                        if (n9 > 0) {
                            this.filters = this.filters + ", ";
                        }
                        this.filters = this.filters + nArray3[n9];
                        ++n9;
                    }
                    log.debug("getMetadata: filter[{}] is user defined compression", (Object)i);
                }
                if (this.compression.length() == 0) {
                    this.compression = "NONE";
                }
                log.trace("getMetadata: filter compression={}", (Object)this.compression);
                if (this.filters.length() == 0) {
                    this.filters = "NONE";
                }
                log.trace("getMetadata: filter information={}", (Object)this.filters);
                this.storage = "" + l;
                try {
                    int[] nArray5 = new int[]{0};
                    H5.H5Pget_alloc_time(n2, nArray5);
                    this.storage = this.storage + ", allocation time: ";
                    if (nArray5[0] == HDF5Constants.H5D_ALLOC_TIME_EARLY) {
                        this.storage = this.storage + "Early";
                    } else if (nArray5[0] == HDF5Constants.H5D_ALLOC_TIME_INCR) {
                        this.storage = this.storage + "Incremental";
                    } else if (nArray5[0] == HDF5Constants.H5D_ALLOC_TIME_LATE) {
                        this.storage = this.storage + "Late";
                    }
                }
                catch (Exception exception) {
                    log.debug("Storage allocation time:", (Throwable)exception);
                }
                if (this.storage.length() == 0) {
                    this.storage = "NONE";
                }
                log.trace("getMetadata: storage={}", (Object)this.storage);
            }
            finally {
                try {
                    H5.H5Pclose(n2);
                }
                catch (Exception exception) {
                    log.debug("finally close:", (Throwable)exception);
                }
                this.close(n);
            }
        }
        log.trace("getMetadata: finish");
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        boolean bl = false;
        Attribute attribute = (Attribute)object;
        log.trace("writeMetadata: {}", (Object)attribute.getName());
        if (this.attributeList == null) {
            this.getMetadata();
        }
        if (this.attributeList != null) {
            bl = this.attributeList.contains(attribute);
        }
        this.getFileFormat().writeAttribute(this, attribute, bl);
        if (!bl) {
            this.attributeList.add(attribute);
            this.nAttributes = this.attributeList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetadata(Object object) throws HDF5Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        Attribute attribute = (Attribute)object;
        log.trace("removeMetadata: {}", (Object)attribute.getName());
        int n = this.open();
        if (n >= 0) {
            try {
                H5.H5Adelete(n, attribute.getName());
                List<Attribute> list = this.getMetadata();
                list.remove(attribute);
                this.nAttributes = list.size();
            }
            finally {
                this.close(n);
            }
        }
    }

    @Override
    public void updateMetadata(Object object) throws HDF5Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        log.trace("updateMetadata");
        Attribute attribute = (Attribute)object;
        log.trace("updateMetadata: {}", (Object)attribute.getName());
        this.nAttributes = -1;
    }

    @Override
    public void setName(String string) throws Exception {
        H5File.renameObject(this, string);
        super.setName(string);
    }

    private void resetSelection() {
        log.trace("resetSelection: start");
        for (int i = 0; i < this.rank; ++i) {
            this.startDims[i] = 0L;
            this.selectedDims[i] = 1L;
            if (this.selectedStride == null) continue;
            this.selectedStride[i] = 1L;
        }
        if (this.interlace == 0) {
            this.selectedDims[2] = 3L;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedIndex[2] = 2;
        } else if (this.interlace == 2) {
            this.selectedDims[0] = 3L;
            this.selectedDims[1] = this.dims[1];
            this.selectedDims[2] = this.dims[2];
            this.selectedIndex[0] = 1;
            this.selectedIndex[1] = 2;
            this.selectedIndex[2] = 0;
        } else if (this.rank == 1) {
            this.selectedIndex[0] = 0;
            this.selectedDims[0] = this.dims[0];
        } else if (this.rank == 2) {
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
        } else if (this.rank > 2) {
            if (this.isImage) {
                this.selectedIndex[1] = this.rank - 1;
                this.selectedIndex[0] = this.rank - 2;
                this.selectedIndex[2] = this.rank - 3;
            } else {
                this.selectedIndex[0] = 0;
                this.selectedIndex[1] = 1;
                this.selectedIndex[2] = 2;
            }
            this.selectedDims[this.selectedIndex[0]] = this.dims[this.selectedIndex[0]];
            this.selectedDims[this.selectedIndex[1]] = this.dims[this.selectedIndex[1]];
        }
        if (this.rank > 1 && this.isText) {
            this.selectedIndex[0] = this.rank - 1;
            this.selectedIndex[1] = 0;
            this.selectedDims[0] = 1L;
            this.selectedDims[this.selectedIndex[0]] = this.dims[this.selectedIndex[0]];
        }
        this.isDataLoaded = false;
        this.isDefaultImageOrder = true;
        log.trace("resetSelection: finish");
    }

    public static Dataset create(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, Object object) throws Exception {
        return H5ScalarDS.create(string, group, datatype, lArray, lArray2, lArray3, n, null, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dataset create(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, Object object, Object object2) throws Exception {
        int n2;
        Object[] objectArray;
        int n3;
        int n4;
        H5ScalarDS h5ScalarDS = null;
        String string2 = null;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        log.trace("H5ScalarDS create start");
        if (group == null || string == null || lArray == null || n > 0 && lArray3 == null) {
            return null;
        }
        H5File h5File = (H5File)group.getFileFormat();
        if (h5File == null) {
            return null;
        }
        String string3 = "/";
        if (!group.isRoot()) {
            string3 = group.getPath() + group.getName() + "/";
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            if ((n4 = string.lastIndexOf("/")) >= 0) {
                string = string.substring(n4 + 1);
            }
        }
        string2 = string3 + string;
        n4 = 0;
        if (lArray2 != null) {
            for (n3 = 0; n3 < lArray2.length; ++n3) {
                if (lArray2[n3] == 0L) {
                    lArray2[n3] = lArray[n3];
                } else if (lArray2[n3] < 0L) {
                    lArray2[n3] = HDF5Constants.H5S_UNLIMITED;
                }
                if (lArray2[n3] == lArray[n3]) continue;
                n4 = 1;
            }
        }
        if (lArray3 == null && n4 != 0) {
            lArray3 = new long[lArray.length];
            for (n3 = 0; n3 < lArray.length; ++n3) {
                lArray3[n3] = Math.min(lArray[n3], 64L);
            }
        }
        n3 = lArray.length;
        n7 = datatype.toNative();
        if (n7 >= 0) {
            try {
                n6 = H5.H5Screate_simple(n3, lArray, lArray2);
                n8 = HDF5Constants.H5P_DEFAULT;
                objectArray = null;
                try {
                    objectArray = H5ScalarDS.parseFillValue(datatype, object);
                }
                catch (Exception exception) {
                    log.debug("fill value:", (Throwable)exception);
                }
                if (lArray3 != null || objectArray != null) {
                    n8 = H5.H5Pcreate(HDF5Constants.H5P_DATASET_CREATE);
                    if (lArray3 != null) {
                        H5.H5Pset_layout(n8, HDF5Constants.H5D_CHUNKED);
                        H5.H5Pset_chunk(n8, n3, lArray3);
                        if (n > 0) {
                            H5.H5Pset_deflate(n8, n);
                        }
                    }
                    if (objectArray != null) {
                        H5.H5Pset_fill_value(n8, n7, (byte[])objectArray);
                    }
                }
                n2 = h5File.getFID();
                log.trace("H5ScalarDS create dataset");
                n5 = H5.H5Dcreate(n2, string2, n7, n6, HDF5Constants.H5P_DEFAULT, n8, HDF5Constants.H5P_DEFAULT);
                log.trace("H5ScalarDS create H5ScalarDS");
                h5ScalarDS = new H5ScalarDS(h5File, string, string3);
            }
            finally {
                try {
                    H5.H5Pclose(n8);
                }
                catch (HDF5Exception hDF5Exception) {
                    log.debug("create finally close:", (Throwable)hDF5Exception);
                }
                try {
                    H5.H5Sclose(n6);
                }
                catch (HDF5Exception hDF5Exception) {
                    log.debug("create finally close:", (Throwable)hDF5Exception);
                }
                try {
                    H5.H5Tclose(n7);
                }
                catch (HDF5Exception hDF5Exception) {
                    log.debug("create finally close:", (Throwable)hDF5Exception);
                }
                try {
                    H5.H5Dclose(n5);
                }
                catch (HDF5Exception hDF5Exception) {
                    log.debug("create finally close:", (Throwable)hDF5Exception);
                }
            }
        }
        if (h5ScalarDS != null) {
            group.addToMemberList(h5ScalarDS);
            if (object2 != null) {
                h5ScalarDS.init();
                objectArray = h5ScalarDS.getSelectedDims();
                for (n2 = 0; n2 < n3; ++n2) {
                    objectArray[n2] = lArray[n2];
                }
                h5ScalarDS.write(object2);
            }
        }
        log.trace("H5ScalarDS create finish");
        return h5ScalarDS;
    }

    private void checkCFconvention(int n) throws Exception {
        Object object = this.getAttrValue(n, "_FillValue");
        if (object != null) {
            int n2 = Array.getLength(object);
            for (int i = 0; i < n2; ++i) {
                this.addFilteredImageValue((Number)Array.get(object, i));
            }
        }
        if (this.imageDataRange == null || this.imageDataRange[1] <= this.imageDataRange[0]) {
            double d = 0.0;
            double d2 = 0.0;
            object = this.getAttrValue(n, "valid_range");
            if (object != null) {
                try {
                    d = Double.valueOf(Array.get(object, 0).toString());
                    d2 = Double.valueOf(Array.get(object, 1).toString());
                    this.imageDataRange = new double[2];
                    this.imageDataRange[0] = d;
                    this.imageDataRange[1] = d2;
                    return;
                }
                catch (Exception exception) {
                    log.debug("valid_range:", (Throwable)exception);
                }
            }
            if ((object = this.getAttrValue(n, "valid_min")) != null) {
                try {
                    d = Double.valueOf(Array.get(object, 0).toString());
                }
                catch (Exception exception) {
                    log.debug("valid_min:", (Throwable)exception);
                }
                object = this.getAttrValue(n, "valid_max");
                if (object != null) {
                    try {
                        d2 = Double.valueOf(Array.get(object, 0).toString());
                        this.imageDataRange = new double[2];
                        this.imageDataRange[0] = d;
                        this.imageDataRange[1] = d2;
                    }
                    catch (Exception exception) {
                        log.debug("valid_max:", (Throwable)exception);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getAttrValue(int n, String string) {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        Object object = null;
        log.trace("getAttrValue: start name={}", (Object)string);
        try {
            n2 = H5.H5Aopen_by_name(n, ".", string, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5LibraryException hDF5LibraryException) {
            log.debug("Failed to find attribute {} : Expected", (Object)string);
        }
        catch (Exception exception) {
            log.debug("try to find attribute {}:", (Object)string, (Object)exception);
        }
        if (n2 > 0) {
            try {
                int n5 = n3 = H5.H5Aget_type(n2);
                n3 = H5.H5Tget_native_type(n5);
                try {
                    H5.H5Tclose(n5);
                }
                catch (Exception exception) {
                    log.debug("close H5Aget_type after getting H5Tget_native_type:", (Throwable)exception);
                }
                n4 = H5.H5Aget_space(n2);
                long[] lArray = null;
                int n6 = H5.H5Sget_simple_extent_ndims(n4);
                if (n6 > 0) {
                    lArray = new long[n6];
                    H5.H5Sget_simple_extent_dims(n4, lArray, null);
                }
                log.trace("getAttrValue: adims={}", (Object)lArray);
                long l = 1L;
                if (lArray != null) {
                    for (int i = 0; i < lArray.length; ++i) {
                        l *= lArray[i];
                    }
                }
                log.trace("getAttrValue: lsize={}", (Object)l);
                object = H5Datatype.allocateArray(n3, (int)l);
                if (object != null) {
                    log.trace("read attribute id {} of size={}", (Object)n3, (Object)l);
                    H5.H5Aread(n2, n3, object);
                    if (H5Datatype.isUnsigned(n3)) {
                        log.trace("id {} is unsigned", (Object)n3);
                        object = H5ScalarDS.convertFromUnsignedC(object, null);
                    }
                }
            }
            catch (Exception exception) {
                log.debug("try to get value for attribute {}:", (Object)string, (Object)exception);
            }
            finally {
                try {
                    H5.H5Tclose(n3);
                }
                catch (HDF5Exception hDF5Exception) {
                    log.debug("finally close:", (Throwable)hDF5Exception);
                }
                try {
                    H5.H5Sclose(n4);
                }
                catch (HDF5Exception hDF5Exception) {
                    log.debug("finally close:", (Throwable)hDF5Exception);
                }
                try {
                    H5.H5Aclose(n2);
                }
                catch (HDF5Exception hDF5Exception) {
                    log.debug("finally close:", (Throwable)hDF5Exception);
                }
            }
        }
        log.trace("getAttrValue: finish");
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStringAttributeOf(int n, String string, String string2) {
        boolean bl = false;
        int n2 = -1;
        int n3 = -1;
        try {
            n2 = H5.H5Aopen_by_name(n, ".", string, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
            n3 = H5.H5Aget_type(n2);
            int n4 = H5.H5Tget_size(n3);
            byte[] byArray = new byte[n4];
            H5.H5Aread(n2, n3, byArray);
            String string3 = new String(byArray).trim();
            bl = string3.equalsIgnoreCase(string2);
        }
        catch (Exception exception) {
            log.debug("try to find out interlace mode:", (Throwable)exception);
        }
        finally {
            try {
                H5.H5Tclose(n3);
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("finally close:", (Throwable)hDF5Exception);
            }
            try {
                H5.H5Aclose(n2);
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("finally close:", (Throwable)hDF5Exception);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dataset copy(Group group, String string, long[] lArray, Object object) throws Exception {
        H5ScalarDS h5ScalarDS;
        block45: {
            if (group == null) {
                return null;
            }
            h5ScalarDS = null;
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            String string2 = null;
            String string3 = null;
            string3 = group.isRoot() ? "/" : group.getPath() + group.getName() + "/";
            string2 = string3 + string;
            n = this.open();
            if (n >= 0) {
                try {
                    n3 = H5.H5Dget_type(n);
                    n4 = H5.H5Screate_simple(lArray.length, lArray, null);
                    n5 = H5.H5Dget_create_plist(n);
                    long[] lArray2 = new long[lArray.length];
                    boolean bl = false;
                    try {
                        H5.H5Pget_chunk(n5, lArray.length, lArray2);
                        for (int i = 0; i < lArray.length; ++i) {
                            if (lArray[i] >= lArray2[i]) continue;
                            bl = true;
                            lArray2[i] = lArray[i] == 1L ? 1L : lArray[i] / 2L;
                        }
                    }
                    catch (Exception exception) {
                        log.debug("copy chunk:", (Throwable)exception);
                    }
                    if (bl) {
                        H5.H5Pset_chunk(n5, lArray.length, lArray2);
                    }
                    try {
                        n2 = H5.H5Dcreate(group.getFID(), string2, n3, n4, HDF5Constants.H5P_DEFAULT, n5, HDF5Constants.H5P_DEFAULT);
                    }
                    catch (Exception exception) {
                        log.debug("copy create:", (Throwable)exception);
                    }
                    finally {
                        try {
                            H5.H5Dclose(n2);
                        }
                        catch (Exception exception) {
                            log.debug("finally close:", (Throwable)exception);
                        }
                    }
                    h5ScalarDS = new H5ScalarDS(group.getFileFormat(), string, string3);
                    if (object != null) {
                        ((Dataset)h5ScalarDS).init();
                        ((Dataset)h5ScalarDS).write(object);
                    }
                    if ((n2 = ((HObject)h5ScalarDS).open()) < 0) break block45;
                    try {
                        H5File.copyAttributes(n, n2);
                    }
                    finally {
                        try {
                            H5.H5Dclose(n2);
                        }
                        catch (Exception exception) {
                            log.debug("finally close:", (Throwable)exception);
                        }
                    }
                }
                finally {
                    try {
                        H5.H5Pclose(n5);
                    }
                    catch (Exception exception) {
                        log.debug("finally close:", (Throwable)exception);
                    }
                    try {
                        H5.H5Sclose(n4);
                    }
                    catch (Exception exception) {
                        log.debug("finally close:", (Throwable)exception);
                    }
                    try {
                        H5.H5Tclose(n3);
                    }
                    catch (Exception exception) {
                        log.debug("finally close:", (Throwable)exception);
                    }
                    try {
                        H5.H5Dclose(n);
                    }
                    catch (Exception exception) {
                        log.debug("finally close:", (Throwable)exception);
                    }
                }
            }
        }
        group.addToMemberList(h5ScalarDS);
        ((ScalarDS)h5ScalarDS).setIsImage(this.isImage);
        return h5ScalarDS;
    }

    @Override
    public byte[][] getPalette() {
        if (this.palette == null) {
            this.palette = this.readPalette(0);
        }
        return this.palette;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPaletteName(int n) {
        byte[] byArray = this.getPaletteRefs();
        int n2 = -1;
        int n3 = -1;
        String[] stringArray = new String[]{""};
        long l = 100L;
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[8];
        try {
            System.arraycopy(byArray, n * 8, byArray2, 0, 8);
        }
        catch (Throwable throwable) {
            return null;
        }
        n2 = this.open();
        if (n2 >= 0) {
            try {
                n3 = H5.H5Rdereference(this.getFID(), HDF5Constants.H5R_OBJECT, byArray2);
                H5.H5Iget_name(n3, stringArray, l);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.close(n3);
                this.close(n2);
            }
        }
        return stringArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[][] readPalette(int n) {
        byte[][] byArray = null;
        byte[] byArray2 = this.getPaletteRefs();
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        if (byArray2 == null) {
            return null;
        }
        byte[] byArray3 = null;
        byte[] byArray4 = new byte[8];
        try {
            System.arraycopy(byArray2, n * 8, byArray4, 0, 8);
        }
        catch (Throwable throwable) {
            return null;
        }
        n2 = this.open();
        if (n2 >= 0) {
            try {
                n3 = H5.H5Rdereference(this.getFID(), HDF5Constants.H5R_OBJECT, byArray4);
                n4 = H5.H5Dget_type(n3);
                if (H5.H5Dget_storage_size(n3) <= 768L) {
                    byArray3 = new byte[768];
                    H5.H5Dread(n3, n4, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, byArray3);
                }
            }
            catch (HDF5Exception hDF5Exception) {
                byArray3 = null;
            }
            finally {
                try {
                    H5.H5Tclose(n4);
                }
                catch (HDF5Exception hDF5Exception) {}
                this.close(n3);
                this.close(n2);
            }
        }
        if (byArray3 != null) {
            byArray = new byte[3][256];
            for (int i = 0; i < 256; ++i) {
                byArray[0][i] = byArray3[i * 3];
                byArray[1][i] = byArray3[i * 3 + 1];
                byArray[2][i] = byArray3[i * 3 + 2];
            }
        }
        return byArray;
    }

    private static byte[] parseFillValue(Datatype datatype, Object object) throws Exception {
        byte[] byArray = null;
        if (datatype == null || object == null) {
            return null;
        }
        int n = datatype.getDatatypeClass();
        int n2 = datatype.getDatatypeSize();
        double d = 0.0;
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        } else if (object.getClass().isArray()) {
            string = Array.get(object, 0).toString();
        }
        if (n != 3) {
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        try {
            switch (n) {
                case 0: 
                case 2: 
                case 8: {
                    if (n2 == 1) {
                        byArray = new byte[]{(byte)d};
                        break;
                    }
                    if (n2 == 2) {
                        byArray = HDFNativeData.shortToByte((short)d);
                        break;
                    }
                    if (n2 == 8) {
                        byArray = HDFNativeData.longToByte((long)d);
                        break;
                    }
                    byArray = HDFNativeData.intToByte((int)d);
                    break;
                }
                case 1: {
                    if (n2 == 8) {
                        byArray = HDFNativeData.doubleToByte(d);
                        break;
                    }
                    byArray = HDFNativeData.floatToByte((float)d);
                    break;
                }
                case 3: {
                    byArray = string.getBytes();
                    break;
                }
                case 7: {
                    byArray = HDFNativeData.longToByte((long)d);
                    break;
                }
                default: {
                    log.debug("parseFillValue datatypeClass unknown");
                    break;
                }
            }
        }
        catch (Exception exception) {
            byArray = null;
        }
        return byArray;
    }

    @Override
    public byte[] getPaletteRefs() {
        if (this.rank <= 0) {
            this.init();
        }
        return this.paletteRefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getPaletteRefs(int n) {
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        byte[] byArray = null;
        try {
            n2 = H5.H5Aopen_by_name(n, ".", "PALETTE", HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
            n3 = H5.H5Aget_space(n2);
            n5 = H5.H5Sget_simple_extent_ndims(n3);
            n4 = 1;
            if (n5 > 0) {
                long[] lArray = new long[n5];
                H5.H5Sget_simple_extent_dims(n3, lArray, null);
                for (int i = 0; i < n5; ++i) {
                    n4 *= (int)lArray[i];
                }
            }
            byArray = new byte[n4 * 8];
            n6 = H5.H5Aget_type(n2);
            H5.H5Aread(n2, n6, byArray);
        }
        catch (HDF5Exception hDF5Exception) {
            log.debug("Palette attribute search failed: Expected");
            byArray = null;
        }
        finally {
            try {
                H5.H5Tclose(n6);
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("finally close:", (Throwable)hDF5Exception);
            }
            try {
                H5.H5Sclose(n3);
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("finally close:", (Throwable)hDF5Exception);
            }
            try {
                H5.H5Aclose(n2);
            }
            catch (HDF5Exception hDF5Exception) {
                log.debug("finally close:", (Throwable)hDF5Exception);
            }
        }
        return byArray;
    }

    public void extend(long[] lArray) throws HDF5Exception {
        int n = -1;
        int n2 = -1;
        n = this.open();
        if (n >= 0) {
            try {
                H5.H5Dset_extent(n, lArray);
                H5.H5Fflush(n, HDF5Constants.H5F_SCOPE_GLOBAL);
                n2 = H5.H5Dget_space(n);
                long[] lArray2 = new long[this.rank];
                H5.H5Sget_simple_extent_dims(n2, lArray2, null);
                for (int i = 0; i < this.rank; ++i) {
                    if (lArray2[i] == lArray[i]) continue;
                    throw new HDF5Exception("error extending dataset " + this.getName());
                }
                this.dims = lArray2;
            }
            catch (Exception exception) {
                throw new HDF5Exception(exception.getMessage());
            }
            finally {
                if (n2 > 0) {
                    H5.H5Sclose(n2);
                }
                this.close(n);
            }
        }
    }
}

