/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h4;

import java.io.File;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFLibrary;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.h4.H4Datatype;
import ncsa.hdf.object.h4.H4GRImage;
import ncsa.hdf.object.h4.H4Group;
import ncsa.hdf.object.h4.H4SDS;
import ncsa.hdf.object.h4.H4Vdata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H4File
extends FileFormat {
    private static final long serialVersionUID = 8985533001471224030L;
    private static final Logger log = LoggerFactory.getLogger(H4File.class);
    private int flag;
    private DefaultMutableTreeNode rootNode;
    private List objList;
    private int grid;
    private boolean isNetCDF = false;
    private int sdid;
    private boolean showAll = false;

    public H4File() {
        this("", 4);
    }

    public H4File(String string) {
        this(string, 4);
    }

    public H4File(String string, int n) {
        super(string);
        this.isReadOnly = n == 2;
        this.objList = new Vector();
        this.fid = -1;
        this.flag = n == 2 ? 1 : (n == 4 ? 2 : (n == 8 ? 4 : n));
        String string2 = System.getProperty("h4showall");
        if (string2 != null) {
            this.showAll = true;
            log.debug("show all is on");
        } else {
            log.debug("show all is off");
        }
    }

    @Override
    public boolean isThisType(FileFormat fileFormat) {
        return fileFormat instanceof H4File;
    }

    @Override
    public boolean isThisType(String string) {
        boolean bl = false;
        try {
            bl = HDFLibrary.Hishdf(string);
        }
        catch (HDFException hDFException) {
            bl = false;
        }
        if (!bl) {
            bl = this.isNetCDF(string);
        }
        return bl;
    }

    @Override
    public FileFormat createFile(String string, int n) throws Exception {
        File file;
        Boolean bl = true;
        if (n == 20 && (file = new File(string)).exists()) {
            bl = false;
        }
        if (bl.booleanValue()) {
            int n2 = HDFLibrary.Hopen(string, 4);
            try {
                HDFLibrary.Hclose(n2);
            }
            catch (HDFException hDFException) {
                log.debug("Hclose failure: ", (Throwable)hDFException);
            }
        }
        return new H4File(string, 4);
    }

    @Override
    public FileFormat createInstance(String string, int n) throws Exception {
        return new H4File(string, n);
    }

    @Override
    public int open() throws Exception {
        if (this.fid >= 0) {
            return this.fid;
        }
        if (this.flag < 0) {
            throw new HDFException("Invalid access identifer -- " + this.flag);
        }
        if (this.flag == 1) {
            if (!this.exists()) {
                throw new HDFException("File does not exist -- " + this.fullFileName);
            }
            if (this.exists() && !this.canRead()) {
                throw new HDFException("Cannot read file -- " + this.fullFileName);
            }
        } else if ((this.flag == 2 || this.flag == 4) && this.exists() && !this.canWrite()) {
            throw new HDFException("Cannot write file, try open as read-only -- " + this.fullFileName);
        }
        this.isNetCDF = this.isNetCDF(this.fullFileName);
        if (this.isNetCDF) {
            this.isReadOnly = true;
        }
        if (this.isNetCDF) {
            this.fid = 0;
        } else {
            this.fid = HDFLibrary.Hopen(this.fullFileName, this.flag);
            HDFLibrary.Vstart(this.fid);
            this.grid = HDFLibrary.GRstart(this.fid);
        }
        this.sdid = HDFLibrary.SDstart(this.fullFileName, this.flag);
        this.rootNode = this.loadTree();
        return this.fid;
    }

    @Override
    public void close() throws HDFException {
        if (this.rootNode != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            HObject hObject = null;
            Enumeration<TreeNode> enumeration = this.rootNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                hObject = (HObject)defaultMutableTreeNode.getUserObject();
                if (hObject instanceof Dataset) {
                    ((Dataset)hObject).clearData();
                }
                hObject = null;
                defaultMutableTreeNode = null;
            }
        }
        try {
            HDFLibrary.GRend(this.grid);
        }
        catch (HDFException hDFException) {
            log.debug("GRend failure: ", (Throwable)hDFException);
        }
        try {
            HDFLibrary.SDend(this.sdid);
        }
        catch (HDFException hDFException) {
            log.debug("SDend failure: ", (Throwable)hDFException);
        }
        try {
            HDFLibrary.Vend(this.fid);
        }
        catch (HDFException hDFException) {
            log.debug("Vend failure: ", (Throwable)hDFException);
        }
        HDFLibrary.Hclose(this.fid);
        this.fid = -1;
        this.objList = null;
    }

    @Override
    public TreeNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public Group createGroup(String string, Group group) throws Exception {
        return H4Group.create(string, group);
    }

    @Override
    public Datatype createDatatype(int n, int n2, int n3, int n4) throws Exception {
        return new H4Datatype(n, n2, n3, n4);
    }

    @Override
    public Datatype createDatatype(int n, int n2, int n3, int n4, Datatype datatype) throws Exception {
        return new H4Datatype(n, n2, n3, n4);
    }

    @Override
    public Datatype createDatatype(int n, int n2, int n3, int n4, String string) throws Exception {
        throw new UnsupportedOperationException("HDF4 does not support named datatype.");
    }

    @Override
    public Datatype createDatatype(int n, int n2, int n3, int n4, Datatype datatype, String string) throws Exception {
        throw new UnsupportedOperationException("HDF4 does not support named datatype.");
    }

    @Override
    public Dataset createScalarDS(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, Object object, Object object2) throws Exception {
        return H4SDS.create(string, group, datatype, lArray, lArray2, lArray3, n, object, object2);
    }

    @Override
    public Dataset createImage(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, int n2, int n3, Object object) throws Exception {
        H4GRImage h4GRImage = H4GRImage.create(string, group, datatype, lArray, lArray2, lArray3, n, n2, n3, object);
        return h4GRImage;
    }

    @Override
    public void delete(HObject hObject) throws Exception {
        throw new UnsupportedOperationException("Cannot delete HDF4 object.");
    }

    @Override
    public TreeNode copy(HObject hObject, Group group, String string) throws Exception {
        TreeNode treeNode = null;
        log.trace("copy(): start");
        if (hObject == null || group == null) {
            return null;
        }
        if (string == null) {
            string = hObject.getName();
        }
        log.trace("copy(): dstName={}", (Object)string);
        if (hObject instanceof H4SDS) {
            log.trace("copy(): srcObj instanceof H4SDS");
            treeNode = new DefaultMutableTreeNode(((H4SDS)hObject).copy(group, string, null, null));
        } else if (hObject instanceof H4GRImage) {
            log.trace("copy(): srcObj instanceof H4GRImage");
            treeNode = new DefaultMutableTreeNode(((H4GRImage)hObject).copy(group, string, null, null));
        } else if (hObject instanceof H4Vdata) {
            log.trace("copy(): srcObj instanceof H4Vdata");
            treeNode = new DefaultMutableTreeNode(((H4Vdata)hObject).copy(group, null, null, null));
        } else if (hObject instanceof H4Group) {
            log.trace("copy(): srcObj instanceof H4Group");
            treeNode = this.copyGroup((H4Group)hObject, (H4Group)group);
        }
        log.trace("copy(): finish");
        return treeNode;
    }

    @Override
    public void writeAttribute(HObject hObject, Attribute attribute, boolean bl) throws HDFException {
        String string = attribute.getName();
        int n = attribute.getType().toNative();
        long[] lArray = attribute.getDataDims();
        int n2 = 1;
        if (lArray != null) {
            for (int i = 0; i < lArray.length; ++i) {
                n2 *= (int)lArray[i];
            }
        }
        log.trace("writeAttribute(): start count={}", (Object)n2);
        Object object = attribute.getValue();
        if (Array.get(object, 0) instanceof String) {
            String string2 = (String)Array.get(object, 0);
            if (string2.length() > n2) {
                string2 = string2.substring(0, n2);
                Array.set(object, 0, string2);
            } else {
                for (int i = string2.length(); i < n2; ++i) {
                    string2 = string2 + " ";
                }
            }
            byte[] byArray = string2.getBytes();
            byArray[string2.length() - 1] = 0;
            object = byArray;
        }
        if (hObject instanceof H4Group && ((H4Group)hObject).isRoot()) {
            if (bl) {
                HDFLibrary.SDsetattr(this.sdid, string, n, n2, object);
            } else {
                HDFLibrary.GRsetattr(this.grid, string, n, n2, object);
            }
            return;
        }
        int n3 = hObject.open();
        if (hObject instanceof H4Group) {
            HDFLibrary.Vsetattr(n3, string, n, n2, object);
        } else if (hObject instanceof H4SDS) {
            HDFLibrary.SDsetattr(n3, string, n, n2, object);
        } else if (hObject instanceof H4GRImage) {
            HDFLibrary.GRsetattr(n3, string, n, n2, object);
        } else if (hObject instanceof H4Vdata) {
            HDFLibrary.VSsetattr(n3, -1, string, n, n2, object);
        }
        hObject.close(n3);
        log.trace("writeAttribute(): finish");
    }

    private TreeNode copyGroup(H4Group h4Group, H4Group h4Group2) throws Exception {
        int n;
        H4Group h4Group3 = null;
        String string = null;
        String string2 = null;
        log.trace("copyGroup(): start");
        int n2 = HDFLibrary.Vattach(this.fid, -1, "w");
        if (n2 < 0) {
            return null;
        }
        string = h4Group.getName();
        int n3 = h4Group.open();
        HDFLibrary.Vsetname(n2, string);
        int n4 = HDFLibrary.VQueryref(n2);
        int n5 = HDFLibrary.VQuerytag(n2);
        if (h4Group2.isRoot()) {
            string2 = "/";
        } else {
            string2 = h4Group2.getPath() + h4Group2.getName() + "/";
            n = h4Group2.open();
            HDFLibrary.Vinsert(n, n2);
            h4Group2.close(n);
        }
        n = 0;
        try {
            n = HDFLibrary.Vnattrs(n3);
        }
        catch (Exception exception) {
            n = 0;
        }
        String[] stringArray = new String[1];
        byte[] byArray = null;
        int[] nArray = new int[3];
        for (int i = 0; i < n; ++i) {
            try {
                stringArray[0] = "";
                HDFLibrary.Vattrinfo(n3, i, stringArray, nArray);
                byArray = new byte[nArray[2]];
                HDFLibrary.Vgetattr(n3, i, byArray);
                HDFLibrary.Vsetattr(n2, stringArray[0], nArray[0], nArray[2], byArray);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        long[] lArray = new long[]{n5, n4};
        h4Group3 = new H4Group(this, string, string2, h4Group2, lArray);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(h4Group3){
            private static final long serialVersionUID = -8601910527549035409L;

            @Override
            public boolean isLeaf() {
                return false;
            }
        };
        h4Group2.addToMemberList(h4Group3);
        List<HObject> list = h4Group.getMemberList();
        if (list != null && list.size() > 0) {
            for (HObject hObject : list) {
                try {
                    defaultMutableTreeNode.add((MutableTreeNode)this.copy(hObject, h4Group3));
                }
                catch (Exception exception) {
                    log.debug("newNode.ad failure: ", (Throwable)exception);
                }
            }
        }
        h4Group.close(n3);
        try {
            HDFLibrary.Vdetach(n2);
        }
        catch (Exception exception) {
            log.debug("Vdetach failure: ", (Throwable)exception);
        }
        log.trace("copyGroup(): finish");
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode loadTree() {
        Dataset dataset;
        int n;
        if (this.fid < 0) {
            return null;
        }
        long[] lArray = new long[]{0L, 0L};
        int n2 = 0;
        int n3 = -1;
        int[] nArray = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        log.trace("loadTree(): start");
        H4Group h4Group = new H4Group(this, "/", null, null, lArray);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(h4Group){
            private static final long serialVersionUID = 3507473044690724650L;

            @Override
            public boolean isLeaf() {
                return false;
            }
        };
        int[] nArray2 = new int[1];
        int[] nArray3 = null;
        try {
            n2 = HDFLibrary.Vlone(this.fid, nArray2, 0);
            nArray3 = new int[n2];
            n2 = HDFLibrary.Vlone(this.fid, nArray3, n2);
        }
        catch (HDFException hDFException) {
            n2 = 0;
        }
        int n4 = Math.max(0, this.getStartMembers());
        int n5 = this.getMaxMembers();
        if (n5 >= n2) {
            n5 = n2;
            n4 = 0;
        }
        n5 += n4;
        n5 = Math.min(n5, n2);
        for (n = n4; n < n5; ++n) {
            n3 = nArray3[n];
            H4Group h4Group2 = this.getVGroup(1965, n3, "/", h4Group, false);
            if (h4Group2 == null) continue;
            defaultMutableTreeNode = new DefaultMutableTreeNode(h4Group2){
                private static final long serialVersionUID = 8927502967802143369L;

                @Override
                public boolean isLeaf() {
                    return false;
                }
            };
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
            h4Group.addToMemberList(h4Group2);
            this.depth_first(defaultMutableTreeNode, null);
        }
        nArray = new int[2];
        n = 0;
        try {
            n = HDFLibrary.GRfileinfo(this.grid, nArray) ? 1 : 0;
        }
        catch (HDFException hDFException) {
            n = 0;
        }
        if (n != 0) {
            n2 = nArray[0];
            for (int i = 0; i < n2; ++i) {
                dataset = this.getGRImage(306, i, "/", false);
                if (dataset == null) continue;
                defaultMutableTreeNode = new DefaultMutableTreeNode(dataset);
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
                h4Group.addToMemberList(dataset);
            }
        }
        try {
            n = HDFLibrary.SDfileinfo(this.sdid, nArray) ? 1 : 0;
        }
        catch (HDFException hDFException) {
            n = 0;
        }
        if (n != 0) {
            n2 = nArray[0];
            for (int i = 0; i < n2; ++i) {
                dataset = this.getSDS(720, i, "/", false);
                if (dataset == null) continue;
                defaultMutableTreeNode = new DefaultMutableTreeNode(dataset);
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
                h4Group.addToMemberList(dataset);
            }
        }
        try {
            n2 = HDFLibrary.VSlone(this.fid, nArray2, 0);
            nArray3 = new int[n2];
            n2 = HDFLibrary.VSlone(this.fid, nArray3, n2);
        }
        catch (HDFException hDFException) {
            n2 = 0;
        }
        for (int i = 0; i < n2; ++i) {
            n3 = nArray3[i];
            dataset = this.getVdata(1963, n3, "/", false);
            if (dataset == null) continue;
            defaultMutableTreeNode = new DefaultMutableTreeNode(dataset);
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
            h4Group.addToMemberList(dataset);
        }
        if (h4Group != null) {
            List list = null;
            try {
                list = h4Group.getMetadata();
            }
            catch (HDFException hDFException) {
                log.debug("rootGroup.getMetadata failure: ", (Throwable)hDFException);
            }
            if (list != null) {
                try {
                    this.getFileAnnotation(this.fid, list);
                }
                catch (HDFException hDFException) {
                    log.debug("getFileAnnotation failure: ", (Throwable)hDFException);
                }
                try {
                    this.getGRglobleAttribute(this.grid, list);
                }
                catch (HDFException hDFException) {
                    log.debug("getGRglobleAttributte failure: ", (Throwable)hDFException);
                }
                try {
                    this.getSDSglobleAttribute(this.sdid, list);
                }
                catch (HDFException hDFException) {
                    log.debug("getSDglobleAttributte failure: ", (Throwable)hDFException);
                }
            }
        }
        log.trace("loadTree(): finish");
        return defaultMutableTreeNode2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void depth_first(MutableTreeNode mutableTreeNode, H4Group h4Group) {
        if (h4Group == null && mutableTreeNode == null) {
            return;
        }
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int[] nArray = null;
        int[] nArray2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        if (mutableTreeNode != null) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)mutableTreeNode;
            h4Group = (H4Group)defaultMutableTreeNode2.getUserObject();
        }
        String string = h4Group.getPath() + h4Group.getName() + "/";
        int n5 = h4Group.open();
        if (n5 == -1) {
            return;
        }
        try {
            n = HDFLibrary.Vntagrefs(n5);
            nArray = new int[n];
            nArray2 = new int[n];
            n = HDFLibrary.Vgettagrefs(n5, nArray, nArray2, n);
        }
        catch (HDFException hDFException) {
            n = 0;
        }
        finally {
            h4Group.close(n5);
        }
        int n6 = Math.max(0, this.getStartMembers());
        int n7 = this.getMaxMembers();
        if (n7 >= n) {
            n7 = n;
            n6 = 0;
        }
        n7 += n6;
        n7 = Math.min(n7, n);
        block15: for (int i = n6; i < n7; ++i) {
            n3 = nArray[i];
            n2 = nArray2[i];
            switch (n3) {
                case 202: 
                case 302: 
                case 306: {
                    try {
                        n4 = HDFLibrary.GRreftoindex(this.grid, (short)n2);
                    }
                    catch (HDFException hDFException) {
                        n4 = -1;
                    }
                    if (n4 == -1) continue block15;
                    Dataset dataset = this.getGRImage(n3, n4, string, true);
                    h4Group.addToMemberList(dataset);
                    if (dataset == null || defaultMutableTreeNode2 == null) continue block15;
                    defaultMutableTreeNode = new DefaultMutableTreeNode(dataset);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode);
                    continue block15;
                }
                case 700: 
                case 702: 
                case 720: {
                    try {
                        n4 = HDFLibrary.SDreftoindex(this.sdid, n2);
                    }
                    catch (HDFException hDFException) {
                        n4 = -1;
                    }
                    if (n4 == -1) continue block15;
                    Dataset dataset = this.getSDS(n3, n4, string, true);
                    h4Group.addToMemberList(dataset);
                    if (dataset == null || defaultMutableTreeNode2 == null) continue block15;
                    defaultMutableTreeNode = new DefaultMutableTreeNode(dataset);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode);
                    continue block15;
                }
                case 1962: 
                case 1963: {
                    Dataset dataset = this.getVdata(n3, n2, string, true);
                    h4Group.addToMemberList(dataset);
                    if (dataset == null || defaultMutableTreeNode2 == null) continue block15;
                    defaultMutableTreeNode = new DefaultMutableTreeNode(dataset);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode);
                    continue block15;
                }
                case 1965: {
                    H4Group h4Group2 = this.getVGroup(n3, n2, string, h4Group, true);
                    h4Group.addToMemberList(h4Group2);
                    if (h4Group2 == null || defaultMutableTreeNode2 == null) continue block15;
                    defaultMutableTreeNode = new DefaultMutableTreeNode(h4Group2){
                        private static final long serialVersionUID = -8774836537322039221L;

                        @Override
                        public boolean isLeaf() {
                            return false;
                        }
                    };
                    defaultMutableTreeNode2.add(defaultMutableTreeNode);
                    boolean bl = false;
                    DefaultMutableTreeNode defaultMutableTreeNode3 = defaultMutableTreeNode2;
                    while (defaultMutableTreeNode3 != null && !bl) {
                        long[] lArray;
                        H4Group h4Group3 = (H4Group)defaultMutableTreeNode3.getUserObject();
                        if (h4Group3.equalsOID(lArray = new long[]{n3, n2})) {
                            bl = true;
                            continue;
                        }
                        defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode3.getParent();
                    }
                    if (bl) continue block15;
                    this.depth_first(defaultMutableTreeNode, null);
                    continue block15;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final H4GRImage getGRImage(int n, int n2, String string, boolean bl) {
        int n3 = -1;
        int n4 = -1;
        H4GRImage h4GRImage = null;
        String[] stringArray = new String[]{""};
        int[] nArray = new int[4];
        int[] nArray2 = new int[]{0, 0};
        try {
            n3 = HDFLibrary.GRselect(this.grid, n2);
            n4 = HDFLibrary.GRidtoref(n3);
            HDFLibrary.GRgetiminfo(n3, stringArray, nArray, nArray2);
        }
        catch (HDFException hDFException) {
            n3 = -1;
        }
        finally {
            try {
                HDFLibrary.GRendaccess(n3);
            }
            catch (HDFException hDFException) {
                log.debug("GRendaccess failure: ", (Throwable)hDFException);
            }
        }
        if (n3 != -1) {
            long[] lArray = new long[]{n, n4};
            if (bl) {
                this.objList.add(lArray);
            } else if (this.find(lArray)) {
                return null;
            }
            h4GRImage = new H4GRImage(this, stringArray[0], string, lArray);
        }
        return h4GRImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final H4SDS getSDS(int n, int n2, String string, boolean bl) {
        int n3 = -1;
        int n4 = -1;
        H4SDS h4SDS = null;
        String[] stringArray = new String[]{""};
        int[] nArray = new int[32];
        int[] nArray2 = new int[]{0, 0, 0};
        log.trace("getSDS(): start");
        boolean bl2 = false;
        try {
            n3 = HDFLibrary.SDselect(this.sdid, n2);
            if (this.isNetCDF) {
                n4 = n2;
                n = 67687001;
            } else {
                n4 = HDFLibrary.SDidtoref(n3);
            }
            HDFLibrary.SDgetinfo(n3, stringArray, nArray, nArray2);
            bl2 = HDFLibrary.SDiscoordvar(n3);
        }
        catch (HDFException hDFException) {
            n3 = -1;
        }
        finally {
            try {
                HDFLibrary.SDendaccess(n3);
            }
            catch (HDFException hDFException) {
                log.debug("SDendaccess failure: ", (Throwable)hDFException);
            }
        }
        if (bl2) {
            stringArray[0] = stringArray[0] + " (dimension)";
        }
        if (n3 != -1) {
            long[] lArray = new long[]{n, n4};
            if (bl) {
                this.objList.add(lArray);
            } else if (this.find(lArray)) {
                return null;
            }
            h4SDS = new H4SDS(this, stringArray[0], string, lArray);
        }
        log.trace("getSDS(): finish");
        return h4SDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final H4Vdata getVdata(int n, int n2, String string, boolean bl) {
        int n3 = -1;
        H4Vdata h4Vdata = null;
        String[] stringArray = new String[]{""};
        String[] stringArray2 = new String[]{""};
        long[] lArray = new long[]{n, n2};
        log.trace("getVdata(): start");
        if (bl) {
            this.objList.add(lArray);
        } else if (this.find(lArray)) {
            return null;
        }
        try {
            n3 = HDFLibrary.VSattach(this.fid, n2, "r");
            HDFLibrary.VSgetclass(n3, stringArray2);
            stringArray2[0] = stringArray2[0].trim();
            HDFLibrary.VSgetname(n3, stringArray);
        }
        catch (HDFException hDFException) {
            n3 = -1;
        }
        finally {
            try {
                HDFLibrary.VSdetach(n3);
            }
            catch (HDFException hDFException) {
                log.debug("VSdetach failure: ", (Throwable)hDFException);
            }
        }
        if (!(!this.showAll && (n3 == -1 || stringArray2[0].equalsIgnoreCase("Attr0.0") || stringArray2[0].startsWith("_HDF_CHK_TBL_") || stringArray2[0].startsWith("SDSVar") || stringArray2[0].startsWith("CoordVar") || stringArray2[0].startsWith("DimVal0.0") || stringArray2[0].startsWith("DimVal0.1") || stringArray2[0].startsWith("RIATTR0.0C") || stringArray2[0].startsWith("RIATTR0.0N") || stringArray2[0].equalsIgnoreCase("CDF0.0")))) {
            h4Vdata = new H4Vdata(this, stringArray[0], string, lArray);
        }
        log.trace("getVdata(): finish");
        return h4Vdata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final H4Group getVGroup(int n, int n2, String string, H4Group h4Group, boolean bl) {
        int n3 = -1;
        H4Group h4Group2 = null;
        String[] stringArray = new String[]{""};
        String[] stringArray2 = new String[]{""};
        long[] lArray = new long[]{n, n2};
        log.trace("getVGroup(): start");
        if (bl) {
            this.objList.add(lArray);
        } else if (this.find(lArray)) {
            return null;
        }
        try {
            n3 = HDFLibrary.Vattach(this.fid, n2, "r");
            HDFLibrary.Vgetclass(n3, stringArray2);
            stringArray2[0] = stringArray2[0].trim();
            HDFLibrary.Vgetname(n3, stringArray);
        }
        catch (HDFException hDFException) {
            n3 = -1;
        }
        finally {
            try {
                HDFLibrary.Vdetach(n3);
            }
            catch (HDFException hDFException) {
                log.debug("Vdetach failure: ", (Throwable)hDFException);
            }
        }
        if (this.showAll || n3 != -1 && !stringArray2[0].equalsIgnoreCase("RIG0.0") && !stringArray2[0].equalsIgnoreCase("RI0.0") && !stringArray2[0].equalsIgnoreCase("RIATTR0.0N") && !stringArray2[0].equalsIgnoreCase("RIATTR0.0C") && !stringArray2[0].equalsIgnoreCase("CDF0.0")) {
            h4Group2 = new H4Group(this, stringArray[0], string, h4Group, lArray);
        }
        log.trace("getVGroup(): finish");
        return h4Group2;
    }

    private final boolean find(long[] lArray) {
        boolean bl = false;
        if (this.objList == null) {
            return false;
        }
        int n = this.objList.size();
        long[] lArray2 = null;
        for (int i = 0; i < n; ++i) {
            lArray2 = (long[])this.objList.get(i);
            if (lArray2[0] != lArray[0] || lArray2[1] != lArray[1]) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.objList.add(lArray);
        }
        return bl;
    }

    int getGRAccessID() {
        return this.grid;
    }

    int getSDAccessID() {
        return this.sdid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getFileAnnotation(int n, List vector) throws HDFException {
        if (n < 0) {
            return vector;
        }
        int n2 = -1;
        try {
            n2 = HDFLibrary.ANstart(n);
            int[] nArray = new int[4];
            HDFLibrary.ANfileinfo(n2, nArray);
            if (nArray[0] + nArray[1] <= 0) {
                try {
                    HDFLibrary.ANend(n2);
                }
                catch (HDFException hDFException) {
                    log.debug("ANend failure: ", (Throwable)hDFException);
                }
                Vector<Attribute> vector2 = vector;
                return vector2;
            }
            if (vector == null) {
                vector = new Vector<Attribute>(nArray[0] + nArray[1], 5);
            }
            int n3 = -1;
            int[] nArray2 = new int[]{2, 3};
            for (int i = 0; i < 2; ++i) {
                String string = null;
                string = i == 0 ? "File Label" : "File Description";
                for (int j = 0; j < nArray[i]; ++j) {
                    try {
                        n3 = HDFLibrary.ANselect(n2, j, nArray2[i]);
                    }
                    catch (HDFException hDFException) {
                        n3 = -1;
                    }
                    if (n3 == -1) {
                        try {
                            HDFLibrary.ANendaccess(n3);
                        }
                        catch (HDFException hDFException) {
                            log.debug("ANendaccess failure: ", (Throwable)hDFException);
                        }
                        continue;
                    }
                    int n4 = 0;
                    try {
                        n4 = HDFLibrary.ANannlen(n3) + 1;
                    }
                    catch (HDFException hDFException) {
                        n4 = 0;
                    }
                    if (n4 > 0) {
                        boolean bl = false;
                        String[] stringArray = new String[]{""};
                        try {
                            bl = HDFLibrary.ANreadann(n3, stringArray, n4);
                        }
                        catch (HDFException hDFException) {
                            bl = false;
                        }
                        if (bl && stringArray[0].length() > 0) {
                            long[] lArray = new long[]{stringArray[0].length()};
                            Attribute attribute = new Attribute(string + " #" + j, new H4Datatype(4), lArray);
                            vector.add(attribute);
                            attribute.setValue(stringArray[0]);
                        }
                    }
                    try {
                        HDFLibrary.ANendaccess(n3);
                        continue;
                    }
                    catch (HDFException hDFException) {
                        log.debug("ANendaccess failure: ", (Throwable)hDFException);
                    }
                }
            }
        }
        finally {
            try {
                HDFLibrary.ANend(n2);
            }
            catch (HDFException hDFException) {
                log.debug("ANend failure: ", (Throwable)hDFException);
            }
        }
        return vector;
    }

    private List getGRglobleAttribute(int n, List vector) throws HDFException {
        if (n == -1) {
            return vector;
        }
        int[] nArray = new int[]{0, 0};
        HDFLibrary.GRfileinfo(n, nArray);
        int n2 = nArray[1];
        if (n2 > 0) {
            if (vector == null) {
                vector = new Vector<Attribute>(n2, 5);
            }
            String[] stringArray = new String[1];
            for (int i = 0; i < n2; ++i) {
                stringArray[0] = "";
                boolean bl = false;
                try {
                    bl = HDFLibrary.GRattrinfo(n, i, stringArray, nArray);
                    nArray[0] = nArray[0] & 0xFFFFBFFF;
                }
                catch (HDFException hDFException) {
                    bl = false;
                }
                if (!bl) continue;
                long[] lArray = new long[]{nArray[1]};
                Attribute attribute = new Attribute(stringArray[0], new H4Datatype(nArray[0]), lArray);
                vector.add(attribute);
                String[] stringArray2 = H4Datatype.allocateArray(nArray[0], nArray[1]);
                try {
                    HDFLibrary.GRgetattr(n, i, stringArray2);
                }
                catch (HDFException hDFException) {
                    stringArray2 = null;
                }
                if (stringArray2 == null) continue;
                if (nArray[0] == 4 || nArray[0] == 3) {
                    stringArray2 = Dataset.byteToString((byte[])stringArray2, nArray[1]);
                }
                attribute.setValue(stringArray2);
            }
        }
        return vector;
    }

    private List getSDSglobleAttribute(int n, List vector) throws HDFException {
        if (n == -1) {
            return vector;
        }
        int[] nArray = new int[]{0, 0};
        HDFLibrary.SDfileinfo(n, nArray);
        int n2 = nArray[1];
        if (n2 > 0) {
            if (vector == null) {
                vector = new Vector<Attribute>(n2, 5);
            }
            String[] stringArray = new String[1];
            for (int i = 0; i < n2; ++i) {
                stringArray[0] = "";
                boolean bl = false;
                try {
                    bl = HDFLibrary.SDattrinfo(n, i, stringArray, nArray);
                    nArray[0] = nArray[0] & 0xFFFFBFFF;
                }
                catch (HDFException hDFException) {
                    bl = false;
                }
                if (!bl) continue;
                long[] lArray = new long[]{nArray[1]};
                Attribute attribute = new Attribute(stringArray[0], new H4Datatype(nArray[0]), lArray);
                vector.add(attribute);
                String[] stringArray2 = H4Datatype.allocateArray(nArray[0], nArray[1]);
                try {
                    HDFLibrary.SDreadattr(n, i, stringArray2);
                }
                catch (HDFException hDFException) {
                    stringArray2 = null;
                }
                if (stringArray2 == null) continue;
                if (nArray[0] == 4 || nArray[0] == 3) {
                    stringArray2 = Dataset.byteToString((byte[])stringArray2, nArray[1]);
                }
                attribute.setValue(stringArray2);
            }
        }
        return vector;
    }

    @Override
    public String getLibversion() {
        int[] nArray = new int[3];
        String string = "HDF ";
        String[] stringArray = new String[]{""};
        try {
            HDFLibrary.Hgetlibversion(nArray, stringArray);
        }
        catch (HDFException hDFException) {
            log.debug("Hgetlibversion failure: ", (Throwable)hDFException);
        }
        string = string + nArray[0] + "." + nArray[1] + "." + nArray[2];
        log.debug("libversion is {}", (Object)string);
        return string;
    }

    private boolean isNetCDF(String string) {
        boolean bl = false;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
        }
        catch (Exception exception) {
            log.debug("RandaomAccessFile {}", (Object)string, (Object)exception);
            try {
                randomAccessFile.close();
            }
            catch (Exception exception2) {
                log.debug("RAF.close  failure: ", (Throwable)exception2);
            }
            randomAccessFile = null;
        }
        if (randomAccessFile == null) {
            return false;
        }
        byte[] byArray = new byte[4];
        try {
            randomAccessFile.read(byArray);
        }
        catch (Exception exception) {
            byArray = null;
        }
        if (byArray != null) {
            bl = byArray[0] == 67 && byArray[1] == 68 && byArray[2] == 70 && byArray[3] == 1;
        }
        try {
            randomAccessFile.close();
        }
        catch (Exception exception) {
            log.debug("RAF.close failure: ", (Throwable)exception);
        }
        return bl;
    }

    @Override
    public HObject get(String string) throws Exception {
        if (this.objList == null) {
            this.objList = new Vector();
        }
        if (string == null || string.length() <= 0) {
            return null;
        }
        if (!(string = string.replace('\\', '/')).startsWith("/")) {
            string = "/" + string;
        }
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        if (string.equals("/")) {
            string2 = "/";
            bl = true;
        } else {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 2);
            }
            int n = string.lastIndexOf(47);
            string2 = string.substring(n + 1);
            string3 = n == 0 ? "/" : string.substring(0, n);
        }
        HObject hObject = null;
        this.isReadOnly = false;
        if (this.fid < 0) {
            this.fid = HDFLibrary.Hopen(this.fullFileName, 2);
            if (this.fid < 0) {
                this.isReadOnly = true;
                this.fid = HDFLibrary.Hopen(this.fullFileName, 1);
            }
            HDFLibrary.Vstart(this.fid);
            this.grid = HDFLibrary.GRstart(this.fid);
            this.sdid = HDFLibrary.SDstart(this.fullFileName, this.flag);
        }
        hObject = bl ? this.getRootGroup() : this.getAttachedObject(string3, string2);
        return hObject;
    }

    private H4Group getRootGroup() {
        Dataset dataset;
        int n;
        H4Group h4Group = null;
        long[] lArray = new long[]{0L, 0L};
        int n2 = 0;
        int n3 = -1;
        int[] nArray = null;
        h4Group = new H4Group(this, "/", null, null, lArray);
        int[] nArray2 = new int[1];
        int[] nArray3 = null;
        try {
            n2 = HDFLibrary.Vlone(this.fid, nArray2, 0);
            nArray3 = new int[n2];
            n2 = HDFLibrary.Vlone(this.fid, nArray3, n2);
        }
        catch (HDFException hDFException) {
            n2 = 0;
        }
        for (n = 0; n < n2; ++n) {
            n3 = nArray3[n];
            H4Group h4Group2 = this.getVGroup(1965, n3, "/", h4Group, false);
            if (h4Group2 == null) continue;
            h4Group.addToMemberList(h4Group2);
        }
        nArray = new int[2];
        n = 0;
        try {
            n = HDFLibrary.GRfileinfo(this.grid, nArray) ? 1 : 0;
        }
        catch (HDFException hDFException) {
            n = 0;
        }
        if (n != 0) {
            n2 = nArray[0];
            for (int i = 0; i < n2; ++i) {
                dataset = this.getGRImage(306, i, "/", false);
                if (dataset == null) continue;
                h4Group.addToMemberList(dataset);
            }
        }
        try {
            n = HDFLibrary.SDfileinfo(this.sdid, nArray) ? 1 : 0;
        }
        catch (HDFException hDFException) {
            n = 0;
        }
        if (n != 0) {
            n2 = nArray[0];
            for (int i = 0; i < n2; ++i) {
                dataset = this.getSDS(720, i, "/", false);
                if (dataset == null) continue;
                h4Group.addToMemberList(dataset);
            }
        }
        try {
            n2 = HDFLibrary.VSlone(this.fid, nArray2, 0);
            nArray3 = new int[n2];
            n2 = HDFLibrary.VSlone(this.fid, nArray3, n2);
        }
        catch (HDFException hDFException) {
            n2 = 0;
        }
        for (int i = 0; i < n2; ++i) {
            n3 = nArray3[i];
            dataset = this.getVdata(1963, n3, "/", false);
            if (dataset == null) continue;
            h4Group.addToMemberList(dataset);
        }
        if (h4Group != null) {
            List list = null;
            try {
                list = h4Group.getMetadata();
            }
            catch (HDFException hDFException) {
                log.debug("rootGroup.getMetadata failure: ", (Throwable)hDFException);
            }
            if (list != null) {
                try {
                    this.getFileAnnotation(this.fid, list);
                }
                catch (HDFException hDFException) {
                    log.debug("getFileAnnotation failure: ", (Throwable)hDFException);
                }
                try {
                    this.getGRglobleAttribute(this.grid, list);
                }
                catch (HDFException hDFException) {
                    log.debug("getGRglobleAttribute failure: ", (Throwable)hDFException);
                }
                try {
                    this.getSDSglobleAttribute(this.sdid, list);
                }
                catch (HDFException hDFException) {
                    log.debug("getSDSglobleAttribute failure: ", (Throwable)hDFException);
                }
            }
        }
        return h4Group;
    }

    private HObject getAttachedObject(String string, String string2) {
        if (string2 == null || string2.length() <= 0) {
            return null;
        }
        HObject hObject = null;
        String[] stringArray = new String[]{""};
        int n = -1;
        try {
            n = HDFLibrary.GRnametoindex(this.grid, string2);
        }
        catch (HDFException hDFException) {
            n = -1;
        }
        if (n >= 0) {
            return this.getGRImage(306, n, "/", false);
        }
        try {
            n = HDFLibrary.SDnametoindex(this.sdid, string2);
        }
        catch (HDFException hDFException) {
            n = -1;
        }
        if (n >= 0) {
            return this.getSDS(720, n, "/", false);
        }
        int n2 = 0;
        try {
            n2 = HDFLibrary.Vfind(this.fid, string2);
        }
        catch (HDFException hDFException) {
            n2 = -1;
        }
        if (n2 > 0) {
            long[] lArray = new long[]{1965L, n2};
            H4Group h4Group = new H4Group(this, stringArray[0], string, null, lArray);
            this.depth_first(null, h4Group);
            return h4Group;
        }
        try {
            n2 = HDFLibrary.VSfind(this.fid, string2);
        }
        catch (HDFException hDFException) {
            n2 = -1;
        }
        if (n2 > 0) {
            return this.getVdata(1963, n2, "/", false);
        }
        return hObject;
    }
}

