/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.hdf5.util;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Tools;
import com.rapidminer.hdf5.HDF5Attribute;
import java.lang.reflect.Array;
import java.util.Arrays;

public class ConverterUtil {
    public static void convert(Attribute a, HDF5Attribute h5a, Object srcArr, int srcOff, Object trgArr, int trgOff, int length) {
        if (srcArr.getClass() == trgArr.getClass()) {
            System.arraycopy(srcArr, srcOff, trgArr, trgOff, length);
            return;
        }
        if (srcArr instanceof double[]) {
            ConverterUtil.convert(a, (double[])srcArr, srcOff, trgArr, trgOff, length);
            return;
        }
        if (trgArr instanceof double[]) {
            ConverterUtil.convert(a, h5a, srcArr, srcOff, (double[])trgArr, trgOff, length);
            return;
        }
        double[] tmp = new double[length];
        ConverterUtil.convert(a, h5a, srcArr, srcOff, tmp, 0, length);
        ConverterUtil.convert(a, tmp, 0, trgArr, trgOff, length);
    }

    public static void convert(Attribute a, double[] srcArr, int srcOff, Object trgArr, int trgOff, int length) {
        if (trgArr instanceof double[]) {
            System.arraycopy(srcArr, srcOff, trgArr, trgOff, length);
            return;
        }
        if (trgArr instanceof float[]) {
            ConverterUtil.convert(srcArr, srcOff, (float[])trgArr, trgOff, length);
            return;
        }
        if (trgArr instanceof long[]) {
            ConverterUtil.convert(srcArr, srcOff, (long[])trgArr, trgOff, length);
            return;
        }
        if (trgArr instanceof int[]) {
            ConverterUtil.convert(srcArr, srcOff, (int[])trgArr, trgOff, length);
            return;
        }
        if (trgArr instanceof short[]) {
            ConverterUtil.convert(srcArr, srcOff, (short[])trgArr, trgOff, length);
            return;
        }
        if (trgArr instanceof byte[]) {
            ConverterUtil.convert(srcArr, srcOff, (byte[])trgArr, trgOff, length);
            return;
        }
        if (trgArr instanceof String[]) {
            ConverterUtil.convert(a, srcArr, srcOff, (String[])trgArr, trgOff, length);
            return;
        }
    }

    static void convert(double[] srcArr, int srcOff, float[] trgArr, int trgOff, int length) {
        for (int i = 0; i < length; ++i) {
            trgArr[trgOff + i] = (float)srcArr[srcOff + i];
        }
    }

    static void convert(double[] srcArr, int srcOff, long[] trgArr, int trgOff, int length) {
        for (int i = 0; i < length; ++i) {
            trgArr[trgOff + i] = (long)srcArr[srcOff + i];
        }
    }

    static void convert(double[] srcArr, int srcOff, int[] trgArr, int trgOff, int length) {
        for (int i = 0; i < length; ++i) {
            trgArr[trgOff + i] = (int)srcArr[srcOff + i];
        }
    }

    static void convert(double[] srcArr, int srcOff, short[] trgArr, int trgOff, int length) {
        for (int i = 0; i < length; ++i) {
            trgArr[trgOff + i] = (short)srcArr[srcOff + i];
        }
    }

    static void convert(double[] srcArr, int srcOff, byte[] trgArr, int trgOff, int length) {
        for (int i = 0; i < length; ++i) {
            trgArr[trgOff + i] = (byte)srcArr[srcOff + i];
        }
    }

    static void convert(Attribute a, double[] srcArr, int srcOff, String[] trgArr, int trgOff, int length) {
        if (a.isDateTime() || a.isNominal()) {
            for (int i = 0; i < length; ++i) {
                trgArr[trgOff + i] = a.getAsString(srcArr[srcOff + i], 0, false);
            }
        } else {
            throw new IllegalArgumentException("Attribute type not supported: " + a);
        }
    }

    public static void convert(Attribute a, HDF5Attribute h5a, Object srcArr, int srcOff, double[] trgArr, int trgOff, int length) {
        if (srcArr instanceof double[]) {
            System.arraycopy(srcArr, srcOff, trgArr, trgOff, length);
            return;
        }
        if (srcArr instanceof float[]) {
            ConverterUtil.convert((float[])srcArr, srcOff, trgArr, trgOff, length);
            return;
        }
        if (srcArr instanceof long[]) {
            ConverterUtil.convert((long[])srcArr, srcOff, trgArr, trgOff, length);
            return;
        }
        if (srcArr instanceof int[]) {
            ConverterUtil.convert((int[])srcArr, srcOff, trgArr, trgOff, length);
            return;
        }
        if (srcArr instanceof short[]) {
            ConverterUtil.convert((short[])srcArr, srcOff, trgArr, trgOff, length);
            return;
        }
        if (srcArr instanceof byte[]) {
            ConverterUtil.convert((byte[])srcArr, srcOff, trgArr, trgOff, length);
            return;
        }
        if (srcArr instanceof String[]) {
            ConverterUtil.convert(a, h5a, (String[])srcArr, srcOff, trgArr, trgOff, length);
            return;
        }
    }

    static void convert(float[] srcArr, int srcOff, double[] trgArr, int trgOff, int length) {
        for (int i = 0; i < length; ++i) {
            trgArr[trgOff + i] = srcArr[srcOff + i];
        }
    }

    static void convert(long[] srcArr, int srcOff, double[] trgArr, int trgOff, int length) {
        for (int i = 0; i < length; ++i) {
            trgArr[trgOff + i] = srcArr[srcOff + i];
        }
    }

    static void convert(int[] srcArr, int srcOff, double[] trgArr, int trgOff, int length) {
        for (int i = 0; i < length; ++i) {
            trgArr[trgOff + i] = srcArr[srcOff + i];
        }
    }

    static void convert(short[] srcArr, int srcOff, double[] trgArr, int trgOff, int length) {
        for (int i = 0; i < length; ++i) {
            trgArr[trgOff + i] = srcArr[srcOff + i];
        }
    }

    static void convert(byte[] srcArr, int srcOff, double[] trgArr, int trgOff, int length) {
        for (int i = 0; i < length; ++i) {
            trgArr[trgOff + i] = srcArr[srcOff + i];
        }
    }

    static void convert(Attribute a, HDF5Attribute h5a, String[] srcArr, int srcOff, double[] trgArr, int trgOff, int length) {
        if (a.isDateTime() || a.isNominal()) {
            for (int i = 0; i < length; ++i) {
                int value = a.getMapping().getIndex(srcArr[srcOff + i]);
                if (h5a != null) {
                    value = h5a.map2HDF(value);
                }
                trgArr[trgOff + i] = value;
            }
        } else {
            throw new IllegalArgumentException("Attribute type not supported: " + a);
        }
    }

    public static void reduce(Attribute att, HDF5Attribute h5Att, Object srcArr, int srcOff, Object trgArr, int trgOff, int length) {
        if (srcArr.getClass() != trgArr.getClass()) {
            Object tmpArr = Array.newInstance(srcArr.getClass().getComponentType(), length);
            ConverterUtil.reduce(att, h5Att, srcArr, srcOff, tmpArr, 0, length);
            ConverterUtil.convert(att, h5Att, tmpArr, 0, trgArr, trgOff, length);
            return;
        }
        if (srcArr instanceof double[]) {
            ConverterUtil.reduce(h5Att, (double[])srcArr, srcOff, (double[])trgArr, trgOff, length);
            return;
        }
        if (srcArr instanceof float[]) {
            ConverterUtil.reduce(h5Att, (float[])srcArr, srcOff, (float[])trgArr, trgOff, length);
            return;
        }
        if (srcArr instanceof long[]) {
            ConverterUtil.reduce(h5Att, (long[])srcArr, srcOff, (long[])trgArr, trgOff, length);
            return;
        }
        if (srcArr instanceof int[]) {
            ConverterUtil.reduce(h5Att, (int[])srcArr, srcOff, (int[])trgArr, trgOff, length);
            return;
        }
        if (srcArr instanceof short[]) {
            ConverterUtil.reduce(h5Att, (short[])srcArr, srcOff, (short[])trgArr, trgOff, length);
            return;
        }
        if (srcArr instanceof byte[]) {
            ConverterUtil.reduce(h5Att, (byte[])srcArr, srcOff, (byte[])trgArr, trgOff, length);
            return;
        }
        if (srcArr instanceof String[]) {
            ConverterUtil.reduce(h5Att, (String[])srcArr, srcOff, (String[])trgArr, trgOff, length);
            return;
        }
    }

    static void reduce(HDF5Attribute h5Att, double[] srcArr, int srcOff, double[] trgArr, int trgOff, int length) {
        for (int i = 0; i < length; ++i) {
            trgArr[trgOff + i] = srcArr[h5Att.getSubindices(srcOff + i)[0]];
        }
    }

    static void reduce(HDF5Attribute h5Att, float[] srcArr, int srcOff, float[] trgArr, int trgOff, int length) {
        for (int i = 0; i < length; ++i) {
            trgArr[trgOff + i] = srcArr[h5Att.getSubindices(srcOff + i)[0]];
        }
    }

    static void reduce(HDF5Attribute h5Att, long[] srcArr, int srcOff, long[] trgArr, int trgOff, int length) {
        for (int i = 0; i < length; ++i) {
            trgArr[trgOff + i] = srcArr[h5Att.getSubindices(srcOff + i)[0]];
        }
    }

    static void reduce(HDF5Attribute h5Att, int[] srcArr, int srcOff, int[] trgArr, int trgOff, int length) {
        for (int i = 0; i < length; ++i) {
            trgArr[trgOff + i] = srcArr[h5Att.getSubindices(srcOff + i)[0]];
        }
    }

    static void reduce(HDF5Attribute h5Att, short[] srcArr, int srcOff, short[] trgArr, int trgOff, int length) {
        for (int i = 0; i < length; ++i) {
            trgArr[trgOff + i] = srcArr[h5Att.getSubindices(srcOff + i)[0]];
        }
    }

    static void reduce(HDF5Attribute h5Att, byte[] srcArr, int srcOff, byte[] trgArr, int trgOff, int length) {
        for (int i = 0; i < length; ++i) {
            trgArr[trgOff + i] = srcArr[h5Att.getSubindices(srcOff + i)[0]];
        }
    }

    static void reduce(HDF5Attribute h5Att, String[] srcArr, int srcOff, String[] trgArr, int trgOff, int length) {
        for (int i = 0; i < length; ++i) {
            trgArr[trgOff + i] = srcArr[h5Att.getSubindices(srcOff + i)[0]];
        }
    }

    public static void reorganize(double[][] source, double[][] target, int size, Double fillValue) {
        int b = 0;
        for (double[] arr : source) {
            if (arr == null) continue;
            b = arr.length;
            break;
        }
        if (b == 0) {
            return;
        }
        int c = target.length;
        int d = (int)Math.ceil((double)size / (double)c);
        int n = 0;
        int k = 1;
        int i = 1;
        while (n < size) {
            int old = n;
            n = Math.min(i * b, k * d);
            n = Math.min(n, size);
            int length = n - old;
            if (source[i - 1] != null) {
                boolean copy;
                int srcOff = old % b;
                if (fillValue != null) {
                    copy = false;
                    for (int l = 0; l < length; ++l) {
                        if (Tools.isDefault((double)fillValue, (double)source[i - 1][srcOff + l])) continue;
                        copy = true;
                        break;
                    }
                } else {
                    copy = true;
                }
                if (copy) {
                    if (target[k - 1] == null) {
                        target[k - 1] = new double[d];
                        if (fillValue != null) {
                            Arrays.fill(target[k - 1], fillValue);
                        }
                    }
                    System.arraycopy(source[i - 1], srcOff, target[k - 1], old % d, length);
                }
            }
            if (n % b == 0) {
                ++i;
            }
            if (n % d != 0) continue;
            ++k;
        }
        if (c * d > size && target[c - 1] != null && target[c - 1].length != size % d) {
            double[] rest = new double[size % d];
            System.arraycopy(target[c - 1], 0, rest, 0, rest.length);
            target[c - 1] = rest;
        }
    }
}

