/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.hdf5;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SimpleExampleSet;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.hdf5.HDF5Attribute;
import com.rapidminer.hdf5.HDF5DatasetExampleTable;
import com.rapidminer.hdf5.util.ConverterUtil;
import com.rapidminer.tools.LogService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import ncsa.hdf.hdf5lib.exceptions.HDF5ObjectHeaderException;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.object.h5.H5CompoundDS;
import ncsa.hdf.object.h5.H5Datatype;
import ncsa.hdf.object.h5.H5ScalarDS;

public class HDF5WriteUtil {
    public static final Comparator<Attribute> attributeComparator = (att1, att2) -> {
        if (att1 == null) {
            return att2 == null ? 0 : -1;
        }
        if (att2 == null) {
            return 1;
        }
        return att1.getTableIndex() - att2.getTableIndex();
    };

    public static Dataset createDataset(ExampleSet srcSet, int eH, Group group, String name, long[] chunks, int gzip) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Iterator attIter = srcSet.getAttributes().allAttributes();
        while (attIter.hasNext()) {
            attributes.add((Attribute)attIter.next());
        }
        Collections.sort(attributes, attributeComparator);
        return HDF5WriteUtil.createDataset(srcSet.getExampleTable(), group, name, attributes, eH, chunks, gzip, srcSet.size());
    }

    public static Dataset createDataset(ExampleTable srcTable, Group group, String name, List<Attribute> attributes, int eH, long[] chunks, int gzip, int size) {
        if (group == null || name == null || name.trim().isEmpty() || size < 1) {
            throw new IllegalArgumentException();
        }
        if (attributes == null) {
            attributes = Arrays.asList(srcTable.getAttributes());
        }
        attributes = new ArrayList<Attribute>(attributes);
        while (attributes.contains(null)) {
            attributes.remove(null);
        }
        if (attributes.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Collections.sort(attributes, attributeComparator);
        return HDF5WriteUtil.createCompound(srcTable, group, name, attributes, eH, chunks, gzip, size);
    }

    private static Dataset createCompound(ExampleTable srcTable, Group group, String name, List<Attribute> attributes, int eH, long[] chunks, int gzip, int size) {
        long[] dims = new long[]{size};
        String[] memberNames = new String[attributes.size()];
        Datatype[] memberDatatypes = new Datatype[attributes.size()];
        ArrayList<Integer> enumIndices = new ArrayList<Integer>();
        int[] memberRanks = new int[attributes.size()];
        long[][] memberDims = new long[attributes.size()][];
        boolean isHDFBacked = srcTable instanceof HDF5DatasetExampleTable;
        HDF5DatasetExampleTable h5Table = null;
        if (isHDFBacked) {
            h5Table = (HDF5DatasetExampleTable)srcTable;
        }
        int i = 0;
        String prefix = name + ".";
        for (Attribute a : attributes) {
            memberNames[i] = a.getName();
            int prefixIndex = memberNames[i].indexOf(prefix);
            if (prefixIndex >= 0) {
                memberNames[i] = memberNames[i].substring(prefixIndex + prefix.length());
            }
            memberDatatypes[i] = isHDFBacked ? HDF5WriteUtil.getDatatypeFromAttribute(a, eH, h5Table, size) : HDF5WriteUtil.getDatatypeFromAttribute(a, eH, size);
            if (memberDatatypes[i].getDatatypeClass() == 8) {
                enumIndices.add(i);
            }
            ++i;
        }
        if (enumIndices.isEmpty()) {
            enumIndices = null;
        } else {
            Collections.sort(enumIndices, (i1, i2) -> memberDatatypes[i2].getEnumMembers().length() - memberDatatypes[i1].getEnumMembers().length());
        }
        while (enumIndices == null || !enumIndices.isEmpty()) {
            try {
                return H5CompoundDS.create(name, group, dims, null, chunks, gzip, memberNames, memberDatatypes, memberRanks, memberDims, null);
            }
            catch (Exception e) {
                if (enumIndices != null && eH == 0 && e instanceof HDF5ObjectHeaderException && e.getMessage().equals("Unable to initialize object")) {
                    int index = (Integer)enumIndices.remove(0);
                    LogService.getRoot().log(Level.WARNING, "Converting " + memberNames[index] + " to string and trying again.", e);
                    memberDatatypes[index] = new H5Datatype(3, -1, -1, -1);
                    continue;
                }
                LogService.getRoot().log(Level.SEVERE, e.getMessage(), e);
                break;
            }
        }
        return null;
    }

    private static Datatype getDatatypeFromAttribute(Attribute a, int eH, HDF5DatasetExampleTable srcTable, int size) {
        int index = a.getTableIndex();
        Datatype type = null;
        HDF5Attribute h5att = (HDF5Attribute)srcTable.h5AttMapping.get(index);
        if (h5att == null) {
            return HDF5WriteUtil.getDatatypeFromAttribute(a, eH, size);
        }
        if (srcTable.isComp) {
            type = ((CompoundDS)srcTable.dataset).getMemberTypes()[h5att.getIndex()];
            type = new H5Datatype(type.toNative());
        } else {
            type = ((ScalarDS)srcTable.dataset).getDatatype();
        }
        if (type.getDatatypeClass() == 10) {
            type = type.getBasetype();
        }
        if (eH == 2 && type.getDatatypeClass() == 3 || eH == 1 && type.getDatatypeClass() == 8) {
            return HDF5WriteUtil.getDatatypeFromAttribute(a, eH, size);
        }
        if (srcTable.newValues != null && srcTable.newValues.containsKey(index)) {
            type = HDF5WriteUtil.checkForUpgrade(a, type);
        }
        return type;
    }

    static Datatype checkForUpgrade(Attribute a, Datatype type) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        switch (type.getDatatypeClass()) {
            case 8: {
                min = 0.0;
                max = a.getMapping().size();
                break;
            }
            case 0: 
            case 1: {
                try {
                    min = a.getStatistics("minimum");
                    max = a.getStatistics("maximum");
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                return type;
            }
        }
        return HDF5WriteUtil.checkForUpgrade(type, min, max);
    }

    static Datatype checkForUpgrade(Datatype type, double min, double max) {
        int nBytes = type.getDatatypeClass() == 1 ? HDF5WriteUtil.findNBytesFloat(min, max) : HDF5WriteUtil.findNBytesInt(min, max);
        boolean newSign = min < 0.0 && type.getDatatypeClass() != 1 && type.getDatatypeSign() == 0;
        H5Datatype newType = new H5Datatype(type.getDatatypeClass(), nBytes, -1, -1);
        int tid = ((Datatype)newType).toNative();
        if (newSign && type.getDatatypeSize() > H5Datatype.getDatatypeSize(tid)) {
            nBytes = type.getDatatypeSize();
            newType = new H5Datatype(type.getDatatypeClass(), nBytes, -1, -1);
            tid = ((Datatype)newType).toNative();
        }
        if (newSign || H5Datatype.getDatatypeSize(tid) > type.getDatatypeSize()) {
            return newType;
        }
        return type;
    }

    public static Datatype getDatatypeFromAttribute(Attribute a, int eH, int size) {
        int typeID;
        int nBytes = -1;
        String enums = null;
        switch (a.getValueType()) {
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                NominalMapping mapping = a.getMapping();
                if (eH == 1 || eH == 0 && HDF5WriteUtil.useAsEnum(mapping, size)) {
                    typeID = 8;
                    nBytes = HDF5WriteUtil.findNBytesInt(0.0, mapping.size() - 1);
                    enums = HDF5WriteUtil.enumFromMapping(mapping);
                    break;
                }
                typeID = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                typeID = 0;
                nBytes = 8;
                break;
            }
            case 3: {
                typeID = 0;
                double min = Double.POSITIVE_INFINITY;
                double max = Double.NEGATIVE_INFINITY;
                try {
                    min = a.getStatistics("minimum");
                    max = a.getStatistics("maximum");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                nBytes = HDF5WriteUtil.findNBytesInt(min, max);
                break;
            }
            case 2: 
            case 4: {
                typeID = 1;
                double min = Double.POSITIVE_INFINITY;
                double max = Double.NEGATIVE_INFINITY;
                try {
                    min = a.getStatistics("minimum");
                    max = a.getStatistics("maximum");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                nBytes = HDF5WriteUtil.findNBytesFloat(min, max);
                break;
            }
            default: {
                typeID = 1;
                nBytes = 8;
            }
        }
        H5Datatype type = new H5Datatype(typeID, nBytes, -1, -1);
        if (enums != null) {
            type.setEnumMembers(enums);
        }
        return type;
    }

    private static boolean useAsEnum(NominalMapping mapping, int size) {
        int n = mapping.size();
        int length = 0;
        for (String s : mapping.getValues()) {
            length += s.length();
        }
        int nBytes = HDF5WriteUtil.findNBytesInt(0.0, n - 1);
        return 0 > length * (n - size) + n * (size + n) * nBytes;
    }

    private static int findNBytesInt(double min, double max) {
        if (Double.isInfinite(min) || Double.isInfinite(max)) {
            return -1;
        }
        if (min >= -128.0 && max <= 127.0) {
            return 1;
        }
        if (min >= -32768.0 && max <= 32767.0) {
            return 2;
        }
        if (min >= -2.147483648E9 && max <= 2.147483647E9) {
            return 4;
        }
        if (min >= -9.223372036854776E18 && max <= 9.223372036854776E18) {
            return 8;
        }
        return -1;
    }

    private static int findNBytesFloat(double min, double max) {
        if (Double.isInfinite(min) || Double.isInfinite(max) || Double.isNaN(min) || Double.isNaN(max)) {
            return -1;
        }
        min = Math.abs(min);
        max = Math.abs(max);
        if (min <= 3.4028234663852886E38 && max <= 3.4028234663852886E38 && min >= (double)1.4E-45f && max >= (double)1.4E-45f) {
            return 4;
        }
        return 8;
    }

    private static String enumFromMapping(NominalMapping mapping) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (String s : mapping.getValues()) {
            builder.append(s + "=" + i++ + ",");
        }
        return builder.toString();
    }

    private static Dataset createScalar(ExampleTable srcTable, Group group, String name, List<Attribute> attributes, long[] chunks, int gzip, int size) {
        Datatype datatype = srcTable instanceof HDF5DatasetExampleTable ? HDF5WriteUtil.getDatatypeFromAttribute(attributes.get(0), 0, (HDF5DatasetExampleTable)srcTable, size) : HDF5WriteUtil.getDatatypeFromAttribute(attributes.get(0), 0, size);
        try {
            return H5ScalarDS.create(name, group, datatype, new long[]{size}, null, chunks, gzip, null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Exception writeToDataset(ExampleSet source, Dataset target) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Iterator attIter = source.getAttributes().allAttributes();
        while (attIter.hasNext()) {
            attributes.add((Attribute)attIter.next());
        }
        Collections.sort(attributes, attributeComparator);
        source.recalculateAllAttributeStatistics();
        if (source instanceof SimpleExampleSet) {
            return HDF5WriteUtil.writeToDataset(source.getExampleTable(), target, attributes);
        }
        return HDF5WriteUtil.writeToDataset(source.iterator(), target, attributes, source.size());
    }

    public static Exception writeToDataset(ExampleTable source, Dataset target, List<Attribute> attributes) {
        if (attributes == null) {
            attributes = new ArrayList<Attribute>(Arrays.asList(source.getAttributes()));
            while (attributes.contains(null)) {
                attributes.remove(null);
            }
        }
        if (source instanceof HDF5DatasetExampleTable) {
            return HDF5WriteUtil.writeToDataset((HDF5DatasetExampleTable)source, target, attributes);
        }
        return HDF5WriteUtil.writeToDataset(source.getDataRowReader(), target, attributes, source.size());
    }

    static Exception writeToDataset(HDF5DatasetExampleTable source, Dataset target, List<Attribute> attributes) {
        int windowSize = HDF5WriteUtil.getTargetWindowSize(source, source.windowSize, target.getChunkSize());
        long targetStart = target.getStartDims()[0];
        boolean isComp = target instanceof CompoundDS;
        target.getStride();
        for (int currentWindowStart = 0; currentWindowStart < source.size(); currentWindowStart += windowSize) {
            Object targetData;
            Object sourceData;
            source.setActiveWindow(currentWindowStart);
            target.clear();
            target.getStartDims()[0] = targetStart + (long)currentWindowStart;
            target.getSelectedDims()[0] = source.dataset.getSelectedDims()[0];
            try {
                sourceData = source.dataset.getData();
                targetData = target.getData();
            }
            catch (Exception e) {
                e.printStackTrace();
                return e;
            }
            int memberIndex = 0;
            for (Attribute a : attributes) {
                Object sourceArr;
                int tmpIndex = a.getTableIndex();
                double[] newValues = null;
                HDF5Attribute h5Att = (HDF5Attribute)source.h5AttMapping.get(tmpIndex);
                if (h5Att != null) {
                    if (source.newValues != null && source.newValues.containsKey(tmpIndex)) {
                        newValues = source.newValues.get(tmpIndex)[currentWindowStart / windowSize];
                    }
                    if (source.isComp) {
                        tmpIndex = source.usedMembers.indexOf(h5Att.getIndex());
                        sourceArr = ((List)sourceData).get(tmpIndex);
                    } else {
                        sourceArr = sourceData;
                    }
                } else {
                    sourceArr = ((double[][])source.newAttributes.get(tmpIndex))[currentWindowStart / windowSize];
                }
                Object targetArr = isComp ? ((List)targetData).get(memberIndex) : targetData;
                int length = (int)target.getSelectedDims()[0];
                HDF5WriteUtil.transform(a, h5Att, sourceArr, 0, newValues, targetArr, 0, length);
                try {
                    target.write();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return e;
                }
                ++memberIndex;
            }
        }
        source.updateCacheSize();
        source.currentWindowStart = source.size();
        return null;
    }

    private static int getTargetWindowSize(HDF5DatasetExampleTable source, int windowSize, long[] chunkSize) {
        if (chunkSize == null || chunkSize[0] == 0L) {
            return windowSize;
        }
        if ((long)windowSize > chunkSize[0] && (long)windowSize % chunkSize[0] != 0L) {
            windowSize = (int)((long)windowSize - (long)windowSize % chunkSize[0]);
            if (source != null) {
                source.windowSize = windowSize;
                source.currentWindowStart = source.size();
                source.reorganizeStaticData();
            }
        }
        return windowSize;
    }

    private static void transform(Attribute att, HDF5Attribute h5Att, Object srcArr, int srcOff, double[] newValues, Object trgArr, int trgOff, int length) {
        if (h5Att != null && h5Att.isArray()) {
            ConverterUtil.reduce(att, h5Att, srcArr, srcOff, trgArr, trgOff, length);
        } else if (srcArr.getClass() == trgArr.getClass()) {
            System.arraycopy(srcArr, srcOff, trgArr, trgOff, length);
        } else {
            ConverterUtil.convert(att, h5Att, srcArr, srcOff, trgArr, trgOff, length);
        }
        HDF5WriteUtil.transformNewValues(att, h5Att, newValues, 0, trgArr, trgOff, length);
    }

    static void transformNewValues(Attribute att, HDF5Attribute h5Att, double[] newValues, int newOff, Object trgArr, int trgOff, int length) {
        if (newValues == null) {
            return;
        }
        boolean transformPoly = h5Att.isPolynominal() && !(trgArr instanceof String[]);
        for (int i = 0; i < length; ++i) {
            double value = newValues[newOff + i];
            if (Double.isInfinite(value)) continue;
            if (transformPoly) {
                value = h5Att.map2HDF((int)value);
            }
            int trgOffTmp = trgOff + (h5Att.isArray() ? h5Att.getSubindices(i)[0] : i);
            ConverterUtil.convert(att, new double[]{value}, 0, trgArr, trgOffTmp, 1);
        }
    }

    private static <E> Exception writeToDataset(Iterator<E> iterator, Dataset target, List<Attribute> attributes, int size) {
        int windowSize = (int)(9.375E7 / (double)attributes.size());
        windowSize = windowSize > size ? size : HDF5WriteUtil.getTargetWindowSize(null, windowSize, target.getChunkSize());
        int currentWindowStart = 0;
        boolean isComp = target instanceof CompoundDS;
        target.getStride();
        List dataList = null;
        Object targetArr = null;
        while (currentWindowStart < size) {
            Object targetData;
            target.clear();
            target.getStartDims()[0] = currentWindowStart;
            target.getSelectedDims()[0] = windowSize;
            try {
                targetData = target.getData();
            }
            catch (Exception e) {
                e.printStackTrace();
                return e;
            }
            if (isComp) {
                dataList = (List)targetData;
            } else {
                targetArr = targetData;
            }
            for (int relIndex = 0; relIndex < windowSize; ++relIndex) {
                E next = iterator.next();
                DataRow data = next instanceof Example ? ((Example)next).getDataRow() : (DataRow)next;
                int memberIndex = 0;
                for (Attribute a : attributes) {
                    if (isComp) {
                        targetArr = dataList.get(memberIndex);
                    }
                    ConverterUtil.convert(a, new double[]{data.get(a)}, 0, targetArr, relIndex, 1);
                    ++memberIndex;
                }
            }
            try {
                target.write();
            }
            catch (Exception e) {
                e.printStackTrace();
                return e;
            }
            if ((currentWindowStart += windowSize) + windowSize <= size) continue;
            windowSize = size - currentWindowStart;
        }
        return null;
    }
}

