/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.hdf5;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.BinominalMapping;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowReader;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.example.table.NominalAttribute;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.example.table.PolynominalMapping;
import com.rapidminer.hdf5.HDF5Attribute;
import com.rapidminer.hdf5.HDF5DatasetDataRow;
import com.rapidminer.hdf5.HDF5DatasetDataRowReader;
import com.rapidminer.hdf5.HDF5WriteUtil;
import com.rapidminer.hdf5.util.Compatiblity;
import com.rapidminer.hdf5.util.ConverterUtil;
import com.rapidminer.operator.OperatorException;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.object.h5.H5File;

public class HDF5DatasetExampleTable
extends MemoryExampleTable
implements Cloneable {
    private static final long serialVersionUID = 7928440078687627319L;
    static final int CACHE_MEMORY = 125000000;
    static final double WINDOW_CACHE_RATIO = 0.75;
    private static final double PRELOAD_RATIO = 0.25;
    Dataset dataset;
    private final long[] locks = new long[1];
    private boolean inMemory = false;
    private long lastAccess;
    private DateFormat df;
    SortedMap<Integer, HDF5Attribute> h5AttMapping;
    private List<HDF5Attribute> removedAtts;
    SortedMap<Integer, double[][]> newAttributes;
    Map<Integer, double[][]> newValues;
    List<Integer> compatible;
    List<Integer> usedMembers = new ArrayList<Integer>();
    private Map<Integer, Integer> arrayMembers;
    boolean isComp;
    private boolean isTemp = false;
    private int size;
    private int maxCacheSize;
    int windowSize;
    long chunkSize = -1L;
    int currentWindowStart = 0;
    private int maxLoadedIndex = -1;
    private LinkedHashMap<Integer, SoftReference<DataRow>> rowCache = new LinkedHashMap<Integer, SoftReference<DataRow>>(){
        private static final long serialVersionUID = 2793003887032957782L;

        @Override
        public SoftReference<DataRow> put(Integer key, SoftReference<DataRow> value) {
            if (value == null || value.get() == null) {
                return null;
            }
            return super.put(key, value);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        @Override
        public SoftReference<DataRow> get(Object key) {
            SoftReference value = (SoftReference)super.get(key);
            if (value == null) {
                return null;
            }
            if (value.get() == null) {
                this.remove(key);
                return null;
            }
            return value;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, SoftReference<DataRow>> eldest) {
            return eldest != null && (eldest.getValue() == null || eldest.getValue().get() == null);
        }
    };
    private Timer clearTimer = new Timer(true);
    private Timer updateTimer;
    private TimerTask clearer;
    private final boolean[] cancelled = new boolean[]{true};

    public HDF5DatasetExampleTable(Dataset dataset) throws OperatorException {
        this(dataset, new ArrayList<String>());
    }

    public HDF5DatasetExampleTable(Dataset dataset, List<String> joinAtts) throws OperatorException {
        super(new ArrayList());
        if (dataset == null) {
            throw new OperatorException("Data set must not be null.");
        }
        this.dataset = dataset;
        if (dataset instanceof CompoundDS) {
            this.isComp = true;
            this.createAttributes((CompoundDS)dataset, joinAtts);
        } else if (dataset instanceof ScalarDS) {
            this.isComp = false;
            this.createAttributes((ScalarDS)dataset);
        } else {
            throw new OperatorException("Dataset type " + dataset.getClass() + " of data set " + dataset.getFullName() + " not supported.");
        }
        if (this.getAttributeCount() == 0) {
            throw new OperatorException("No valid attributes found in data set " + dataset.getFullName());
        }
        this.size = (int)dataset.getDims()[0];
        if (dataset.getChunkSize() != null) {
            this.chunkSize = dataset.getChunkSize()[0];
        }
        this.updateCacheSize();
        dataset.getStride();
        this.startUpdateTimer();
    }

    private void createAttributes(ScalarDS scalar) {
        scalar.init();
        try {
            scalar.getMetadata();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.h5AttMapping = new TreeMap<Integer, HDF5Attribute>();
        String attName = scalar.getName();
        Datatype attType = scalar.getDatatype();
        int order = 1;
        long[] dims = scalar.getDims();
        for (int i = 1; i < dims.length; ++i) {
            order = (int)((long)order * dims[i]);
        }
        this.addAttribute(attType, attName, order, 0);
        scalar.clear();
    }

    private void createAttributes(CompoundDS comp, List<String> joinAtts) {
        comp.init();
        try {
            comp.getMetadata();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.h5AttMapping = new TreeMap<Integer, HDF5Attribute>();
        String[] attNames = comp.getMemberNames();
        Datatype[] attTypes = comp.getMemberTypes();
        int[] attOrders = comp.getMemberOrders();
        String setName = this.dataset.getFullName().substring(1).replace('/', '.');
        comp.setMemberSelection(false);
        int i = 0;
        while (i < attNames.length) {
            Datatype type = attTypes[i];
            String name = attNames[i];
            int order = attOrders[i];
            if (!joinAtts.contains(name)) {
                name = setName + "." + name;
            }
            this.addAttribute(type, name, order, i++);
        }
        for (int i2 : this.usedMembers) {
            comp.selectMember(i2);
        }
        comp.clear();
    }

    private void addAttribute(Datatype type, String name, int order, int ... index) {
        HDF5Attribute hdf5Att;
        int RMType;
        boolean isMultiDim;
        int HDFType = type.getDatatypeClass();
        boolean isArray = HDFType == 10 || HDFType == 9;
        boolean bl = isMultiDim = !this.isComp && order > 1 && index.length == 1;
        if (isArray || isMultiDim) {
            int i;
            int[] dims;
            if (index.length > 1) {
                return;
            }
            if (isMultiDim) {
                long[] dsdims = this.dataset.getDims();
                dims = new int[dsdims.length - 1];
                for (i = 1; i < dsdims.length; ++i) {
                    long dim = dsdims[i];
                    if (dim > Integer.MAX_VALUE) {
                        return;
                    }
                    dims[i - 1] = (int)dim;
                }
            } else {
                dims = ((CompoundDS)this.dataset).getMemberDims(index[0]);
                type = type.getBasetype();
            }
            index = Arrays.copyOf(index, index.length + 1);
            for (i = 0; i < order; ++i) {
                index = Arrays.copyOf(index, index.length);
                index[index.length - 1] = i;
                String suffix = "";
                int tmpOrder = i;
                for (int j = dims.length - 1; j >= 0; --j) {
                    int d = dims[j];
                    suffix = "[" + tmpOrder % d + "]" + suffix;
                    tmpOrder /= d;
                }
                this.addAttribute(type, name + suffix, order, index);
            }
            return;
        }
        String[] enums = null;
        switch (HDFType) {
            case 0: 
            case 2: {
                RMType = 3;
                break;
            }
            case 1: {
                RMType = 4;
                break;
            }
            case 8: {
                enums = type.getEnumMembers().split(",");
                RMType = enums.length > 2 ? 7 : 6;
                break;
            }
            case 3: {
                enums = this.createEnums(order, index);
                RMType = enums == null ? 5 : (enums.length > 2 ? 7 : 6);
                break;
            }
            case 11: {
                RMType = 9;
                break;
            }
            default: {
                return;
            }
        }
        Attribute att = AttributeFactory.createAttribute((String)name, (int)RMType);
        List<Integer> RM2HDF = null;
        if (enums != null && att instanceof NominalAttribute) {
            RM2HDF = HDF5DatasetExampleTable.createNominalMapping((NominalAttribute)att, enums);
            hdf5Att = new HDF5Attribute(index, order, RM2HDF);
        } else {
            hdf5Att = new HDF5Attribute(index, order);
        }
        this.h5AttMapping.put(super.addAttribute(att), hdf5Att);
        if (!this.usedMembers.contains(index[0])) {
            this.usedMembers.add(index[0]);
        } else {
            if (this.arrayMembers == null) {
                this.arrayMembers = new HashMap<Integer, Integer>();
            }
            int count = 2;
            if (this.arrayMembers.containsKey(index[0])) {
                count = this.arrayMembers.get(index[0]) + 1;
            }
            this.arrayMembers.put(index[0], count);
        }
    }

    private String[] createEnums(int order, int ... index) {
        int i;
        HashSet<String> strings = new HashSet<String>();
        if (this.isComp) {
            ((CompoundDS)this.dataset).selectMember(index[0]);
        }
        this.windowSize = 125000000;
        int exampleIndex = 0;
        while ((long)exampleIndex < this.dataset.getDims()[0]) {
            Object data;
            this.setActiveWindow(exampleIndex);
            try {
                data = this.dataset.getData();
            }
            catch (Exception e) {
                return null;
            }
            if (this.isComp) {
                try {
                    data = ((List)data).get(0);
                }
                catch (ClassCastException cce) {
                    return null;
                }
            }
            if (index.length > 1) {
                for (i = 0; i < this.size(); ++i) {
                    Object arr = Array.get(data, order * i + index[1]);
                    for (int j = 2; j < index.length; ++j) {
                        arr = Array.get(arr, index[j]);
                    }
                    strings.add((String)arr);
                }
            } else {
                strings.addAll(Arrays.asList((String[])data));
            }
            this.dataset.clear();
            exampleIndex += this.windowSize;
        }
        if (this.isComp) {
            ((CompoundDS)this.dataset).setMemberSelection(false);
        }
        String[] enums = new String[strings.size()];
        i = 0;
        for (String string : strings) {
            enums[i] = string + "=" + i++;
        }
        return enums;
    }

    private static List<Integer> createNominalMapping(NominalAttribute att, String[] enums) {
        BinominalMapping mapping;
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        ArrayList<Integer> RM2HDF = new ArrayList<Integer>();
        int mapkey = 0;
        for (String e : enums) {
            String[] kv = e.split("=");
            String value = kv[0];
            int key = new Integer(kv[1]);
            map.put(mapkey++, value);
            RM2HDF.add(key);
        }
        if (enums.length <= 2) {
            mapping = new BinominalMapping();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                mapping.setMapping((String)map.get(i), i);
            }
        } else {
            mapping = new PolynominalMapping(map);
        }
        att.setMapping((NominalMapping)mapping);
        return RM2HDF;
    }

    public int size() {
        return this.size;
    }

    public DataRowReader getDataRowReader() {
        try {
            this.maxLoadedIndex = -1;
            return new HDF5DatasetDataRowReader(this);
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DataRow getDataRow(int index) {
        try {
            return this.getDataRow(index, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.getDataRow(index, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private DataRow getDataRow(int index, boolean preload) {
        if (!preload && this.rowCache.containsKey(index)) {
            return this.rowCache.get(index).get();
        }
        this.setActiveWindow(index);
        long[] lArray = this.locks;
        synchronized (this.locks) {
            this.locks[0] = this.locks[0] + 1L;
            // ** MonitorExit[lArray] (shouldn't be in output)
            int relIndex = index % this.windowSize;
            boolean[] blArray = this.cancelled;
            synchronized (this.cancelled) {
                Object[] values;
                int attIndex;
                Object data;
                if (this.cancelled[0]) {
                    this.clearer = this.setCacheTimer();
                }
                // ** MonitorExit[blArray] (shouldn't be in output)
                try {
                    data = this.dataset.getData();
                }
                catch (Exception e) {
                    return null;
                }
                int numberOfRows = 1;
                if (preload) {
                    numberOfRows = (int)(this.dataset.getSelectedDims()[0] - (long)relIndex);
                }
                int[] indices = new int[this.getAttributeCount()];
                HashMap<Integer, Integer> indexMapping = new HashMap<Integer, Integer>();
                int indexOfAtt = 0;
                for (Attribute a : this.getAttributes()) {
                    if (a == null) continue;
                    indices[indexOfAtt] = attIndex = a.getTableIndex();
                    indexMapping.put(attIndex, indexOfAtt++);
                }
                double[][] rowData = new double[numberOfRows][this.getAttributeCount()];
                this.df = null;
                for (Map.Entry<Integer, HDF5Attribute> entry : this.h5AttMapping.entrySet()) {
                    attIndex = entry.getKey();
                    indexOfAtt = (Integer)indexMapping.get(attIndex);
                    HDF5Attribute hdf5Att = entry.getValue();
                    int h5Index = hdf5Att.getIndex();
                    double[] attValues = this.newValues != null && this.newValues.containsKey(attIndex) ? this.newValues.get(attIndex)[index / this.windowSize] : null;
                    Object arr = this.isComp ? ((List)data).get(this.usedMembers.indexOf(h5Index)) : data;
                    for (int i = 0; i < numberOfRows; ++i) {
                        Object value;
                        block26: {
                            if (attValues != null && !Double.isInfinite(attValues[relIndex + i])) {
                                rowData[i][indexOfAtt] = attValues[relIndex + i];
                                continue;
                            }
                            if (hdf5Att.isArray()) {
                                value = arr;
                                try {
                                    for (int j : hdf5Att.getSubindices(relIndex + i)) {
                                        value = Array.get(value, j);
                                    }
                                    break block26;
                                }
                                catch (ArrayIndexOutOfBoundsException aiooe) {
                                    rowData[i][indexOfAtt] = Double.NaN;
                                    continue;
                                }
                            }
                            value = Array.get(arr, relIndex + i);
                        }
                        Number nr = hdf5Att.isPolynominal() ? (Number)(value instanceof String ? Integer.valueOf(this.getAttribute(attIndex).getMapping().getIndex((String)value)) : Integer.valueOf(hdf5Att.map2RM(((Number)value).intValue()))) : (Number)(value instanceof String ? (Number)this.parseDateTime((String)value) : (Number)((Number)value));
                        rowData[i][indexOfAtt] = nr.doubleValue();
                    }
                }
                if (this.newAttributes != null) {
                    for (Map.Entry<Integer, double[][]> entry : this.newAttributes.entrySet()) {
                        indexOfAtt = (Integer)indexMapping.get(entry.getKey());
                        values = entry.getValue()[index / this.windowSize];
                        for (int i = 0; i < numberOfRows; ++i) {
                            rowData[i][indexOfAtt] = values[relIndex + i];
                        }
                    }
                }
                values = this.locks;
                synchronized (this.locks) {
                    void var18_28;
                    this.locks[0] = this.locks[0] - 1L;
                    this.lastAccess = System.currentTimeMillis();
                    // ** MonitorExit[values /* !! */ ] (shouldn't be in output)
                    boolean bl = false;
                    while (var18_28 < numberOfRows) {
                        HDF5DatasetDataRow row = new HDF5DatasetDataRow(indices, rowData[var18_28], index + var18_28, this);
                        this.rowCache.put(index + var18_28, new SoftReference<HDF5DatasetDataRow>(row));
                        ++var18_28;
                    }
                    return this.getDataRow(index);
                }
            }
        }
    }

    synchronized boolean setActiveWindow(int index) {
        int relIndex = index - this.currentWindowStart;
        if (index < 0 || index >= this.size || relIndex >= 0 && (long)relIndex < this.dataset.getSelectedDims()[0]) {
            return false;
        }
        while (this.locks[0] != 0L) {
        }
        this.clearDataset();
        this.clearCacheTimer();
        this.currentWindowStart = index / this.windowSize * this.windowSize;
        this.dataset.getStartDims()[0] = this.currentWindowStart;
        this.dataset.getSelectedDims()[0] = this.currentWindowStart + this.windowSize >= this.size ? (long)(this.size - this.currentWindowStart) : (long)this.windowSize;
        return true;
    }

    private Number parseDateTime(String value) {
        if (this.df != null) {
            try {
                return this.df.parse(value).getTime();
            }
            catch (ParseException e) {
                this.df = null;
            }
        }
        for (int tStyle = 0; tStyle < 4; ++tStyle) {
            this.df = DateFormat.getTimeInstance(tStyle);
            try {
                return this.df.parse(value).getTime();
            }
            catch (ParseException e) {
                this.df = null;
                for (int dStyle = 0; dStyle < 4; ++dStyle) {
                    this.df = DateFormat.getDateTimeInstance(dStyle, tStyle);
                    try {
                        return this.df.parse(value).getTime();
                    }
                    catch (ParseException e2) {
                        this.df = null;
                        continue;
                    }
                }
                continue;
            }
        }
        for (int dStyle = 0; dStyle < 4; ++dStyle) {
            this.df = DateFormat.getDateInstance(dStyle);
            try {
                return this.df.parse(value).getTime();
            }
            catch (ParseException e) {
                this.df = null;
                continue;
            }
        }
        return Double.NaN;
    }

    public void preload(int index) {
        int futureIndex = (int)((double)index + (double)this.windowSize * 0.25);
        int futuremaxIndex = this.currentWindowStart + 2 * this.windowSize - 1;
        if (futureIndex < this.size && futuremaxIndex > this.maxLoadedIndex) {
            this.getDataRow(futureIndex, true);
            this.maxLoadedIndex = futuremaxIndex;
        }
    }

    public void set(int row, int index, double value) {
        HDF5Attribute hdf5Att = (HDF5Attribute)this.h5AttMapping.get(index);
        if (hdf5Att != null) {
            this.setNewValue(row, index, value);
        } else {
            ((double[][])this.newAttributes.get((Object)Integer.valueOf((int)index)))[row / this.windowSize][row % this.windowSize] = value;
        }
    }

    private void setNewValue(int row, int index, double value) {
        double[] values;
        Object attValues;
        if (this.newValues == null) {
            this.newValues = new HashMap<Integer, double[][]>();
        }
        if ((attValues = this.newValues.get(index)) == null) {
            attValues = new double[(int)Math.ceil((double)this.size / (double)this.windowSize)][];
            this.newValues.put(index, (double[][])attValues);
        }
        if ((values = attValues[row / this.windowSize]) == null) {
            values = row / this.windowSize == ((double[][])attValues).length - 1 && ((double[][])attValues).length * this.windowSize > this.size ? new double[this.size % this.windowSize] : new double[this.windowSize];
            Arrays.fill(values, Double.POSITIVE_INFINITY);
            attValues[row / this.windowSize] = values;
        }
        values[row % this.windowSize] = value;
        this.checkCompatibility(index, value);
    }

    private void checkCompatibility(int index, double value) {
        if (this.compatible != null && this.compatible.contains(index)) {
            return;
        }
        HDF5Attribute h5a = (HDF5Attribute)this.h5AttMapping.get(index);
        Datatype t = this.isComp ? ((CompoundDS)this.dataset).getMemberTypes()[h5a.getIndex()] : this.dataset.getDatatype();
        if (t != HDF5WriteUtil.checkForUpgrade(t, value, value)) {
            if (this.compatible == null) {
                this.compatible = new ArrayList<Integer>();
            }
            this.compatible.add(index);
        }
    }

    public synchronized int addAttribute(Attribute att) {
        int index = super.addAttribute(att);
        if (this.newAttributes == null) {
            this.newAttributes = new TreeMap<Integer, double[][]>();
        }
        this.updateCacheSize();
        double[][] attData = new double[(int)Math.ceil((double)this.size / (double)this.windowSize)][this.windowSize];
        if (attData.length * this.windowSize > this.size) {
            attData[attData.length - 1] = new double[this.size % this.windowSize];
        }
        this.newAttributes.put(index, attData);
        return index;
    }

    void updateCacheSize() {
        int attCount = this.getAttributeCount();
        if (attCount != 0) {
            this.maxCacheSize = 125000000 / attCount;
            this.windowSize = (int)((double)this.maxCacheSize * 0.75);
            if (this.windowSize > this.size) {
                this.windowSize = this.size;
            } else if (this.chunkSize != -1L && (long)this.windowSize > this.chunkSize) {
                this.windowSize = (int)((long)this.windowSize - (long)this.windowSize % this.chunkSize);
            }
            this.dataset.getSelectedDims()[0] = this.windowSize;
            this.currentWindowStart = 0;
            this.reorganizeStaticData();
        }
    }

    void reorganizeStaticData() {
        this.reorganizeStaticData(this.newValues, Double.POSITIVE_INFINITY);
        this.reorganizeStaticData(this.newAttributes, null);
    }

    private void reorganizeStaticData(Map<Integer, double[][]> map, Double fillValue) {
        if (map == null) {
            return;
        }
        int windows = (int)Math.ceil((double)this.size / (double)this.windowSize);
        for (Map.Entry<Integer, double[][]> entry : map.entrySet()) {
            Object tmp = fillValue == null ? (Object)new double[windows][this.windowSize] : new double[windows][];
            ConverterUtil.reorganize(entry.getValue(), (double[][])tmp, this.size, fillValue);
            entry.setValue((double[][])tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void removeAttribute(int index) {
        Attribute old = this.getAttribute(index);
        if (old == null) {
            return;
        }
        super.removeAttribute(index);
        HDF5Attribute hdf5Att = (HDF5Attribute)this.h5AttMapping.remove(index);
        this.newAttributes.remove(index);
        this.updateCache(old);
        this.updateCacheSize();
        if (hdf5Att == null) {
            if (!this.newAttributes.isEmpty()) return;
            this.newAttributes = null;
            return;
        }
        if (this.newValues != null && this.newValues.remove(index) != null && this.newValues.isEmpty()) {
            this.newValues = null;
            this.compatible = null;
        }
        if (this.compatible != null) {
            this.compatible.remove(index);
        }
        if (this.removedAtts == null) {
            this.removedAtts = new ArrayList<HDF5Attribute>();
        }
        this.removedAtts.add(hdf5Att);
        int memberIndex = hdf5Att.getIndex();
        if (hdf5Att.isArray()) {
            int count = this.arrayMembers.get(memberIndex);
            if (count > 1) {
                this.arrayMembers.put(memberIndex, count - 1);
                return;
            }
            this.arrayMembers.remove(memberIndex);
        }
        if (!this.usedMembers.remove((Object)memberIndex)) {
            return;
        }
        if (!this.isComp) return;
        CompoundDS comp = (CompoundDS)this.dataset;
        if (!comp.isMemberSelected(memberIndex)) {
            return;
        }
        Object object = this.locks;
        synchronized (this.locks) {
            this.locks[0] = this.locks[0] + 1L;
            // ** MonitorExit[var6_7 /* !! */ ] (shouldn't be in output)
            comp.setMemberSelection(false);
            object = this.usedMembers.iterator();
            while (object.hasNext()) {
                int m = (Integer)object.next();
                comp.selectMember(m);
            }
            object = this.locks;
            synchronized (this.locks) {
                this.locks[0] = this.locks[0] - 1L;
                comp.clear();
                // ** MonitorExit[var6_7 /* !! */ ] (shouldn't be in output)
                return;
            }
        }
    }

    private void updateCache(Attribute old) {
        double def = old.getDefault();
        for (SoftReference<DataRow> dr : this.rowCache.values()) {
            if (dr.get() == null) continue;
            dr.get().set(old, def);
        }
    }

    public ExampleTable createInMemory(boolean inMemory) {
        this.inMemory = inMemory;
        return this;
    }

    public ExampleSet createExampleSet(Map<Attribute, String> specialAttributes) {
        ExampleSet set = this.inMemory ? Compatiblity.getDefault().createInMemory(this) : super.createExampleSet(specialAttributes);
        set.getAnnotations().setAnnotation("Source", this.dataset.getFullName());
        set.getAnnotations().setAnnotation("Filename", this.dataset.getFile());
        return set;
    }

    private void startUpdateTimer() {
        this.updateTimer = new Timer(true);
        this.updateTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                HDF5DatasetExampleTable.this.checkForTemp();
            }
        }, 1000L, 1000L);
    }

    protected synchronized void checkForTemp() {
        int updateSize = 0;
        if (this.newValues != null) {
            updateSize += this.newValues.size();
        }
        if (this.newAttributes != null) {
            updateSize += this.newAttributes.size();
        }
        if (updateSize == 0 || updateSize * 2 <= this.getAttributeCount() && updateSize * this.size <= 125000000) {
            return;
        }
        if ((this.compatible == null || this.compatible.isEmpty()) && (this.newAttributes == null || this.newAttributes.isEmpty())) {
            this.copyToTemp();
        } else {
            this.makeTemp();
        }
    }

    protected boolean copyToTemp() {
        Dataset copy = this.dataset;
        if (!this.isTemp) {
            DefaultMutableTreeNode node;
            H5File h5tmp = HDF5DatasetExampleTable.getNewTempFile();
            if (h5tmp == null) {
                return false;
            }
            try {
                node = (DefaultMutableTreeNode)h5tmp.copy(this.dataset, (Group)h5tmp.get("/"), this.dataset.getName());
            }
            catch (Exception e) {
                return false;
            }
            copy = (Dataset)node.getUserObject();
            copy.init();
            copy.getStride();
            if (copy instanceof CompoundDS) {
                ((CompoundDS)copy).setMemberSelection(false);
                for (int i = 0; i < ((CompoundDS)copy).getMemberCount(); ++i) {
                    if (!((CompoundDS)this.dataset).isMemberSelected(i)) continue;
                    ((CompoundDS)copy).selectMember(i);
                }
            }
        }
        for (Map.Entry<Integer, double[][]> entry : this.newValues.entrySet()) {
            Attribute att = this.getAttribute(entry.getKey());
            HDF5Attribute h5Att = (HDF5Attribute)this.h5AttMapping.get(entry.getKey());
            int mIndex = h5Att.getIndex();
            mIndex = this.usedMembers.indexOf(mIndex);
            double[][] newVal = entry.getValue();
            int i = 0;
            copy.getSelectedDims()[0] = this.windowSize;
            for (double[] newValWin : newVal) {
                Object data;
                if (newValWin == null) {
                    ++i;
                    continue;
                }
                copy.getStartDims()[0] = i * this.windowSize;
                if ((i + 1) * this.windowSize >= this.size) {
                    copy.getSelectedDims()[0] = this.size - i * this.windowSize;
                }
                try {
                    data = copy.getData();
                }
                catch (Exception e) {
                    return false;
                }
                if (this.isComp) {
                    data = ((List)data).get(mIndex);
                }
                HDF5WriteUtil.transformNewValues(att, h5Att, newValWin, 0, data, 0, (int)copy.getSelectedDims()[0]);
                try {
                    copy.write();
                }
                catch (Exception e) {
                    return false;
                }
                copy.clear();
                ++i;
            }
        }
        this.replaceDataset(copy);
        this.newValues = null;
        this.isTemp = true;
        return true;
    }

    private static H5File getNewTempFile() {
        File tmpFile;
        try {
            tmpFile = File.createTempFile("hdftmp", ".hd5");
        }
        catch (IOException e) {
            return null;
        }
        tmpFile.deleteOnExit();
        FileFormat format = FileFormat.getFileFormat("HDF5");
        if (format == null) {
            return null;
        }
        try {
            return (H5File)format.createFile(tmpFile.getAbsolutePath(), 20);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void replaceDataset(Dataset newSet) {
        this.clearDataset();
        if (this.isTemp) {
            try {
                new File(this.dataset.getFile()).delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.dataset = newSet;
        this.isComp = this.dataset instanceof CompoundDS;
        this.locks[0] = 0L;
        this.updateCacheSize();
        this.maxLoadedIndex = -1;
        this.rowCache.clear();
        if (this.clearer == null) {
            this.clearer = this.setCacheTimer();
        }
        System.gc();
    }

    protected boolean makeTemp() {
        Dataset tmpDS;
        H5File h5tmp = HDF5DatasetExampleTable.getNewTempFile();
        if (h5tmp == null) {
            return false;
        }
        try {
            String comp = this.dataset.getCompression();
            int index = comp.indexOf("level = ");
            int gzip = 6;
            long[] chunks = this.dataset.getChunkSize();
            if (chunks == null) {
                chunks = new long[]{this.windowSize};
            }
            if (index >= 0) {
                try {
                    gzip = new Integer(comp.substring(index + 8));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            tmpDS = HDF5WriteUtil.createDataset((ExampleTable)this, (Group)h5tmp.get("/"), this.dataset.getName(), null, 0, chunks, gzip, this.size);
        }
        catch (Exception e) {
            return false;
        }
        if (tmpDS == null) {
            return false;
        }
        tmpDS.init();
        try {
            tmpDS.getMetadata();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (HDF5WriteUtil.writeToDataset((ExampleTable)this, tmpDS, null) != null) {
            return false;
        }
        TreeMap<Integer, HDF5Attribute> newMap = new TreeMap<Integer, HDF5Attribute>(this.h5AttMapping);
        for (int i : this.newAttributes.keySet()) {
            HDF5Attribute h5Att;
            Attribute a = this.getAttribute(i);
            if (a.isNominal()) {
                ArrayList<Integer> enumMapping = new ArrayList<Integer>(a.getMapping().size());
                for (int j = 0; j < enumMapping.size(); ++j) {
                    enumMapping.add(j);
                }
                h5Att = new HDF5Attribute(null, enumMapping);
            } else {
                h5Att = new HDF5Attribute(null);
            }
            newMap.put(i, h5Att);
        }
        int mIndex = 0;
        for (HDF5Attribute h5a : newMap.values()) {
            h5a.setIndex(new int[]{mIndex++});
        }
        this.replaceDataset(tmpDS);
        this.newAttributes = null;
        this.newValues = null;
        this.usedMembers = new ArrayList<Integer>(this.getAttributeCount());
        for (int i = 0; i < this.getAttributeCount(); ++i) {
            this.usedMembers.add(i);
        }
        this.arrayMembers = null;
        this.isTemp = true;
        this.removedAtts = null;
        this.h5AttMapping = newMap;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void clearCacheTimer() {
        if (this.clearer == null) return;
        try {
            this.clearer.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clearer = null;
        boolean[] blArray = this.cancelled;
        synchronized (this.cancelled) {
            this.cancelled[0] = true;
            // ** MonitorExit[var1_2] (shouldn't be in output)
            this.clearTimer.purge();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerTask setCacheTimer() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                HDF5DatasetExampleTable.this.clearDataset();
            }
        };
        this.clearTimer.schedule(task, 1000L, 1000L);
        boolean[] blArray = this.cancelled;
        synchronized (this.cancelled) {
            this.cancelled[0] = false;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDataset() {
        long[] lArray = this.locks;
        synchronized (this.locks) {
            boolean cancel;
            boolean bl = cancel = this.dataset != null && this.locks[0] == 0L && System.currentTimeMillis() - 1000L > this.lastAccess;
            if (cancel) {
                this.dataset.clear();
                this.clearCacheTimer();
                System.gc();
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    protected void finalize() {
        this.clearCacheTimer();
        this.clearTimer.cancel();
    }

    public void readExamples(DataRowReader i, boolean permute, Random random) {
        throw new UnsupportedOperationException("HDF backed example table can not read data rows");
    }

    public void addDataRow(DataRow dataRow) {
        throw new UnsupportedOperationException("HDF backed example table can not add data rows");
    }

    public boolean removeDataRow(DataRow dataRow) {
        throw new UnsupportedOperationException("HDF backed example table can not remove data rows");
    }

    public void clear() {
        throw new UnsupportedOperationException("HDF backed example table can not clear data rows");
    }
}

