/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.PaletteListener;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JButton;

public class PaletteButton
extends JButton {
    static final int NORMAL = 1;
    static final int PRESSED = 2;
    static final int SELECTED = 3;
    public PaletteListener listener;
    public int state;
    public int oldState;

    public PaletteButton() {
    }

    public PaletteButton(PaletteListener l) {
        this.listener = l;
        this.oldState = 1;
        this.state = 1;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setMaximumSize(new Dimension(24, 24));
        this.setMinimumSize(new Dimension(24, 24));
        this.setPreferredSize(new Dimension(24, 24));
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                PaletteButton.this.this_mouseMoved(e);
            }

            public void mouseDragged(MouseEvent e) {
                PaletteButton.this.this_mouseDragged(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                PaletteButton.this.this_mouseEntered(e);
            }

            public void mouseExited(MouseEvent e) {
                PaletteButton.this.this_mouseExited(e);
            }

            public void mouseReleased(MouseEvent e) {
                PaletteButton.this.this_mouseReleased(e);
            }

            public void mousePressed(MouseEvent e) {
                PaletteButton.this.this_mousePressed(e);
            }
        });
    }

    public void this_mouseEntered(MouseEvent e) {
    }

    public void this_mouseExited(MouseEvent e) {
        if (this.state == 2) {
            this.this_mouseDragged(e);
        }
        if (this.listener != null) {
            this.listener.paletteUserOver(this, false);
        }
    }

    public void this_mouseReleased(MouseEvent e) {
        this.state = this.oldState;
        if (this.listener != null) {
            this.listener.paletteUserSelected(this);
        }
    }

    public void this_mouseMoved(MouseEvent e) {
        if (this.listener != null) {
            this.listener.paletteUserOver(this, true);
        }
    }

    public void this_mouseDragged(MouseEvent e) {
        this.state = this.contains(e.getX(), e.getY()) ? 2 : this.oldState;
    }

    public void this_mousePressed(MouseEvent e) {
        this.oldState = this.state;
        this.state = 2;
    }

    public Object value() {
        return null;
    }

    public String name() {
        return " ";
    }

    public void reset() {
        this.setSelected(false);
    }

    public void select() {
        this.setSelected(true);
    }

    static {
        NORMAL = 1;
        PRESSED = 2;
        SELECTED = 3;
    }
}

