/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.ReverseFigureEnumerator;
import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;

public abstract class CompositeFigure
extends AbstractFigure
implements FigureChangeListener {
    protected Vector fFigures = new Vector();
    private static final long serialVersionUID = 7408153435700021866L;
    private int compositeFigureSerializedDataVersion = 1;

    protected CompositeFigure() {
    }

    public Figure add(Figure figure) {
        if (!this.fFigures.contains(figure)) {
            this.fFigures.addElement(figure);
            figure.addToContainer(this);
        }
        return figure;
    }

    public void addAll(Vector newFigures) {
        Enumeration k = newFigures.elements();
        while (k.hasMoreElements()) {
            this.add((Figure)k.nextElement());
        }
    }

    public Figure remove(Figure figure) {
        if (this.fFigures.contains(figure)) {
            figure.removeFromContainer(this);
            this.fFigures.removeElement(figure);
        }
        return figure;
    }

    public void removeAll(Vector figures) {
        Enumeration k = figures.elements();
        while (k.hasMoreElements()) {
            this.remove((Figure)k.nextElement());
        }
    }

    public void removeAll() {
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            figure.removeFromContainer(this);
        }
        this.fFigures.removeAllElements();
    }

    public synchronized Figure orphan(Figure figure) {
        this.fFigures.removeElement(figure);
        return figure;
    }

    public void orphanAll(Vector newFigures) {
        Enumeration k = newFigures.elements();
        while (k.hasMoreElements()) {
            this.orphan((Figure)k.nextElement());
        }
    }

    public synchronized void replace(Figure figure, Figure replacement) {
        int index = this.fFigures.indexOf(figure);
        if (index != -1) {
            replacement.addToContainer(this);
            figure.changed();
            this.fFigures.setElementAt(replacement, index);
        }
    }

    public synchronized void sendToBack(Figure figure) {
        if (this.fFigures.contains(figure)) {
            this.fFigures.removeElement(figure);
            this.fFigures.insertElementAt(figure, 0);
            figure.changed();
        }
    }

    public synchronized void bringToFront(Figure figure) {
        if (this.fFigures.contains(figure)) {
            this.fFigures.removeElement(figure);
            this.fFigures.addElement(figure);
            figure.changed();
        }
    }

    public void draw(Graphics g) {
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            k.nextFigure().draw(g);
        }
    }

    public Figure figureAt(int i) {
        return (Figure)this.fFigures.elementAt(i);
    }

    public final FigureEnumeration figures() {
        return new FigureEnumerator(this.fFigures);
    }

    public int figureCount() {
        return this.fFigures.size();
    }

    public final FigureEnumeration figuresReverse() {
        return new ReverseFigureEnumerator(this.fFigures);
    }

    public Figure findFigure(int x, int y) {
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (!figure.containsPoint(x, y)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigure(Rectangle r) {
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            Rectangle fr = figure.displayBox();
            if (!r.intersects(fr)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigureWithout(int x, int y, Figure without) {
        if (without == null) {
            return this.findFigure(x, y);
        }
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (!figure.containsPoint(x, y) || figure.includes(without)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigure(Rectangle r, Figure without) {
        if (without == null) {
            return this.findFigure(r);
        }
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            Rectangle fr = figure.displayBox();
            if (!r.intersects(fr) || figure.includes(without)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigureInside(int x, int y) {
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure().findFigureInside(x, y);
            if (figure == null) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigureInsideWithout(int x, int y, Figure without) {
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure found;
            Figure figure = k.nextFigure();
            if (figure == without || (found = figure.findFigureInside(x, y)) == null) continue;
            return found;
        }
        return null;
    }

    public boolean includes(Figure figure) {
        if (super.includes(figure)) {
            return true;
        }
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            if (!f.includes(figure)) continue;
            return true;
        }
        return false;
    }

    protected void basicMoveBy(int x, int y) {
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            k.nextFigure().moveBy(x, y);
        }
    }

    public void release() {
        super.release();
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            figure.release();
        }
    }

    public void figureInvalidated(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureInvalidated(e);
        }
    }

    public void figureRequestRemove(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(new FigureChangeEvent(this));
        }
    }

    public void figureRequestUpdate(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureRequestUpdate(e);
        }
    }

    public void figureChanged(FigureChangeEvent e) {
    }

    public void figureRemoved(FigureChangeEvent e) {
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fFigures.size());
        Enumeration k = this.fFigures.elements();
        while (k.hasMoreElements()) {
            dw.writeStorable((Storable)k.nextElement());
        }
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        int size = dr.readInt();
        this.fFigures = new Vector(size);
        for (int i = 0; i < size; ++i) {
            this.add((Figure)dr.readStorable());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            figure.addToContainer(this);
        }
    }

    static {
        serialVersionUID = 7408153435700021866L;
    }
}

