/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.util.Command;
import java.awt.Rectangle;

public class AlignCommand
extends Command {
    private DrawingView fView;
    private int fOp;
    public static final int LEFTS = 0;
    public static final int CENTERS = 1;
    public static final int RIGHTS = 2;
    public static final int TOPS = 3;
    public static final int MIDDLES = 4;
    public static final int BOTTOMS = 5;

    public AlignCommand(String name, DrawingView view, int op) {
        super(name);
        this.fView = view;
        this.fOp = op;
    }

    public boolean isExecutable() {
        return this.fView.selectionCount() > 1;
    }

    public void execute() {
        FigureEnumeration selection = this.fView.selectionElements();
        Figure anchorFigure = selection.nextFigure();
        Rectangle r = anchorFigure.displayBox();
        while (selection.hasMoreElements()) {
            Figure f = selection.nextFigure();
            Rectangle rr = f.displayBox();
            switch (this.fOp) {
                case 0: {
                    f.moveBy(r.x - rr.x, 0);
                    break;
                }
                case 1: {
                    f.moveBy(r.x + r.width / 2 - (rr.x + rr.width / 2), 0);
                    break;
                }
                case 2: {
                    f.moveBy(r.x + r.width - (rr.x + rr.width), 0);
                    break;
                }
                case 3: {
                    f.moveBy(0, r.y - rr.y);
                    break;
                }
                case 4: {
                    f.moveBy(0, r.y + r.height / 2 - (rr.y + rr.height / 2));
                    break;
                }
                case 5: {
                    f.moveBy(0, r.y + r.height - (rr.y + rr.height));
                }
            }
        }
        this.fView.checkDamage();
    }

    static {
        LEFTS = 0;
        CENTERS = 1;
        RIGHTS = 2;
        TOPS = 3;
        MIDDLES = 4;
        BOTTOMS = 5;
    }
}

