/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.internal;

import CH.ifa.draw.figures.GroupCommand;
import CH.ifa.draw.figures.UngroupCommand;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.AlignCommand;
import CH.ifa.draw.standard.BringToFrontCommand;
import CH.ifa.draw.standard.BufferedUpdateStrategy;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.CopyCommand;
import CH.ifa.draw.standard.CutCommand;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.DuplicateCommand;
import CH.ifa.draw.standard.PasteCommand;
import CH.ifa.draw.standard.SelectionTool;
import CH.ifa.draw.standard.SendToBackCommand;
import CH.ifa.draw.standard.SimpleUpdateStrategy;
import CH.ifa.draw.standard.StandardDrawing;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.ToggleGridCommand;
import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.PaletteButton;
import CH.ifa.draw.util.PaletteLayout;
import CH.ifa.draw.util.PaletteListener;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class DrawPanel
extends JPanel
implements DrawingEditor,
PaletteListener {
    private Drawing fDrawing;
    private Tool fTool;
    private Iconkit fIconkit;
    private JTextField fStatusLine;
    private StandardDrawingView fView;
    private ToolButton fDefaultToolButton;
    private ToolButton fSelectedToolButton;
    private String fDrawingFilename;
    static String fgUntitled = "untitled";
    private static final String fgDrawPath = "/CH/ifa/draw/";
    public static final String IMAGES = "/CH/ifa/draw/images/";
    public static final int FILE_MENU = 0;
    public static final int EDIT_MENU = 1;
    public static final int ALIGNMENT_MENU = 2;
    public static final int ATTRIBUTES_MENU = 3;

    public void open() {
        this.fIconkit = new Iconkit(this);
        this.setLayout(new BorderLayout());
        this.fView = this.createDrawingView();
        JComponent contents = this.createContents(this.fView);
        this.add("Center", contents);
        JPanel tools = this.createToolPalette();
        this.createTools(tools);
        this.add("West", tools);
        this.fStatusLine = this.createStatusLine();
        this.add("South", this.fStatusLine);
        this.initDrawing();
        Dimension d = this.defaultSize();
        this.setSize(d.width, d.height);
    }

    private void initDrawing() {
        this.fDrawing = this.createDrawing();
        this.fDrawingFilename = fgUntitled;
        this.fView.setDrawing(this.fDrawing);
        this.toolDone();
    }

    protected void createMenus(JMenuBar mb) {
        mb.add(this.createFileMenu());
        mb.add(this.createEditMenu());
        mb.add(this.createAlignmentMenu());
        mb.add(this.createAttributesMenu());
    }

    protected JMenu createFileMenu() {
        JMenu menu = new JMenu("File");
        JMenuItem mi = new JMenuItem("New");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DrawPanel.this.promptNew();
            }
        });
        menu.add(mi);
        mi = new JMenuItem("Open...");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DrawPanel.this.promptOpen();
            }
        });
        menu.add(mi);
        mi = new JMenuItem("Save As...");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DrawPanel.this.promptSaveAs();
            }
        });
        menu.add(mi);
        mi = new JMenuItem("Save As Serialized...");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DrawPanel.this.promptSaveAsSerialized();
            }
        });
        menu.add(mi);
        menu.addSeparator();
        mi = new JMenuItem("Print...");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DrawPanel.this.print();
            }
        });
        menu.add(mi);
        menu.addSeparator();
        mi = new JMenuItem("Exit");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
            }
        });
        menu.add(mi);
        return menu;
    }

    protected JMenu createEditMenu() {
        CommandMenu menu = new CommandMenu("Edit");
        menu.add(new CutCommand("Cut", this.fView), 'x');
        menu.add(new CopyCommand("Copy", this.fView), 'c');
        menu.add(new PasteCommand("Paste", this.fView), 'v');
        menu.addSeparator();
        menu.add(new DuplicateCommand("Duplicate", this.fView), 'd');
        menu.add(new DeleteCommand("Delete", this.fView));
        menu.addSeparator();
        menu.add(new GroupCommand("Group", this.fView));
        menu.add(new UngroupCommand("Ungroup", this.fView));
        menu.addSeparator();
        menu.add(new SendToBackCommand("Send to Back", this.fView));
        menu.add(new BringToFrontCommand("Bring to Front", this.fView));
        return menu;
    }

    protected JMenu createAlignmentMenu() {
        CommandMenu menu = new CommandMenu("Align");
        menu.add(new ToggleGridCommand("Toggle Snap to Grid", this.fView, new Point(4, 4)));
        menu.addSeparator();
        menu.add(new AlignCommand("Lefts", this.fView, 0));
        menu.add(new AlignCommand("Centers", this.fView, 1));
        menu.add(new AlignCommand("Rights", this.fView, 2));
        menu.addSeparator();
        menu.add(new AlignCommand("Tops", this.fView, 3));
        menu.add(new AlignCommand("Middles", this.fView, 4));
        menu.add(new AlignCommand("Bottoms", this.fView, 5));
        return menu;
    }

    protected JMenu createDebugMenu() {
        JMenu menu = new JMenu("Debug");
        JMenuItem mi = new JMenuItem("Simple Update");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DrawPanel.this.fView.setDisplayUpdate(new SimpleUpdateStrategy());
            }
        });
        menu.add(mi);
        mi = new JMenuItem("Buffered Update");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DrawPanel.this.fView.setDisplayUpdate(new BufferedUpdateStrategy());
            }
        });
        menu.add(mi);
        return menu;
    }

    protected JMenu createAttributesMenu() {
        JMenu menu = new JMenu("Attributes");
        menu.add(this.createColorMenu("Fill Color", "FillColor"));
        menu.add(this.createColorMenu("Pen Color", "FrameColor"));
        menu.add(this.createArrowMenu());
        menu.addSeparator();
        menu.add(this.createFontMenu());
        menu.add(this.createFontSizeMenu());
        menu.add(this.createFontStyleMenu());
        menu.add(this.createColorMenu("Text Color", "TextColor"));
        return menu;
    }

    protected JMenu createColorMenu(String title, String attribute) {
        CommandMenu menu = new CommandMenu(title);
        for (int i = 0; i < ColorMap.size(); ++i) {
            menu.add(new ChangeAttributeCommand(ColorMap.name(i), attribute, ColorMap.color(i), this.fView));
        }
        return menu;
    }

    protected JMenu createArrowMenu() {
        CommandMenu menu = new CommandMenu("Arrow");
        menu.add(new ChangeAttributeCommand("none", "ArrowMode", new Integer(0), this.fView));
        menu.add(new ChangeAttributeCommand("at Start", "ArrowMode", new Integer(1), this.fView));
        menu.add(new ChangeAttributeCommand("at End", "ArrowMode", new Integer(2), this.fView));
        menu.add(new ChangeAttributeCommand("at Both", "ArrowMode", new Integer(3), this.fView));
        return menu;
    }

    protected JMenu createFontMenu() {
        CommandMenu menu = new CommandMenu("Font");
        String[] fonts = Toolkit.getDefaultToolkit().getFontList();
        for (int i = 0; i < fonts.length; ++i) {
            menu.add(new ChangeAttributeCommand(fonts[i], "FontName", fonts[i], this.fView));
        }
        return menu;
    }

    protected JMenu createFontStyleMenu() {
        CommandMenu menu = new CommandMenu("Font Style");
        menu.add(new ChangeAttributeCommand("Plain", "FontStyle", new Integer(0), this.fView));
        menu.add(new ChangeAttributeCommand("Italic", "FontStyle", new Integer(2), this.fView));
        menu.add(new ChangeAttributeCommand("Bold", "FontStyle", new Integer(1), this.fView));
        return menu;
    }

    protected JMenu createFontSizeMenu() {
        CommandMenu menu = new CommandMenu("Font Size");
        int[] sizes = new int[]{9, 10, 12, 14, 18, 24, 36, 48, 72};
        for (int i = 0; i < sizes.length; ++i) {
            menu.add(new ChangeAttributeCommand(Integer.toString(sizes[i]), "FontSize", new Integer(sizes[i]), this.fView));
        }
        return menu;
    }

    protected JPanel createToolPalette() {
        JPanel palette = new JPanel();
        palette.setBackground(Color.lightGray);
        palette.setLayout(new PaletteLayout(2, new Point(2, 2)));
        return palette;
    }

    protected void createTools(JPanel palette) {
        Tool tool = this.createSelectionTool();
        this.fDefaultToolButton = this.createToolButton("/CH/ifa/draw/images/SEL", "Selection Tool", tool);
        palette.add(this.fDefaultToolButton);
    }

    protected void setDefaultToolButton(JButton defaultButton) {
        this.fDefaultToolButton = (ToolButton)defaultButton;
    }

    protected Tool createSelectionTool() {
        return new SelectionTool(this.view());
    }

    protected ToolButton createToolButton(String iconName, String toolName, Tool tool) {
        return new ToolButton(this, iconName, toolName, tool);
    }

    protected StandardDrawingView createDrawingView() {
        Dimension d = this.getDrawingViewSize();
        return new StandardDrawingView(this, d.width, d.height);
    }

    protected Dimension getDrawingViewSize() {
        return new Dimension(300, 300);
    }

    protected Drawing createDrawing() {
        return new StandardDrawing();
    }

    protected JComponent createContents(StandardDrawingView view) {
        JScrollPane sp = new JScrollPane(view);
        JScrollBar vadjust = sp.getVerticalScrollBar();
        JScrollBar hadjust = sp.getHorizontalScrollBar();
        hadjust.setUnitIncrement(16);
        vadjust.setUnitIncrement(16);
        return sp;
    }

    public void setDrawing(Drawing drawing) {
        this.fView.setDrawing(drawing);
        this.fDrawing = drawing;
    }

    protected Dimension defaultSize() {
        return new Dimension(430, 406);
    }

    protected JTextField createStatusLine() {
        JTextField field = new JTextField("No Tool", 40);
        field.setEditable(false);
        return field;
    }

    public void paletteUserSelected(PaletteButton button) {
        ToolButton toolButton = (ToolButton)button;
        this.setTool(toolButton.tool(), toolButton.name());
        this.setSelected(toolButton);
    }

    public void paletteUserOver(PaletteButton button, boolean inside) {
        ToolButton toolButton = (ToolButton)button;
        if (inside) {
            this.showStatus(toolButton.name());
        } else if (this.fSelectedToolButton != null) {
            this.showStatus(this.fSelectedToolButton.name());
        }
    }

    public Drawing drawing() {
        return this.fDrawing;
    }

    public Tool tool() {
        return this.fTool;
    }

    public DrawingView view() {
        return this.fView;
    }

    public void toolDone() {
        if (this.fDefaultToolButton != null) {
            this.setTool(this.fDefaultToolButton.tool(), this.fDefaultToolButton.name());
            this.setSelected(this.fDefaultToolButton);
        }
    }

    public void selectionChanged(DrawingView view) {
    }

    public void showStatus(String string) {
        if (this.fStatusLine != null) {
            this.fStatusLine.setText(string);
        }
    }

    private void setTool(Tool t, String name) {
        if (this.fTool != null) {
            this.fTool.deactivate();
        }
        this.fTool = t;
        if (this.fTool != null) {
            this.fStatusLine.setText(name);
            this.fTool.activate();
        }
    }

    private void setSelected(ToolButton button) {
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.reset();
        }
        this.fSelectedToolButton = button;
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.select();
        }
    }

    protected void destroy() {
    }

    public void promptNew() {
        this.initDrawing();
    }

    public void promptOpen() {
    }

    public void promptSaveAs() {
        this.toolDone();
        String path = this.getSavePath("Save File...");
        if (path != null) {
            if (!path.endsWith(".draw")) {
                path = String.valueOf(String.valueOf(path)).concat(".draw");
            }
            this.saveAsStorableOutput(path);
        }
    }

    public void promptSaveAsSerialized() {
        this.toolDone();
        String path = this.getSavePath("Save File...");
        if (path != null) {
            if (!path.endsWith(".ser")) {
                path = String.valueOf(String.valueOf(path)).concat(".ser");
            }
            this.saveAsObjectOutput(path);
        }
    }

    public void print() {
    }

    private String getSavePath(String title) {
        return null;
    }

    private String stripTrailingAsterisks(String filename) {
        if (filename.endsWith("*.*")) {
            return filename.substring(0, filename.length() - 4);
        }
        return filename;
    }

    private void saveAsStorableOutput(String file) {
        try {
            FileOutputStream stream = new FileOutputStream(file);
            StorableOutput output = new StorableOutput(stream);
            output.writeStorable(this.fDrawing);
            output.close();
        }
        catch (IOException e) {
            this.showStatus(e.toString());
        }
    }

    private void saveAsObjectOutput(String file) {
        try {
            FileOutputStream stream = new FileOutputStream(file);
            ObjectOutputStream output = new ObjectOutputStream(stream);
            output.writeObject(this.fDrawing);
            output.close();
        }
        catch (IOException e) {
            this.showStatus(e.toString());
        }
    }

    private void loadDrawing(String file) {
        this.toolDone();
        String type = this.guessType(file);
        if (type.equals("storable")) {
            this.readFromStorableInput(file);
        } else if (type.equals("serialized")) {
            this.readFromObjectInput(file);
        } else {
            this.showStatus("Unknown file type");
        }
    }

    private void readFromStorableInput(String file) {
        try {
            FileInputStream stream = new FileInputStream(file);
            StorableInput input = new StorableInput(stream);
            this.fDrawing.release();
            this.fDrawing = (Drawing)input.readStorable();
            this.fView.setDrawing(this.fDrawing);
        }
        catch (IOException e) {
            this.initDrawing();
            this.showStatus("Error: ".concat(String.valueOf(String.valueOf(e))));
        }
    }

    private void readFromObjectInput(String file) {
        try {
            FileInputStream stream = new FileInputStream(file);
            ObjectInputStream input = new ObjectInputStream(stream);
            this.fDrawing.release();
            this.fDrawing = (Drawing)input.readObject();
            this.fView.setDrawing(this.fDrawing);
        }
        catch (IOException e) {
            this.initDrawing();
            this.showStatus("Error: ".concat(String.valueOf(String.valueOf(e))));
        }
        catch (ClassNotFoundException e) {
            this.initDrawing();
            this.showStatus("Class not found: ".concat(String.valueOf(String.valueOf(e))));
        }
    }

    private String guessType(String file) {
        if (file.endsWith(".draw")) {
            return "storable";
        }
        if (file.endsWith(".ser")) {
            return "serialized";
        }
        return "unknown";
    }

    static {
        fgDrawPath = fgDrawPath;
        IMAGES = IMAGES;
        FILE_MENU = 0;
        EDIT_MENU = 1;
        ALIGNMENT_MENU = 2;
        ATTRIBUTES_MENU = 3;
    }
}

