/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.figures.PolyLineConnector;
import CH.ifa.draw.figures.PolyLineHandle;
import CH.ifa.draw.figures.PolyLineLocator;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class PolyLineFigure
extends AbstractFigure {
    public static final int ARROW_TIP_NONE = 0;
    public static final int ARROW_TIP_START = 1;
    public static final int ARROW_TIP_END = 2;
    public static final int ARROW_TIP_BOTH = 3;
    protected Vector fPoints;
    protected LineDecoration fStartDecoration = null;
    protected LineDecoration fEndDecoration = null;
    protected Color fFrameColor = Color.black;
    private static final long serialVersionUID = -7951352179906577773L;
    private int polyLineFigureSerializedDataVersion = 1;

    public PolyLineFigure() {
        this.fPoints = new Vector(4);
    }

    public PolyLineFigure(int size) {
        this.fPoints = new Vector(size);
    }

    public PolyLineFigure(int x, int y) {
        this.fPoints = new Vector();
        this.fPoints.addElement(new Point(x, y));
    }

    public Rectangle displayBox() {
        Enumeration k = this.points();
        Rectangle r = new Rectangle((Point)k.nextElement());
        while (k.hasMoreElements()) {
            r.add((Point)k.nextElement());
        }
        return r;
    }

    public boolean isEmpty() {
        return this.size().width < 3 && this.size().height < 3;
    }

    public Vector handles() {
        Vector<PolyLineHandle> handles = new Vector<PolyLineHandle>(this.fPoints.size());
        for (int i = 0; i < this.fPoints.size(); ++i) {
            handles.addElement(new PolyLineHandle(this, PolyLineFigure.locator(i), i));
        }
        return handles;
    }

    public void basicDisplayBox(Point origin, Point corner) {
    }

    public void addPoint(int x, int y) {
        this.fPoints.addElement(new Point(x, y));
        this.changed();
    }

    public Enumeration points() {
        return this.fPoints.elements();
    }

    public int pointCount() {
        return this.fPoints.size();
    }

    protected void basicMoveBy(int dx, int dy) {
        Enumeration k = this.fPoints.elements();
        while (k.hasMoreElements()) {
            ((Point)k.nextElement()).translate(dx, dy);
        }
    }

    public void setPointAt(Point p, int i) {
        this.willChange();
        this.fPoints.setElementAt(p, i);
        this.changed();
    }

    public void insertPointAt(Point p, int i) {
        this.fPoints.insertElementAt(p, i);
        this.changed();
    }

    public void removePointAt(int i) {
        this.willChange();
        this.fPoints.removeElementAt(i);
        this.changed();
    }

    public int splitSegment(int x, int y) {
        int i = this.findSegment(x, y);
        if (i != -1) {
            this.insertPointAt(new Point(x, y), i + 1);
        }
        return i + 1;
    }

    public Point pointAt(int i) {
        return (Point)this.fPoints.elementAt(i);
    }

    public boolean joinSegments(int x, int y) {
        for (int i = 1; i < this.fPoints.size() - 1; ++i) {
            Point p = this.pointAt(i);
            if (Geom.length(x, y, p.x, p.y) >= (long)3) continue;
            this.removePointAt(i);
            return true;
        }
        return false;
    }

    public Connector connectorAt(int x, int y) {
        return new PolyLineConnector(this);
    }

    public void setStartDecoration(LineDecoration l) {
        this.fStartDecoration = l;
    }

    public void setEndDecoration(LineDecoration l) {
        this.fEndDecoration = l;
    }

    public void draw(Graphics g) {
        g.setColor(this.getFrameColor());
        for (int i = 0; i < this.fPoints.size() - 1; ++i) {
            Point p1 = (Point)this.fPoints.elementAt(i);
            Point p2 = (Point)this.fPoints.elementAt(i + 1);
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
        }
        this.decorate(g);
    }

    public boolean containsPoint(int x, int y) {
        Rectangle bounds = this.displayBox();
        bounds.grow(4, 4);
        if (!bounds.contains(x, y)) {
            return false;
        }
        for (int i = 0; i < this.fPoints.size() - 1; ++i) {
            Point p1 = (Point)this.fPoints.elementAt(i);
            Point p2 = (Point)this.fPoints.elementAt(i + 1);
            if (!Geom.lineContainsPoint(p1.x, p1.y, p2.x, p2.y, x, y)) continue;
            return true;
        }
        return false;
    }

    public int findSegment(int x, int y) {
        for (int i = 0; i < this.fPoints.size() - 1; ++i) {
            Point p1 = (Point)this.fPoints.elementAt(i);
            Point p2 = (Point)this.fPoints.elementAt(i + 1);
            if (!Geom.lineContainsPoint(p1.x, p1.y, p2.x, p2.y, x, y)) continue;
            return i;
        }
        return -1;
    }

    private void decorate(Graphics g) {
        if (this.fStartDecoration != null) {
            Point p1 = (Point)this.fPoints.elementAt(0);
            Point p2 = (Point)this.fPoints.elementAt(1);
            this.fStartDecoration.draw(g, p1.x, p1.y, p2.x, p2.y);
        }
        if (this.fEndDecoration != null) {
            Point p3 = (Point)this.fPoints.elementAt(this.fPoints.size() - 2);
            Point p4 = (Point)this.fPoints.elementAt(this.fPoints.size() - 1);
            this.fEndDecoration.draw(g, p4.x, p4.y, p3.x, p3.y);
        }
    }

    public Object getAttribute(String name) {
        if (name.equals("FrameColor")) {
            return this.getFrameColor();
        }
        if (name.equals("ArrowMode")) {
            int value = 0;
            if (this.fStartDecoration != null) {
                value |= 1;
            }
            if (this.fEndDecoration != null) {
                value |= 2;
            }
            return new Integer(value);
        }
        return super.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        if (name.equals("FrameColor")) {
            this.setFrameColor((Color)value);
            this.changed();
        } else if (name.equals("ArrowMode")) {
            Integer intObj = (Integer)value;
            if (intObj != null) {
                int decoration = intObj;
                this.fStartDecoration = (decoration & 1) != 0 ? new ArrowTip() : null;
                this.fEndDecoration = (decoration & 2) != 0 ? new ArrowTip() : null;
            }
            this.changed();
        } else {
            super.setAttribute(name, value);
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fPoints.size());
        Enumeration k = this.fPoints.elements();
        while (k.hasMoreElements()) {
            Point p = (Point)k.nextElement();
            dw.writeInt(p.x);
            dw.writeInt(p.y);
        }
        dw.writeStorable(this.fStartDecoration);
        dw.writeStorable(this.fEndDecoration);
        dw.writeColor(this.fFrameColor);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        int size = dr.readInt();
        this.fPoints = new Vector(size);
        for (int i = 0; i < size; ++i) {
            int x = dr.readInt();
            int y = dr.readInt();
            this.fPoints.addElement(new Point(x, y));
        }
        this.fStartDecoration = (LineDecoration)dr.readStorable();
        this.fEndDecoration = (LineDecoration)dr.readStorable();
        this.fFrameColor = dr.readColor();
    }

    public static Locator locator(int pointIndex) {
        return new PolyLineLocator(pointIndex);
    }

    protected Color getFrameColor() {
        return this.fFrameColor;
    }

    protected void setFrameColor(Color c) {
        this.fFrameColor = c;
    }

    static {
        ARROW_TIP_NONE = 0;
        ARROW_TIP_START = 1;
        ARROW_TIP_END = 2;
        ARROW_TIP_BOTH = 3;
        serialVersionUID = -7951352179906577773L;
    }
}

