/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.figures.PolyLineHandle;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.standard.ChangeConnectionEndHandle;
import CH.ifa.draw.standard.ChangeConnectionStartHandle;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class LineConnection
extends PolyLineFigure
implements ConnectionFigure {
    protected Connector fStart = null;
    protected Connector fEnd = null;
    private static final long serialVersionUID = 6883731614578414801L;
    private int lineConnectionSerializedDataVersion = 1;

    public LineConnection() {
        super(4);
        this.setStartDecoration(new ArrowTip());
        this.setEndDecoration(new ArrowTip());
    }

    public boolean canConnect() {
        return false;
    }

    protected void basicMoveBy(int dx, int dy) {
        for (int i = 1; i < this.fPoints.size() - 1; ++i) {
            ((Point)this.fPoints.elementAt(i)).translate(dx, dy);
        }
        this.updateConnection();
    }

    public void connectStart(Connector start) {
        this.fStart = start;
        this.startFigure().addFigureChangeListener(this);
        this.handleConnect(this.startFigure(), this.endFigure());
    }

    public void connectEnd(Connector end) {
        this.fEnd = end;
        this.endFigure().addFigureChangeListener(this);
        this.handleConnect(this.startFigure(), this.endFigure());
    }

    public void disconnectStart() {
        this.handleDisconnect(this.startFigure(), this.endFigure());
        this.startFigure().removeFigureChangeListener(this);
        this.fStart = null;
    }

    public void disconnectEnd() {
        this.handleDisconnect(this.startFigure(), this.endFigure());
        this.endFigure().removeFigureChangeListener(this);
        this.fEnd = null;
    }

    public boolean connectsSame(ConnectionFigure other) {
        return other.start() == this.start() && other.end() == this.end();
    }

    protected void handleDisconnect(Figure start, Figure end) {
    }

    protected void handleConnect(Figure start, Figure end) {
    }

    public Figure startFigure() {
        if (this.start() != null) {
            return this.start().owner();
        }
        return null;
    }

    public Figure endFigure() {
        if (this.end() != null) {
            return this.end().owner();
        }
        return null;
    }

    public Connector start() {
        return this.fStart;
    }

    public Connector end() {
        return this.fEnd;
    }

    public boolean canConnect(Figure start, Figure end) {
        return true;
    }

    public void startPoint(int x, int y) {
        this.willChange();
        if (this.fPoints.size() == 0) {
            this.fPoints.addElement(new Point(x, y));
        } else {
            this.fPoints.setElementAt(new Point(x, y), 0);
        }
        this.changed();
    }

    public void endPoint(int x, int y) {
        this.willChange();
        if (this.fPoints.size() < 2) {
            this.fPoints.addElement(new Point(x, y));
        } else {
            this.fPoints.setElementAt(new Point(x, y), this.fPoints.size() - 1);
        }
        this.changed();
    }

    public Point startPoint() {
        Point p = (Point)this.fPoints.firstElement();
        return new Point(p.x, p.y);
    }

    public Point endPoint() {
        Point p = (Point)this.fPoints.lastElement();
        return new Point(p.x, p.y);
    }

    public Vector handles() {
        Vector<AbstractHandle> handles = new Vector<AbstractHandle>(this.fPoints.size());
        handles.addElement(new ChangeConnectionStartHandle(this));
        for (int i = 1; i < this.fPoints.size() - 1; ++i) {
            handles.addElement(new PolyLineHandle(this, PolyLineFigure.locator(i), i));
        }
        handles.addElement(new ChangeConnectionEndHandle(this));
        return handles;
    }

    public void setPointAt(Point p, int i) {
        super.setPointAt(p, i);
        this.layoutConnection();
    }

    public void insertPointAt(Point p, int i) {
        super.insertPointAt(p, i);
        this.layoutConnection();
    }

    public void removePointAt(int i) {
        super.removePointAt(i);
        this.layoutConnection();
    }

    public void updateConnection() {
        if (this.fStart != null) {
            Point start = this.fStart.findStart(this);
            this.startPoint(start.x, start.y);
        }
        if (this.fEnd != null) {
            Point end = this.fEnd.findEnd(this);
            this.endPoint(end.x, end.y);
        }
    }

    public void layoutConnection() {
        this.updateConnection();
    }

    public void figureChanged(FigureChangeEvent e) {
        this.updateConnection();
    }

    public void figureRemoved(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(new FigureChangeEvent(this));
        }
    }

    public void figureRequestRemove(FigureChangeEvent e) {
    }

    public void figureInvalidated(FigureChangeEvent e) {
    }

    public void figureRequestUpdate(FigureChangeEvent e) {
    }

    public void release() {
        super.release();
        this.handleDisconnect(this.startFigure(), this.endFigure());
        if (this.fStart != null) {
            this.startFigure().removeFigureChangeListener(this);
        }
        if (this.fEnd != null) {
            this.endFigure().removeFigureChangeListener(this);
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fStart);
        dw.writeStorable(this.fEnd);
    }

    public void read(StorableInput dr) throws IOException {
        Connector end;
        super.read(dr);
        Connector start = (Connector)dr.readStorable();
        if (start != null) {
            this.connectStart(start);
        }
        if ((end = (Connector)dr.readStorable()) != null) {
            this.connectEnd(end);
        }
        if (start != null && end != null) {
            this.updateConnection();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.fStart != null) {
            this.connectStart(this.fStart);
        }
        if (this.fEnd != null) {
            this.connectEnd(this.fEnd);
        }
    }

    static {
        serialVersionUID = 6883731614578414801L;
    }
}

