/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.LocatorHandle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;

public class FontSizeHandle
extends LocatorHandle {
    private Font fFont;
    private int fSize;

    public FontSizeHandle(Figure owner, Locator l) {
        super(owner, l);
    }

    public void invokeStart(int x, int y, DrawingView view) {
        TextFigure textOwner = (TextFigure)this.owner();
        this.fFont = textOwner.getFont();
        this.fSize = this.fFont.getSize();
    }

    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        TextFigure textOwner = (TextFigure)this.owner();
        int newSize = this.fSize + y - anchorY;
        textOwner.setFont(new Font(this.fFont.getName(), this.fFont.getStyle(), newSize));
    }

    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.yellow);
        g.fillOval(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        g.drawOval(r.x, r.y, r.width, r.height);
    }
}

