#!/bin/sh

# path to the application
# ***********************

# Please replace with the HCI directory without final slash:
MYPATH="/home/user/MiningMart/HCI"

# libraries
# *********

            HCI="${MYPATH}/miningmart.jar"

        LIBPATH="${MYPATH}/lib"
            ORA="${LIBPATH}/classes12.zip"
        HOTDRAW="${LIBPATH}/hotdraw.jar:${LIBPATH}/GraphView.jar"
           SPIN="${LIBPATH}/Socrat.jar"
             M4="${LIBPATH}/M4InterfaceClient.jar"
  CONCEPTEDITOR="${LIBPATH}/ConceptEditor.jar:${LIBPATH}/diagram.jar"
       COMPILER="${LIBPATH}/M4CompilerClient.jar"
           HELP="${LIBPATH}/jh.jar"

   JBOSS_CLIENT="${LIBPATH}/jboss-client.jar"
JBOSS_CM_CLIENT="${LIBPATH}/jboss-common-client.jar"
     JBOSS_J2EE="${LIBPATH}/jboss-j2ee.jar"
  JBOSSX_CLIENT="${LIBPATH}/jbosssx-client.jar"
           JNET="${LIBPATH}/jnet.jar"
     JNP_CLIENT="${LIBPATH}/jnp-client.jar"
          LOG4J="${LIBPATH}/log4j.jar"

JBOSS="${JBOSS_CLIENT}:${JBOSS_CM_CLIENT}:${JBOSS_J2EE}:${JBOSSX_CLIENT}:${JNET}:${JNP_CLIENT}:${LOG4J}"


CLASSPATH="${MYPATH}:${HCI}:${HOTDRAW}:${SPIN}:${M4}:${JBOSS}:${ORA}:${COMPILER}:${CONCEPTEDITOR}:${HELP}"
export CLASSPATH


# parameter
# *********

HCI_HOME="${MYPATH}"

# Please replace with the host of your compiler server:
COMPILERSERVER=


# Jndi.properties
# ***************

JNDI1="java.naming.factory.initial=org.jnp.interfaces.NamingContextFactory"
JNDI2="java.naming.factory.url.pkgs=org.jboss.naming:org.jnp.interfaces"

# Please replace with the host of your JBOSS:
JNDI3="java.naming.provider.url=jnp://"


# running the application
# ***********************

JAVA_COMMAND=java

${JAVA_COMMAND} -Dspin.home=${HCI_HOME} -DCOMPILER_SERVER=${COMPILERSERVER} -D${JNDI1} -D${JNDI2} -D${JNDI3} miningmart.hci.gui.main.Application
