/*
 * Decompiled with CFR 0.152.
 */
package miningmart.m4;

import java.util.Collection;
import java.util.Iterator;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Case;
import miningmart.m4.Column;
import miningmart.m4.ColumnSet;
import miningmart.m4.Concept;
import miningmart.m4.ForeignKey;
import miningmart.m4.M4Interface;
import miningmart.m4.MultipleResultException;
import miningmart.m4.Parameter;
import miningmart.m4.PrimaryKey;
import miningmart.m4.Relationship;
import miningmart.m4.Step;
import miningmart.m4.StorageException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class M4ClientExampleDelete {
    private static Logger logger;

    public static void main(String[] args) {
        M4ClientExampleDelete.initLogger();
        M4Interface myInterface = M4Interface.getInstance();
        if (myInterface == null) {
            logger.error((Object)"Could not initialize the M4 Interface");
        } else {
            logger.info((Object)"M4 Interface initialized");
        }
        Collection caseList = myInterface.getAllCaseNames();
        System.out.println("Available cases: ");
        M4ClientExampleDelete.printList(caseList);
        Collection operatorList = myInterface.getAllOperatorNames();
        System.out.println("Available operators: ");
        M4ClientExampleDelete.printList(operatorList);
        Case myCase = null;
        try {
            myCase = myInterface.findCaseForUpdate("Dummy Case", true);
            if (myCase == null) {
                logger.info((Object)"Case not found!");
                System.exit(0);
            }
            logger.info((Object)String.valueOf("Case found: ").concat(String.valueOf(myCase.getName())));
        }
        catch (M4Interface.CaseLockedException e) {
            logger.error((Object)"Case locked! Unlock case first.");
            System.exit(0);
        }
        logger.info((Object)String.valueOf("Case found: ").concat(String.valueOf(myCase.getName())));
        Concept partner = myCase.getConcept("Partner");
        logger.info((Object)String.valueOf("Concept found: ").concat(String.valueOf(partner.getName())));
        try {
            Parameter op = partner.getOutputParameter();
            if (op != null) {
                logger.info((Object)String.valueOf("Output parameter found: ").concat(String.valueOf(op.getParameterName())));
            }
        }
        catch (MultipleResultException op) {
            // empty catch block
        }
        BaseAttribute partnerName = partner.getBaseAttribute("Name");
        if (partnerName == null) {
            logger.error((Object)"Could not find base attribute");
        } else {
            logger.info((Object)String.valueOf("Attribute found: ").concat(String.valueOf(partnerName.getName())));
        }
        BaseAttribute partnerAge = partner.getBaseAttribute("Age");
        if (partnerAge == null) {
            logger.error((Object)"Could not find base attribute");
        } else {
            logger.info((Object)String.valueOf("Attribute found: ").concat(String.valueOf(partnerAge.getName())));
        }
        Concept contract = myCase.getConcept("Contract");
        logger.info((Object)String.valueOf("Concept found: ").concat(String.valueOf(contract.getName())));
        BaseAttribute contractName = contract.getBaseAttribute("Name");
        if (contractName == null) {
            logger.error((Object)"Could not find base attribute");
        } else {
            logger.info((Object)String.valueOf("Attribute found: ").concat(String.valueOf(contractName.getName())));
        }
        BaseAttribute contractDate = contract.getBaseAttribute("Date");
        if (contractDate == null) {
            logger.error((Object)"Could not find base attribute");
        } else {
            logger.info((Object)String.valueOf("Attribute found: ").concat(String.valueOf(contractDate.getName())));
        }
        Relationship partnerRole = partner.getFromConceptRelationship("partnerRole", contract);
        if (partnerRole == null) {
            logger.error((Object)"Could not find Relationship");
        } else {
            logger.info((Object)String.valueOf("Relationship for partner found: ").concat(String.valueOf(partnerRole.getName())));
        }
        Step aStep = myCase.getStep("First step");
        if (aStep == null) {
            logger.error((Object)"Could not find Step");
        } else {
            logger.info((Object)String.valueOf("Step found: ").concat(String.valueOf(aStep.getName())));
            Parameter inputParameter = aStep.getParameter("inputParameter");
            if (inputParameter == null) {
                logger.error((Object)"Could not find parameter");
            } else {
                logger.info((Object)String.valueOf("Parameter found: ").concat(String.valueOf(inputParameter.getParameterObject())));
                logger.info((Object)"Concept partner found as input parameter for the step");
            }
        }
        Step scStep = myCase.getStep("Second step");
        if (scStep == null) {
            logger.error((Object)"Could not find Step");
        } else {
            logger.info((Object)String.valueOf("Step found: ").concat(String.valueOf(scStep.getName())));
            Parameter outputParameter = scStep.getParameter("outputParameter");
            if (outputParameter == null) {
                logger.error((Object)"Could not find parameter");
            } else {
                logger.info((Object)String.valueOf("Parameter found: ").concat(String.valueOf(outputParameter.getParameterObject())));
                logger.info((Object)"Concept partner found as output parameter for the step");
            }
            Step predStep = scStep.getPredecessor("First step");
            logger.info((Object)String.valueOf(String.valueOf(String.valueOf("Predecessor for ").concat(String.valueOf(scStep.getName()))).concat(String.valueOf("found: "))).concat(String.valueOf(predStep.getName())));
            Step succStep = aStep.getSuccessor("Second step");
            logger.info((Object)String.valueOf(String.valueOf(String.valueOf("Successor for ").concat(String.valueOf(aStep.getName()))).concat(String.valueOf("found: "))).concat(String.valueOf(succStep.getName())));
        }
        ColumnSet partnerColumnSet = partner.getColumnSet("partnerColumnSet");
        logger.info((Object)String.valueOf("ColumnSet found: ").concat(String.valueOf(partnerColumnSet.getName())));
        Column partnerColumnSetC1 = partnerColumnSet.getColumn("PCSC1");
        logger.info((Object)String.valueOf("Column found Name: ").concat(String.valueOf(partnerColumnSetC1.getName())));
        Column partnerColumnSetC2 = partnerColumnSet.getColumn("PCSC2");
        logger.info((Object)String.valueOf("Column found Name: ").concat(String.valueOf(partnerColumnSetC2.getName())));
        PrimaryKey partnerColumnSetPK = partnerColumnSet.getPrimaryKey();
        logger.info((Object)String.valueOf("Column PK found Name: ").concat(String.valueOf(partnerColumnSetPK.getName())));
        ForeignKey partnerColumnSetFK = partnerColumnSet.getForeignKey("PCSFK");
        logger.info((Object)String.valueOf("Column FK found Name: ").concat(String.valueOf(partnerColumnSetFK.getName())));
        try {
            if (partnerColumnSetFK == null) {
                logger.error((Object)"Could not delete foreign key");
            } else {
                partnerColumnSetFK.delete();
                logger.info((Object)"Foreign key deleted");
            }
        }
        catch (StorageException e) {
            logger.error((Object)"Exception while deleting foreign key ", (Throwable)e);
        }
        try {
            if (partnerColumnSetPK == null) {
                logger.error((Object)"Could not delete primary key");
            } else {
                partnerColumnSetPK.delete();
                logger.info((Object)"Primary key deleted");
            }
        }
        catch (StorageException e) {
            logger.error((Object)"Exception while deleting primary key ", (Throwable)e);
        }
        try {
            if (partnerColumnSetC2 == null) {
                logger.error((Object)"Could not delete Column");
            } else {
                partnerColumnSetC2.delete();
                logger.info((Object)"Column deleted");
            }
        }
        catch (StorageException e) {
            logger.error((Object)"Exception while deleting second Column ", (Throwable)e);
        }
        try {
            if (partnerColumnSetC1 == null) {
                logger.error((Object)"Could not delete Column");
            } else {
                partnerColumnSetC1.delete();
                logger.info((Object)"Column deleted");
            }
        }
        catch (StorageException e) {
            logger.error((Object)"Exception while deleting first Column ", (Throwable)e);
        }
        try {
            if (partnerColumnSet == null) {
                logger.error((Object)"Could not delete Columnset");
            } else {
                partnerColumnSet.delete();
                logger.info((Object)"Columnset deleted");
            }
        }
        catch (StorageException e) {
            logger.error((Object)"Exception while deleting Columnset ", (Throwable)e);
        }
        try {
            if (scStep == null) {
                logger.error((Object)"Could not delete Step");
            } else {
                scStep.delete();
                logger.info((Object)"Step deleted");
            }
        }
        catch (StorageException e) {
            logger.error((Object)"Exception while deleting second Step ", (Throwable)e);
        }
        try {
            if (aStep == null) {
                logger.error((Object)"Could not delete Step");
            } else {
                aStep.delete();
                logger.info((Object)"Step deleted");
            }
        }
        catch (StorageException e) {
            logger.error((Object)"Exception while deleting first Step ", (Throwable)e);
        }
        try {
            if (partnerRole == null) {
                logger.error((Object)"Could not delete Relationship");
            } else {
                partnerRole.delete();
                logger.info((Object)"Relationship deleted");
            }
        }
        catch (StorageException e) {
            logger.error((Object)"Exception while deleting Relationship partner role ", (Throwable)e);
        }
        try {
            if (contractDate == null) {
                logger.error((Object)"Could not delete Base Attribute");
            } else {
                contractDate.delete();
                logger.info((Object)"Base Attribute deleted");
            }
        }
        catch (StorageException e) {
            logger.error((Object)"Exception while deleting Base Attribute contract date ", (Throwable)e);
        }
        try {
            if (contractName == null) {
                logger.error((Object)"Could not delete Base Attribute");
            } else {
                contractName.delete();
                logger.info((Object)"Base Attribute deleted");
            }
        }
        catch (StorageException e) {
            logger.error((Object)"Exception while deleting Base Attribute contract name ", (Throwable)e);
        }
        try {
            if (partnerAge == null) {
                logger.error((Object)"Could not delete Base Attribute");
            } else {
                partnerAge.delete();
                logger.info((Object)"Base Attribute deleted");
            }
        }
        catch (StorageException e) {
            logger.error((Object)"Exception while deleting Base Attribute partner age ", (Throwable)e);
        }
        try {
            if (partnerName == null) {
                logger.error((Object)"Could not delete Base Attribute");
            } else {
                partnerName.delete();
                logger.info((Object)"Base Attribute deleted");
            }
        }
        catch (StorageException e) {
            logger.error((Object)"Exception while deleting Base Attribute partner name ", (Throwable)e);
        }
        try {
            contract.delete();
            logger.info((Object)"Contract Concept deleted");
        }
        catch (StorageException e) {
            logger.error((Object)"Exception while deleting concept contract ", (Throwable)e);
        }
        try {
            partner.delete();
            logger.info((Object)"Partner Concept deleted");
        }
        catch (StorageException e) {
            logger.error((Object)"Exception while deleting concept partner ", (Throwable)e);
        }
        try {
            myCase.delete();
            logger.info((Object)"Dummy Case deleted");
        }
        catch (StorageException e) {
            logger.error((Object)"Exception while deleting Dummy Case ", (Throwable)e);
        }
        myInterface.releaseCase("Dummy Case");
    }

    private static void printList(Collection list) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String aName = (String)i.next();
            System.out.println(aName);
        }
        System.out.println();
    }

    private static void initLogger() {
        PropertyConfigurator.configure((String)"log4j.properties");
        logger = Logger.getLogger((String)"M4Test");
    }
}

