/*
 * Decompiled with CFR 0.152.
 */
package miningmart.m4;

import java.awt.Point;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Case;
import miningmart.m4.Chain;
import miningmart.m4.Column;
import miningmart.m4.ColumnSet;
import miningmart.m4.Concept;
import miningmart.m4.CreateException;
import miningmart.m4.ForeignKey;
import miningmart.m4.M4Interface;
import miningmart.m4.NameExistsException;
import miningmart.m4.Parameter;
import miningmart.m4.PrimaryKey;
import miningmart.m4.Relationship;
import miningmart.m4.Step;
import miningmart.m4.StorageException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class M4ClientExample {
    private static Logger logger;

    public static void main(String[] args) {
        M4ClientExample.initLogger();
        M4Interface myInterface = M4Interface.getInstance();
        if (myInterface == null) {
            logger.error((Object)"Could not initialize the M4 Interface");
        } else {
            logger.info((Object)"M4 Interface initialized");
        }
        Collection caseList = myInterface.getAllCaseNames();
        System.out.println("Available cases: ");
        M4ClientExample.printList(caseList);
        Collection operatorList = myInterface.getAllOperatorNames();
        System.out.println("Available operators: ");
        M4ClientExample.printList(operatorList);
        Case myCase = null;
        try {
            myCase = myInterface.createCase("Dummy Case");
            logger.info((Object)String.valueOf("Case created: ").concat(String.valueOf(myCase.getName())));
        }
        catch (CreateException e) {
            logger.error((Object)"Exception while creating a Dummy Case ", (Throwable)e);
        }
        catch (NameExistsException e) {
            logger.error((Object)"Name already exists ", (Throwable)e);
        }
        try {
            myCase.store();
            logger.info((Object)String.valueOf("Case stored: ").concat(String.valueOf(myCase.getName())));
        }
        catch (StorageException e) {
            logger.error((Object)"Exception while storing Dummy Case ", (Throwable)e);
        }
        Concept partner = null;
        BaseAttribute partnerName = null;
        BaseAttribute partnerAge = null;
        try {
            partner = myCase.createConcept("Partner", "BASE");
            partner.store();
            logger.info((Object)String.valueOf("Concept created and stored: ").concat(String.valueOf(partner.getName())));
            partnerName = partner.createBaseAttribute("Name", "NOMINAL", "DB");
            logger.info((Object)String.valueOf("Attribute added: ").concat(String.valueOf(partnerName.getName())));
            partnerAge = partner.createBaseAttribute("Age", "SCALAR", "DB");
            logger.info((Object)String.valueOf("Attribute added: ").concat(String.valueOf(partnerAge.getName())));
        }
        catch (CreateException e) {
            logger.error((Object)"Failed to create the partner concept or its attributes", (Throwable)e);
        }
        catch (NameExistsException e) {
            logger.error((Object)"Name already exists ", (Throwable)e);
        }
        catch (StorageException e) {
            logger.error((Object)"Failed to store the partner concept or its attributes", (Throwable)e);
        }
        Concept contract = null;
        try {
            contract = myCase.createConcept("Contract", "BASE");
            contract.store();
            logger.info((Object)String.valueOf("Concept created: ").concat(String.valueOf(contract.getName())));
            BaseAttribute contractName = contract.createBaseAttribute("Name", "NOMINAL", "DB");
            logger.info((Object)String.valueOf("Attribute added: ").concat(String.valueOf(contractName.getName())));
            BaseAttribute contractDate = contract.createBaseAttribute("Date", "TIME", "DB");
            logger.info((Object)String.valueOf("Attribute added: ").concat(String.valueOf(contractDate.getName())));
        }
        catch (CreateException e) {
            logger.error((Object)"Failed to create the contract concept or its attributes", (Throwable)e);
        }
        catch (NameExistsException e) {
            logger.error((Object)"Name already exists ", (Throwable)e);
        }
        catch (StorageException e) {
            logger.error((Object)"Failed to store the contract concept or its attributes", (Throwable)e);
        }
        Relationship partnerRole = null;
        try {
            partnerRole = partner.createFromConceptRelationship("partnerRole", contract);
            partnerRole.store();
            logger.info((Object)String.valueOf("Relationship created: ").concat(String.valueOf(partnerRole.getName())));
        }
        catch (CreateException e) {
            logger.error((Object)"Failed to create relationship partnerRole ", (Throwable)e);
        }
        catch (NameExistsException e) {
            logger.error((Object)"Name already exists ", (Throwable)e);
        }
        catch (StorageException e) {
            logger.error((Object)"Failed to store relationship partnerRole ", (Throwable)e);
        }
        Step aStep = null;
        try {
            aStep = myCase.createStep("First step");
            logger.info((Object)String.valueOf("Step created: ").concat(String.valueOf(aStep.getName())));
            aStep.setOperator(myInterface.findOperator("RowSelectionByQuery"));
            aStep.setStepNr(1);
            aStep.store();
            logger.info((Object)String.valueOf("Operator added to Step: ").concat(String.valueOf(aStep.getOperator().getName())));
            Parameter inputParameter = aStep.createParameter("inputParameter", partner, aStep.getOperator(), 1, "IN");
            inputParameter.store();
            logger.info((Object)String.valueOf("Parameter created: ").concat(String.valueOf(inputParameter.getParameterObject())));
            logger.info((Object)"Concept partner set as input parameter for the step");
        }
        catch (CreateException e) {
            logger.error((Object)"Failed to create a Step or set up an input parameter ", (Throwable)e);
        }
        catch (NameExistsException e) {
            logger.error((Object)"Name already exists ", (Throwable)e);
        }
        catch (StorageException e) {
            logger.error((Object)"Failed to store a Step or its input parameter ", (Throwable)e);
        }
        Step scStep = null;
        try {
            scStep = myCase.createStep("Second step");
            logger.info((Object)String.valueOf("Step created: ").concat(String.valueOf(scStep.getName())));
            scStep.setOperator(myInterface.findOperator("RowSelectionByQuery"));
            scStep.setStepNr(2);
            scStep.store();
            logger.info((Object)String.valueOf("Operator added to Step: ").concat(String.valueOf(scStep.getOperator().getName())));
            Parameter outputParameter1 = scStep.createParameter("outputParameter", partner, scStep.getOperator(), 1, "OUT");
            outputParameter1.store();
            logger.info((Object)String.valueOf("Parameter created: ").concat(String.valueOf(outputParameter1.getParameterObject())));
            logger.info((Object)"Concept partner set as output parameter for the step");
        }
        catch (CreateException e) {
            logger.error((Object)"Failed to create a Step or set up an output parameter ", (Throwable)e);
        }
        catch (NameExistsException e) {
            logger.error((Object)"Name already exists ", (Throwable)e);
        }
        catch (StorageException e) {
            logger.error((Object)"Failed to store a Step or its output parameter ", (Throwable)e);
        }
        try {
            scStep.addPredecessor(aStep);
            scStep.store();
            logger.info((Object)"Predecessor created: ");
        }
        catch (StorageException e) {
            logger.error((Object)"Failed to store predecessor for second step ", (Throwable)e);
        }
        try {
            aStep.addSuccessor(scStep);
            aStep.store();
            logger.info((Object)"Successor created: ");
        }
        catch (StorageException e) {
            logger.error((Object)"Failed to store successor for second step ", (Throwable)e);
        }
        Chain chain = null;
        try {
            chain = myCase.createChain("Two Step Chain");
            logger.info((Object)String.valueOf("Chain created: ").concat(String.valueOf(chain.getName())));
            chain.addStep(aStep);
            chain.addStep(scStep);
            aStep.setPoint(chain, new Point(1, 2));
            aStep.setPoint(chain, new Point(2, 3));
            aStep.setPoint(chain, new Point(3, 4));
            aStep.setPoint(chain, new Point(4, 5));
            scStep.setPoint(chain, new Point(3, 4));
            aStep.setPoint(null, new Point(1, 2));
            aStep.setPoint(null, new Point(2, 3));
            aStep.setPoint(null, new Point(3, 4));
            aStep.setPoint(null, new Point(4, 5));
            Map points = chain.getPointsContext();
            Point point1 = chain.getPoint(points, aStep);
            System.out.println(String.valueOf("Punt1 =").concat(String.valueOf(point1.toString())));
            Point point2 = chain.getPoint(points, scStep);
            System.out.println(String.valueOf("Punt2 =").concat(String.valueOf(point2.toString())));
        }
        catch (CreateException e) {
            logger.error((Object)"Failed to create a Chain or adding steps ", (Throwable)e);
        }
        catch (NameExistsException e) {
            logger.error((Object)"Name already exists ", (Throwable)e);
        }
        catch (StorageException e) {
            logger.error((Object)"Failed to store a Step or adding steps ", (Throwable)e);
        }
        ColumnSet partnerColumnSet = null;
        try {
            partnerColumnSet = partner.createColumnSet("partnerColumnSet", "MM", "T");
            partnerColumnSet.store();
            logger.info((Object)String.valueOf("ColumnSet created: ").concat(String.valueOf(partnerColumnSet.getName())));
        }
        catch (CreateException e) {
            logger.error((Object)"Failed to create ColumnSet partnerColumnSet ", (Throwable)e);
        }
        catch (NameExistsException e) {
            logger.error((Object)"Name already exists ", (Throwable)e);
        }
        catch (StorageException e) {
            logger.error((Object)"Failed to store ColumnSet partnerColumnSet ", (Throwable)e);
        }
        Column partnerColumnSetC1 = null;
        try {
            partnerColumnSetC1 = partnerColumnSet.createColumn("PCSC1", "NUMBER");
            partnerColumnSetC1.store();
            logger.info((Object)String.valueOf("Column C1 created Name: ").concat(String.valueOf(partnerColumnSetC1.getName())));
            logger.info((Object)String.valueOf("Column C1 created Datatype: ").concat(String.valueOf(partnerColumnSetC1.getColumnDatatype())));
        }
        catch (CreateException e) {
            logger.error((Object)"Failed to create Column C1 in partnerColumnSet ", (Throwable)e);
        }
        catch (NameExistsException e) {
            logger.error((Object)"Name already exists ", (Throwable)e);
        }
        catch (StorageException e) {
            logger.error((Object)"Failed to store Column C1 in partnerColumnSet  ", (Throwable)e);
        }
        try {
            partnerName.addColumn(partnerColumnSetC1);
            partnerName.store();
        }
        catch (StorageException e) {
            logger.error((Object)"Failed to store the partner concept or its attributes", (Throwable)e);
        }
        Column partnerColumnSetC2 = null;
        try {
            partnerColumnSetC2 = partnerColumnSet.createColumn("PCSC2", "NUMBER");
            partnerColumnSetC2.store();
            logger.info((Object)String.valueOf("Column C2 created Name: ").concat(String.valueOf(partnerColumnSetC2.getName())));
            logger.info((Object)String.valueOf("Column C2 created Datatype: ").concat(String.valueOf(partnerColumnSetC2.getColumnDatatype())));
        }
        catch (CreateException e) {
            logger.error((Object)"Failed to create Column C2 in partnerColumnSet ", (Throwable)e);
        }
        catch (NameExistsException e) {
            logger.error((Object)"Name already exists ", (Throwable)e);
        }
        catch (StorageException e) {
            logger.error((Object)"Failed to store Column C2 in partnerColumnSet  ", (Throwable)e);
        }
        PrimaryKey partnerColumnSetPK = null;
        try {
            partnerColumnSetPK = partnerColumnSet.createPrimaryKey("PCSPK");
            partnerColumnSetPK.store();
            logger.info((Object)String.valueOf("Column PK created Name: ").concat(String.valueOf(partnerColumnSetPK.getName())));
        }
        catch (CreateException e) {
            logger.error((Object)"Failed to create Column PK in partnerColumnSet ", (Throwable)e);
        }
        catch (NameExistsException e) {
            logger.error((Object)"Name already exists ", (Throwable)e);
        }
        catch (StorageException e) {
            logger.error((Object)"Failed to store Column PK in partnerColumnSet  ", (Throwable)e);
        }
        try {
            partnerColumnSetPK.addColumn(partnerColumnSetC1);
            partnerColumnSetPK.store();
            logger.info((Object)String.valueOf("Column C1 addedPK: ").concat(String.valueOf(partnerColumnSetPK.getName())));
        }
        catch (StorageException e) {
            logger.error((Object)"Failed to store Column C1 PK ", (Throwable)e);
        }
        try {
            partnerColumnSetPK.addColumn(partnerColumnSetC2);
            partnerColumnSetPK.store();
            logger.info((Object)String.valueOf("Column C2 addedPK: ").concat(String.valueOf(partnerColumnSetPK.getName())));
        }
        catch (StorageException e) {
            logger.error((Object)"Failed to store Column C2 PK ", (Throwable)e);
        }
        ForeignKey partnerColumnSetFK = null;
        try {
            partnerColumnSetFK = partnerColumnSet.createForeignKey("PCSFK");
            partnerColumnSetFK.store();
            logger.info((Object)String.valueOf("Column FK created Name: ").concat(String.valueOf(partnerColumnSetFK.getName())));
        }
        catch (CreateException e) {
            logger.error((Object)"Failed to create Column FK in partnerColumnSet ", (Throwable)e);
        }
        catch (NameExistsException e) {
            logger.error((Object)"Name already exists ", (Throwable)e);
        }
        catch (StorageException e) {
            logger.error((Object)"Failed to store Column FK in partnerColumnSet  ", (Throwable)e);
        }
    }

    private static void printList(Collection list) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String aName = (String)i.next();
            System.out.println(aName);
        }
        System.out.println();
    }

    private static void initLogger() {
        PropertyConfigurator.configure((String)"log4j.properties");
        logger = Logger.getLogger((String)"M4Test");
    }
}

