/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.m4;

import com.syllogic.miningmart.m4.Case;
import com.syllogic.miningmart.m4.Chain;
import com.syllogic.miningmart.m4.Documentation;
import com.syllogic.miningmart.m4.M4Interface;
import com.syllogic.miningmart.m4.M4Object;
import com.syllogic.miningmart.m4.Operator;
import com.syllogic.miningmart.m4.Parameter;
import com.syllogic.miningmart.m4.Value;
import com.syllogic.miningmart.m4.ejb.Steps;
import com.syllogic.miningmart.m4.ejb.StepsHome;
import java.awt.Point;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import miningmart.compilerInterface.M4CompilerInterfaceError;
import miningmart.m4.NameExistsException;
import miningmart.m4.StorageException;
import miningmart.m4.value.DocumentationV;
import miningmart.m4.value.StepV;
import org.apache.log4j.Logger;

public class Step
extends M4Object
implements miningmart.m4.Step,
Serializable {
    private static Logger logger = Logger.getLogger((String)"com.syllogic.miningmart.m4.Step");
    private boolean functionallyValid = false;
    private StepV value;
    private static StepsHome home = null;
    private static Map cache = new HashMap();

    public Step() {
        this.value = new StepV();
        this.setExisting(false);
        this.setChanged(true);
    }

    public Step(StepV value) {
        this.value = value;
        this.setExisting(true);
        this.setChanged(false);
    }

    public int getId() {
        return this.value.getId();
    }

    public String getName() {
        return this.value.getName();
    }

    public void setName(String name) throws NameExistsException {
        if (Step.getByCaseAndName(Step.getCurrentCase().getId(), name) != null) {
            throw new NameExistsException("Duplicate name");
        }
        this.value.setName(name);
        this.setChanged(true);
    }

    public int getStepNr() {
        return this.value.getStepNr();
    }

    public void setStepNr(int stepNr) {
        this.value.setStepNr(stepNr);
        this.setChanged(true);
    }

    public int getStepLoopNr() {
        return this.value.getLoopNr();
    }

    public void setStepLoopNr(int stepLoopNr) {
        this.value.setLoopNr(stepLoopNr);
        this.setChanged(true);
    }

    public String getMultiStepCondition() {
        return this.value.getMultiStepCondition();
    }

    public void setMultiStepCondition(String multiStepCondition) {
        this.value.setMultiStepCondition(multiStepCondition);
        this.setChanged(true);
    }

    public miningmart.m4.Case getCase() {
        if (this.value.getMmCaseName() == null) {
            return null;
        }
        return Case.getById(this.value.getMmCase());
    }

    public void setCase(miningmart.m4.Case rec) throws StorageException {
        Case anObj = (Case)rec;
        if (!anObj.isExisting()) {
            anObj.store();
        }
        this.value.setMmCase(anObj.getId());
        this.value.setMmCaseName(anObj.getName());
        this.setChanged(true);
    }

    public miningmart.m4.Chain getChain() {
        if (this.value.getChainName() == null) {
            return null;
        }
        return Chain.getById(this.value.getChain());
    }

    public void setChain(miningmart.m4.Chain rec) throws StorageException {
        Chain anObj = (Chain)rec;
        if (!anObj.isExisting()) {
            anObj.store();
        }
        this.value.setChain(anObj.getId());
        this.value.setChainName(anObj.getName());
        this.setChanged(true);
    }

    public void removeChain() throws StorageException {
        this.value.setChain(0);
        this.value.setChainName("NULL");
        this.setChanged(true);
    }

    public void setPoint(miningmart.m4.Chain chain, Point point) {
        M4Interface m4Interface = (M4Interface)M4Interface.getInstance();
        if (chain == null) {
            m4Interface.removePoint(this.getId(), this.getName(), "ST", null, null, null);
            m4Interface.setPoint(this.getId(), this.getName(), "ST", null, null, null, point);
        } else {
            m4Interface.removePoint(this.getId(), this.getName(), "ST", new Integer(((Chain)chain).getId()), null, "CH");
            m4Interface.setPoint(this.getId(), this.getName(), "ST", new Integer(((Chain)chain).getId()), null, "CH", point);
        }
    }

    public Point getPoint(miningmart.m4.Chain chain) {
        M4Interface m4Interface = (M4Interface)M4Interface.getInstance();
        Point point = null;
        point = chain == null ? m4Interface.getPoint(this.getId(), this.getName(), "ST", null, null, null) : m4Interface.getPoint(this.getId(), this.getName(), "ST", new Integer(((Chain)chain).getId()), null, "CH");
        return point;
    }

    public void removePoint(miningmart.m4.Chain chain) {
        M4Interface m4Interface = (M4Interface)M4Interface.getInstance();
        if (chain == null) {
            m4Interface.removePoint(this.getId(), this.getName(), "ST", null, null, null);
        } else {
            m4Interface.removePoint(this.getId(), this.getName(), "ST", new Integer(((Chain)chain).getId()), null, "CH");
        }
    }

    public void removeAllPoints() {
        M4Interface m4Interface = (M4Interface)M4Interface.getInstance();
        m4Interface.removeAllPoints(this.getId(), this.getName(), "ST");
    }

    public boolean isFunctionallyValid() {
        return this.functionallyValid;
    }

    public void setFunctionallyValid(boolean functionallyValid) {
        this.functionallyValid = functionallyValid;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRelationallyValid() {
        Steps anEJB = null;
        boolean valid = false;
        anEJB = Step.getEJB();
        valid = anEJB.getValidity(this.getId());
        Object var5_3 = null;
        if (anEJB == null) return valid;
        try {
            anEJB.remove();
            return valid;
        }
        catch (Exception exception) {}
        return valid;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var5_4 = null;
                if (anEJB == null) return valid;
                try {
                    anEJB.remove();
                    return valid;
                }
                catch (Exception exception) {}
                return valid;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var5_5 = null;
                if (anEJB == null) return valid;
                try {
                    anEJB.remove();
                    return valid;
                }
                catch (Exception exception) {}
                return valid;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addPredecessor(miningmart.m4.Step rec) {
        Step anObj = (Step)rec;
        Steps anEJB = null;
        anEJB = Step.getEJB();
        anEJB.addStepSequence(anObj.getId(), this.getId());
        Object var6_4 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var6_5 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var6_6 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public miningmart.m4.Step getPredecessor(String name) {
        return Step.getByCaseAndName(Step.getCurrentCase().getId(), name);
    }

    public Collection getAllPredecessors() {
        return Step.getPredecessorsByStep(this.getId());
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removePredecessor(String name) {
        Step anObj = (Step)this.getPredecessor(name);
        Steps anEJB = null;
        anEJB = Step.getEJB();
        anEJB.removeStepSequence(anObj.getId(), this.getId());
        Object var6_4 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var6_5 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var6_6 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeAllPredecessors() {
        Steps anEJB = null;
        anEJB = Step.getEJB();
        Iterator it = this.getAllPredecessors().iterator();
        while (it.hasNext()) {
            anEJB.removeStepSequence(((Step)it.next()).getId(), this.getId());
        }
        Object var4_5 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var4_6 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var4_7 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addSuccessor(miningmart.m4.Step rec) {
        Step anObj = (Step)rec;
        Steps anEJB = null;
        anEJB = Step.getEJB();
        anEJB.addStepSequence(this.getId(), anObj.getId());
        Object var6_4 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var6_5 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var6_6 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public miningmart.m4.Step getSuccessor(String name) {
        return Step.getByCaseAndName(Step.getCurrentCase().getId(), name);
    }

    public Collection getAllSuccessors() {
        return Step.getSuccessorsByStep(this.getId());
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection getAllNames() {
        block12: {
            aMap = null;
            anEJB = null;
            try {
                try {
                    anEJB = Step.getEJB();
                    aMap = anEJB.getNameIdMapByCase(Step.getCurrentCase().getId());
                    if (aMap != null) break block12;
                    var2_2 = null;
                    var4_5 = null;
                    if (anEJB == null) return var2_2;
                }
                catch (RemoteException e) {
                    Step.logger.error((Object)"Communication failure", (Throwable)e);
                    var4_7 = null;
                    if (anEJB == null) return aMap.keySet();
                    try {
                        anEJB.remove();
                        return aMap.keySet();
                    }
                    catch (Exception var5_12) {
                        return aMap.keySet();
                    }
                }
                catch (SQLException e) {
                    Step.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var4_8 = null;
                    if (anEJB == null) return aMap.keySet();
                    try {}
                    catch (Exception var5_13) {
                        return aMap.keySet();
                    }
                    anEJB.remove();
                    return aMap.keySet();
                }
            }
            catch (Throwable var3_15) {
                var4_9 = null;
                if (anEJB == null) throw var3_15;
                ** try [egrp 2[TRYBLOCK] [3 : 84->93)] { 
lbl38:
                // 1 sources

                anEJB.remove();
                throw var3_15;
lbl40:
                // 1 sources

                catch (Exception var5_14) {
                    // empty catch block
                }
                throw var3_15;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 84->93)] { 
lbl45:
            // 1 sources

            anEJB.remove();
            return var2_2;
lbl47:
            // 1 sources

            catch (Exception var5_10) {
                // empty catch block
            }
            return var2_2;
        }
        var4_6 = null;
        if (anEJB == null) return aMap.keySet();
        try {}
        catch (Exception var5_11) {}
        anEJB.remove();
        return aMap.keySet();
        return aMap.keySet();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeSuccessor(String name) {
        Step anObj = (Step)this.getSuccessor(name);
        Steps anEJB = null;
        anEJB = Step.getEJB();
        anEJB.removeStepSequence(this.getId(), anObj.getId());
        Object var6_4 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var6_5 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var6_6 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeAllSuccessors() {
        Steps anEJB = null;
        anEJB = Step.getEJB();
        Iterator it = this.getAllSuccessors().iterator();
        while (it.hasNext()) {
            anEJB.removeStepSequence(this.getId(), ((Step)it.next()).getId());
        }
        Object var4_5 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var4_6 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var4_7 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public miningmart.m4.Operator getOperator() {
        if (this.value.getOperatorName() == null) {
            return null;
        }
        return Operator.getById(this.value.getOperator());
    }

    public void setOperator(miningmart.m4.Operator rec) throws StorageException {
        Operator anObj = (Operator)rec;
        if (!anObj.isExisting()) {
            anObj.store();
        }
        this.value.setOperator(anObj.getId());
        this.value.setOperatorName(anObj.getName());
        this.setChanged(true);
    }

    public void removeOperator() {
        this.value.setOperator(0);
        this.value.setOperatorName("NULL");
    }

    public miningmart.m4.Parameter createParameter(String name, miningmart.m4.M4Object object, miningmart.m4.Operator operator, int number, String type) throws NameExistsException, miningmart.m4.CreateException {
        if (name == null || object == null || operator == null || type == null) {
            throw new miningmart.m4.CreateException("Name, object, operator and type required");
        }
        if (Parameter.getByStepAndName(this.getId(), name) != null) {
            throw new NameExistsException("Duplicate name");
        }
        Parameter rec = new Parameter();
        try {
            rec.setStep(this);
            rec.setParameterName(name);
            rec.setParameterObject(object);
            rec.setOperator(operator);
            rec.setParameterNr(number);
            rec.setParameterType(type);
        }
        catch (StorageException e) {
            logger.warn((Object)"Could not connect Parameter to Step.", (Throwable)e);
            throw new miningmart.m4.CreateException("A storage exception occurred.");
        }
        return rec;
    }

    public miningmart.m4.Parameter createValueParameter(String value, String datatype, String name, miningmart.m4.Operator operator, int number, String type) throws NameExistsException, miningmart.m4.CreateException {
        if (value == null || datatype == null || name == null || operator == null || type == null) {
            throw new miningmart.m4.CreateException("Value, datatype, name, object, operator and type required");
        }
        if (Parameter.getByStepAndName(this.getId(), name) != null) {
            throw new NameExistsException("Duplicate name");
        }
        Value newValue = new Value();
        newValue.setValue(value);
        newValue.setName(name);
        newValue.setDatatype(datatype);
        Parameter rec = new Parameter();
        try {
            rec.setStep(this);
            rec.setParameterName(name);
            rec.setParameterObject(newValue);
            rec.setOperator(operator);
            rec.setParameterNr(number);
            rec.setParameterType(type);
        }
        catch (StorageException e) {
            logger.warn((Object)"Could not connect Parameter to Step.", (Throwable)e);
            throw new miningmart.m4.CreateException("A storage exception occurred.");
        }
        return rec;
    }

    public void addParameter(miningmart.m4.Parameter rec) throws StorageException {
        rec.setStep(this);
    }

    public miningmart.m4.Parameter getParameter(String name) {
        return Parameter.getByStepAndName(this.getId(), name);
    }

    public Collection getAllParameters() {
        return Parameter.getByStepAndTypeName(this.getId(), "Both");
    }

    public Collection getAllInputParameters() {
        return Parameter.getByStepAndTypeName(this.getId(), "Input");
    }

    public Collection getAllOutputParameters() {
        return Parameter.getByStepAndTypeName(this.getId(), "Output");
    }

    public void removeParameter(String name) throws StorageException {
        this.getParameter(name).delete();
    }

    public void removeAllParameters() throws StorageException {
        Iterator it = this.getAllParameters().iterator();
        while (it.hasNext()) {
            ((Parameter)it.next()).delete();
        }
    }

    private static Steps getEJB() {
        try {
            Object initial;
            if (home == null) {
                initial = new InitialContext();
                home = (StepsHome)PortableRemoteObject.narrow((Object)initial.lookup("Steps"), Class.forName("com.syllogic.miningmart.m4.ejb.StepsHome"));
            }
            initial = home.create();
            return initial;
        }
        catch (ClassCastException e) {
            logger.warn((Object)"Got the wrong EJB?:", (Throwable)e);
        }
        catch (CreateException e) {
            logger.warn((Object)"Failed to create EJB reference:", (Throwable)e);
        }
        catch (NamingException e) {
            logger.warn((Object)"Failed to resolve JNDI name in initial context:", (Throwable)e);
        }
        catch (RemoteException e) {
            logger.warn((Object)"Communication failure", (Throwable)e);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static miningmart.m4.Step getById(int id) {
        Steps anEJB;
        Step aStep;
        block10: {
            Integer idObject = new Integer(id);
            aStep = (Step)cache.get(idObject);
            if (aStep != null) return aStep;
            anEJB = null;
            anEJB = Step.getEJB();
            StepV val = anEJB.find(id);
            if (val == null) break block10;
            aStep = new Step(val);
            cache.put(idObject, aStep);
        }
        Object var6_7 = null;
        if (anEJB == null) return aStep;
        try {
            anEJB.remove();
            return aStep;
        }
        catch (Exception exception) {}
        return aStep;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var6_8 = null;
                if (anEJB == null) return aStep;
                try {
                    anEJB.remove();
                    return aStep;
                }
                catch (Exception exception) {}
                return aStep;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var6_9 = null;
                if (anEJB == null) return aStep;
                try {
                    anEJB.remove();
                    return aStep;
                }
                catch (Exception exception) {}
                return aStep;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static miningmart.m4.Step getByCaseAndName(int id, String name) {
        block13: {
            anEJB = null;
            try {
                try {
                    anEJB = Step.getEJB();
                    anId = anEJB.getIdByCaseAndName(id, name);
                    if (anId == null) break block13;
                    anObj = (Step)Step.cache.get(anId);
                    if (anObj == null && (val = anEJB.find(anId)) != null) {
                        anObj = new Step(val);
                        Step.cache.put(anId, anObj);
                    }
                    if (anObj == null) break block13;
                    var5_7 = anObj;
                    var7_8 = null;
                    if (anEJB == null) return var5_7;
                }
                catch (RemoteException e) {
                    Step.logger.warn((Object)"Communication failure", (Throwable)e);
                    var7_10 = null;
                    if (anEJB == null) return null;
                    try {
                        anEJB.remove();
                        return null;
                    }
                    catch (Exception var8_15) {
                        return null;
                    }
                }
                catch (SQLException e) {
                    Step.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var7_11 = null;
                    if (anEJB == null) return null;
                    try {}
                    catch (Exception var8_16) {
                        return null;
                    }
                    anEJB.remove();
                    return null;
                }
            }
            catch (Throwable var6_18) {
                var7_12 = null;
                if (anEJB == null) throw var6_18;
                ** try [egrp 2[TRYBLOCK] [3 : 147->156)] { 
lbl43:
                // 1 sources

                anEJB.remove();
                throw var6_18;
lbl45:
                // 1 sources

                catch (Exception var8_17) {
                    // empty catch block
                }
                throw var6_18;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 147->156)] { 
lbl50:
            // 1 sources

            anEJB.remove();
            return var5_7;
lbl52:
            // 1 sources

            catch (Exception var8_13) {
                // empty catch block
            }
            return var5_7;
        }
        var7_9 = null;
        if (anEJB == null) return null;
        try {}
        catch (Exception var8_14) {}
        anEJB.remove();
        return null;
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection getPredecessorsByStep(int id) {
        ArrayList<Step> aList = new ArrayList<Step>();
        Steps anEJB = null;
        anEJB = Step.getEJB();
        Iterator it = anEJB.getPredecessorIdByStep(id).iterator();
        while (it.hasNext()) {
            StepV val;
            Integer anId = (Integer)it.next();
            Step anObj = (Step)cache.get(anId);
            if (anObj == null && (val = anEJB.find(anId)) != null) {
                anObj = new Step(val);
                cache.put(anId, anObj);
            }
            if (anObj == null) continue;
            aList.add(anObj);
        }
        Object var8_9 = null;
        if (anEJB == null) return aList;
        try {
            anEJB.remove();
            return aList;
        }
        catch (Exception exception) {}
        return aList;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var8_10 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var8_11 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection getSuccessorsByStep(int id) {
        ArrayList<Step> aList = new ArrayList<Step>();
        Steps anEJB = null;
        anEJB = Step.getEJB();
        Iterator it = anEJB.getSuccessorIdByStep(id).iterator();
        while (it.hasNext()) {
            StepV val;
            Integer anId = (Integer)it.next();
            Step anObj = (Step)cache.get(anId);
            if (anObj == null && (val = anEJB.find(anId)) != null) {
                anObj = new Step(val);
                cache.put(anId, anObj);
            }
            if (anObj == null) continue;
            aList.add(anObj);
        }
        Object var8_9 = null;
        if (anEJB == null) return aList;
        try {
            anEJB.remove();
            return aList;
        }
        catch (Exception exception) {}
        return aList;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var8_10 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var8_11 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection getByCase(int id) {
        ArrayList<Step> aList = new ArrayList<Step>();
        Steps anEJB = null;
        anEJB = Step.getEJB();
        Iterator it = anEJB.getIdByCase(id).iterator();
        while (it.hasNext()) {
            StepV val;
            Integer anId = (Integer)it.next();
            Step anObj = (Step)cache.get(anId);
            if (anObj == null && (val = anEJB.find(anId)) != null) {
                anObj = new Step(val);
                cache.put(anId, anObj);
            }
            if (anObj == null) continue;
            aList.add(anObj);
        }
        Object var8_9 = null;
        if (anEJB == null) return aList;
        try {
            anEJB.remove();
            return aList;
        }
        catch (Exception exception) {}
        return aList;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var8_10 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var8_11 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection getByChain(int id) {
        ArrayList<Step> aList = new ArrayList<Step>();
        Steps anEJB = null;
        anEJB = Step.getEJB();
        Iterator it = anEJB.getIdByChain(id).iterator();
        while (it.hasNext()) {
            StepV val;
            Integer anId = (Integer)it.next();
            Step anObj = (Step)cache.get(anId);
            if (anObj == null && (val = anEJB.find(anId)) != null) {
                anObj = new Step(val);
                cache.put(anId, anObj);
            }
            if (anObj == null) continue;
            aList.add(anObj);
        }
        Object var8_9 = null;
        if (anEJB == null) return aList;
        try {
            anEJB.remove();
            return aList;
        }
        catch (Exception exception) {}
        return aList;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var8_10 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var8_11 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection getNamesByChain(int id) {
        Collection aCollection = null;
        Steps anEJB = null;
        anEJB = Step.getEJB();
        aCollection = anEJB.getNameByChain(id);
        Object var5_3 = null;
        if (anEJB == null) return aCollection;
        try {
            anEJB.remove();
            return aCollection;
        }
        catch (Exception exception) {}
        return aCollection;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var5_4 = null;
                if (anEJB == null) return aCollection;
                try {
                    anEJB.remove();
                    return aCollection;
                }
                catch (Exception exception) {}
                return aCollection;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var5_5 = null;
                if (anEJB == null) return aCollection;
                try {
                    anEJB.remove();
                    return aCollection;
                }
                catch (Exception exception) {}
                return aCollection;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public miningmart.m4.Step copy(miningmart.m4.Case newCase, miningmart.m4.Chain newChain) throws StorageException, NameExistsException, miningmart.m4.CreateException {
        String stepName = this.getName();
        int stepNr = this.getStepNr();
        Operator stepOperator = (Operator)this.getOperator();
        int stepLoopNr = this.getStepLoopNr();
        String stepMultiStepCondition = this.getMultiStepCondition();
        Step newStep = null;
        newStep = (Step)newCase.createStep(stepName);
        newStep.setStepNr(stepNr);
        newStep.setOperator(stepOperator);
        newStep.setStepLoopNr(stepLoopNr);
        newStep.setMultiStepCondition(stepMultiStepCondition);
        newStep.setChain(newChain);
        return newStep;
    }

    /*
     * Unable to fully structure code
     */
    public void delete() throws StorageException {
        block21: {
            if (!this.isExisting()) {
                return;
            }
            currentCompilerAccess = M4Interface.getCurrentCompilerAccess();
            if (currentCompilerAccess == null) {
                if (Step.logger.isDebugEnabled()) {
                    Step.logger.debug((Object)"No currentCompilerAccess available!");
                }
            } else {
                Step.logger.info((Object)"CompilerAccess found!");
                try {
                    currentCompilerAccess.deleteTrashForStep((long)this.value.getId());
                }
                catch (M4CompilerInterfaceError e) {
                    Step.logger.warn((Object)"M4CompilerInterfaceError failure", (Throwable)e);
                }
                catch (RemoteException e) {
                    Step.logger.warn((Object)"Communication failure", (Throwable)e);
                }
            }
            anEJB = null;
            try {
                anEJB = Step.getEJB();
                anEJB.delete(this.value.getId());
                this.setExisting(false);
                Step.cache.remove(this);
                var5_5 = null;
                ** if (anEJB == null) goto lbl-1000
            }
            catch (Throwable var4_15) {
                var5_8 = null;
                if (anEJB != null) {
                    try {
                        anEJB.remove();
                    }
                    catch (Exception var6_12) {
                        // empty catch block
                    }
                }
                throw var4_15;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    anEJB.remove();
                }
                catch (Exception var6_9) {}
            }
lbl-1000:
            // 2 sources

            {
                break block21;
                catch (RemoteException e) {
                    Step.logger.warn((Object)"Communication failure", (Throwable)e);
                    var5_6 = null;
                    if (anEJB != null) {
                        try {
                            anEJB.remove();
                        }
                        catch (Exception var6_10) {}
                    }
                    break block21;
                }
                catch (SQLException e) {
                    Step.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var5_7 = null;
                    if (anEJB != null) {
                        try {
                            anEJB.remove();
                        }
                        catch (Exception var6_11) {}
                    }
                }
            }
        }
        this.removeAllPoints();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void store() throws StorageException {
        if (!this.isChanged()) {
            return;
        }
        Steps anEJB = null;
        anEJB = Step.getEJB();
        if (this.isExisting()) {
            anEJB.update(this.value);
        } else {
            this.value.setId(anEJB.create(this.value));
            cache.put(new Integer(this.value.getId()), this);
        }
        this.setChanged(false);
        this.setExisting(true);
        Object var4_2 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var4_3 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var4_4 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void setDocumentation(String text) {
        this.removeAllDocumentation();
        if (text == null || text.equalsIgnoreCase("")) {
            return;
        }
        DocumentationV val = new DocumentationV();
        val.setText(text);
        val.setObjectId(this.getId());
        val.setObjectType("ST");
        Documentation.createByValueObject(val);
    }

    public String getDocumentation() {
        return Documentation.getByIdAndType(this.getId(), "ST");
    }

    public void removeAllDocumentation() {
        Documentation.deleteByIdAndType(this.getId(), "ST");
    }

    private static Case getCurrentCase() {
        return (Case)M4Interface.getCurrentCase();
    }

    protected static void clearCache() {
        cache.clear();
    }

    public boolean isCompiled() {
        boolean isCompiled = false;
        miningmart.m4.M4Interface m4Interface = M4Interface.getInstance();
        String qSQL = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("SELECT\tCOUNT(*) FROM\t\tstep_t st ,\t\t\tparameter_t p ,\t\t\tcolumnset_t c WHERE\tst.st_id = ").concat(String.valueOf(this.getId()))).concat(String.valueOf(" "))).concat(String.valueOf("AND\t\tst.st_id = p.par_stid "))).concat(String.valueOf("AND\t\tp.par_objtype = 'CON' "))).concat(String.valueOf("AND\t\tp.par_type = 'OUT' "))).concat(String.valueOf("AND\t\tp.par_objid = c.cs_conid"));
        try {
            List columnSetExist = m4Interface.executeSQLQC1(qSQL, 10);
            isCompiled = columnSetExist != null;
        }
        catch (SQLException e) {
            logger.error((Object)"Exception while executing SQL ", (Throwable)e);
        }
        return isCompiled;
    }
}

