/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.m4;

import com.syllogic.miningmart.m4.BaseAttribute;
import com.syllogic.miningmart.m4.Case;
import com.syllogic.miningmart.m4.Concept;
import com.syllogic.miningmart.m4.Documentation;
import com.syllogic.miningmart.m4.M4Interface;
import com.syllogic.miningmart.m4.M4Object;
import com.syllogic.miningmart.m4.MultiColumnFeature;
import com.syllogic.miningmart.m4.Operator;
import com.syllogic.miningmart.m4.Relationship;
import com.syllogic.miningmart.m4.Step;
import com.syllogic.miningmart.m4.Value;
import com.syllogic.miningmart.m4.ejb.Parameters;
import com.syllogic.miningmart.m4.ejb.ParametersHome;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import miningmart.m4.MultipleResultException;
import miningmart.m4.NameExistsException;
import miningmart.m4.StorageException;
import miningmart.m4.value.DocumentationV;
import miningmart.m4.value.ParameterV;
import org.apache.log4j.Logger;

public class Parameter
extends M4Object
implements miningmart.m4.Parameter,
Serializable {
    public static final String BOTH = "Both";
    public static final String INPUT = "Input";
    public static final String OUTPUT = "Output";
    private ParameterV value;
    private static ParametersHome home = null;
    private static Logger logger = Logger.getLogger((String)"com.syllogic.miningmart.m4.Parameter");
    private static Map cache = new HashMap();

    public Parameter() {
        this.value = new ParameterV();
        this.setExisting(false);
        this.setChanged(true);
    }

    public Parameter(ParameterV value) {
        this.value = value;
        this.setExisting(true);
        this.setChanged(false);
    }

    public int getId() {
        return this.value.getId();
    }

    public String getParameterName() {
        return this.value.getName();
    }

    public void setParameterName(String parameterName) throws NameExistsException {
        if (Parameter.getByStepAndName(((Step)this.getStep()).getId(), parameterName) != null) {
            throw new NameExistsException("Duplicate name");
        }
        this.value.setName(parameterName);
        this.setChanged(true);
    }

    public String getParameterType() {
        return this.value.getType();
    }

    public void setParameterType(String parameterType) {
        this.value.setType(parameterType);
        this.setChanged(true);
    }

    public int getParameterNr() {
        return this.value.getParameterNr();
    }

    public void setParameterNr(int parameterNr) {
        this.value.setParameterNr(parameterNr);
        this.setChanged(true);
    }

    public int getLoopNr() {
        return this.value.getStepLoopNr();
    }

    public void setLoopNr(int loopNr) {
        this.value.setStepLoopNr(loopNr);
        this.setChanged(true);
    }

    public miningmart.m4.Step getStep() {
        if (this.value.getStepName() == null) {
            return null;
        }
        return Step.getById(this.value.getStep());
    }

    public void setStep(miningmart.m4.Step rec) throws StorageException {
        Step anObj = (Step)rec;
        if (!anObj.isExisting()) {
            anObj.store();
        }
        this.value.setStep(anObj.getId());
        this.value.setStepName(anObj.getName());
        this.setChanged(true);
    }

    public miningmart.m4.Operator getOperator() {
        if (this.value.getOperatorName() == null) {
            return null;
        }
        return Operator.getById(this.value.getOperator());
    }

    public void setOperator(miningmart.m4.Operator rec) throws StorageException {
        Operator anObj = (Operator)rec;
        if (!anObj.isExisting()) {
            anObj.store();
        }
        this.value.setOperator(anObj.getId());
        this.value.setOperatorName(anObj.getName());
        this.setChanged(true);
    }

    public miningmart.m4.M4Object getParameterObject() {
        String type = this.value.getObjectType();
        if (type == null) {
            return null;
        }
        if (type.equalsIgnoreCase("CON")) {
            return Concept.getById(this.value.getObjectId());
        }
        if (type.equalsIgnoreCase("REL")) {
            return Relationship.getById(this.value.getObjectId());
        }
        if (type.equalsIgnoreCase("MCF")) {
            return MultiColumnFeature.getById(this.value.getObjectId());
        }
        if (type.equalsIgnoreCase("BA")) {
            return BaseAttribute.getById(this.value.getObjectId());
        }
        if (type.equalsIgnoreCase("V")) {
            return Value.getById(this.value.getObjectId());
        }
        return null;
    }

    public void removeParameterObject() {
        this.value.setObjectId(0);
        this.value.setObjectType("NULL");
        this.setChanged(true);
    }

    public void setParameterObject(miningmart.m4.M4Object rec) throws StorageException {
        if (rec == null) {
            this.value.setObjectId(0);
            this.value.setObjectType("V");
            this.setChanged(true);
            return;
        }
        M4Object anObj = (M4Object)rec;
        if (!anObj.isExisting()) {
            anObj.store();
        }
        this.value.setObjectId(anObj.getId());
        if (anObj instanceof BaseAttribute) {
            this.value.setObjectType("BA");
        } else if (anObj instanceof MultiColumnFeature) {
            this.value.setObjectType("MCF");
        } else if (anObj instanceof Concept) {
            this.value.setObjectType("CON");
        } else if (anObj instanceof Relationship) {
            this.value.setObjectType("REL");
        } else if (anObj instanceof Value) {
            this.value.setObjectType("V");
        }
        this.setChanged(true);
    }

    public miningmart.m4.MultiColumnFeature getMultiColumnFeature() {
        return (MultiColumnFeature)this.getParameterObject();
    }

    public void setMultiColumnFeature(miningmart.m4.MultiColumnFeature rec) throws StorageException {
        this.setParameterObject(rec);
    }

    public miningmart.m4.BaseAttribute getBaseAttribute() {
        return (BaseAttribute)this.getParameterObject();
    }

    public void setBaseAttribute(miningmart.m4.BaseAttribute rec) throws StorageException {
        this.setParameterObject(rec);
    }

    public miningmart.m4.Value getValue() {
        return Value.getByParameter(this.getId());
    }

    public void removeValue() throws StorageException {
        miningmart.m4.Value aValue = this.getValue();
        if (aValue != null) {
            this.getValue().delete();
            this.setParameterObject(null);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Parameter getByStepAndName(int id, String name) {
        block13: {
            anEJB = null;
            try {
                try {
                    anEJB = Parameter.getEJB();
                    anId = anEJB.getIdByStepAndName(id, name);
                    if (anId == null) break block13;
                    anObj = (Parameter)Parameter.cache.get(anId);
                    if (anObj == null && (val = anEJB.find(anId)) != null) {
                        anObj = new Parameter(val);
                        Parameter.cache.put(anId, anObj);
                    }
                    if (anObj == null) break block13;
                    var5_7 = anObj;
                    var7_8 = null;
                    if (anEJB == null) return var5_7;
                }
                catch (RemoteException e) {
                    Parameter.logger.warn((Object)"Communication failure", (Throwable)e);
                    var7_10 = null;
                    if (anEJB == null) return null;
                    try {
                        anEJB.remove();
                        return null;
                    }
                    catch (Exception var8_15) {
                        return null;
                    }
                }
                catch (SQLException e) {
                    Parameter.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var7_11 = null;
                    if (anEJB == null) return null;
                    try {}
                    catch (Exception var8_16) {
                        return null;
                    }
                    anEJB.remove();
                    return null;
                }
            }
            catch (Throwable var6_18) {
                var7_12 = null;
                if (anEJB == null) throw var6_18;
                ** try [egrp 2[TRYBLOCK] [3 : 147->156)] { 
lbl43:
                // 1 sources

                anEJB.remove();
                throw var6_18;
lbl45:
                // 1 sources

                catch (Exception var8_17) {
                    // empty catch block
                }
                throw var6_18;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 147->156)] { 
lbl50:
            // 1 sources

            anEJB.remove();
            return var5_7;
lbl52:
            // 1 sources

            catch (Exception var8_13) {
                // empty catch block
            }
            return var5_7;
        }
        var7_9 = null;
        if (anEJB == null) return null;
        try {}
        catch (Exception var8_14) {}
        anEJB.remove();
        return null;
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Parameter getById(int id) {
        Parameters anEJB;
        Parameter aParameter;
        block10: {
            Integer idObject = new Integer(id);
            aParameter = (Parameter)cache.get(idObject);
            if (aParameter != null) return aParameter;
            anEJB = null;
            anEJB = Parameter.getEJB();
            ParameterV val = anEJB.find(id);
            if (val == null) break block10;
            aParameter = new Parameter(val);
            cache.put(idObject, aParameter);
        }
        Object var6_7 = null;
        if (anEJB == null) return aParameter;
        try {
            anEJB.remove();
            return aParameter;
        }
        catch (Exception exception) {}
        return aParameter;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var6_8 = null;
                if (anEJB == null) return aParameter;
                try {
                    anEJB.remove();
                    return aParameter;
                }
                catch (Exception exception) {}
                return aParameter;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var6_9 = null;
                if (anEJB == null) return aParameter;
                try {
                    anEJB.remove();
                    return aParameter;
                }
                catch (Exception exception) {}
                return aParameter;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static Parameters getEJB() {
        try {
            Object initial;
            if (home == null) {
                initial = new InitialContext();
                home = (ParametersHome)PortableRemoteObject.narrow((Object)initial.lookup("Parameters"), Class.forName("com.syllogic.miningmart.m4.ejb.ParametersHome"));
            }
            initial = home.create();
            return initial;
        }
        catch (ClassCastException e) {
            logger.warn((Object)"Got the wrong EJB?:", (Throwable)e);
        }
        catch (CreateException e) {
            logger.warn((Object)"Failed to create EJB reference:", (Throwable)e);
        }
        catch (NamingException e) {
            logger.warn((Object)"Failed to resolve JNDI name in initial context:", (Throwable)e);
        }
        catch (RemoteException e) {
            logger.warn((Object)"Communication failure", (Throwable)e);
        }
        return null;
    }

    public miningmart.m4.Parameter copy(M4Object newParameterObject, miningmart.m4.Step newStep) throws StorageException, NameExistsException, miningmart.m4.CreateException {
        String parameterName = this.getParameterName();
        Operator parameterOperator = (Operator)this.getOperator();
        int parameterNr = this.getParameterNr();
        String parameterType = this.getParameterType();
        int parameterStepLoopNr = this.getLoopNr();
        Parameter newParameter = null;
        newParameter = (Parameter)newStep.createParameter(parameterName, newParameterObject, parameterOperator, parameterNr, parameterType);
        newParameter.setLoopNr(parameterStepLoopNr);
        return newParameter;
    }

    public miningmart.m4.Parameter copy(miningmart.m4.Step newStep) throws StorageException, NameExistsException, miningmart.m4.CreateException {
        String parameterName = this.getParameterName();
        M4Object parameterObject = (M4Object)this.getParameterObject();
        Operator parameterOperator = (Operator)this.getOperator();
        int parameterNr = this.getParameterNr();
        String parameterType = this.getParameterType();
        int parameterStepLoopNr = this.getLoopNr();
        Case newCase = (Case)newStep.getCase();
        M4Object newParameterObject = parameterObject;
        if (parameterObject instanceof BaseAttribute) {
            BaseAttribute oldBaseAttribute = (BaseAttribute)parameterObject;
            String oldBaseAttributeName = oldBaseAttribute.getName();
            try {
                Concept oldConcept = (Concept)oldBaseAttribute.getConcept();
                String oldConceptName = oldConcept.getName();
                Concept newConcept = (Concept)newCase.getConcept(oldConceptName);
                BaseAttribute newBaseAttribute = (BaseAttribute)newConcept.getBaseAttribute(oldBaseAttributeName);
                newParameterObject = newBaseAttribute;
            }
            catch (MultipleResultException oldConcept) {}
        } else if (parameterObject instanceof MultiColumnFeature) {
            MultiColumnFeature oldMultiColumnFeature = (MultiColumnFeature)parameterObject;
            String oldMultiColumnFeatureName = oldMultiColumnFeature.getName();
            Concept oldConcept = (Concept)oldMultiColumnFeature.getConcept();
            String oldConceptName = oldConcept.getName();
            Concept newConcept = (Concept)newCase.getConcept(oldConceptName);
            MultiColumnFeature newMultiColumnFeature = (MultiColumnFeature)newConcept.getMultiColumnFeature(oldMultiColumnFeatureName);
            newParameterObject = newMultiColumnFeature;
        } else if (parameterObject instanceof Concept) {
            Concept oldConcept = (Concept)parameterObject;
            String oldConceptName = oldConcept.getName();
            Concept newConcept = (Concept)newCase.getConcept(oldConceptName);
            newParameterObject = newConcept;
        } else if (parameterObject instanceof Relationship) {
            Relationship oldRelationship = (Relationship)parameterObject;
            String oldRelationshipName = oldRelationship.getName();
            Concept oldFromConcept = (Concept)oldRelationship.getFromConcept();
            String oldFromConceptName = oldFromConcept.getName();
            Concept oldToConcept = (Concept)oldRelationship.getToConcept();
            String oldToConceptName = oldToConcept.getName();
            Concept newFromConcept = (Concept)newCase.getConcept(oldFromConceptName);
            Concept newToConcept = (Concept)newCase.getConcept(oldToConceptName);
            Relationship newRelationship = (Relationship)newToConcept.getToConceptRelationship(oldRelationshipName, newFromConcept);
            newParameterObject = newRelationship;
        } else if (parameterObject instanceof Value) {
            // empty if block
        }
        Parameter newParameter = null;
        newParameter = (Parameter)newStep.createParameter(parameterName, newParameterObject, parameterOperator, parameterNr, parameterType);
        newParameter.setLoopNr(parameterStepLoopNr);
        return newParameter;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delete() throws StorageException {
        if (!this.isExisting()) {
            return;
        }
        Parameters anEJB = null;
        anEJB = Parameter.getEJB();
        anEJB.delete(this.value.getId());
        this.setExisting(false);
        cache.remove(this);
        Object var4_2 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var4_3 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var4_4 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void store() throws StorageException {
        if (!this.isChanged()) {
            return;
        }
        Parameters anEJB = null;
        anEJB = Parameter.getEJB();
        if (this.isExisting()) {
            anEJB.update(this.value);
        } else {
            this.value.setId(anEJB.create(this.value));
            cache.put(new Integer(this.value.getId()), this);
        }
        this.setChanged(false);
        this.setExisting(true);
        Object var4_2 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var4_3 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var4_4 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection getByStepAndTypeName(int id, String ioType) {
        ArrayList<Parameter> aList = new ArrayList<Parameter>();
        Parameters anEJB = null;
        anEJB = Parameter.getEJB();
        Iterator it = null;
        it = ioType.equalsIgnoreCase(INPUT) ? anEJB.getInputIdByStep(id).iterator() : (ioType.equalsIgnoreCase(OUTPUT) ? anEJB.getOutputIdByStep(id).iterator() : anEJB.getIdByStep(id).iterator());
        while (it.hasNext()) {
            ParameterV val;
            Integer anId = (Integer)it.next();
            Parameter anObj = (Parameter)cache.get(anId);
            if (anObj == null && (val = anEJB.find(anId)) != null) {
                anObj = new Parameter(val);
                cache.put(anId, anObj);
            }
            if (anObj == null) continue;
            aList.add(anObj);
        }
        Object var9_10 = null;
        if (anEJB == null) return aList;
        try {
            anEJB.remove();
            return aList;
        }
        catch (Exception exception) {}
        return aList;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var9_11 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var9_12 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection getByValue(int id) {
        ArrayList<Parameter> aList = new ArrayList<Parameter>();
        Parameters anEJB = null;
        anEJB = Parameter.getEJB();
        Iterator it = anEJB.getIdByValueAndCase(id, Parameter.getCurrentCase().getId()).iterator();
        while (it.hasNext()) {
            ParameterV val;
            Integer anId = (Integer)it.next();
            Parameter anObj = (Parameter)cache.get(anId);
            if (anObj == null && (val = anEJB.find(anId)) != null) {
                anObj = new Parameter(val);
                cache.put(anId, anObj);
            }
            if (anObj == null) continue;
            aList.add(anObj);
        }
        Object var8_9 = null;
        if (anEJB == null) return aList;
        try {
            anEJB.remove();
            return aList;
        }
        catch (Exception exception) {}
        return aList;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var8_10 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var8_11 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static miningmart.m4.Parameter getByValueAndStepNameAndName(int valueId, String stepName, String parameterName) {
        block13: {
            anEJB = null;
            try {
                try {
                    anEJB = Parameter.getEJB();
                    step = Step.getByCaseAndName(Parameter.getCurrentCase().getId(), stepName);
                    stepId = ((Step)step).getId();
                    anId = anEJB.getIdByValueAndStepAndName(valueId, stepId, parameterName);
                    if (anId == null) break block13;
                    anObj = (Parameter)Parameter.cache.get(anId);
                    if (anObj == null && (val = anEJB.find(valueId)) != null) {
                        anObj = new Parameter(val);
                        Parameter.cache.put(anId, anObj);
                    }
                    if (anObj == null) break block13;
                    var8_10 = anObj;
                    var10_11 = null;
                    if (anEJB == null) return var8_10;
                }
                catch (RemoteException e) {
                    Parameter.logger.warn((Object)"Communication failure", (Throwable)e);
                    var10_13 = null;
                    if (anEJB == null) return null;
                    try {
                        anEJB.remove();
                        return null;
                    }
                    catch (Exception var11_18) {
                        return null;
                    }
                }
                catch (SQLException e) {
                    Parameter.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var10_14 = null;
                    if (anEJB == null) return null;
                    try {}
                    catch (Exception var11_19) {
                        return null;
                    }
                    anEJB.remove();
                    return null;
                }
            }
            catch (Throwable var9_21) {
                var10_15 = null;
                if (anEJB == null) throw var9_21;
                ** try [egrp 2[TRYBLOCK] [3 : 179->188)] { 
lbl45:
                // 1 sources

                anEJB.remove();
                throw var9_21;
lbl47:
                // 1 sources

                catch (Exception var11_20) {
                    // empty catch block
                }
                throw var9_21;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 179->188)] { 
lbl52:
            // 1 sources

            anEJB.remove();
            return var8_10;
lbl54:
            // 1 sources

            catch (Exception var11_16) {
                // empty catch block
            }
            return var8_10;
        }
        var10_12 = null;
        if (anEJB == null) return null;
        try {}
        catch (Exception var11_17) {}
        anEJB.remove();
        return null;
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static miningmart.m4.Parameter getByMultiColumnFeatureAndStepNameAndName(int id, String stepName, String name) {
        block13: {
            anEJB = null;
            try {
                try {
                    anEJB = Parameter.getEJB();
                    step = Step.getByCaseAndName(Parameter.getCurrentCase().getId(), stepName);
                    stepId = ((Step)step).getId();
                    anId = anEJB.getIdByMultiColumnFeatureAndStepAndName(id, stepId, name);
                    if (anId == null) break block13;
                    anObj = (Parameter)Parameter.cache.get(anId);
                    if (anObj == null && (val = anEJB.find(anId)) != null) {
                        anObj = new Parameter(val);
                        Parameter.cache.put(anId, anObj);
                    }
                    if (anObj == null) break block13;
                    var8_10 = anObj;
                    var10_11 = null;
                    if (anEJB == null) return var8_10;
                }
                catch (RemoteException e) {
                    Parameter.logger.warn((Object)"Communication failure", (Throwable)e);
                    var10_13 = null;
                    if (anEJB == null) return null;
                    try {
                        anEJB.remove();
                        return null;
                    }
                    catch (Exception var11_18) {
                        return null;
                    }
                }
                catch (SQLException e) {
                    Parameter.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var10_14 = null;
                    if (anEJB == null) return null;
                    try {}
                    catch (Exception var11_19) {
                        return null;
                    }
                    anEJB.remove();
                    return null;
                }
            }
            catch (Throwable var9_21) {
                var10_15 = null;
                if (anEJB == null) throw var9_21;
                ** try [egrp 2[TRYBLOCK] [3 : 180->189)] { 
lbl45:
                // 1 sources

                anEJB.remove();
                throw var9_21;
lbl47:
                // 1 sources

                catch (Exception var11_20) {
                    // empty catch block
                }
                throw var9_21;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 180->189)] { 
lbl52:
            // 1 sources

            anEJB.remove();
            return var8_10;
lbl54:
            // 1 sources

            catch (Exception var11_16) {
                // empty catch block
            }
            return var8_10;
        }
        var10_12 = null;
        if (anEJB == null) return null;
        try {}
        catch (Exception var11_17) {}
        anEJB.remove();
        return null;
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static miningmart.m4.Parameter getByBaseAttributeAndStepNameAndName(int id, String stepName, String name) {
        block13: {
            anEJB = null;
            try {
                try {
                    anEJB = Parameter.getEJB();
                    step = Step.getByCaseAndName(Parameter.getCurrentCase().getId(), stepName);
                    stepId = ((Step)step).getId();
                    anId = anEJB.getIdByBaseAttributeAndStepAndName(id, stepId, name);
                    if (anId == null) break block13;
                    anObj = (Parameter)Parameter.cache.get(anId);
                    if (anObj == null && (val = anEJB.find(anId)) != null) {
                        anObj = new Parameter(val);
                        Parameter.cache.put(anId, anObj);
                    }
                    if (anObj == null) break block13;
                    var8_10 = anObj;
                    var10_11 = null;
                    if (anEJB == null) return var8_10;
                }
                catch (RemoteException e) {
                    Parameter.logger.warn((Object)"Communication failure", (Throwable)e);
                    var10_13 = null;
                    if (anEJB == null) return null;
                    try {
                        anEJB.remove();
                        return null;
                    }
                    catch (Exception var11_18) {
                        return null;
                    }
                }
                catch (SQLException e) {
                    Parameter.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var10_14 = null;
                    if (anEJB == null) return null;
                    try {}
                    catch (Exception var11_19) {
                        return null;
                    }
                    anEJB.remove();
                    return null;
                }
            }
            catch (Throwable var9_21) {
                var10_15 = null;
                if (anEJB == null) throw var9_21;
                ** try [egrp 2[TRYBLOCK] [3 : 180->189)] { 
lbl45:
                // 1 sources

                anEJB.remove();
                throw var9_21;
lbl47:
                // 1 sources

                catch (Exception var11_20) {
                    // empty catch block
                }
                throw var9_21;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 180->189)] { 
lbl52:
            // 1 sources

            anEJB.remove();
            return var8_10;
lbl54:
            // 1 sources

            catch (Exception var11_16) {
                // empty catch block
            }
            return var8_10;
        }
        var10_12 = null;
        if (anEJB == null) return null;
        try {}
        catch (Exception var11_17) {}
        anEJB.remove();
        return null;
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static miningmart.m4.Parameter getByConceptAndStepNameAndName(int id, String stepName, String name) {
        block13: {
            anEJB = null;
            try {
                try {
                    anEJB = Parameter.getEJB();
                    step = Step.getByCaseAndName(Parameter.getCurrentCase().getId(), stepName);
                    stepId = ((Step)step).getId();
                    anId = anEJB.getIdByConceptAndStepAndName(id, stepId, name);
                    if (anId == null) break block13;
                    anObj = (Parameter)Parameter.cache.get(anId);
                    if (anObj == null && (val = anEJB.find(anId)) != null) {
                        anObj = new Parameter(val);
                        Parameter.cache.put(anId, anObj);
                    }
                    if (anObj == null) break block13;
                    var8_10 = anObj;
                    var10_11 = null;
                    if (anEJB == null) return var8_10;
                }
                catch (RemoteException e) {
                    Parameter.logger.warn((Object)"Communication failure", (Throwable)e);
                    var10_13 = null;
                    if (anEJB == null) return null;
                    try {
                        anEJB.remove();
                        return null;
                    }
                    catch (Exception var11_18) {
                        return null;
                    }
                }
                catch (SQLException e) {
                    Parameter.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var10_14 = null;
                    if (anEJB == null) return null;
                    try {}
                    catch (Exception var11_19) {
                        return null;
                    }
                    anEJB.remove();
                    return null;
                }
            }
            catch (Throwable var9_21) {
                var10_15 = null;
                if (anEJB == null) throw var9_21;
                ** try [egrp 2[TRYBLOCK] [3 : 180->189)] { 
lbl45:
                // 1 sources

                anEJB.remove();
                throw var9_21;
lbl47:
                // 1 sources

                catch (Exception var11_20) {
                    // empty catch block
                }
                throw var9_21;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 180->189)] { 
lbl52:
            // 1 sources

            anEJB.remove();
            return var8_10;
lbl54:
            // 1 sources

            catch (Exception var11_16) {
                // empty catch block
            }
            return var8_10;
        }
        var10_12 = null;
        if (anEJB == null) return null;
        try {}
        catch (Exception var11_17) {}
        anEJB.remove();
        return null;
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static miningmart.m4.Parameter getByRelationshipAndStepNameAndName(int id, String stepName, String name) {
        block13: {
            anEJB = null;
            try {
                try {
                    anEJB = Parameter.getEJB();
                    step = Step.getByCaseAndName(Parameter.getCurrentCase().getId(), stepName);
                    stepId = ((Step)step).getId();
                    anId = anEJB.getIdByRelationshipAndStepAndName(id, stepId, name);
                    if (anId == null) break block13;
                    anObj = (Parameter)Parameter.cache.get(anId);
                    if (anObj == null && (val = anEJB.find(anId)) != null) {
                        anObj = new Parameter(val);
                        Parameter.cache.put(anId, anObj);
                    }
                    if (anObj == null) break block13;
                    var8_10 = anObj;
                    var10_11 = null;
                    if (anEJB == null) return var8_10;
                }
                catch (RemoteException e) {
                    Parameter.logger.warn((Object)"Communication failure", (Throwable)e);
                    var10_13 = null;
                    if (anEJB == null) return null;
                    try {
                        anEJB.remove();
                        return null;
                    }
                    catch (Exception var11_18) {
                        return null;
                    }
                }
                catch (SQLException e) {
                    Parameter.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var10_14 = null;
                    if (anEJB == null) return null;
                    try {}
                    catch (Exception var11_19) {
                        return null;
                    }
                    anEJB.remove();
                    return null;
                }
            }
            catch (Throwable var9_21) {
                var10_15 = null;
                if (anEJB == null) throw var9_21;
                ** try [egrp 2[TRYBLOCK] [3 : 180->189)] { 
lbl45:
                // 1 sources

                anEJB.remove();
                throw var9_21;
lbl47:
                // 1 sources

                catch (Exception var11_20) {
                    // empty catch block
                }
                throw var9_21;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 180->189)] { 
lbl52:
            // 1 sources

            anEJB.remove();
            return var8_10;
lbl54:
            // 1 sources

            catch (Exception var11_16) {
                // empty catch block
            }
            return var8_10;
        }
        var10_12 = null;
        if (anEJB == null) return null;
        try {}
        catch (Exception var11_17) {}
        anEJB.remove();
        return null;
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection getByMultiColumnFeature(int id) {
        ArrayList<Parameter> aList = new ArrayList<Parameter>();
        Parameters anEJB = null;
        anEJB = Parameter.getEJB();
        Iterator it = anEJB.getIdByMultiColumnFeatureAndCase(id, Parameter.getCurrentCase().getId()).iterator();
        while (it.hasNext()) {
            ParameterV val;
            Integer anId = (Integer)it.next();
            Parameter anObj = (Parameter)cache.get(anId);
            if (anObj == null && (val = anEJB.find(anId)) != null) {
                anObj = new Parameter(val);
                cache.put(anId, anObj);
            }
            if (anObj == null) continue;
            aList.add(anObj);
        }
        Object var8_9 = null;
        if (anEJB == null) return aList;
        try {
            anEJB.remove();
            return aList;
        }
        catch (Exception exception) {}
        return aList;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var8_10 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var8_11 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection getByBaseAttribute(int id) {
        ArrayList<Parameter> aList = new ArrayList<Parameter>();
        Parameters anEJB = null;
        anEJB = Parameter.getEJB();
        Iterator it = anEJB.getIdByBaseAttributeAndCase(id, Parameter.getCurrentCase().getId()).iterator();
        while (it.hasNext()) {
            ParameterV val;
            Integer anId = (Integer)it.next();
            Parameter anObj = (Parameter)cache.get(anId);
            if (anObj == null && (val = anEJB.find(anId)) != null) {
                anObj = new Parameter(val);
                cache.put(anId, anObj);
            }
            if (anObj == null) continue;
            aList.add(anObj);
        }
        Object var8_9 = null;
        if (anEJB == null) return aList;
        try {
            anEJB.remove();
            return aList;
        }
        catch (Exception exception) {}
        return aList;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var8_10 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var8_11 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection getByRelationship(int id) {
        ArrayList<Parameter> aList = new ArrayList<Parameter>();
        Parameters anEJB = null;
        anEJB = Parameter.getEJB();
        Iterator it = anEJB.getIdByRelationshipAndCase(id, Parameter.getCurrentCase().getId()).iterator();
        while (it.hasNext()) {
            ParameterV val;
            Integer anId = (Integer)it.next();
            Parameter anObj = (Parameter)cache.get(anId);
            if (anObj == null && (val = anEJB.find(anId)) != null) {
                anObj = new Parameter(val);
                cache.put(anId, anObj);
            }
            if (anObj == null) continue;
            aList.add(anObj);
        }
        Object var8_9 = null;
        if (anEJB == null) return aList;
        try {
            anEJB.remove();
            return aList;
        }
        catch (Exception exception) {}
        return aList;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var8_10 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var8_11 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection getByConcept(int id) {
        ArrayList<Parameter> aList = new ArrayList<Parameter>();
        Parameters anEJB = null;
        anEJB = Parameter.getEJB();
        Iterator it = anEJB.getIdByConceptAndCase(id, Parameter.getCurrentCase().getId()).iterator();
        while (it.hasNext()) {
            ParameterV val;
            Integer anId = (Integer)it.next();
            Parameter anObj = (Parameter)cache.get(anId);
            if (anObj == null && (val = anEJB.find(anId)) != null) {
                anObj = new Parameter(val);
                cache.put(anId, anObj);
            }
            if (anObj == null) continue;
            aList.add(anObj);
        }
        Object var8_9 = null;
        if (anEJB == null) return aList;
        try {
            anEJB.remove();
            return aList;
        }
        catch (Exception exception) {}
        return aList;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var8_10 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var8_11 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection getByMultiColumnFeatureAndTypeName(int id, String typeName) {
        ArrayList<Parameter> aList = new ArrayList<Parameter>();
        Parameters anEJB = null;
        anEJB = Parameter.getEJB();
        Iterator it = null;
        it = typeName.equalsIgnoreCase(INPUT) ? anEJB.getInputIdByMultiColumnFeatureAndCase(id, Parameter.getCurrentCase().getId()).iterator() : (typeName.equalsIgnoreCase(OUTPUT) ? anEJB.getOutputIdByMultiColumnFeatureAndCase(id, Parameter.getCurrentCase().getId()).iterator() : anEJB.getIdByMultiColumnFeatureAndCase(id, Parameter.getCurrentCase().getId()).iterator());
        while (it.hasNext()) {
            ParameterV val;
            Integer anId = (Integer)it.next();
            Parameter anObj = (Parameter)cache.get(anId);
            if (anObj == null && (val = anEJB.find(anId)) != null) {
                anObj = new Parameter(val);
                cache.put(anId, anObj);
            }
            if (anObj == null) continue;
            aList.add(anObj);
        }
        Object var9_10 = null;
        if (anEJB == null) return aList;
        try {
            anEJB.remove();
            return aList;
        }
        catch (Exception exception) {}
        return aList;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var9_11 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var9_12 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection getByBaseAttributeAndTypeName(int id, String typeName) {
        ArrayList<Parameter> aList = new ArrayList<Parameter>();
        Parameters anEJB = null;
        anEJB = Parameter.getEJB();
        Iterator it = null;
        it = typeName.equalsIgnoreCase(INPUT) ? anEJB.getInputIdByBaseAttributeAndCase(id, Parameter.getCurrentCase().getId()).iterator() : (typeName.equalsIgnoreCase(OUTPUT) ? anEJB.getOutputIdByBaseAttributeAndCase(id, Parameter.getCurrentCase().getId()).iterator() : anEJB.getIdByBaseAttributeAndCase(id, Parameter.getCurrentCase().getId()).iterator());
        while (it.hasNext()) {
            ParameterV val;
            Integer anId = (Integer)it.next();
            Parameter anObj = (Parameter)cache.get(anId);
            if (anObj == null && (val = anEJB.find(anId)) != null) {
                anObj = new Parameter(val);
                cache.put(anId, anObj);
            }
            if (anObj == null) continue;
            aList.add(anObj);
        }
        Object var9_10 = null;
        if (anEJB == null) return aList;
        try {
            anEJB.remove();
            return aList;
        }
        catch (Exception exception) {}
        return aList;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var9_11 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var9_12 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection getByConceptAndTypeName(int id, String typeName) {
        ArrayList<Parameter> aList = new ArrayList<Parameter>();
        Parameters anEJB = null;
        anEJB = Parameter.getEJB();
        Iterator it = null;
        it = typeName.equalsIgnoreCase(INPUT) ? anEJB.getInputIdByConceptAndCase(id, Parameter.getCurrentCase().getId()).iterator() : (typeName.equalsIgnoreCase(OUTPUT) ? anEJB.getOutputIdByConceptAndCase(id, Parameter.getCurrentCase().getId()).iterator() : anEJB.getIdByConceptAndCase(id, Parameter.getCurrentCase().getId()).iterator());
        while (it.hasNext()) {
            ParameterV val;
            Integer anId = (Integer)it.next();
            Parameter anObj = (Parameter)cache.get(anId);
            if (anObj == null && (val = anEJB.find(anId)) != null) {
                anObj = new Parameter(val);
                cache.put(anId, anObj);
            }
            if (anObj == null) continue;
            aList.add(anObj);
        }
        Object var9_10 = null;
        if (anEJB == null) return aList;
        try {
            anEJB.remove();
            return aList;
        }
        catch (Exception exception) {}
        return aList;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var9_11 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var9_12 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void setDocumentation(String text) {
        this.removeAllDocumentation();
        if (text == null || text.equalsIgnoreCase("")) {
            return;
        }
        DocumentationV val = new DocumentationV();
        val.setText(text);
        val.setObjectId(this.getId());
        val.setObjectType("PAR");
        Documentation.createByValueObject(val);
    }

    public String getDocumentation() {
        return Documentation.getByIdAndType(this.getId(), "PAR");
    }

    public void removeAllDocumentation() {
        Documentation.deleteByIdAndType(this.getId(), "PAR");
    }

    private static Case getCurrentCase() {
        return (Case)M4Interface.getCurrentCase();
    }

    protected static void clearCache() {
        cache.clear();
    }
}

