/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.m4;

import com.syllogic.miningmart.m4.Assertion;
import com.syllogic.miningmart.m4.Condition;
import com.syllogic.miningmart.m4.Constraint;
import com.syllogic.miningmart.m4.Documentation;
import com.syllogic.miningmart.m4.M4Object;
import com.syllogic.miningmart.m4.OperatorParameter;
import com.syllogic.miningmart.m4.ejb.Operators;
import com.syllogic.miningmart.m4.ejb.OperatorsHome;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import miningmart.m4.NameExistsException;
import miningmart.m4.StorageException;
import miningmart.m4.value.DocumentationV;
import miningmart.m4.value.OperatorV;
import org.apache.log4j.Logger;

public class Operator
extends M4Object
implements miningmart.m4.Operator,
Serializable {
    private OperatorV value;
    private static Map cache = new HashMap();
    private static OperatorsHome home = null;
    private static Logger logger = Logger.getLogger((String)"com.syllogic.miningmart.m4.Operator");

    public Operator() {
        this.value = new OperatorV();
        this.setExisting(false);
        this.setChanged(true);
    }

    public Operator(OperatorV value) {
        this.value = value;
        this.setExisting(true);
        this.setChanged(false);
    }

    public int getId() {
        return this.value.getId();
    }

    public String getName() {
        return this.value.getName();
    }

    public void setName(String name) throws NameExistsException {
        if (Operator.getByName(name) != null) {
            throw new NameExistsException("Duplicate name");
        }
        this.value.setName(name);
        this.setChanged(true);
    }

    public boolean isLoopable() {
        return this.value.isLoopable();
    }

    public void setLoopable(boolean loopable) {
        this.value.setLoopable(loopable);
        this.setChanged(true);
    }

    public boolean isMultiStepable() {
        return this.value.isMultiStepable();
    }

    public void setMultiStepable(boolean multiStepable) {
        this.value.setMultiStepable(multiStepable);
        this.setChanged(true);
    }

    public boolean isManual() {
        return this.value.isManual();
    }

    public void setManual(boolean manual) {
        this.value.setManual(manual);
        this.setChanged(true);
    }

    public String getRealizes() {
        return this.value.getRealizes();
    }

    public void setRealizes(String realizes) {
        this.value.setRealizes(realizes);
        this.setChanged(true);
    }

    public miningmart.m4.Assertion createAssertion(String type, String object1, String object2, String text) throws miningmart.m4.CreateException {
        if (type == null || object1 == null) {
            throw new miningmart.m4.CreateException("Assertion type and object should be included");
        }
        Assertion rec = new Assertion();
        rec.setAssertionType(type);
        rec.setObject1(object1);
        rec.setObject2(object2);
        rec.setShortDescription(text);
        try {
            rec.setOperator(this);
        }
        catch (StorageException e) {
            logger.warn((Object)"Could not connect assertion to operator.", (Throwable)e);
            throw new miningmart.m4.CreateException("A storage exception occurred.");
        }
        return rec;
    }

    public Collection getAssertionsByType(String type) {
        return Assertion.getByOperatorAndType(this.getId(), type);
    }

    public Collection getAllAssertions() {
        return Assertion.getByOperator(this.getId());
    }

    public void removeAssertionsByType(String type) throws StorageException {
        Iterator it = this.getAssertionsByType(type).iterator();
        while (it.hasNext()) {
            ((Assertion)it.next()).delete();
        }
    }

    public void removeAllAssertions() throws StorageException {
        Iterator it = this.getAllAssertions().iterator();
        while (it.hasNext()) {
            ((Assertion)it.next()).delete();
        }
    }

    public miningmart.m4.Condition createCondition(String type, String object1, String object2, String text) throws miningmart.m4.CreateException {
        if (type == null || object1 == null) {
            throw new miningmart.m4.CreateException("Condition type and object should be included");
        }
        Condition rec = new Condition();
        rec.setConditionType(type);
        rec.setObject1(object1);
        rec.setObject2(object2);
        rec.setShortDescription(text);
        try {
            rec.setOperator(this);
        }
        catch (StorageException e) {
            logger.warn((Object)"Could not connect assertion to operator.", (Throwable)e);
            throw new miningmart.m4.CreateException("A storage exception occurred.");
        }
        return rec;
    }

    public Collection getConditionsByType(String type) {
        return Condition.getByOperatorAndType(this.getId(), type);
    }

    public Collection getAllConditions() {
        return Condition.getByOperator(this.getId());
    }

    public void removeConditionsByType(String type) throws StorageException {
        Iterator it = this.getConditionsByType(type).iterator();
        while (it.hasNext()) {
            ((Condition)it.next()).delete();
        }
    }

    public void removeAllConditions() throws StorageException {
        Iterator it = this.getAllConditions().iterator();
        while (it.hasNext()) {
            ((Condition)it.next()).delete();
        }
    }

    public miningmart.m4.Constraint createConstraint(String type, String object1, String object2, String text) throws miningmart.m4.CreateException {
        if (type == null || object1 == null) {
            throw new miningmart.m4.CreateException("Constraint type and object should be included");
        }
        Constraint rec = new Constraint();
        rec.setConstraintType(type);
        rec.setObject1(object1);
        rec.setObject2(object2);
        rec.setShortDescription(text);
        try {
            rec.setOperator(this);
        }
        catch (StorageException e) {
            logger.warn((Object)"Could not connect assertion to operator.", (Throwable)e);
            throw new miningmart.m4.CreateException("A storage exception occurred.");
        }
        return rec;
    }

    public Collection getConstraintsByType(String type) {
        return Constraint.getByOperatorAndType(this.getId(), type);
    }

    public Collection getAllConstraints() {
        return Constraint.getByOperator(this.getId());
    }

    public void removeConstraintsByType(String type) throws StorageException {
        Iterator it = this.getConstraintsByType(type).iterator();
        while (it.hasNext()) {
            ((Constraint)it.next()).delete();
        }
    }

    public void removeAllConstraints() throws StorageException {
        Iterator it = this.getAllConstraints().iterator();
        while (it.hasNext()) {
            ((Constraint)it.next()).delete();
        }
    }

    public miningmart.m4.OperatorParameter createOperatorParameter(String name, int minNrOfArgs, int maxNrOfArgs, String ioType, String parameterType, String text) throws NameExistsException, miningmart.m4.CreateException {
        if (name == null || ioType == null || parameterType == null) {
            throw new miningmart.m4.CreateException("OperatorParameter name, ioType and parameterType should be included");
        }
        if (OperatorParameter.getByOperatorAndName(this.getId(), name) != null) {
            throw new NameExistsException("Duplicate name");
        }
        OperatorParameter rec = new OperatorParameter();
        try {
            rec.setOperator(this);
            rec.setName(name);
            rec.setMinNrOfArgs(minNrOfArgs);
            rec.setMaxNrOfArgs(maxNrOfArgs);
            rec.setIoType(ioType);
            rec.setParameterType(parameterType);
            rec.setShortDescription(text);
        }
        catch (StorageException e) {
            logger.warn((Object)"Could not connect assertion to operator.", (Throwable)e);
            throw new miningmart.m4.CreateException("A storage exception occurred.");
        }
        return rec;
    }

    public miningmart.m4.OperatorParameter getOperatorParameter(String name) {
        return OperatorParameter.getByOperatorAndName(this.getId(), name);
    }

    public Collection getOperatorParametersByType(String type) {
        return OperatorParameter.getByOperatorAndType(this.getId(), type);
    }

    public Collection getAllOperatorParameters() {
        return OperatorParameter.getByOperator(this.getId(), "Both");
    }

    public Collection getAllInputOperatorParameters() {
        return OperatorParameter.getByOperator(this.getId(), "Input");
    }

    public Collection getAllOutputOperatorParameters() {
        return OperatorParameter.getByOperator(this.getId(), "Output");
    }

    public void removeOperatorParameter(String name) throws StorageException {
        this.getOperatorParameter(name).delete();
    }

    public void removeOperatorParameterByType(String type) throws StorageException {
        Iterator it = this.getOperatorParametersByType(type).iterator();
        while (it.hasNext()) {
            ((OperatorParameter)it.next()).delete();
        }
    }

    public void removeAllOperatorParameters() throws StorageException {
        Iterator it = this.getAllOperatorParameters().iterator();
        while (it.hasNext()) {
            ((OperatorParameter)it.next()).delete();
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Operator getById(int id) {
        Operators anEJB;
        Operator aOperator;
        block10: {
            Integer idObject = new Integer(id);
            aOperator = (Operator)cache.get(idObject);
            if (aOperator != null) return aOperator;
            anEJB = null;
            anEJB = Operator.getEJB();
            OperatorV val = anEJB.find(id);
            if (val == null) break block10;
            aOperator = new Operator(val);
            cache.put(idObject, aOperator);
        }
        Object var6_7 = null;
        if (anEJB == null) return aOperator;
        try {
            anEJB.remove();
            return aOperator;
        }
        catch (Exception exception) {}
        return aOperator;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var6_8 = null;
                if (anEJB == null) return aOperator;
                try {
                    anEJB.remove();
                    return aOperator;
                }
                catch (Exception exception) {}
                return aOperator;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var6_9 = null;
                if (anEJB == null) return aOperator;
                try {
                    anEJB.remove();
                    return aOperator;
                }
                catch (Exception exception) {}
                return aOperator;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static Operators getEJB() {
        try {
            Object initial;
            if (home == null) {
                initial = new InitialContext();
                home = (OperatorsHome)PortableRemoteObject.narrow((Object)initial.lookup("Operators"), Class.forName("com.syllogic.miningmart.m4.ejb.OperatorsHome"));
            }
            initial = home.create();
            return initial;
        }
        catch (ClassCastException e) {
            logger.warn((Object)"Got the wrong EJB?:", (Throwable)e);
        }
        catch (CreateException e) {
            logger.warn((Object)"Failed to create EJB reference:", (Throwable)e);
        }
        catch (NamingException e) {
            logger.warn((Object)"Failed to resolve JNDI name in initial context:", (Throwable)e);
        }
        catch (RemoteException e) {
            logger.warn((Object)"Communication failure", (Throwable)e);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delete() throws StorageException {
        if (!this.isExisting()) {
            return;
        }
        Operators anEJB = null;
        anEJB = Operator.getEJB();
        anEJB.delete(this.value.getId());
        this.setExisting(false);
        cache.remove(this);
        Object var4_2 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var4_3 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var4_4 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void store() throws StorageException {
        if (!this.isChanged()) {
            return;
        }
        Operators anEJB = null;
        anEJB = Operator.getEJB();
        if (this.isExisting()) {
            anEJB.update(this.value);
        } else {
            this.value.setId(anEJB.create(this.value));
            cache.put(new Integer(this.value.getId()), this);
        }
        this.setChanged(false);
        this.setExisting(true);
        Object var4_2 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var4_3 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var4_4 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection getAllNames() {
        block12: {
            aMap = null;
            anEJB = null;
            try {
                try {
                    anEJB = Operator.getEJB();
                    aMap = anEJB.getNameIdMap();
                    if (aMap != null) break block12;
                    var2_2 = null;
                    var4_5 = null;
                    if (anEJB == null) return var2_2;
                }
                catch (RemoteException e) {
                    Operator.logger.warn((Object)"Communication failure", (Throwable)e);
                    var4_7 = null;
                    if (anEJB == null) return aMap.keySet();
                    try {
                        anEJB.remove();
                        return aMap.keySet();
                    }
                    catch (Exception var5_12) {
                        return aMap.keySet();
                    }
                }
                catch (SQLException e) {
                    Operator.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var4_8 = null;
                    if (anEJB == null) return aMap.keySet();
                    try {}
                    catch (Exception var5_13) {
                        return aMap.keySet();
                    }
                    anEJB.remove();
                    return aMap.keySet();
                }
            }
            catch (Throwable var3_15) {
                var4_9 = null;
                if (anEJB == null) throw var3_15;
                ** try [egrp 2[TRYBLOCK] [3 : 78->87)] { 
lbl38:
                // 1 sources

                anEJB.remove();
                throw var3_15;
lbl40:
                // 1 sources

                catch (Exception var5_14) {
                    // empty catch block
                }
                throw var3_15;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 78->87)] { 
lbl45:
            // 1 sources

            anEJB.remove();
            return var2_2;
lbl47:
            // 1 sources

            catch (Exception var5_10) {
                // empty catch block
            }
            return var2_2;
        }
        var4_6 = null;
        if (anEJB == null) return aMap.keySet();
        try {}
        catch (Exception var5_11) {}
        anEJB.remove();
        return aMap.keySet();
        return aMap.keySet();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Operator getByName(String name) {
        block13: {
            anEJB = null;
            try {
                try {
                    anEJB = Operator.getEJB();
                    anId = anEJB.getIdByName(name);
                    if (anId == null) break block13;
                    anObj = (Operator)Operator.cache.get(anId);
                    if (anObj == null && (val = anEJB.find((int)anId)) != null) {
                        anObj = new Operator(val);
                        Operator.cache.put(anId, anObj);
                    }
                    if (anObj == null) break block13;
                    var4_6 = anObj;
                    var6_7 = null;
                    if (anEJB == null) return var4_6;
                }
                catch (RemoteException e) {
                    Operator.logger.warn((Object)"Communication failure", (Throwable)e);
                    var6_9 = null;
                    if (anEJB == null) return null;
                    try {
                        anEJB.remove();
                        return null;
                    }
                    catch (Exception var7_14) {
                        return null;
                    }
                }
                catch (SQLException e) {
                    Operator.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var6_10 = null;
                    if (anEJB == null) return null;
                    try {}
                    catch (Exception var7_15) {
                        return null;
                    }
                    anEJB.remove();
                    return null;
                }
            }
            catch (Throwable var5_17) {
                var6_11 = null;
                if (anEJB == null) throw var5_17;
                ** try [egrp 2[TRYBLOCK] [3 : 143->152)] { 
lbl43:
                // 1 sources

                anEJB.remove();
                throw var5_17;
lbl45:
                // 1 sources

                catch (Exception var7_16) {
                    // empty catch block
                }
                throw var5_17;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 143->152)] { 
lbl50:
            // 1 sources

            anEJB.remove();
            return var4_6;
lbl52:
            // 1 sources

            catch (Exception var7_12) {
                // empty catch block
            }
            return var4_6;
        }
        var6_8 = null;
        if (anEJB == null) return null;
        try {}
        catch (Exception var7_13) {}
        anEJB.remove();
        return null;
        return null;
    }

    public void setDocumentation(String text) {
        this.removeAllDocumentation();
        if (text == null || text.equalsIgnoreCase("")) {
            return;
        }
        DocumentationV val = new DocumentationV();
        val.setText(text);
        val.setObjectId(this.getId());
        val.setObjectType("OP");
        Documentation.createByValueObject(val);
    }

    public String getDocumentation() {
        return Documentation.getByIdAndType(this.getId(), "OP");
    }

    public void removeAllDocumentation() {
        Documentation.deleteByIdAndType(this.getId(), "OP");
    }

    protected static void clearCache() {
        cache.clear();
    }
}

