/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.m4;

import com.syllogic.miningmart.m4.Assertion;
import com.syllogic.miningmart.m4.BaseAttribute;
import com.syllogic.miningmart.m4.Case;
import com.syllogic.miningmart.m4.Chain;
import com.syllogic.miningmart.m4.Column;
import com.syllogic.miningmart.m4.ColumnBasicStatistics;
import com.syllogic.miningmart.m4.ColumnDistributionStatistics;
import com.syllogic.miningmart.m4.ColumnSet;
import com.syllogic.miningmart.m4.ColumnSetStatistics;
import com.syllogic.miningmart.m4.Concept;
import com.syllogic.miningmart.m4.Condition;
import com.syllogic.miningmart.m4.Constraint;
import com.syllogic.miningmart.m4.ForeignKey;
import com.syllogic.miningmart.m4.MultiColumnFeature;
import com.syllogic.miningmart.m4.Operator;
import com.syllogic.miningmart.m4.OperatorParameter;
import com.syllogic.miningmart.m4.Parameter;
import com.syllogic.miningmart.m4.PrimaryKey;
import com.syllogic.miningmart.m4.Relationship;
import com.syllogic.miningmart.m4.RoleRestriction;
import com.syllogic.miningmart.m4.Step;
import com.syllogic.miningmart.m4.Value;
import com.syllogic.miningmart.m4.ejb.M4InterfaceHome;
import java.awt.Point;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import miningmart.m4.M4Interface;
import miningmart.m4.NameExistsException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class M4Interface
extends miningmart.m4.M4Interface {
    private static Logger logger = Logger.getLogger((String)"M4Interface");
    private static M4InterfaceHome home = null;

    public Collection getAllCaseNames() {
        return Case.getAllNames();
    }

    public miningmart.m4.Operator findOperator(String name) {
        return Operator.getByName(name);
    }

    public Collection getAllOperatorNames() {
        return Operator.getAllNames();
    }

    public boolean isCaseLockedForReading(String name) {
        boolean caseLockedForReading = false;
        miningmart.m4.M4Interface m4Interface = M4Interface.getInstance();
        String user = System.getProperty("user.name");
        String qSQL = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("SELECT\t* FROM\t\tm4_access_t WHERE\tobject_id = '").concat(String.valueOf(name))).concat(String.valueOf("'"))).concat(String.valueOf("AND\t\tobject_type = 'CASE'"))).concat(String.valueOf("AND\t\t(\t\t(client_name = '"))).concat(String.valueOf(user))).concat(String.valueOf("' AND\taccess_type = 'READ')"))).concat(String.valueOf("\t\t\t\tOR\taccess_type = 'WRITE')"));
        try {
            List lockExist = m4Interface.executeSQLQC1(qSQL, 10);
            caseLockedForReading = lockExist != null;
        }
        catch (SQLException e) {
            logger.error((Object)"Exception while executing SQL ", (Throwable)e);
        }
        return caseLockedForReading;
    }

    private boolean lockCaseForReading(String name) {
        boolean lockedCaseForReading = false;
        miningmart.m4.M4Interface m4Interface = M4Interface.getInstance();
        String user = System.getProperty("user.name");
        String uSQL = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("INSERT INTO m4_access_t SELECT '").concat(String.valueOf(name))).concat(String.valueOf("', 'CASE', '"))).concat(String.valueOf(user))).concat(String.valueOf("', 'READ' "))).concat(String.valueOf("FROM\t\t(SELECT COUNT(*) FROM m4_access_t) "))).concat(String.valueOf("WHERE\t(SELECT COUNT(*) "))).concat(String.valueOf("FROM m4_access_t "))).concat(String.valueOf("WHERE object_id = '"))).concat(String.valueOf(name))).concat(String.valueOf("'"))).concat(String.valueOf("AND object_type = 'CASE' "))).concat(String.valueOf("AND\t\t(\t\t(client_name = '"))).concat(String.valueOf(user))).concat(String.valueOf("' AND\taccess_type = 'READ')"))).concat(String.valueOf("\t\t\t\tOR\taccess_type = 'WRITE')) = 0"));
        String qSQL = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("SELECT\t* FROM\t\tm4_access_t WHERE\tobject_id = '").concat(String.valueOf(name))).concat(String.valueOf("'"))).concat(String.valueOf("AND\t\tobject_type = 'CASE'"))).concat(String.valueOf("AND\t\tclient_name = '"))).concat(String.valueOf(user))).concat(String.valueOf("' "))).concat(String.valueOf("AND\t\taccess_type = 'READ'"));
        try {
            m4Interface.executeSQLU(uSQL);
            List writeLockNew = m4Interface.executeSQLQC1(qSQL, 10);
            if (writeLockNew != null) {
                lockedCaseForReading = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Exception while executing SQL ", (Throwable)e);
        }
        return lockedCaseForReading;
    }

    public miningmart.m4.Case findCaseForReadOnlyAccess(String name, boolean setAsCurrent) throws M4Interface.CaseLockedException {
        miningmart.m4.M4Interface m4Interface = M4Interface.getInstance();
        if (this.isCaseLockedForReading(name)) {
            throw new M4Interface.CaseLockedException(this);
        }
        Case aCase = null;
        if (this.lockCaseForReading(name)) {
            aCase = Case.getReadOnlyByName(name);
            if (logger.isDebugEnabled() && aCase != null) {
                logger.debug((Object)String.valueOf("Found a case: ").concat(String.valueOf(aCase.getName())));
            }
        } else {
            throw new M4Interface.CaseLockedException(this);
        }
        if (aCase != null && setAsCurrent) {
            miningmart.m4.M4Interface.setCurrentCase(aCase);
        }
        return aCase;
    }

    public boolean isCaseLockedForWriting(String name) {
        boolean caseLockedForWriting = false;
        miningmart.m4.M4Interface m4Interface = M4Interface.getInstance();
        String user = System.getProperty("user.name");
        String qSQL = String.valueOf(String.valueOf(String.valueOf("SELECT\t* FROM\t\tm4_access_t WHERE\tobject_id = '").concat(String.valueOf(name))).concat(String.valueOf("'"))).concat(String.valueOf("AND\t\tobject_type = 'CASE'"));
        try {
            List lockExist = m4Interface.executeSQLQC1(qSQL, 10);
            caseLockedForWriting = lockExist != null;
        }
        catch (SQLException e) {
            logger.error((Object)"Exception while executing SQL ", (Throwable)e);
        }
        return caseLockedForWriting;
    }

    private boolean lockCaseForWriting(String name) {
        boolean lockedCaseForWriting = false;
        miningmart.m4.M4Interface m4Interface = M4Interface.getInstance();
        String user = System.getProperty("user.name");
        String uSQL = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("INSERT INTO m4_access_t SELECT '").concat(String.valueOf(name))).concat(String.valueOf("', 'CASE', '"))).concat(String.valueOf(user))).concat(String.valueOf("', 'WRITE' "))).concat(String.valueOf("FROM\t\t(SELECT COUNT(*) FROM m4_access_t) "))).concat(String.valueOf("WHERE\t(SELECT COUNT(*) FROM m4_access_t WHERE object_id = '"))).concat(String.valueOf(name))).concat(String.valueOf("'"))).concat(String.valueOf("AND object_type = 'CASE') = 0"));
        String qSQL = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("SELECT\t* FROM\t\tm4_access_t WHERE\tobject_id = '").concat(String.valueOf(name))).concat(String.valueOf("'"))).concat(String.valueOf("AND\t\tobject_type = 'CASE'"))).concat(String.valueOf("AND\t\tclient_name = '"))).concat(String.valueOf(user))).concat(String.valueOf("' "))).concat(String.valueOf("AND\t\taccess_type = 'WRITE'"));
        try {
            m4Interface.executeSQLU(uSQL);
            List writeLockNew = m4Interface.executeSQLQC1(qSQL, 10);
            if (writeLockNew != null) {
                lockedCaseForWriting = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Exception while executing SQL ", (Throwable)e);
        }
        return lockedCaseForWriting;
    }

    public miningmart.m4.Case findCaseForUpdate(String name, boolean setAsCurrent) throws M4Interface.CaseLockedException {
        miningmart.m4.M4Interface m4Interface = M4Interface.getInstance();
        if (this.isCaseLockedForWriting(name)) {
            throw new M4Interface.CaseLockedException(this);
        }
        Case aCase = null;
        if (this.lockCaseForWriting(name)) {
            aCase = Case.getForUpdateByName(name);
            if (logger.isDebugEnabled() && aCase != null) {
                logger.debug((Object)String.valueOf("Found a case: ").concat(String.valueOf(aCase.getName())));
            }
        } else {
            throw new M4Interface.CaseLockedException(this);
        }
        if (aCase != null && setAsCurrent) {
            miningmart.m4.M4Interface.setCurrentCase(aCase);
        }
        return aCase;
    }

    public void releaseCase(String name) {
        miningmart.m4.M4Interface m4Interface = M4Interface.getInstance();
        String user = System.getProperty("user.name");
        String dSQL = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("DELETE FROM\t\tm4_access_t WHERE\tobject_id = '").concat(String.valueOf(name))).concat(String.valueOf("'"))).concat(String.valueOf("AND\t\tobject_type = 'CASE'"))).concat(String.valueOf("AND\t\tclient_name = '"))).concat(String.valueOf(user))).concat(String.valueOf("'"));
        try {
            m4Interface.executeSQLU(dSQL);
        }
        catch (SQLException e) {
            logger.error((Object)"Exception while executing SQL ", (Throwable)e);
        }
    }

    private static com.syllogic.miningmart.m4.ejb.M4Interface getEJB() {
        try {
            Object initial;
            if (home == null) {
                initial = new InitialContext();
                home = (M4InterfaceHome)PortableRemoteObject.narrow((Object)initial.lookup("M4Interface"), Class.forName("com.syllogic.miningmart.m4.ejb.M4InterfaceHome"));
            }
            initial = home.create();
            return initial;
        }
        catch (ClassCastException e) {
            logger.warn((Object)"Got the wrong EJB?:", (Throwable)e);
        }
        catch (CreateException e) {
            logger.warn((Object)"Failed to create EJB reference:", (Throwable)e);
        }
        catch (NamingException e) {
            logger.warn((Object)"Failed to resolve JNDI name in initial context:", (Throwable)e);
        }
        catch (RemoteException e) {
            logger.warn((Object)"Communication failure", (Throwable)e);
        }
        return null;
    }

    public List executeSQLQC1(String sqlString, int maxRows) throws SQLException {
        Map tableData = this.executeSQLQ(sqlString, maxRows);
        List columnNames = (List)tableData.get("mmColumnNames");
        String firstColumnName = columnNames.get(0).toString();
        List firstColumnData = (List)tableData.get(firstColumnName);
        return firstColumnData;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map executeSQLQ(String sqlString, int maxRows) throws SQLException {
        void var3_5;
        HashMap hashMap = new HashMap();
        com.syllogic.miningmart.m4.ejb.M4Interface anEJB = null;
        anEJB = M4Interface.getEJB();
        Map map = anEJB.executeSQLQ(sqlString, maxRows);
        Object var7_7 = null;
        if (anEJB == null) return var3_5;
        try {
            anEJB.remove();
            return var3_5;
        }
        catch (Exception exception) {}
        return var3_5;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var7_8 = null;
                if (anEJB == null) return var3_5;
                try {
                    anEJB.remove();
                    return var3_5;
                }
                catch (Exception exception) {}
                return var3_5;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeSQLU(String sqlString) throws SQLException {
        com.syllogic.miningmart.m4.ejb.M4Interface anEJB = null;
        anEJB = M4Interface.getEJB();
        anEJB.executeSQLU(sqlString);
        Object var5_3 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var5_4 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void setPoint(int objID, String objName, String objType, Integer contextID, String contextName, String contextType, Point point) {
        String setPointSQL = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("insert into hci_coord_t (obj_id, obj_name, obj_type, context_id, context_name, context_type, x, y) values (").concat(String.valueOf(objID))).concat(String.valueOf(",'"))).concat(String.valueOf(objName))).concat(String.valueOf("','"))).concat(String.valueOf(objType))).concat(String.valueOf("',"))).concat(String.valueOf(this.nullable(contextID)))).concat(String.valueOf(","))).concat(String.valueOf(this.nullable(contextName)))).concat(String.valueOf(","))).concat(String.valueOf(this.nullable(contextType)))).concat(String.valueOf(","))).concat(String.valueOf(point.getX()))).concat(String.valueOf(","))).concat(String.valueOf(point.getY()))).concat(String.valueOf(")"));
        try {
            this.executeSQLU(setPointSQL);
        }
        catch (SQLException e) {
            logger.error((Object)"Exception while executing SQL ", (Throwable)e);
        }
    }

    public Point getPoint(int objID, String objName, String objType, Integer contextID, String contextName, String contextType) {
        Point point = null;
        Map tableData = new HashMap();
        String getPointSQL = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("select\tx, y from\t\thci_coord_t where\tobj_id = ").concat(String.valueOf(objID))).concat(String.valueOf(" "))).concat(String.valueOf("and\t\tobj_name = '"))).concat(String.valueOf(objName))).concat(String.valueOf("' "))).concat(String.valueOf("and\t\tobj_type = '"))).concat(String.valueOf(objType))).concat(String.valueOf("' "))).concat(String.valueOf("and\t\tcontext_id "))).concat(String.valueOf(this.isNullable(contextID)))).concat(String.valueOf(" "))).concat(String.valueOf("and\t\tcontext_name "))).concat(String.valueOf(this.isNullable(contextName)))).concat(String.valueOf(" "))).concat(String.valueOf("and\t\tcontext_type "))).concat(String.valueOf(this.isNullable(contextType)));
        int maxRows = 1;
        try {
            tableData = this.executeSQLQ(getPointSQL, maxRows);
            List xValues = (List)tableData.get("X");
            List yValues = (List)tableData.get("Y");
            if (xValues != null) {
                point = new Point();
                double x = ((BigDecimal)xValues.get(0)).doubleValue();
                double y = ((BigDecimal)yValues.get(0)).doubleValue();
                point.setLocation(x, y);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Exception while executing SQL ", (Throwable)e);
        }
        return point;
    }

    public Map getPoints(Integer objID, String objName, String objType, Integer contextID, String contextName, String contextType) {
        Map tableData = new HashMap();
        String getPointsSQL = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("select\tobj_id ,\t\t\tobj_name ,\t\t\tobj_type ,    \tcontext_id ,\t\t\tcontext_name ,\t\t\tcontext_type ,\t\t\tx ,\t\t\ty from\t\thci_coord_t where\t1=1 ").concat(String.valueOf(this.isNullable("and\t\tobj_id", objID)))).concat(String.valueOf(this.isNullable("and\t\tobj_name", objName)))).concat(String.valueOf(this.isNullable("and\t\tobj_type", objType)))).concat(String.valueOf(this.isNullable("and\t\tcontext_id", contextID)))).concat(String.valueOf(this.isNullable("and\t\tcontext_name", contextName)))).concat(String.valueOf(this.isNullable("and\t\tcontext_type", contextType)));
        int maxRows = 1000;
        try {
            tableData = this.executeSQLQ(getPointsSQL, maxRows);
        }
        catch (SQLException e) {
            logger.error((Object)"Exception while executing SQL ", (Throwable)e);
        }
        return tableData;
    }

    public Point getPoint(Map points, int objIDP, String objNameP, String objTypeP, Integer contextIDP, String contextNameP, String contextTypeP) {
        Point point = null;
        List objIDs = (List)points.get("OBJ_ID");
        List objNames = (List)points.get("OBJ_NAME");
        List objTypes = (List)points.get("OBJ_TYPE");
        List contextIDs = (List)points.get("CONTEXT_ID");
        List contextNames = (List)points.get("CONTEXT_NAME");
        List contextTypes = (List)points.get("CONTEXT_TYPE");
        List xValues = (List)points.get("X");
        List yValues = (List)points.get("Y");
        if (objIDs != null) {
            Iterator it = objIDs.iterator();
            int index = 0;
            boolean found = false;
            while (it.hasNext() && !found) {
                int objID = ((BigDecimal)it.next()).intValue();
                String objName = (String)objNames.get(index);
                String objType = (String)objTypes.get(index);
                int contextID = ((BigDecimal)contextIDs.get(index)).intValue();
                String contextName = (String)contextNames.get(index);
                String contextType = (String)contextTypes.get(index);
                if (objID == objIDP && objName.equals(objNameP) && objType.equals(objTypeP) && contextID == contextIDP && contextName.equals(contextNameP) && contextType.equals(contextTypeP)) {
                    double x = ((BigDecimal)xValues.get(index)).doubleValue();
                    double y = ((BigDecimal)yValues.get(index)).doubleValue();
                    point = new Point();
                    point.setLocation(x, y);
                    found = true;
                }
                ++index;
            }
        }
        return point;
    }

    public void removePoint(int objID, String objName, String objType, Integer contextID, String contextName, String contextType) {
        String getPointSQL = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("delete from\t\thci_coord_t where\tobj_id = ").concat(String.valueOf(objID))).concat(String.valueOf(" "))).concat(String.valueOf("and\t\tobj_name = '"))).concat(String.valueOf(objName))).concat(String.valueOf("' "))).concat(String.valueOf("and\t\tobj_type = '"))).concat(String.valueOf(objType))).concat(String.valueOf("' "))).concat(String.valueOf("and\t\tcontext_id "))).concat(String.valueOf(this.isNullable(contextID)))).concat(String.valueOf(" "))).concat(String.valueOf("and\t\tcontext_name "))).concat(String.valueOf(this.isNullable(contextName)))).concat(String.valueOf(" "))).concat(String.valueOf("and\t\tcontext_type "))).concat(String.valueOf(this.isNullable(contextType)));
        try {
            this.executeSQLU(getPointSQL);
        }
        catch (SQLException e) {
            logger.error((Object)"Exception while executing SQL ", (Throwable)e);
        }
    }

    public void removeAllPoints(int objID, String objName, String objType) {
        String getPointSQL = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("delete from\t\thci_coord_t where\tobj_id = ").concat(String.valueOf(objID))).concat(String.valueOf(" "))).concat(String.valueOf("and\t\tobj_name = '"))).concat(String.valueOf(objName))).concat(String.valueOf("' "))).concat(String.valueOf("and\t\tobj_type = '"))).concat(String.valueOf(objType))).concat(String.valueOf("' "));
        try {
            this.executeSQLU(getPointSQL);
        }
        catch (SQLException e) {
            logger.error((Object)"Exception while executing SQL ", (Throwable)e);
        }
    }

    private String nullable(Object columnValue) {
        if (columnValue == null) {
            return "NULL";
        }
        return String.valueOf(String.valueOf("'").concat(String.valueOf(columnValue.toString()))).concat(String.valueOf("' "));
    }

    private String isNullable(Object columnValue) {
        if (columnValue == null) {
            return "IS NULL";
        }
        return String.valueOf(String.valueOf(" = '").concat(String.valueOf(columnValue.toString()))).concat(String.valueOf("' "));
    }

    private String isNullable(String columnClause, Object columnValue) {
        String str = "";
        if (columnValue != null) {
            str = String.valueOf(String.valueOf(String.valueOf(columnClause).concat(String.valueOf(" = '"))).concat(String.valueOf(columnValue.toString()))).concat(String.valueOf("' "));
        }
        return str;
    }

    public miningmart.m4.Case createCase(String name) throws NameExistsException, miningmart.m4.CreateException {
        logger.info((Object)"Starting to create a Case...");
        if (name == null) {
            throw new miningmart.m4.CreateException("Name for Case should be included");
        }
        if (Case.getByName(name) != null) {
            throw new NameExistsException("Duplicate name");
        }
        Case newCase = new Case();
        newCase.setName(name);
        newCase.setMode("DESIGN");
        miningmart.m4.M4Interface.setCurrentCase(newCase);
        return newCase;
    }

    public miningmart.m4.Operator createOperator(String name) throws NameExistsException, miningmart.m4.CreateException {
        if (name == null) {
            throw new miningmart.m4.CreateException("Name for Operator should be included");
        }
        if (Operator.getByName(name) != null) {
            throw new NameExistsException("Duplicate name");
        }
        Operator operator = new Operator();
        operator.setName(name);
        return operator;
    }

    public static void clearCache() {
        Assertion.clearCache();
        BaseAttribute.clearCache();
        Case.clearCache();
        Chain.clearCache();
        Column.clearCache();
        ColumnBasicStatistics.clearCache();
        ColumnDistributionStatistics.clearCache();
        ColumnSet.clearCache();
        ColumnSetStatistics.clearCache();
        Concept.clearCache();
        Condition.clearCache();
        Constraint.clearCache();
        ForeignKey.clearCache();
        MultiColumnFeature.clearCache();
        Operator.clearCache();
        OperatorParameter.clearCache();
        Parameter.clearCache();
        PrimaryKey.clearCache();
        Relationship.clearCache();
        RoleRestriction.clearCache();
        Step.clearCache();
        Value.clearCache();
    }

    static {
        PropertyConfigurator.configure((String)"log4j.properties");
    }
}

