/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.m4;

import com.syllogic.miningmart.m4.Documentation;
import com.syllogic.miningmart.m4.M4Object;
import com.syllogic.miningmart.m4.ejb.KeyHeads;
import com.syllogic.miningmart.m4.ejb.KeyHeadsHome;
import com.syllogic.miningmart.m4.ejb.KeyMembers;
import com.syllogic.miningmart.m4.ejb.KeyMembersHome;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import miningmart.m4.ColumnSet;
import miningmart.m4.NameExistsException;
import miningmart.m4.StorageException;
import miningmart.m4.value.DocumentationV;
import miningmart.m4.value.KeyHeadV;
import miningmart.m4.value.KeyMemberV;
import org.apache.log4j.Logger;

public abstract class Key
extends M4Object
implements miningmart.m4.Key {
    protected KeyHeadV value;
    protected List members = new ArrayList();
    protected Map memberMap = new HashMap();
    protected static KeyHeadsHome khHome = null;
    protected static KeyMembersHome kmHome = null;
    private static Logger logger = Logger.getLogger((String)"com.syllogic.miningmart.m4.Key");

    public abstract Collection getAllColumns();

    public abstract ColumnSet getColumnSet();

    public abstract void setColumnSet(ColumnSet var1) throws StorageException;

    public abstract void removeAllColumns();

    public abstract void removeColumn(String var1);

    public Key() {
        this.value = new KeyHeadV();
        this.setExisting(false);
        this.setChanged(true);
    }

    public Key(KeyHeadV value) {
        this.value = value;
        this.loadMembers();
        this.setExisting(true);
        this.setChanged(false);
    }

    public int getId() {
        return this.value.getId();
    }

    public abstract String getName();

    public abstract void setName(String var1) throws NameExistsException;

    protected abstract String getMemberName(KeyMemberV var1);

    protected KeyMemberV getMember(String columnName) {
        return (KeyMemberV)this.memberMap.get(columnName);
    }

    protected void addMember(KeyMemberV member) {
        this.members.add(member);
        this.memberMap.put(this.getMemberName(member), member);
        this.setChanged(true);
    }

    protected void removeMember(String columnName) {
        KeyMemberV member = this.getMember(columnName);
        if (member != null) {
            this.members.remove(member);
            this.setChanged(true);
        }
    }

    protected void removeMemberIterator(String columnName, Iterator it) {
        KeyMemberV member = this.getMember(columnName);
        if (member != null) {
            it.remove();
            this.setChanged(true);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadMembers() {
        KeyMembers anEJB = null;
        anEJB = Key.getKMEJB();
        this.members.clear();
        Iterator it = anEJB.findByKeyHead(this.value.getId()).iterator();
        while (it.hasNext()) {
            KeyMemberV member = (KeyMemberV)it.next();
            this.addMember(member);
        }
        Collections.sort(this.members, new Comparator(){

            public int compare(Object o1, Object o2) {
                KeyMemberV m1 = (KeyMemberV)o1;
                KeyMemberV m2 = (KeyMemberV)o2;
                return m2.getPosition() - m1.getPosition();
            }

            public boolean equals(Object o) {
                return o == this;
            }
        });
        Object var5_6 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var5_7 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var5_8 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected static KeyHeads getKHEJB() {
        try {
            Object initial;
            if (khHome == null) {
                initial = new InitialContext();
                khHome = (KeyHeadsHome)PortableRemoteObject.narrow((Object)initial.lookup("KeyHeads"), Class.forName("com.syllogic.miningmart.m4.ejb.KeyHeadsHome"));
            }
            initial = khHome.create();
            return initial;
        }
        catch (ClassCastException e) {
            logger.warn((Object)"Got the wrong EJB?:", (Throwable)e);
        }
        catch (CreateException e) {
            logger.warn((Object)"Failed to create EJB reference:", (Throwable)e);
        }
        catch (NamingException e) {
            logger.warn((Object)"Failed to resolve JNDI name in initial context:", (Throwable)e);
        }
        catch (RemoteException e) {
            logger.warn((Object)"Communication failure", (Throwable)e);
        }
        return null;
    }

    protected static KeyMembers getKMEJB() {
        try {
            Object initial;
            if (kmHome == null) {
                initial = new InitialContext();
                kmHome = (KeyMembersHome)PortableRemoteObject.narrow((Object)initial.lookup("KeyMembers"), Class.forName("com.syllogic.miningmart.m4.ejb.KeyMembersHome"));
            }
            initial = kmHome.create();
            return initial;
        }
        catch (ClassCastException e) {
            logger.warn((Object)"Got the wrong EJB?:", (Throwable)e);
        }
        catch (CreateException e) {
            logger.warn((Object)"Failed to create EJB reference:", (Throwable)e);
        }
        catch (NamingException e) {
            logger.warn((Object)"Failed to resolve JNDI name in initial context:", (Throwable)e);
        }
        catch (RemoteException e) {
            logger.warn((Object)"Communication failure", (Throwable)e);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delete() throws StorageException {
        if (!this.isExisting()) {
            return;
        }
        this.removeAllColumns();
        KeyHeads anEJB = null;
        anEJB = Key.getKHEJB();
        anEJB.delete(this.value.getId());
        this.setExisting(false);
        Object var4_2 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var4_3 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var4_4 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void store() throws StorageException {
        if (!this.isChanged()) {
            return;
        }
        KeyHeads anEJB = null;
        anEJB = khHome.create();
        if (this.isExisting()) {
            anEJB.update(this.value);
        } else {
            this.value.setId(anEJB.create(this.value));
        }
        this.setChanged(false);
        this.setExisting(true);
        Object var4_2 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (CreateException e) {
                logger.warn((Object)"Failed to create EJB", (Throwable)e);
                Object var4_3 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var4_4 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var4_5 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void setDocumentation(String text) {
        this.removeAllDocumentation();
        if (text == null || text.equalsIgnoreCase("")) {
            return;
        }
        DocumentationV val = new DocumentationV();
        val.setText(text);
        val.setObjectId(this.getId());
        val.setObjectType("KH");
        Documentation.createByValueObject(val);
    }

    public String getDocumentation() {
        return Documentation.getByIdAndType(this.getId(), "KH");
    }

    public void removeAllDocumentation() {
        Documentation.deleteByIdAndType(this.getId(), "KH");
    }
}

