/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.m4;

import com.syllogic.miningmart.m4.BaseAttribute;
import com.syllogic.miningmart.m4.Case;
import com.syllogic.miningmart.m4.ColumnSet;
import com.syllogic.miningmart.m4.Documentation;
import com.syllogic.miningmart.m4.M4Interface;
import com.syllogic.miningmart.m4.M4Object;
import com.syllogic.miningmart.m4.MultiColumnFeature;
import com.syllogic.miningmart.m4.Parameter;
import com.syllogic.miningmart.m4.Relationship;
import com.syllogic.miningmart.m4.RoleRestriction;
import com.syllogic.miningmart.m4.ejb.Concepts;
import com.syllogic.miningmart.m4.ejb.ConceptsHome;
import java.awt.Point;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import miningmart.m4.MultipleResultException;
import miningmart.m4.NameExistsException;
import miningmart.m4.StorageException;
import miningmart.m4.value.ConceptV;
import miningmart.m4.value.DocumentationV;
import org.apache.log4j.Logger;

public class Concept
extends M4Object
implements miningmart.m4.Concept,
Comparable,
Serializable {
    private boolean functionallyValid;
    private ConceptV value;
    private static ConceptsHome home = null;
    private static Map cache = new HashMap();
    private static Logger logger = Logger.getLogger((String)"com.syllogic.miningmart.m4.Concept");

    public Concept() {
        this.value = new ConceptV();
        this.setExisting(false);
        this.setChanged(true);
    }

    public Concept(ConceptV value) {
        this.value = value;
        this.setExisting(true);
        this.setChanged(false);
    }

    public int compareTo(Object concept) {
        String name = ((Concept)concept).getName();
        int cmp = this.getName().compareToIgnoreCase(name);
        return cmp;
    }

    public miningmart.m4.Case getCase() {
        if (this.value.getMmCaseName() == null) {
            return null;
        }
        return Case.getById(this.value.getMmCase());
    }

    public void setCase(miningmart.m4.Case rec) throws StorageException {
        Case anObj = (Case)rec;
        if (!anObj.isExisting()) {
            anObj.store();
        }
        this.value.setMmCase(anObj.getId());
        this.value.setMmCaseName(anObj.getName());
        this.setChanged(true);
    }

    public String getName() {
        return this.value.getName();
    }

    public void setName(String name) throws NameExistsException {
        if (Concept.getByCaseAndName(Concept.getCurrentCase().getId(), name) != null) {
            throw new NameExistsException("Duplicate name");
        }
        this.value.setName(name);
        this.setChanged(true);
    }

    public String getConceptType() {
        return this.value.getType();
    }

    public void setConceptType(String conceptType) {
        this.value.setType(conceptType);
        this.setChanged(true);
    }

    public String getSubConceptRestriction() {
        return this.value.getSubConceptRestriction();
    }

    public void setSubConceptRestriction(String subConceptRestriction) {
        this.value.setSubConceptRestriction(subConceptRestriction);
        this.setChanged(true);
    }

    public boolean isFunctionallyValid() {
        return this.functionallyValid;
    }

    public void setFunctionallyValid(boolean functionallyValid) {
        this.functionallyValid = functionallyValid;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRelationallyValid() {
        Concepts anEJB = null;
        boolean valid = false;
        anEJB = Concept.getEJB();
        valid = anEJB.getValidity(this.getId());
        Object var5_3 = null;
        if (anEJB == null) return valid;
        try {
            anEJB.remove();
            return valid;
        }
        catch (Exception exception) {}
        return valid;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var5_4 = null;
                if (anEJB == null) return valid;
                try {
                    anEJB.remove();
                    return valid;
                }
                catch (Exception exception) {}
                return valid;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var5_5 = null;
                if (anEJB == null) return valid;
                try {
                    anEJB.remove();
                    return valid;
                }
                catch (Exception exception) {}
                return valid;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public int getId() {
        return this.value.getId();
    }

    public miningmart.m4.BaseAttribute createBaseAttribute(String name, String datatype, String attributeType) throws NameExistsException, miningmart.m4.CreateException {
        if (name == null) {
            throw new miningmart.m4.CreateException("Name required for a BaseAttribute");
        }
        if (datatype == null) {
            throw new miningmart.m4.CreateException("Data type required for a BaseAttribute");
        }
        if (attributeType == null) {
            throw new miningmart.m4.CreateException("Attribute type required for a BaseAttribute");
        }
        if (BaseAttribute.getByConceptAndName(this.getId(), name) != null) {
            throw new NameExistsException("Duplicate name");
        }
        BaseAttribute rec = new BaseAttribute();
        rec.setName(name);
        rec.setDatatype(datatype);
        rec.setAttributeType(attributeType);
        try {
            this.addBaseAttribute(rec);
        }
        catch (StorageException e) {
            logger.warn((Object)"Could not connect baseatribute to concept.", (Throwable)e);
            throw new miningmart.m4.CreateException("A storage exception occurred.");
        }
        return rec;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addBaseAttribute(miningmart.m4.BaseAttribute rec) throws StorageException {
        BaseAttribute anObj = (BaseAttribute)rec;
        if (!anObj.isExisting()) {
            anObj.store();
        }
        Concepts anEJB = null;
        anEJB = Concept.getEJB();
        anEJB.addBaseAttribute(this.getId(), anObj.getId());
        Object var6_4 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var6_5 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var6_6 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public miningmart.m4.BaseAttribute getBaseAttribute(String name) {
        return BaseAttribute.getByConceptAndName(this.getId(), name);
    }

    public Collection getAllBaseAttributes() {
        return BaseAttribute.getByConcept(this.getId());
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeBaseAttribute(String name) {
        BaseAttribute anObj = (BaseAttribute)this.getBaseAttribute(name);
        Concepts anEJB = null;
        anEJB = Concept.getEJB();
        anEJB.removeBaseAttribute(this.getId(), anObj.getId());
        Object var6_4 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var6_5 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var6_6 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeAllBaseAttributes() {
        Concepts anEJB = null;
        anEJB = Concept.getEJB();
        Iterator it = this.getAllBaseAttributes().iterator();
        while (it.hasNext()) {
            anEJB.removeBaseAttribute(this.getId(), ((BaseAttribute)it.next()).getId());
        }
        Object var4_5 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var4_6 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var4_7 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public miningmart.m4.MultiColumnFeature createMultiColumnFeature(String name) throws NameExistsException, miningmart.m4.CreateException {
        if (name == null) {
            throw new miningmart.m4.CreateException("Name required");
        }
        if (MultiColumnFeature.getByConceptAndName(this.getId(), name) != null) {
            throw new NameExistsException("Duplicate name");
        }
        MultiColumnFeature rec = new MultiColumnFeature();
        try {
            this.addMultiColumnFeature(rec);
            rec.setName(name);
        }
        catch (StorageException e) {
            logger.warn((Object)"Could not connect multicolumnfeature to concept.", (Throwable)e);
            throw new miningmart.m4.CreateException("A storage exception occurred.");
        }
        return rec;
    }

    public void addMultiColumnFeature(miningmart.m4.MultiColumnFeature rec) throws StorageException {
        rec.setConcept(this);
    }

    public miningmart.m4.MultiColumnFeature getMultiColumnFeature(String name) {
        return MultiColumnFeature.getByConceptAndName(this.getId(), name);
    }

    public Collection getAllMultiColumnFeatures() {
        return MultiColumnFeature.getByConcept(this.getId());
    }

    public void removeMultiColumnFeature(String name) throws StorageException {
        ((MultiColumnFeature)this.getMultiColumnFeature(name)).delete();
    }

    public void removeAllMultiColumnFeatures() throws StorageException {
        Iterator it = this.getAllMultiColumnFeatures().iterator();
        while (it.hasNext()) {
            ((MultiColumnFeature)it.next()).delete();
        }
    }

    public miningmart.m4.Relationship createFromConceptRelationship(String name, miningmart.m4.Concept toConcept) throws NameExistsException, miningmart.m4.CreateException {
        if (name == null) {
            throw new miningmart.m4.CreateException("Name required");
        }
        if (toConcept != null) {
            int toConceptId = ((Concept)toConcept).getId();
            if (Relationship.getByFromConceptAndNameAndToConcept(this.getId(), name, toConceptId) != null) {
                throw new NameExistsException("Duplicate name");
            }
        }
        Relationship rec = new Relationship();
        try {
            rec.setFromConcept(this);
            if (toConcept != null) {
                rec.setToConcept(toConcept);
            }
            rec.setName(name);
        }
        catch (StorageException e) {
            logger.warn((Object)"Could not connect relationship to concept.", (Throwable)e);
            throw new miningmart.m4.CreateException("A storage exception occurred.");
        }
        return rec;
    }

    public void addFromConceptRelationship(miningmart.m4.Relationship rec) throws StorageException {
        rec.setFromConcept(this);
    }

    public miningmart.m4.Relationship getFromConceptRelationship(String name, miningmart.m4.Concept toConcept) {
        return Relationship.getByFromConceptAndNameAndToConcept(this.getId(), name, ((Concept)toConcept).getId());
    }

    public Collection getAllFromConceptRelationships() {
        return Relationship.getByFromConcept(this.getId());
    }

    public void removeFromConceptRelationship(String name, miningmart.m4.Concept fromConcept) throws StorageException {
        this.getFromConceptRelationship(name, fromConcept).delete();
    }

    public void removeAllFromConceptRelationships() throws StorageException {
        Iterator it = this.getAllFromConceptRelationships().iterator();
        while (it.hasNext()) {
            ((Relationship)it.next()).delete();
        }
    }

    public void addToConceptRelationship(miningmart.m4.Relationship rec) throws StorageException {
        rec.setToConcept(this);
    }

    public miningmart.m4.Relationship getToConceptRelationship(String name, miningmart.m4.Concept fromConcept) {
        return Relationship.getByFromConceptAndNameAndToConcept(((Concept)fromConcept).getId(), name, this.getId());
    }

    public Collection getAllToConceptRelationships() {
        return Relationship.getByToConcept(this.getId());
    }

    public void removeToConceptRelationship(String name, miningmart.m4.Concept fromConcept) throws StorageException {
        this.getToConceptRelationship(name, fromConcept).delete();
    }

    public void removeAllToConceptRelationships() throws StorageException {
        Iterator it = this.getAllToConceptRelationships().iterator();
        while (it.hasNext()) {
            ((Relationship)it.next()).delete();
        }
    }

    public miningmart.m4.ColumnSet createColumnSet(String name, String schema, String type) throws NameExistsException, miningmart.m4.CreateException {
        if (name == null || schema == null || type == null) {
            throw new miningmart.m4.CreateException("Name, schema and type should be included");
        }
        if (ColumnSet.getByConceptAndName(this.getId(), name) != null) {
            throw new NameExistsException("Duplicate name");
        }
        ColumnSet rec = new ColumnSet();
        rec.setContext("Concept context");
        try {
            rec.setConcept(this);
            rec.setName(name);
            rec.setSchema(schema);
            rec.setColumnSetType(type);
        }
        catch (StorageException e) {
            logger.warn((Object)"Could not connect columnset to concept.", (Throwable)e);
            throw new miningmart.m4.CreateException("A storage exception occurred.");
        }
        return rec;
    }

    public void addColumnSet(miningmart.m4.ColumnSet rec) throws StorageException {
        rec.setConcept(this);
    }

    public miningmart.m4.ColumnSet getColumnSet(String name) {
        return ColumnSet.getByConceptAndName(this.getId(), name);
    }

    public miningmart.m4.ColumnSet getColumnSetByBranch(String name) {
        return ColumnSet.getByConceptAndBranchName(this.getId(), name);
    }

    public Collection getAllColumnSets() {
        return ColumnSet.getByConcept(this.getId());
    }

    public void removeColumnSet(String name) throws StorageException {
        this.getColumnSet(name).delete();
    }

    public void removeAllColumnSets() throws StorageException {
        Iterator it = this.getAllColumnSets().iterator();
        while (it.hasNext()) {
            ((ColumnSet)it.next()).delete();
        }
    }

    public miningmart.m4.RoleRestriction createRoleRestriction(String name, miningmart.m4.Relationship rel) throws NameExistsException, miningmart.m4.CreateException {
        if (name == null || rel == null) {
            throw new miningmart.m4.CreateException("Name and relationship required");
        }
        if (RoleRestriction.getByConceptAndName(this.getId(), name) != null) {
            throw new NameExistsException("Duplicate name");
        }
        RoleRestriction rec = new RoleRestriction();
        try {
            rec.setRestrictionForConcept(this);
            rec.setRestrictionForRelationship(rel);
            rec.setName(name);
        }
        catch (StorageException e) {
            logger.warn((Object)"Could not connect rolerestriction to concept.", (Throwable)e);
            throw new miningmart.m4.CreateException("A storage exception occurred.");
        }
        return rec;
    }

    public miningmart.m4.RoleRestriction getRoleRestriction(String name) {
        return RoleRestriction.getByConceptAndName(this.getId(), name);
    }

    public Collection getAllRoleRestrictions() {
        return RoleRestriction.getByConcept(this.getId());
    }

    public void removeRoleRestriction(String name) throws StorageException {
        this.getRoleRestriction(name).delete();
    }

    public void removeAllRoleRestrictions() throws StorageException {
        Iterator it = this.getAllRoleRestrictions().iterator();
        while (it.hasNext()) {
            ((RoleRestriction)it.next()).delete();
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSuperConcept(miningmart.m4.Concept rec) throws StorageException {
        if (rec == null) {
            this.removeSuperConcept();
            return;
        }
        Concept oldObj = Concept.getBySubConcept(this.getId());
        Concept anObj = (Concept)rec;
        if (!anObj.isExisting()) {
            anObj.store();
        }
        Concepts anEJB = null;
        anEJB = Concept.getEJB();
        if (oldObj != null) {
            anEJB.removeChildConcept(oldObj.getId(), this.getId());
        }
        anEJB.addChildConcept(anObj.getId(), this.getId());
        Object var7_5 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var7_6 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var7_7 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public miningmart.m4.Concept getSuperConcept() {
        return Concept.getBySubConcept(this.getId());
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeSuperConcept() {
        Concept anObj = Concept.getBySubConcept(this.getId());
        Concepts anEJB = null;
        anEJB = Concept.getEJB();
        anEJB.removeChildConcept(anObj.getId(), this.getId());
        Object var5_3 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var5_4 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var5_5 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFromProjection(miningmart.m4.Concept rec) throws StorageException {
        if (rec == null) {
            this.removeFromProjection();
            return;
        }
        Concept oldObj = Concept.getByToProjection(this.getId());
        Concept anObj = (Concept)rec;
        if (!anObj.isExisting()) {
            anObj.store();
        }
        Concepts anEJB = null;
        anEJB = Concept.getEJB();
        if (oldObj != null) {
            anEJB.removeProjection(oldObj.getId(), this.getId());
        }
        anEJB.addProjection(anObj.getId(), this.getId());
        Object var7_5 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var7_6 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var7_7 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public miningmart.m4.Concept getFromProjection() {
        return Concept.getByToProjection(this.getId());
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeFromProjection() {
        Concept anObj = Concept.getByToProjection(this.getId());
        Concepts anEJB = null;
        anEJB = Concept.getEJB();
        anEJB.removeProjection(anObj.getId(), this.getId());
        Object var5_3 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var5_4 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var5_5 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void addParameter(miningmart.m4.Parameter rec) throws StorageException {
        ((Parameter)rec).setParameterObject(this);
    }

    public miningmart.m4.Parameter getParameter(String stepName, String parmName) {
        return Parameter.getByConceptAndStepNameAndName(this.getId(), stepName, parmName);
    }

    public Collection getAllParameters() {
        return Parameter.getByConcept(this.getId());
    }

    public Collection getAllInputParameters() {
        return Parameter.getByConceptAndTypeName(this.getId(), "Input");
    }

    public miningmart.m4.Parameter getOutputParameter() throws MultipleResultException {
        miningmart.m4.Parameter p = null;
        Collection allOutputParameters = Parameter.getByConceptAndTypeName(this.getId(), "Output");
        if (allOutputParameters.size() == 1) {
            Iterator i = allOutputParameters.iterator();
            p = (miningmart.m4.Parameter)i.next();
        } else if (allOutputParameters.size() > 1) {
            throw new MultipleResultException();
        }
        return p;
    }

    public void removeParameter(String stepName, String parmName) throws StorageException {
        this.getParameter(stepName, parmName).setParameterObject(null);
    }

    public void removeAllParameters() throws StorageException {
        Iterator it = this.getAllParameters().iterator();
        while (it.hasNext()) {
            Parameter rec = (Parameter)it.next();
            rec.setParameterObject(null);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addSubConcept(miningmart.m4.Concept rec) throws StorageException {
        Concept anObj = (Concept)rec;
        if (!anObj.isExisting()) {
            anObj.store();
        }
        Concepts anEJB = null;
        anEJB = Concept.getEJB();
        anEJB.addChildConcept(this.getId(), anObj.getId());
        Object var6_4 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var6_5 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var6_6 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public miningmart.m4.Concept getSubConcept(String name) {
        return Concept.getBySuperConceptAndName(this.getId(), name);
    }

    public Collection getAllSubConcepts() {
        return Concept.getBySuperConcept(this.getId());
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeSubConcept(String name) {
        Concept anObj = (Concept)this.getSubConcept(name);
        Concepts anEJB = null;
        anEJB = Concept.getEJB();
        anEJB.removeChildConcept(this.getId(), anObj.getId());
        Object var6_4 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var6_5 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var6_6 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeAllSubConcepts() {
        Concepts anEJB = null;
        anEJB = Concept.getEJB();
        Iterator it = this.getAllSubConcepts().iterator();
        while (it.hasNext()) {
            anEJB.removeChildConcept(this.getId(), ((Concept)it.next()).getId());
        }
        Object var4_5 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var4_6 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var4_7 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public miningmart.m4.Concept getToProjection(String name) {
        return Concept.getByFromProjectionAndName(this.getId(), name);
    }

    public Collection getAllToProjections() {
        return Concept.getByFromProjection(this.getId());
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection getAllNames() {
        block12: {
            aMap = null;
            anEJB = null;
            try {
                try {
                    anEJB = Concept.getEJB();
                    aMap = anEJB.getNameIdMapByCase(Concept.getCurrentCase().getId());
                    if (aMap != null) break block12;
                    var2_2 = null;
                    var4_5 = null;
                    if (anEJB == null) return var2_2;
                }
                catch (RemoteException e) {
                    Concept.logger.error((Object)"Communication failure", (Throwable)e);
                    var4_7 = null;
                    if (anEJB == null) return aMap.keySet();
                    try {
                        anEJB.remove();
                        return aMap.keySet();
                    }
                    catch (Exception var5_12) {
                        return aMap.keySet();
                    }
                }
                catch (SQLException e) {
                    Concept.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var4_8 = null;
                    if (anEJB == null) return aMap.keySet();
                    try {}
                    catch (Exception var5_13) {
                        return aMap.keySet();
                    }
                    anEJB.remove();
                    return aMap.keySet();
                }
            }
            catch (Throwable var3_15) {
                var4_9 = null;
                if (anEJB == null) throw var3_15;
                ** try [egrp 2[TRYBLOCK] [3 : 84->93)] { 
lbl38:
                // 1 sources

                anEJB.remove();
                throw var3_15;
lbl40:
                // 1 sources

                catch (Exception var5_14) {
                    // empty catch block
                }
                throw var3_15;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 84->93)] { 
lbl45:
            // 1 sources

            anEJB.remove();
            return var2_2;
lbl47:
            // 1 sources

            catch (Exception var5_10) {
                // empty catch block
            }
            return var2_2;
        }
        var4_6 = null;
        if (anEJB == null) return aMap.keySet();
        try {}
        catch (Exception var5_11) {}
        anEJB.remove();
        return aMap.keySet();
        return aMap.keySet();
    }

    public miningmart.m4.Concept copy(miningmart.m4.Case newCase) throws NameExistsException, miningmart.m4.CreateException {
        String conceptName = this.getName();
        String conceptType = this.getConceptType();
        String subConceptRestriction = this.getSubConceptRestriction();
        Concept newConcept = null;
        newConcept = (Concept)newCase.createConcept(conceptName, conceptType);
        newConcept.setSubConceptRestriction(subConceptRestriction);
        return newConcept;
    }

    public void setPoint(Point point, miningmart.m4.Concept context) {
        M4Interface m4Interface = (M4Interface)M4Interface.getInstance();
        Concept aConcept = (Concept)context;
        if (context == null) {
            m4Interface.removePoint(this.getId(), this.getName(), "CON", null, null, null);
            m4Interface.setPoint(this.getId(), this.getName(), "CON", null, null, null, point);
        } else {
            m4Interface.removePoint(this.getId(), this.getName(), "CON", new Integer(aConcept.getId()), aConcept.getName(), "CON");
            m4Interface.setPoint(this.getId(), this.getName(), "CON", new Integer(aConcept.getId()), aConcept.getName(), "CON", point);
        }
    }

    public Point getPoint(miningmart.m4.Concept context) {
        M4Interface m4Interface = (M4Interface)M4Interface.getInstance();
        Concept aConcept = (Concept)context;
        if (aConcept != null) {
            return m4Interface.getPoint(this.getId(), this.getName(), "CON", new Integer(aConcept.getId()), aConcept.getName(), "CON");
        }
        return null;
    }

    public Point getPoint(Map points, miningmart.m4.Concept context) {
        M4Interface m4Interface = (M4Interface)M4Interface.getInstance();
        Concept aConcept = (Concept)context;
        if (aConcept != null) {
            return m4Interface.getPoint(points, this.getId(), this.getName(), "CON", new Integer(aConcept.getId()), aConcept.getName(), "CON");
        }
        return null;
    }

    public Map getPointsContext() {
        M4Interface m4Interface = (M4Interface)M4Interface.getInstance();
        Map points = m4Interface.getPoints(null, null, null, new Integer(this.getId()), this.getName(), "CON");
        return points;
    }

    public void removePoint(miningmart.m4.Concept context) {
        M4Interface m4Interface = (M4Interface)M4Interface.getInstance();
        Concept aConcept = (Concept)context;
        m4Interface.removePoint(this.getId(), this.getName(), "CON", new Integer(aConcept.getId()), aConcept.getName(), "CON");
    }

    public void removeAllPoints() {
        M4Interface m4Interface = (M4Interface)M4Interface.getInstance();
        m4Interface.removeAllPoints(this.getId(), this.getName(), "CON");
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delete() throws StorageException {
        if (!this.isExisting()) {
            return;
        }
        Concepts anEJB = null;
        this.removeAllPoints();
        anEJB = Concept.getEJB();
        anEJB.delete(this.value.getId());
        this.setExisting(false);
        cache.remove(this);
        Object var4_2 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var4_3 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var4_4 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void store() throws StorageException {
        if (!this.isChanged()) {
            return;
        }
        Concepts anEJB = null;
        anEJB = Concept.getEJB();
        if (this.isExisting()) {
            anEJB.update(this.value);
        } else {
            this.value.setId(anEJB.create(this.value));
            cache.put(new Integer(this.value.getId()), this);
        }
        this.setChanged(false);
        this.setExisting(true);
        Object var4_2 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var4_3 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var4_4 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static Concepts getEJB() {
        try {
            Object initial;
            if (home == null) {
                initial = new InitialContext();
                home = (ConceptsHome)PortableRemoteObject.narrow((Object)initial.lookup("Concepts"), Class.forName("com.syllogic.miningmart.m4.ejb.ConceptsHome"));
            }
            initial = home.create();
            return initial;
        }
        catch (ClassCastException e) {
            logger.warn((Object)"Got the wrong EJB?:", (Throwable)e);
        }
        catch (CreateException e) {
            logger.warn((Object)"Failed to create EJB reference:", (Throwable)e);
        }
        catch (NamingException e) {
            logger.warn((Object)"Failed to resolve JNDI name in initial context:", (Throwable)e);
        }
        catch (RemoteException e) {
            logger.warn((Object)"Communication failure", (Throwable)e);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Concept getById(int id) {
        Concepts anEJB;
        Concept aConcept;
        block10: {
            Integer idObject = new Integer(id);
            aConcept = (Concept)cache.get(idObject);
            if (aConcept != null) return aConcept;
            anEJB = null;
            anEJB = Concept.getEJB();
            ConceptV val = anEJB.find(id);
            if (val == null) break block10;
            aConcept = new Concept(val);
            cache.put(idObject, aConcept);
        }
        Object var6_7 = null;
        if (anEJB == null) return aConcept;
        try {
            anEJB.remove();
            return aConcept;
        }
        catch (Exception exception) {}
        return aConcept;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var6_8 = null;
                if (anEJB == null) return aConcept;
                try {
                    anEJB.remove();
                    return aConcept;
                }
                catch (Exception exception) {}
                return aConcept;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var6_9 = null;
                if (anEJB == null) return aConcept;
                try {
                    anEJB.remove();
                    return aConcept;
                }
                catch (Exception exception) {}
                return aConcept;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static miningmart.m4.Concept getByFromProjectionAndName(int id, String name) {
        block13: {
            anEJB = null;
            try {
                try {
                    anEJB = Concept.getEJB();
                    anId = anEJB.getIdByFromProjectionAndName(id, name);
                    if (anId == null) break block13;
                    anObj = (Concept)Concept.cache.get(anId);
                    if (anObj == null && (val = anEJB.find(anId)) != null) {
                        anObj = new Concept(val);
                        Concept.cache.put(anId, anObj);
                    }
                    if (anObj == null) break block13;
                    var5_7 = anObj;
                    var7_8 = null;
                    if (anEJB == null) return var5_7;
                }
                catch (RemoteException e) {
                    Concept.logger.warn((Object)"Communication failure", (Throwable)e);
                    var7_10 = null;
                    if (anEJB == null) return null;
                    try {
                        anEJB.remove();
                        return null;
                    }
                    catch (Exception var8_15) {
                        return null;
                    }
                }
                catch (SQLException e) {
                    Concept.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var7_11 = null;
                    if (anEJB == null) return null;
                    try {}
                    catch (Exception var8_16) {
                        return null;
                    }
                    anEJB.remove();
                    return null;
                }
            }
            catch (Throwable var6_18) {
                var7_12 = null;
                if (anEJB == null) throw var6_18;
                ** try [egrp 2[TRYBLOCK] [3 : 147->156)] { 
lbl43:
                // 1 sources

                anEJB.remove();
                throw var6_18;
lbl45:
                // 1 sources

                catch (Exception var8_17) {
                    // empty catch block
                }
                throw var6_18;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 147->156)] { 
lbl50:
            // 1 sources

            anEJB.remove();
            return var5_7;
lbl52:
            // 1 sources

            catch (Exception var8_13) {
                // empty catch block
            }
            return var5_7;
        }
        var7_9 = null;
        if (anEJB == null) return null;
        try {}
        catch (Exception var8_14) {}
        anEJB.remove();
        return null;
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Concept getBySubConcept(int id) {
        block13: {
            anEJB = null;
            try {
                try {
                    anEJB = Concept.getEJB();
                    it = anEJB.getIdBySubConcept(id).iterator();
                    if (!it.hasNext()) break block13;
                    anId = (Integer)it.next();
                    anObj = (Concept)Concept.cache.get(anId);
                    if (anObj == null && (val = anEJB.find(anId)) != null) {
                        anObj = new Concept(val);
                        Concept.cache.put(anId, anObj);
                    }
                    if (anObj == null) break block13;
                    var5_7 = anObj;
                    var7_8 = null;
                    if (anEJB == null) return var5_7;
                }
                catch (RemoteException e) {
                    Concept.logger.warn((Object)"Communication failure", (Throwable)e);
                    var7_10 = null;
                    if (anEJB == null) return null;
                    try {
                        anEJB.remove();
                        return null;
                    }
                    catch (Exception var8_15) {
                        return null;
                    }
                }
                catch (SQLException e) {
                    Concept.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var7_11 = null;
                    if (anEJB == null) return null;
                    try {}
                    catch (Exception var8_16) {
                        return null;
                    }
                    anEJB.remove();
                    return null;
                }
            }
            catch (Throwable var6_18) {
                var7_12 = null;
                if (anEJB == null) throw var6_18;
                ** try [egrp 2[TRYBLOCK] [3 : 165->174)] { 
lbl44:
                // 1 sources

                anEJB.remove();
                throw var6_18;
lbl46:
                // 1 sources

                catch (Exception var8_17) {
                    // empty catch block
                }
                throw var6_18;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 165->174)] { 
lbl51:
            // 1 sources

            anEJB.remove();
            return var5_7;
lbl53:
            // 1 sources

            catch (Exception var8_13) {
                // empty catch block
            }
            return var5_7;
        }
        var7_9 = null;
        if (anEJB == null) return null;
        try {}
        catch (Exception var8_14) {}
        anEJB.remove();
        return null;
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Concept getByToProjection(int id) {
        block13: {
            anEJB = null;
            try {
                try {
                    anEJB = Concept.getEJB();
                    it = anEJB.getIdByToProjection(id).iterator();
                    if (!it.hasNext()) break block13;
                    anId = (Integer)it.next();
                    anObj = (Concept)Concept.cache.get(anId);
                    if (anObj == null && (val = anEJB.find(anId)) != null) {
                        anObj = new Concept(val);
                        Concept.cache.put(anId, anObj);
                    }
                    if (anObj == null) break block13;
                    var5_7 = anObj;
                    var7_8 = null;
                    if (anEJB == null) return var5_7;
                }
                catch (RemoteException e) {
                    Concept.logger.warn((Object)"Communication failure", (Throwable)e);
                    var7_10 = null;
                    if (anEJB == null) return null;
                    try {
                        anEJB.remove();
                        return null;
                    }
                    catch (Exception var8_15) {
                        return null;
                    }
                }
                catch (SQLException e) {
                    Concept.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var7_11 = null;
                    if (anEJB == null) return null;
                    try {}
                    catch (Exception var8_16) {
                        return null;
                    }
                    anEJB.remove();
                    return null;
                }
            }
            catch (Throwable var6_18) {
                var7_12 = null;
                if (anEJB == null) throw var6_18;
                ** try [egrp 2[TRYBLOCK] [3 : 165->174)] { 
lbl44:
                // 1 sources

                anEJB.remove();
                throw var6_18;
lbl46:
                // 1 sources

                catch (Exception var8_17) {
                    // empty catch block
                }
                throw var6_18;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 165->174)] { 
lbl51:
            // 1 sources

            anEJB.remove();
            return var5_7;
lbl53:
            // 1 sources

            catch (Exception var8_13) {
                // empty catch block
            }
            return var5_7;
        }
        var7_9 = null;
        if (anEJB == null) return null;
        try {}
        catch (Exception var8_14) {}
        anEJB.remove();
        return null;
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection getByFromProjection(int id) {
        ArrayList<Concept> aList = new ArrayList<Concept>();
        Concepts anEJB = null;
        anEJB = Concept.getEJB();
        Iterator it = anEJB.getIdByFromProjection(id).iterator();
        while (it.hasNext()) {
            ConceptV val;
            Integer anId = (Integer)it.next();
            Concept anObj = (Concept)cache.get(anId);
            if (anObj == null && (val = anEJB.find(anId)) != null) {
                anObj = new Concept(val);
                cache.put(anId, anObj);
            }
            if (anObj == null) continue;
            aList.add(anObj);
        }
        Object var8_9 = null;
        if (anEJB == null) return aList;
        try {
            anEJB.remove();
            return aList;
        }
        catch (Exception exception) {}
        return aList;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var8_10 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var8_11 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection getBySuperConcept(int id) {
        ArrayList<Concept> aList = new ArrayList<Concept>();
        Concepts anEJB = null;
        anEJB = Concept.getEJB();
        Iterator it = anEJB.getIdBySuperConcept(id).iterator();
        while (it.hasNext()) {
            ConceptV val;
            Integer anId = (Integer)it.next();
            Concept anObj = (Concept)cache.get(anId);
            if (anObj == null && (val = anEJB.find(anId)) != null) {
                anObj = new Concept(val);
                cache.put(anId, anObj);
            }
            if (anObj == null) continue;
            aList.add(anObj);
        }
        Object var8_9 = null;
        if (anEJB == null) return aList;
        try {
            anEJB.remove();
            return aList;
        }
        catch (Exception exception) {}
        return aList;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var8_10 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var8_11 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Concept getBySuperConceptAndName(int id, String name) {
        block13: {
            anEJB = null;
            try {
                try {
                    anEJB = Concept.getEJB();
                    anId = anEJB.getIdBySuperConceptAndName(id, name);
                    if (anId == null) break block13;
                    anObj = (Concept)Concept.cache.get(anId);
                    if (anObj == null && (val = anEJB.find(anId)) != null) {
                        anObj = new Concept(val);
                        Concept.cache.put(anId, anObj);
                    }
                    if (anObj == null) break block13;
                    var5_7 = anObj;
                    var7_8 = null;
                    if (anEJB == null) return var5_7;
                }
                catch (RemoteException e) {
                    Concept.logger.warn((Object)"Communication failure", (Throwable)e);
                    var7_10 = null;
                    if (anEJB == null) return null;
                    try {
                        anEJB.remove();
                        return null;
                    }
                    catch (Exception var8_15) {
                        return null;
                    }
                }
                catch (SQLException e) {
                    Concept.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var7_11 = null;
                    if (anEJB == null) return null;
                    try {}
                    catch (Exception var8_16) {
                        return null;
                    }
                    anEJB.remove();
                    return null;
                }
            }
            catch (Throwable var6_18) {
                var7_12 = null;
                if (anEJB == null) throw var6_18;
                ** try [egrp 2[TRYBLOCK] [3 : 147->156)] { 
lbl43:
                // 1 sources

                anEJB.remove();
                throw var6_18;
lbl45:
                // 1 sources

                catch (Exception var8_17) {
                    // empty catch block
                }
                throw var6_18;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 147->156)] { 
lbl50:
            // 1 sources

            anEJB.remove();
            return var5_7;
lbl52:
            // 1 sources

            catch (Exception var8_13) {
                // empty catch block
            }
            return var5_7;
        }
        var7_9 = null;
        if (anEJB == null) return null;
        try {}
        catch (Exception var8_14) {}
        anEJB.remove();
        return null;
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection getByBaseAttribute(int id) {
        ArrayList<Concept> aList = new ArrayList<Concept>();
        Concepts anEJB = null;
        anEJB = Concept.getEJB();
        Iterator it = anEJB.getIdByBaseAttribute(id).iterator();
        while (it.hasNext()) {
            ConceptV val;
            Integer anId = (Integer)it.next();
            Concept anObj = (Concept)cache.get(anId);
            if (anObj == null && (val = anEJB.find(anId)) != null) {
                anObj = new Concept(val);
                cache.put(anId, anObj);
            }
            if (anObj == null) continue;
            aList.add(anObj);
        }
        Object var8_9 = null;
        if (anEJB == null) return aList;
        try {
            anEJB.remove();
            return aList;
        }
        catch (Exception exception) {}
        return aList;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var8_10 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var8_11 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Concept getByCaseAndName(int id, String name) {
        block13: {
            anEJB = null;
            try {
                try {
                    anEJB = Concept.getEJB();
                    anId = anEJB.getIdByCaseAndName(id, name);
                    if (anId == null) break block13;
                    anObj = (Concept)Concept.cache.get(anId);
                    if (anObj == null && (val = anEJB.find(anId)) != null) {
                        anObj = new Concept(val);
                        Concept.cache.put(anId, anObj);
                    }
                    if (anObj == null) break block13;
                    var5_7 = anObj;
                    var7_8 = null;
                    if (anEJB == null) return var5_7;
                }
                catch (RemoteException e) {
                    Concept.logger.warn((Object)"Communication failure", (Throwable)e);
                    var7_10 = null;
                    if (anEJB == null) return null;
                    try {
                        anEJB.remove();
                        return null;
                    }
                    catch (Exception var8_15) {
                        return null;
                    }
                }
                catch (SQLException e) {
                    Concept.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var7_11 = null;
                    if (anEJB == null) return null;
                    try {}
                    catch (Exception var8_16) {
                        return null;
                    }
                    anEJB.remove();
                    return null;
                }
            }
            catch (Throwable var6_18) {
                var7_12 = null;
                if (anEJB == null) throw var6_18;
                ** try [egrp 2[TRYBLOCK] [3 : 147->156)] { 
lbl43:
                // 1 sources

                anEJB.remove();
                throw var6_18;
lbl45:
                // 1 sources

                catch (Exception var8_17) {
                    // empty catch block
                }
                throw var6_18;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 147->156)] { 
lbl50:
            // 1 sources

            anEJB.remove();
            return var5_7;
lbl52:
            // 1 sources

            catch (Exception var8_13) {
                // empty catch block
            }
            return var5_7;
        }
        var7_9 = null;
        if (anEJB == null) return null;
        try {}
        catch (Exception var8_14) {}
        anEJB.remove();
        return null;
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection getByCase(int id) {
        block17: {
            if (Concept.logger.isDebugEnabled()) {
                Concept.logger.debug((Object)String.valueOf("Locating Concepts for Case with id:").concat(String.valueOf(id)));
            }
            aList = new ArrayList<Concept>();
            anEJB = null;
            try {
                try {
                    anEJB = Concept.getEJB();
                    it = anEJB.getIdByCase(id).iterator();
                    while (it.hasNext()) {
                        if (Concept.logger.isDebugEnabled()) {
                            Concept.logger.debug((Object)"Found a concept in the case, retrieving...");
                        }
                        if ((anObj = (Concept)Concept.cache.get(anId = (Integer)it.next())) == null && (val = anEJB.find(anId)) != null) {
                            anObj = new Concept(val);
                            Concept.cache.put(anId, anObj);
                        }
                        if (anObj == null) continue;
                        aList.add(anObj);
                    }
                    var8_9 = null;
                    if (anEJB == null) break block17;
                }
                catch (RemoteException e) {
                    Concept.logger.warn((Object)"Communication failure", (Throwable)e);
                    var8_10 = null;
                    if (anEJB != null) {
                        try {
                            anEJB.remove();
                        }
                        catch (Exception var9_14) {}
                    }
                    break block17;
                }
                catch (SQLException e) {
                    Concept.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var8_11 = null;
                    if (anEJB != null) {
                        try {}
                        catch (Exception var9_15) {}
                        anEJB.remove();
                    }
                    break block17;
                }
            }
            catch (Throwable var7_17) {
                var8_12 = null;
                if (anEJB == null) throw var7_17;
                ** try [egrp 2[TRYBLOCK] [3 : 225->234)] { 
lbl48:
                // 1 sources

                anEJB.remove();
                throw var7_17;
lbl50:
                // 1 sources

                catch (Exception var9_16) {
                    // empty catch block
                }
                throw var7_17;
            }
            try {}
            catch (Exception var9_13) {}
            anEJB.remove();
        }
        if (Concept.logger.isDebugEnabled() == false) return aList;
        Concept.logger.debug((Object)"Searched case for concepts");
        if (aList.isEmpty()) {
            Concept.logger.debug((Object)"No concepts found...");
            return aList;
        }
        Concept.logger.debug((Object)"Concepts found...");
        return aList;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection getByCaseAndType(int id, String type) {
        ArrayList<Concept> aList = new ArrayList<Concept>();
        Concepts anEJB = null;
        anEJB = Concept.getEJB();
        Iterator it = anEJB.getIdByCaseAndType(id, type).iterator();
        while (it.hasNext()) {
            ConceptV val;
            Integer anId = (Integer)it.next();
            Concept anObj = (Concept)cache.get(anId);
            if (anObj == null && (val = anEJB.find(anId)) != null) {
                anObj = new Concept(val);
                cache.put(anId, anObj);
            }
            if (anObj == null) continue;
            aList.add(anObj);
        }
        Object var9_10 = null;
        if (anEJB == null) return aList;
        try {
            anEJB.remove();
            return aList;
        }
        catch (Exception exception) {}
        return aList;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var9_11 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var9_12 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void setDocumentation(String text) {
        this.removeAllDocumentation();
        if (text == null || text.equalsIgnoreCase("")) {
            return;
        }
        DocumentationV val = new DocumentationV();
        val.setText(text);
        val.setObjectId(this.getId());
        val.setObjectType("CON");
        Documentation.createByValueObject(val);
    }

    public String getDocumentation() {
        return Documentation.getByIdAndType(this.getId(), "CON");
    }

    public void removeAllDocumentation() {
        Documentation.deleteByIdAndType(this.getId(), "CON");
    }

    private static Case getCurrentCase() {
        return (Case)M4Interface.getCurrentCase();
    }

    protected static void clearCache() {
        cache.clear();
    }
}

