/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.m4;

import com.syllogic.miningmart.m4.Column;
import com.syllogic.miningmart.m4.ColumnSetStatistics;
import com.syllogic.miningmart.m4.Concept;
import com.syllogic.miningmart.m4.Documentation;
import com.syllogic.miningmart.m4.ForeignKey;
import com.syllogic.miningmart.m4.M4Object;
import com.syllogic.miningmart.m4.PrimaryKey;
import com.syllogic.miningmart.m4.Relationship;
import com.syllogic.miningmart.m4.ejb.ColumnSets;
import com.syllogic.miningmart.m4.ejb.ColumnSetsHome;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import miningmart.m4.NameExistsException;
import miningmart.m4.StorageException;
import miningmart.m4.value.ColumnSetV;
import miningmart.m4.value.DocumentationV;
import org.apache.log4j.Logger;

public class ColumnSet
extends M4Object
implements miningmart.m4.ColumnSet,
Serializable {
    private ColumnSetV value = new ColumnSetV();
    private static ColumnSetsHome home = null;
    private static Map cache = new HashMap();
    private static Logger logger = Logger.getLogger((String)"com.syllogic.miningmart.m4.ColumnSet");
    public static final String CONCEPT_CONTEXT = "Concept context";
    public static final String RELATIONSHIP_CONTEXT = "Relationship context";
    private String context = "Concept context";

    public ColumnSet() {
        this.value = new ColumnSetV();
        this.setExisting(false);
        this.setChanged(true);
    }

    public ColumnSet(ColumnSetV value) {
        this.value = value;
        this.setExisting(true);
        this.setChanged(false);
    }

    public int getId() {
        return this.value.getId();
    }

    public String getName() {
        return this.value.getName();
    }

    public void setName(String name) throws NameExistsException {
        if (this.getContext() == CONCEPT_CONTEXT && ColumnSet.getByConceptAndName(((Concept)this.getConcept()).getId(), name) != null) {
            throw new NameExistsException("Duplicate name");
        }
        this.value.setName(name);
        this.setChanged(true);
    }

    public String getSchema() {
        return this.value.getSchema();
    }

    public void setSchema(String schema) {
        this.value.setSchema(schema);
        this.setChanged(true);
    }

    public String getFile() {
        return this.value.getFile();
    }

    public void setFile(String file) {
        this.value.setFile(file);
        this.setChanged(true);
    }

    public String getUser() {
        return this.value.getUser();
    }

    public void setUser(String user) {
        this.value.setUser(user);
        this.setChanged(true);
    }

    public String getConnectString() {
        return this.value.getConnect();
    }

    public void setConnectString(String connectString) {
        this.value.setConnect(connectString);
        this.setChanged(true);
    }

    public String getColumnSetType() {
        return this.value.getType();
    }

    public void setColumnSetType(String columnSetType) {
        this.value.setType(columnSetType);
        this.setChanged(true);
    }

    public String getSqlString() {
        return this.value.getSql();
    }

    public void setSqlString(String sqlString) {
        this.value.setSql(sqlString);
        this.setChanged(true);
    }

    public String getMultiStepBranch() {
        return this.value.getMultiStepBranch();
    }

    public void setMultiStepBranch(String multiStepBranch) {
        this.value.setMultiStepBranch(multiStepBranch);
        this.setChanged(true);
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public miningmart.m4.Column createColumn(String name, String datatype) throws NameExistsException, miningmart.m4.CreateException {
        if (name == null || datatype == null) {
            throw new miningmart.m4.CreateException("Column name and datatype should be included");
        }
        if (Column.getByColumnSetAndName(this.getId(), name) != null) {
            throw new NameExistsException("Duplicate name");
        }
        Column column = new Column();
        try {
            column.setColumnSet(this);
            column.setName(name);
            column.setColumnDatatype(datatype);
        }
        catch (StorageException e) {
            logger.warn((Object)"Could not connect column to columnset.", (Throwable)e);
            throw new miningmart.m4.CreateException("A storage exception occurred.");
        }
        return column;
    }

    public void addColumn(miningmart.m4.Column column) throws StorageException {
        column.setColumnSet(this);
    }

    public miningmart.m4.Column getColumn(String name) {
        return Column.getByColumnSetAndName(this.getId(), name);
    }

    public Collection getAllColumns() {
        return Column.getByColumnSet(this.getId());
    }

    public void removeColumn(String name) throws StorageException {
        this.getColumn(name).delete();
    }

    public void removeAllColumns() throws StorageException {
        Iterator it = this.getAllColumns().iterator();
        while (it.hasNext()) {
            ((Column)it.next()).delete();
        }
    }

    public miningmart.m4.Concept getConcept() {
        if (this.value.getConceptName() == null) {
            return null;
        }
        return Concept.getById(this.value.getConcept());
    }

    public void setConcept(miningmart.m4.Concept rec) throws StorageException {
        if (rec == null) {
            this.value.setConcept(0);
            this.value.setConceptName(null);
            this.setChanged(true);
            return;
        }
        Concept anObj = (Concept)rec;
        if (!anObj.isExisting()) {
            anObj.store();
        }
        this.value.setConcept(anObj.getId());
        this.value.setConceptName(anObj.getName());
        this.setChanged(true);
    }

    public miningmart.m4.Relationship getRelationship() {
        return Relationship.getByColumnSet(this.getId());
    }

    public void setRelationship(miningmart.m4.Relationship relationship) throws StorageException {
        relationship.setColumnSet(this);
    }

    public miningmart.m4.PrimaryKey createPrimaryKey(String name) throws NameExistsException, miningmart.m4.CreateException {
        if (name == null) {
            throw new miningmart.m4.CreateException("PrimaryKey name should be included");
        }
        if (PrimaryKey.getByColumnSetAndName(this.getId(), name) != null) {
            throw new NameExistsException("Duplicate name");
        }
        PrimaryKey rec = new PrimaryKey();
        try {
            rec.setColumnSet(this);
            rec.setName(name);
        }
        catch (StorageException e) {
            logger.warn((Object)"Could not connect primary key to columnset.", (Throwable)e);
            throw new miningmart.m4.CreateException("A storage exception occurred.");
        }
        return rec;
    }

    public void setPrimaryKey(miningmart.m4.PrimaryKey rec) throws StorageException {
        rec.setColumnSet(this);
    }

    public miningmart.m4.PrimaryKey getPrimaryKey() {
        return PrimaryKey.getByColumnSet(this.getId());
    }

    public void removePrimaryKey() throws StorageException {
        this.getPrimaryKey().delete();
    }

    public miningmart.m4.ColumnSetStatistics createColumnSetStatistics() throws miningmart.m4.CreateException {
        ColumnSetStatistics rec = new ColumnSetStatistics();
        try {
            rec.setColumnSet(this);
        }
        catch (StorageException e) {
            logger.warn((Object)"Could not connect ColumnSetStatistics to ColumnSet.", (Throwable)e);
            throw new miningmart.m4.CreateException("A storage exception occurred.");
        }
        return rec;
    }

    public void setColumnSetStatistics(miningmart.m4.ColumnSetStatistics rec) throws StorageException {
        rec.setColumnSet(this);
    }

    public miningmart.m4.ColumnSetStatistics getColumnSetStatistics() {
        return ColumnSetStatistics.getByColumnSet(this.getId());
    }

    public void removeColumnSetStatistics() throws StorageException {
        this.getColumnSetStatistics().delete();
    }

    public miningmart.m4.ForeignKey createForeignKey(String name) throws NameExistsException, miningmart.m4.CreateException {
        if (name == null) {
            throw new miningmart.m4.CreateException("ForeignKey name should be included");
        }
        if (ForeignKey.getByColumnSetAndName(this.getId(), name) != null) {
            throw new NameExistsException("Duplicate name");
        }
        ForeignKey rec = new ForeignKey();
        try {
            rec.setColumnSet(this);
            rec.setName(name);
        }
        catch (StorageException e) {
            logger.warn((Object)"Could not connect foreign key to columnset.", (Throwable)e);
            throw new miningmart.m4.CreateException("A storage exception occurred.");
        }
        return rec;
    }

    public void addForeignKey(miningmart.m4.ForeignKey rec) throws StorageException {
        rec.setColumnSet(this);
    }

    public miningmart.m4.ForeignKey getForeignKey(String name) {
        return ForeignKey.getByColumnSetAndName(this.getId(), name);
    }

    public Collection getAllForeignKeys() {
        return ForeignKey.getByColumnSet(this.getId());
    }

    public void removeForeignKey(String name) throws StorageException {
        this.getForeignKey(name).delete();
    }

    public void removeAllForeignKeys() throws StorageException {
        Iterator it = this.getAllForeignKeys().iterator();
        while (it.hasNext()) {
            ((ForeignKey)it.next()).delete();
        }
    }

    private static ColumnSets getEJB() {
        try {
            Object initial;
            if (home == null) {
                initial = new InitialContext();
                home = (ColumnSetsHome)PortableRemoteObject.narrow((Object)initial.lookup("ColumnSets"), Class.forName("com.syllogic.miningmart.m4.ejb.ColumnSetsHome"));
            }
            initial = home.create();
            return initial;
        }
        catch (ClassCastException e) {
            logger.warn((Object)"Got the wrong EJB?:", (Throwable)e);
        }
        catch (CreateException e) {
            logger.warn((Object)"Failed to create EJB reference:", (Throwable)e);
        }
        catch (NamingException e) {
            logger.warn((Object)"Failed to resolve JNDI name in initial context:", (Throwable)e);
        }
        catch (RemoteException e) {
            logger.warn((Object)"Communication failure:", (Throwable)e);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ColumnSet getById(int id) {
        ColumnSets anEJB;
        ColumnSet aColumnSet;
        block10: {
            Integer idObject = new Integer(id);
            aColumnSet = (ColumnSet)cache.get(idObject);
            if (aColumnSet != null) return aColumnSet;
            anEJB = null;
            anEJB = ColumnSet.getEJB();
            ColumnSetV val = anEJB.find(id);
            if (val == null) break block10;
            aColumnSet = new ColumnSet(val);
            cache.put(idObject, aColumnSet);
        }
        Object var6_7 = null;
        if (anEJB == null) return aColumnSet;
        try {
            anEJB.remove();
            return aColumnSet;
        }
        catch (Exception exception) {}
        return aColumnSet;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure:", (Throwable)e);
                Object var6_8 = null;
                if (anEJB == null) return aColumnSet;
                try {
                    anEJB.remove();
                    return aColumnSet;
                }
                catch (Exception exception) {}
                return aColumnSet;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var6_9 = null;
                if (anEJB == null) return aColumnSet;
                try {
                    anEJB.remove();
                    return aColumnSet;
                }
                catch (Exception exception) {}
                return aColumnSet;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public miningmart.m4.ColumnSet copy(miningmart.m4.Concept newConcept) throws NameExistsException, miningmart.m4.CreateException {
        String name = this.getName();
        String schema = this.getSchema();
        String type = this.getColumnSetType();
        String file = this.getFile();
        String user = this.getUser();
        String connectString = this.getConnectString();
        String sqlString = this.getSqlString();
        String msBranch = this.getMultiStepBranch();
        ColumnSet newColumnSet = null;
        newColumnSet = (ColumnSet)newConcept.createColumnSet(name, schema, type);
        newColumnSet.setFile(file);
        newColumnSet.setUser(user);
        newColumnSet.setConnectString(connectString);
        newColumnSet.setSqlString(sqlString);
        newColumnSet.setMultiStepBranch(msBranch);
        return newColumnSet;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delete() throws StorageException {
        if (!this.isExisting()) {
            return;
        }
        ColumnSets anEJB = null;
        anEJB = ColumnSet.getEJB();
        anEJB.delete(this.value.getId());
        this.setExisting(false);
        Object var4_2 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var4_3 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var4_4 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void store() throws StorageException {
        if (!this.isChanged()) {
            return;
        }
        ColumnSets anEJB = null;
        anEJB = ColumnSet.getEJB();
        if (this.isExisting()) {
            anEJB.update(this.value);
        } else {
            this.value.setId(anEJB.create(this.value));
            cache.put(new Integer(this.value.getId()), this);
        }
        this.setChanged(false);
        this.setExisting(true);
        Object var4_2 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var4_3 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var4_4 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ColumnSet getByConceptAndName(int id, String name) {
        block13: {
            anEJB = null;
            try {
                try {
                    anEJB = ColumnSet.getEJB();
                    anId = anEJB.getIdByConceptAndName(id, name);
                    if (anId == null) break block13;
                    anObj = (ColumnSet)ColumnSet.cache.get(anId);
                    if (anObj == null && (val = anEJB.find(anId)) != null) {
                        anObj = new ColumnSet(val);
                        ColumnSet.cache.put(anId, anObj);
                    }
                    if (anObj == null) break block13;
                    var5_7 = anObj;
                    var7_8 = null;
                    if (anEJB == null) return var5_7;
                }
                catch (RemoteException e) {
                    ColumnSet.logger.warn((Object)"Communication failure", (Throwable)e);
                    var7_10 = null;
                    if (anEJB == null) return null;
                    try {
                        anEJB.remove();
                        return null;
                    }
                    catch (Exception var8_15) {
                        return null;
                    }
                }
                catch (SQLException e) {
                    ColumnSet.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var7_11 = null;
                    if (anEJB == null) return null;
                    try {}
                    catch (Exception var8_16) {
                        return null;
                    }
                    anEJB.remove();
                    return null;
                }
            }
            catch (Throwable var6_18) {
                var7_12 = null;
                if (anEJB == null) throw var6_18;
                ** try [egrp 2[TRYBLOCK] [3 : 147->156)] { 
lbl43:
                // 1 sources

                anEJB.remove();
                throw var6_18;
lbl45:
                // 1 sources

                catch (Exception var8_17) {
                    // empty catch block
                }
                throw var6_18;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 147->156)] { 
lbl50:
            // 1 sources

            anEJB.remove();
            return var5_7;
lbl52:
            // 1 sources

            catch (Exception var8_13) {
                // empty catch block
            }
            return var5_7;
        }
        var7_9 = null;
        if (anEJB == null) return null;
        try {}
        catch (Exception var8_14) {}
        anEJB.remove();
        return null;
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ColumnSet getByConceptAndBranchName(int id, String name) {
        block13: {
            anEJB = null;
            try {
                try {
                    anEJB = ColumnSet.getEJB();
                    anId = anEJB.getIdByConceptAndBranchName(id, name);
                    if (anId == null) break block13;
                    anObj = (ColumnSet)ColumnSet.cache.get(anId);
                    if (anObj == null && (val = anEJB.find(anId)) != null) {
                        anObj = new ColumnSet(val);
                        ColumnSet.cache.put(anId, anObj);
                    }
                    if (anObj == null) break block13;
                    var5_7 = anObj;
                    var7_8 = null;
                    if (anEJB == null) return var5_7;
                }
                catch (RemoteException e) {
                    ColumnSet.logger.warn((Object)"Communication failure", (Throwable)e);
                    var7_10 = null;
                    if (anEJB == null) return null;
                    try {
                        anEJB.remove();
                        return null;
                    }
                    catch (Exception var8_15) {
                        return null;
                    }
                }
                catch (SQLException e) {
                    ColumnSet.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var7_11 = null;
                    if (anEJB == null) return null;
                    try {}
                    catch (Exception var8_16) {
                        return null;
                    }
                    anEJB.remove();
                    return null;
                }
            }
            catch (Throwable var6_18) {
                var7_12 = null;
                if (anEJB == null) throw var6_18;
                ** try [egrp 2[TRYBLOCK] [3 : 147->156)] { 
lbl43:
                // 1 sources

                anEJB.remove();
                throw var6_18;
lbl45:
                // 1 sources

                catch (Exception var8_17) {
                    // empty catch block
                }
                throw var6_18;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 147->156)] { 
lbl50:
            // 1 sources

            anEJB.remove();
            return var5_7;
lbl52:
            // 1 sources

            catch (Exception var8_13) {
                // empty catch block
            }
            return var5_7;
        }
        var7_9 = null;
        if (anEJB == null) return null;
        try {}
        catch (Exception var8_14) {}
        anEJB.remove();
        return null;
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection getByConcept(int id) {
        ArrayList<ColumnSet> aList = new ArrayList<ColumnSet>();
        ColumnSets anEJB = null;
        anEJB = ColumnSet.getEJB();
        Iterator it = anEJB.getIdByConcept(id).iterator();
        while (it.hasNext()) {
            ColumnSetV val;
            Integer anId = (Integer)it.next();
            ColumnSet anObj = (ColumnSet)cache.get(anId);
            if (anObj == null && (val = anEJB.find(anId)) != null) {
                anObj = new ColumnSet(val);
                cache.put(anId, anObj);
            }
            if (anObj == null) continue;
            aList.add(anObj);
        }
        Object var8_9 = null;
        if (anEJB == null) return aList;
        try {
            anEJB.remove();
            return aList;
        }
        catch (Exception exception) {}
        return aList;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var8_10 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var8_11 = null;
                if (anEJB == null) return aList;
                try {
                    anEJB.remove();
                    return aList;
                }
                catch (Exception exception) {}
                return aList;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ColumnSet getByRelationship(int id) {
        block13: {
            anEJB = null;
            try {
                try {
                    anEJB = ColumnSet.getEJB();
                    anId = anEJB.getIdByRelationship(id);
                    anObj = (ColumnSet)ColumnSet.cache.get(anId);
                    if (anObj == null && (val = anEJB.find(anId)) != null) {
                        anObj = new ColumnSet(val);
                        ColumnSet.cache.put(anId, anObj);
                    }
                    if (anObj == null) break block13;
                    var4_6 = anObj;
                    var6_7 = null;
                    if (anEJB == null) return var4_6;
                }
                catch (RemoteException e) {
                    ColumnSet.logger.warn((Object)"Communication failure", (Throwable)e);
                    var6_9 = null;
                    if (anEJB == null) return null;
                    try {
                        anEJB.remove();
                        return null;
                    }
                    catch (Exception var7_14) {
                        return null;
                    }
                }
                catch (SQLException e) {
                    ColumnSet.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var6_10 = null;
                    if (anEJB == null) return null;
                    try {}
                    catch (Exception var7_15) {
                        return null;
                    }
                    anEJB.remove();
                    return null;
                }
            }
            catch (Throwable var5_17) {
                var6_11 = null;
                if (anEJB == null) throw var5_17;
                ** try [egrp 2[TRYBLOCK] [3 : 135->144)] { 
lbl42:
                // 1 sources

                anEJB.remove();
                throw var5_17;
lbl44:
                // 1 sources

                catch (Exception var7_16) {
                    // empty catch block
                }
                throw var5_17;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 135->144)] { 
lbl49:
            // 1 sources

            anEJB.remove();
            return var4_6;
lbl51:
            // 1 sources

            catch (Exception var7_12) {
                // empty catch block
            }
            return var4_6;
        }
        var6_8 = null;
        if (anEJB == null) return null;
        try {}
        catch (Exception var7_13) {}
        anEJB.remove();
        return null;
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ColumnSet getByRelationshipAndName(int id, String name) {
        block13: {
            anEJB = null;
            try {
                try {
                    anEJB = ColumnSet.getEJB();
                    anId = anEJB.getIdByRelationshipAndName(id, name);
                    if (anId == null) break block13;
                    anObj = (ColumnSet)ColumnSet.cache.get(anId);
                    if (anObj == null && (val = anEJB.find(anId)) != null) {
                        anObj = new ColumnSet(val);
                        ColumnSet.cache.put(anId, anObj);
                    }
                    if (anObj == null) break block13;
                    var5_7 = anObj;
                    var7_8 = null;
                    if (anEJB == null) return var5_7;
                }
                catch (RemoteException e) {
                    ColumnSet.logger.warn((Object)"Communication failure", (Throwable)e);
                    var7_10 = null;
                    if (anEJB == null) return null;
                    try {
                        anEJB.remove();
                        return null;
                    }
                    catch (Exception var8_15) {
                        return null;
                    }
                }
                catch (SQLException e) {
                    ColumnSet.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var7_11 = null;
                    if (anEJB == null) return null;
                    try {}
                    catch (Exception var8_16) {
                        return null;
                    }
                    anEJB.remove();
                    return null;
                }
            }
            catch (Throwable var6_18) {
                var7_12 = null;
                if (anEJB == null) throw var6_18;
                ** try [egrp 2[TRYBLOCK] [3 : 147->156)] { 
lbl43:
                // 1 sources

                anEJB.remove();
                throw var6_18;
lbl45:
                // 1 sources

                catch (Exception var8_17) {
                    // empty catch block
                }
                throw var6_18;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 147->156)] { 
lbl50:
            // 1 sources

            anEJB.remove();
            return var5_7;
lbl52:
            // 1 sources

            catch (Exception var8_13) {
                // empty catch block
            }
            return var5_7;
        }
        var7_9 = null;
        if (anEJB == null) return null;
        try {}
        catch (Exception var8_14) {}
        anEJB.remove();
        return null;
        return null;
    }

    public void setDocumentation(String text) {
        this.removeAllDocumentation();
        if (text == null || text.equalsIgnoreCase("")) {
            return;
        }
        DocumentationV val = new DocumentationV();
        val.setText(text);
        val.setObjectId(this.getId());
        val.setObjectType("CS");
        Documentation.createByValueObject(val);
    }

    public String getDocumentation() {
        return Documentation.getByIdAndType(this.getId(), "CS");
    }

    public void removeAllDocumentation() {
        Documentation.deleteByIdAndType(this.getId(), "CS");
    }

    protected static void clearCache() {
        cache.clear();
    }
}

